/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.database.ISysDBColumnRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntimeContext;
import net.ibizsys.central.database.ISysDBTableRuntime;
import net.ibizsys.central.database.SysDBColumnRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.database.IPSSysDBColumn;
import net.ibizsys.model.database.IPSSysDBTable;
import net.ibizsys.runtime.ModelRuntimeBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SysDBTableRuntime
extends ModelRuntimeBase
implements ISysDBTableRuntime {
    private static final Log log = LogFactory.getLog(SysDBTableRuntime.class);
    private ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext = null;
    private IPSSysDBTable iPSSysDBTable = null;
    private List<ISysDBColumnRuntime> sysDBColumnRuntimeList = new ArrayList<ISysDBColumnRuntime>();
    private Map<String, ISysDBColumnRuntime> sysDBColumnRuntimeMap = new HashMap<String, ISysDBColumnRuntime>();
    private IDataEntityRuntime iDataEntityRuntime = null;
    private boolean bTenantMode = false;
    private String strTenantColumnName = null;

    @Override
    public void init(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, IPSSysDBTable iPSSysDBTable) throws Exception {
        this.iSysDBSchemeRuntimeContext = iSysDBSchemeRuntimeContext;
        this.iPSSysDBTable = iPSSysDBTable;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psSysDBColumnList = this.getPSSysDBTable().getAllPSSysDBColumns();
        if (psSysDBColumnList != null) {
            for (IPSSysDBColumn iPSSysDBColumn : psSysDBColumnList) {
                SysDBColumnRuntime sysDBColumnRuntime = new SysDBColumnRuntime();
                sysDBColumnRuntime.init(this.iSysDBSchemeRuntimeContext, this, iPSSysDBColumn);
                this.sysDBColumnRuntimeList.add(sysDBColumnRuntime);
                this.sysDBColumnRuntimeMap.put(sysDBColumnRuntime.getName(), sysDBColumnRuntime);
            }
        }
        super.onInit();
    }

    protected ISysDBSchemeRuntimeContext getSysDBSchemeRuntimeContext() {
        return this.iSysDBSchemeRuntimeContext;
    }

    @Override
    public IPSSysDBTable getPSSysDBTable() {
        return this.iPSSysDBTable;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysDBTable();
    }

    @Override
    public String getId() {
        return this.getPSSysDBTable().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysDBTable().getName();
    }

    @Override
    public List<ISysDBColumnRuntime> getSysDBColumnRuntimes() {
        if (this.sysDBColumnRuntimeList == null || this.sysDBColumnRuntimeList.size() == 0) {
            return null;
        }
        return this.sysDBColumnRuntimeList;
    }

    @Override
    public Map<String, ISysDBColumnRuntime> getColumns() {
        return this.sysDBColumnRuntimeMap;
    }

    @Override
    public String getStandardName() {
        return this.getName();
    }

    @Override
    public boolean isTenantMode() {
        return this.bTenantMode;
    }

    @Override
    public String getTenantColumnName() {
        return this.strTenantColumnName;
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    @Override
    public void setDataEntityRuntime(IDataEntityRuntime iDataEntityRuntime) {
        this.iDataEntityRuntime = iDataEntityRuntime;
        if (this.iDataEntityRuntime == null) {
            this.bTenantMode = false;
            this.strTenantColumnName = null;
        } else {
            try {
                boolean bLastTenantMode = this.bTenantMode;
                this.bTenantMode = this.getDataEntityRuntime().getPSDataEntity().getSaaSMode() != 0;
                this.strTenantColumnName = this.getDataEntityRuntime().getPSDataEntity().getSaaSDCIdColumnName();
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u83b7\u53d6\u5b9e\u4f53SaaS\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    @Override
    public ISysDBSchemeRuntime getSysDBSchemeRuntime() {
        return this.getSysDBSchemeRuntimeContext().getSysDBSchemeRuntime();
    }

    @Override
    public ISysDBSchemeRuntime getSchema() {
        return this.getSysDBSchemeRuntime();
    }

    @Override
    public void setTenantMode(boolean bTenantMode) {
        this.bTenantMode = bTenantMode;
    }

    @Override
    public void setTenantColumnName(String strTenantColumnName) {
        this.strTenantColumnName = strTenantColumnName;
    }
}

