/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemGateway;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.database.IDBDataService;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.ISysDBColumnRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntimeContext;
import net.ibizsys.central.database.ISysDBTableRuntime;
import net.ibizsys.central.database.SysDBSchemeRuntimeException;
import net.ibizsys.central.database.SysDBTableRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.database.IPSSysDBTable;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.SqlCommandParam;
import net.ibizsys.runtime.util.SqlParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysDBSchemeRuntimeBase
extends SystemModelRuntimeBase
implements ISysDBSchemeRuntime {
    private static final Log log = LogFactory.getLog(SysDBSchemeRuntimeBase.class);
    private static IDBDataService dbDataService;
    private IPSSysDBScheme iPSSysDBScheme = null;
    private String strDBType = "MYSQL5";
    private boolean bDBTypeDefined = false;
    private String strRealDBType = null;
    private String strDSLink = null;
    private String strSaaSDCIdColumnName = null;
    private String strSaaSDataIdColumnName = null;
    private Object objDataSourceTag = null;
    private Map<String, ISysDBTableRuntime> sysDBTableRuntimeMap = new HashMap<String, ISysDBTableRuntime>();
    private Map<String, Object> properties = null;
    private IDBDataService iDBDataService = null;
    private boolean bDropIndexFirst = false;
    private boolean bUpdateSchema = true;
    private boolean bInstalled = false;
    private IDBDialect iDBDialect = null;
    private ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext = new ISysDBSchemeRuntimeContext(){

        @Override
        public ISysDBSchemeRuntime getSysDBSchemeRuntime() {
            return SysDBSchemeRuntimeBase.this.getSelf();
        }
    };

    public static void setDefaultDBDataService(IDBDataService dbDataService) {
        SysDBSchemeRuntimeBase.dbDataService = dbDataService;
    }

    public static IDBDataService getDefaultDBDataService() {
        return dbDataService;
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysDBScheme iPSSysDBScheme) throws Exception {
        String strCodeName;
        this.setSystemRuntimeBase(iSystemRuntimeContext.getSystemRuntime());
        this.iPSSysDBScheme = iPSSysDBScheme;
        Assert.notNull((Object)this.iPSSysDBScheme, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u5e93\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setDSLink(this.getPSSysDBScheme().getDSLink());
        this.setSaaSDataIdColumnName(this.getPSSysDBScheme().getSaaSDataIdColumnName());
        this.setSaaSDCIdColumnName(this.getPSSysDBScheme().getSaaSDCIdColumnName());
        if (this.getPSSysDBScheme().isExistingModel() || this.getPSSysDBScheme().getPSSysModelGroup() != null || !StringUtils.hasLength((String)this.getPSSysDBScheme().getDSLink())) {
            this.setUpdateSchema(false);
        }
        if (!StringUtils.hasLength((String)(strCodeName = this.iPSSysDBScheme.getCodeName()))) {
            strCodeName = this.getDSLink();
        }
        this.setConfigFolder("sysdbscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)this.iPSSysDBScheme.getPSSysModelGroup(), (String)this.getDSLink()));
        this.onInit();
        this.fillDataSourceInfo();
    }

    @Override
    protected void onInit() throws Exception {
        String strRealDBType;
        String strDBType;
        this.setDataSourceTag(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".datasourcetag", null));
        if (ObjectUtils.isEmpty((Object)this.getDataSourceTag())) {
            String strDefaultDSName = this.getPSSysDBScheme().getDBInstTag();
            if (!StringUtils.hasLength((String)strDefaultDSName)) {
                strDefaultDSName = this.getSystemRuntimeSetting().getParam("defaultdbinsttag", null);
            }
            if (!StringUtils.hasLength((String)strDefaultDSName)) {
                strDefaultDSName = this.getDSLink();
            }
            this.setDataSourceTag(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".datasource", strDefaultDSName));
        }
        if (StringUtils.hasLength((String)(strDBType = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbtype", null)))) {
            this.setDBType(strDBType);
            this.setDBTypeDefined(true);
        }
        if (StringUtils.hasLength((String)(strRealDBType = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".realdbtype", null)))) {
            this.setRealDBType(strRealDBType);
        }
        this.setSaaSDCIdColumnName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".saasdccolumn", this.getSaaSDCIdColumnName()));
        this.setSaaSDataIdColumnName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".saasidcolumn", this.getSaaSDataIdColumnName()));
        this.setDropIndexFirst(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dropindexfirst", this.isDropIndexFirst()));
        this.setUpdateSchema(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".updateschema", this.isUpdateSchema()));
        List psSysDBTableList = this.getPSSysDBScheme().getAllPSSysDBTables();
        if (psSysDBTableList != null) {
            for (IPSSysDBTable iPSSysDBTable : psSysDBTableList) {
                ISysDBTableRuntime iSysDBTableRuntime = this.createSysDBTableRuntime(iPSSysDBTable);
                try {
                    iSysDBTableRuntime.init(this.getSysDBSchemeRuntimeContext(), iPSSysDBTable);
                    this.sysDBTableRuntimeMap.put(iPSSysDBTable.getName().toUpperCase(), iSysDBTableRuntime);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u521d\u59cb\u5316\u6570\u636e\u5e93[%1$s]\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDBTable.getName(), ex.getMessage()), ex);
                }
            }
        }
        super.onInit();
    }

    protected void fillDataSourceInfo() {
        log.info((Object)String.format("\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u7c7b\u578b[%2$s]\u6570\u636e\u6e90[%3$s]\u66f4\u65b0[%4$s]", PSModelUtils.calcUniqueTag((IPSSysModelGroup)this.getPSSysDBScheme().getPSSysModelGroup(), (String)this.getDSLink()), this.getDBType(), this.getDataSourceTag(), this.isUpdateSchema()));
        if (SystemGateway.getInstance(true) != null) {
            SystemGateway.getInstance(false).fillDataSourceInfo(this);
        }
    }

    protected ISysDBTableRuntime createSysDBTableRuntime(IPSSysDBTable iPSSysDBTable) {
        return new SysDBTableRuntime();
    }

    protected ISysDBSchemeRuntimeContext getSysDBSchemeRuntimeContext() {
        return this.iSysDBSchemeRuntimeContext;
    }

    private SysDBSchemeRuntimeBase getSelf() {
        return this;
    }

    @Override
    public ISysDBTableRuntime getSysDBTableRuntime(String strTableName, boolean bTryMode) {
        ISysDBTableRuntime iSysDBTableRuntime = this.sysDBTableRuntimeMap.get(strTableName.toUpperCase());
        if (iSysDBTableRuntime != null || bTryMode) {
            return iSysDBTableRuntime;
        }
        throw new SysDBSchemeRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u8868[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTableName));
    }

    @Override
    public IPSSysDBScheme getPSSysDBScheme() {
        return this.iPSSysDBScheme;
    }

    @Override
    public String getId() {
        return this.getPSSysDBScheme().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysDBScheme().getName();
    }

    @Override
    public String getDBType() {
        return this.strDBType;
    }

    @Override
    public void setDBType(String strDBType) {
        this.strDBType = strDBType;
    }

    @Override
    public boolean isDBTypeDefined() {
        return this.bDBTypeDefined;
    }

    protected void setDBTypeDefined(boolean bDBTypeDefined) {
        this.bDBTypeDefined = bDBTypeDefined;
    }

    @Override
    public String getDSLink() {
        return this.strDSLink;
    }

    public void setDSLink(String strDSLink) {
        this.strDSLink = strDSLink;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysDBScheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insert(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onInsert(strTableName, args, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onInsert(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        if (ObjectUtils.isEmpty(args)) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        ArrayList<SqlCommandParam> list = new ArrayList<SqlCommandParam>();
        for (Map<String, Object> paramMap : args) {
            SqlParam sqlParam;
            Object objValue;
            HashMap<String, SqlParam> sqlParamMap = new HashMap<String, SqlParam>();
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
            if (extParamMap != null) {
                for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                    if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                    objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                    if (objValue instanceof SqlParam) {
                        sqlParam = (SqlParam)objValue;
                        sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                        sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    sqlParam = SqlParam.value(objValue);
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                }
            }
            list.add(new SqlCommandParam(sqlParamMap.values()));
        }
        return this.getDBDataService().insert(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object update(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onUpdate(strTableName, args, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onUpdate(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        if (ObjectUtils.isEmpty(args)) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        ArrayList<SqlCommandParam> list = new ArrayList<SqlCommandParam>();
        for (Map<String, Object> paramMap : args) {
            SqlParam sqlParam;
            Object objValue;
            HashMap<String, SqlParam> sqlParamMap = new HashMap<String, SqlParam>();
            HashMap<String, SqlParam> conditionSqlParamMap = new HashMap<String, SqlParam>();
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (!sqlParam.isCondition()) {
                        sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (iSysDBColumnRuntime.isPKey()) {
                    sqlParam.setCondition(true);
                }
                if (!sqlParam.isCondition()) {
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
            if (extParamMap != null) {
                for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                    if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                    objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                    if (objValue instanceof SqlParam) {
                        sqlParam = (SqlParam)objValue;
                        sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                        if (!sqlParam.isCondition()) {
                            sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                            continue;
                        }
                        conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    sqlParam = SqlParam.value(objValue);
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (iSysDBColumnRuntime.isPKey()) {
                        sqlParam.setCondition(true);
                    }
                    if (!sqlParam.isCondition()) {
                        sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                }
            }
            for (String strKey : conditionSqlParamMap.keySet()) {
                sqlParamMap.remove(strKey);
            }
            list.add(new SqlCommandParam(sqlParamMap.values(), conditionSqlParamMap.values()));
        }
        return this.getDBDataService().update(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insert(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onInsert(strTableName, paramMap, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onInsert(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        SqlParam sqlParam;
        Object objValue;
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        HashMap<String, SqlParam> sqlParamMap = new HashMap<String, SqlParam>();
        for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
            if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
            objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
            if (objValue instanceof SqlParam) {
                sqlParam = (SqlParam)objValue;
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                continue;
            }
            sqlParam = SqlParam.value(objValue);
            sqlParam.setName(iSysDBColumnRuntime.getStandardName());
            sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
        }
        if (extParamMap != null) {
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
        }
        return this.getDBDataService().insert(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, new SqlCommandParam(sqlParamMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object update(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onUpdate(strTableName, paramMap, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onUpdate(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        SqlParam sqlParam;
        Object objValue;
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        HashMap<String, SqlParam> sqlParamMap = new HashMap<String, SqlParam>();
        HashMap<String, SqlParam> conditionSqlParamMap = new HashMap<String, SqlParam>();
        for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
            if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
            objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
            if (objValue instanceof SqlParam) {
                sqlParam = (SqlParam)objValue;
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (!sqlParam.isCondition()) {
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                continue;
            }
            sqlParam = SqlParam.value(objValue);
            sqlParam.setName(iSysDBColumnRuntime.getStandardName());
            if (iSysDBColumnRuntime.isPKey()) {
                sqlParam.setCondition(true);
            }
            if (!sqlParam.isCondition()) {
                sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                continue;
            }
            conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
        }
        if (extParamMap != null) {
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (!sqlParam.isCondition()) {
                        sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (iSysDBColumnRuntime.isPKey()) {
                    sqlParam.setCondition(true);
                }
                if (!sqlParam.isCondition()) {
                    sqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
        }
        for (String strKey : conditionSqlParamMap.keySet()) {
            sqlParamMap.remove(strKey);
        }
        return this.getDBDataService().update(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, new SqlCommandParam(sqlParamMap.values(), conditionSqlParamMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object delete(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onDelete(strTableName, paramMap, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onDelete(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        SqlParam sqlParam;
        Object objValue;
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        HashMap<String, SqlParam> conditionSqlParamMap = new HashMap<String, SqlParam>();
        for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
            if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
            objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
            if (objValue instanceof SqlParam) {
                sqlParam = (SqlParam)objValue;
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (!sqlParam.isCondition()) continue;
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                continue;
            }
            sqlParam = SqlParam.value(objValue);
            sqlParam.setName(iSysDBColumnRuntime.getStandardName());
            if (iSysDBColumnRuntime.isPKey()) {
                sqlParam.setCondition(true);
            }
            if (!sqlParam.isCondition()) continue;
            conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
        }
        if (extParamMap != null) {
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (!sqlParam.isCondition()) continue;
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (iSysDBColumnRuntime.isPKey()) {
                    sqlParam.setCondition(true);
                }
                if (!sqlParam.isCondition()) continue;
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
        }
        return this.getDBDataService().delete(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, new SqlCommandParam(null, conditionSqlParamMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object delete(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        try {
            this.push();
            Object object = this.onDelete(strTableName, args, extParamMap);
            return object;
        }
        finally {
            this.poll();
        }
    }

    protected Object onDelete(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        if (ObjectUtils.isEmpty(args)) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        ArrayList<SqlCommandParam> list = new ArrayList<SqlCommandParam>();
        for (Map<String, Object> paramMap : args) {
            SqlParam sqlParam;
            Object objValue;
            HashMap<String, SqlParam> conditionSqlParamMap = new HashMap<String, SqlParam>();
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (!sqlParam.isCondition()) continue;
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (iSysDBColumnRuntime.isPKey()) {
                    sqlParam.setCondition(true);
                }
                if (!sqlParam.isCondition()) continue;
                conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
            }
            if (extParamMap != null) {
                for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                    if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                    objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                    if (objValue instanceof SqlParam) {
                        sqlParam = (SqlParam)objValue;
                        sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                        if (!sqlParam.isCondition()) continue;
                        conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                        continue;
                    }
                    sqlParam = SqlParam.value(objValue);
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (iSysDBColumnRuntime.isPKey()) {
                        sqlParam.setCondition(true);
                    }
                    if (!sqlParam.isCondition()) continue;
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getStandardName(), sqlParam);
                }
            }
            list.add(new SqlCommandParam(null, conditionSqlParamMap.values()));
        }
        return this.getDBDataService().delete(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List select(final String strTableName, final Map<String, Object> paramMap, final Map<String, Object> extParamMap) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                List list = this.onSelect(strTableName, paramMap, extParamMap);
                return list;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onSelect(strTableName, paramMap, extParamMap);
                }
            }, null, 3);
            if (ret instanceof List) {
                List list = (List)ret;
                return list;
            }
            List list = null;
            return list;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected List onSelect(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        SqlParam sqlParam;
        Object objValue;
        HashMap<String, SqlParam> sqlParamMap = new HashMap<String, SqlParam>();
        HashMap<String, SqlParam> conditionSqlParamMap = new HashMap<String, SqlParam>();
        ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBTableRuntime(strTableName, false);
        List<ISysDBColumnRuntime> sysDBColumnRuntimeList = iSysDBTableRuntime.getSysDBColumnRuntimes();
        if (sysDBColumnRuntimeList == null || sysDBColumnRuntimeList.size() == 0) {
            throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u8868[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5217", strTableName));
        }
        for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
            if (!paramMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
            objValue = paramMap.get(iSysDBColumnRuntime.getDataItemName());
            if (objValue instanceof SqlParam) {
                sqlParam = (SqlParam)objValue;
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (!sqlParam.isCondition()) {
                    sqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                    continue;
                }
                conditionSqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                continue;
            }
            sqlParam = SqlParam.value(objValue);
            sqlParam.setName(iSysDBColumnRuntime.getStandardName());
            if (iSysDBColumnRuntime.isPKey()) {
                sqlParam.setCondition(true);
            }
            if (!sqlParam.isCondition()) {
                sqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                continue;
            }
            conditionSqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            if (entry.getValue() != SqlParam.NOTSET || sqlParamMap.containsKey(entry.getKey())) continue;
            sqlParamMap.put((String)entry.getKey(), SqlParam.rawCode((String)entry.getKey(), (String)entry.getKey()));
        }
        if (extParamMap != null) {
            for (ISysDBColumnRuntime iSysDBColumnRuntime : sysDBColumnRuntimeList) {
                if (!extParamMap.containsKey(iSysDBColumnRuntime.getDataItemName())) continue;
                objValue = extParamMap.get(iSysDBColumnRuntime.getDataItemName());
                if (objValue instanceof SqlParam) {
                    sqlParam = (SqlParam)objValue;
                    sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                    if (!sqlParam.isCondition()) {
                        sqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                        continue;
                    }
                    conditionSqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                    continue;
                }
                sqlParam = SqlParam.value(objValue);
                sqlParam.setName(iSysDBColumnRuntime.getStandardName());
                if (iSysDBColumnRuntime.isPKey()) {
                    sqlParam.setCondition(true);
                }
                if (!sqlParam.isCondition()) {
                    sqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
                    continue;
                }
                conditionSqlParamMap.put(iSysDBColumnRuntime.getDataItemName(), sqlParam);
            }
        }
        for (String string : conditionSqlParamMap.keySet()) {
            sqlParamMap.remove(string);
        }
        return this.getDBDataService().select(this.getSysDBSchemeRuntimeContext(), iSysDBTableRuntime, new SqlCommandParam(sqlParamMap.values(), conditionSqlParamMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List query(final IDataEntityRuntime iDataEntityRuntime, final IPSDEDataQuery iPSDEDataQuery, final ISearchContext iSearchContext, final String[] outputFields, final Map<String, Object> extParamMap) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                List list = this.onQuery(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
                return list;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onQuery(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
                }
            }, null, 3);
            if (ret instanceof List) {
                List list = (List)ret;
                return list;
            }
            List list = null;
            return list;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected List onQuery(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        return this.getDBDataService().select(this.getSysDBSchemeRuntimeContext(), iDataEntityRuntime, iPSDEDataQuery, iSearchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page query2(final IDataEntityRuntime iDataEntityRuntime, final IPSDEDataQuery iPSDEDataQuery, final ISearchContext iSearchContext, final String[] outputFields, final Map<String, Object> extParamMap) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                Page page = this.onQuery2(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
                return page;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onQuery2(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
                }
            }, null, 3);
            if (ret instanceof Page) {
                Page page = (Page)ret;
                return page;
            }
            Page page = null;
            return page;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected Page onQuery2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        return this.getDBDataService().select2(this.getSysDBSchemeRuntimeContext(), iDataEntityRuntime, iPSDEDataQuery, iSearchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page fetchDataSet(final IDataEntityRuntime iDataEntityRuntime, final IPSDEDataSet iPSDEDataSet, final ISearchContext iSearchContext, final String[] outputFields, final Map<String, Object> extParamMap) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                Page page = this.onFetchDataSet(iDataEntityRuntime, iPSDEDataSet, iSearchContext, outputFields, extParamMap);
                return page;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onFetchDataSet(iDataEntityRuntime, iPSDEDataSet, iSearchContext, outputFields, extParamMap);
                }
            }, null, 3);
            if (ret instanceof Page) {
                Page page = (Page)ret;
                return page;
            }
            Page page = null;
            return page;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected Page onFetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        return this.getDBDataService().select(this.getSysDBSchemeRuntimeContext(), iDataEntityRuntime, iPSDEDataSet, iSearchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List executeSelectSQL(final String strSQL, final List<Object> params) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                List list = this.onExecuteSelectSQL(strSQL, params);
                return list;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onExecuteSelectSQL(strSQL, params);
                }
            }, null, 3);
            if (ret instanceof List) {
                List list = (List)ret;
                return list;
            }
            List list = null;
            return list;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected List onExecuteSelectSQL(String strSQL, List<Object> params) throws Throwable {
        return this.getDBDataService().executeSelectSQL(this.getSysDBSchemeRuntimeContext(), strSQL, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSQL(final String strSQL, final List<Object> params) throws Throwable {
        boolean bActive = this.isActive();
        try {
            if (!bActive) {
                this.push();
            }
            if (bActive) {
                int n = this.onExecuteSQL(strSQL, params);
                return n;
            }
            Object ret = ActionSessionManager.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return SysDBSchemeRuntimeBase.this.onExecuteSQL(strSQL, params);
                }
            }, null, 3);
            int n = (Integer)ret;
            return n;
        }
        finally {
            if (!bActive) {
                this.poll();
            }
        }
    }

    protected int onExecuteSQL(String strSQL, List<Object> params) throws Throwable {
        return this.getDBDataService().executeSQL(this.getSysDBSchemeRuntimeContext(), strSQL, params);
    }

    protected IDBDataService getDBDataService() {
        if (this.iDBDataService != null) {
            return this.iDBDataService;
        }
        if (SysDBSchemeRuntimeBase.getDefaultDBDataService() != null) {
            return SysDBSchemeRuntimeBase.getDefaultDBDataService();
        }
        throw new SysDBSchemeRuntimeException(this, "\u65e0\u6548\u7684\u6570\u636e\u670d\u52a1\u5bf9\u8c61");
    }

    protected void setDBDataService(IDBDataService iDBDataService) {
        this.iDBDataService = iDBDataService;
    }

    @Override
    public Object getDataSourceTag() {
        return this.objDataSourceTag;
    }

    @Override
    public void setDataSourceTag(Object objDataSourceTag) {
        this.objDataSourceTag = objDataSourceTag;
    }

    @Override
    public void setDataSourceProperties(Map<String, Object> properties) {
        if (properties != null) {
            this.properties = new LinkedHashMap<String, Object>();
            this.properties.putAll(properties);
        } else {
            this.properties = properties;
        }
    }

    @Override
    public Object getDataSourceProperty(String strKey, Object objDefault) {
        if (this.properties != null && this.properties.containsKey(strKey)) {
            return this.properties.get(strKey);
        }
        return objDefault;
    }

    @Override
    public void push() {
        try {
            this.onPush();
        }
        catch (Throwable ex) {
            SysDBSchemeRuntimeException.rethrow(this, ex);
            throw new SysDBSchemeRuntimeException((ISysDBSchemeRuntime)this, String.format("push\u6570\u636e\u6e90\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onPush() throws Throwable {
        IDBDataService iDBDataService = this.getDBDataService();
        iDBDataService.push(this);
    }

    @Override
    public void poll() {
        try {
            this.onPoll();
        }
        catch (Throwable ex) {
            SysDBSchemeRuntimeException.rethrow(this, ex);
            throw new SysDBSchemeRuntimeException((ISysDBSchemeRuntime)this, String.format("poll\u6570\u636e\u6e90\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onPoll() throws Throwable {
        IDBDataService iDBDataService = this.getDBDataService();
        iDBDataService.poll();
    }

    @Override
    public boolean isActive() {
        IDBDataService iDBDataService = this.getDBDataService();
        return iDBDataService.current() == this;
    }

    @Override
    public String getSaaSDCIdColumnName() {
        return this.strSaaSDCIdColumnName;
    }

    public void setSaaSDCIdColumnName(String strSaaSDCIdColumnName) {
        this.strSaaSDCIdColumnName = strSaaSDCIdColumnName;
    }

    @Override
    public String getSaaSDataIdColumnName() {
        return this.strSaaSDataIdColumnName;
    }

    public void setSaaSDataIdColumnName(String strSaaSDataIdColumnName) {
        this.strSaaSDataIdColumnName = strSaaSDataIdColumnName;
    }

    @Override
    public boolean isDropIndexFirst() {
        return this.bDropIndexFirst;
    }

    public void setDropIndexFirst(boolean bDropIndexFirst) {
        this.bDropIndexFirst = bDropIndexFirst;
    }

    @Override
    public boolean isUpdateSchema() {
        return this.bUpdateSchema;
    }

    public void setUpdateSchema(boolean bUpdateSchema) {
        this.bUpdateSchema = bUpdateSchema;
    }

    @Override
    public String getRealDBType() {
        if (StringUtils.hasLength((String)this.strRealDBType)) {
            return this.strRealDBType;
        }
        return this.getDBType();
    }

    @Override
    public void setRealDBType(String strRealDBType) {
        this.strRealDBType = strRealDBType;
    }

    @Override
    public IDBDialect getDBDialect() {
        if (this.iDBDialect == null) {
            this.iDBDialect = this.getSystemRuntime().getDBDialect(this.getDBType());
            if (this.iDBDialect == null) {
                throw new SysDBSchemeRuntimeException(this, String.format("\u6570\u636e\u5e93\u8bbf\u95ee\u9002\u914d\u5668\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            }
        }
        return this.iDBDialect;
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public void uninstall() {
        try {
            this.onUninstall();
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u5378\u8f7d\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
        }
    }

    protected void onUninstall() throws Throwable {
    }

    protected String getLogCat() {
        return "DBSCHEME";
    }
}

