/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.bi.util.BISearchDimension;
import net.ibizsys.central.bi.util.BISearchMeasure;
import net.ibizsys.central.bi.util.BISearchPeriod;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.bi.util.IBISearchDimension;
import net.ibizsys.central.bi.util.IBISearchMeasure;
import net.ibizsys.central.bi.util.IBISearchPeriod;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BISearchContext
implements IBISearchContext {
    public static final TypeReference<List<BISearchDimension>> BISearchDimensionListType = new TypeReference<List<BISearchDimension>>(){};
    public static final TypeReference<List<BISearchMeasure>> BISearchMeasureListType = new TypeReference<List<BISearchMeasure>>(){};
    final transient ISearchContext iSearchContext;
    transient String strBICubeTag = null;
    transient String strBIReportTag = null;
    transient List<IBISearchMeasure> biSearchMeasureList = null;
    transient List<IBISearchDimension> biSearchDimensionList = null;
    transient IBISearchPeriod iBISearchPeriod = null;
    transient Sort biSort = null;

    public BISearchContext(ISearchContext iSearchContext) {
        String strBISortInfo;
        Object bisearchperiod;
        Object bidimensions;
        Assert.notNull((Object)iSearchContext, (String)"\u672a\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587");
        this.iSearchContext = iSearchContext;
        this.strBICubeTag = DataTypeUtils.getStringValue(this.getSearchContext().get("bicubetag"), null);
        this.strBIReportTag = DataTypeUtils.getStringValue(this.getSearchContext().get("bireporttag"), null);
        Object bimeasures = this.getSearchContext().get("bimeasures");
        if (!ObjectUtils.isEmpty((Object)bimeasures)) {
            List<BISearchMeasure> list = JsonUtils.as(bimeasures, BISearchMeasureListType);
            this.biSearchMeasureList = list;
        }
        if (!ObjectUtils.isEmpty((Object)(bidimensions = this.getSearchContext().get("bidimensions")))) {
            List<BISearchDimension> list = JsonUtils.as(bidimensions, BISearchDimensionListType);
            this.biSearchDimensionList = list;
        }
        if (!ObjectUtils.isEmpty((Object)(bisearchperiod = this.getSearchContext().get("biperiod")))) {
            this.iBISearchPeriod = JsonUtils.as(bisearchperiod, BISearchPeriod.class);
        }
        if (!ObjectUtils.isEmpty((Object)(strBISortInfo = DataTypeUtils.getStringValue(this.getSearchContext().get("bisort"), null)))) {
            this.setBISort(strBISortInfo);
        }
    }

    @Override
    @JsonIgnore
    public ISearchContext getSearchContext() {
        return this.iSearchContext;
    }

    @Override
    public String getBICubeTag() {
        return this.strBICubeTag;
    }

    public void setBICubeTag(String strBICubeTag) {
        this.strBICubeTag = strBICubeTag;
    }

    @Override
    public String getBIReportTag() {
        return this.strBIReportTag;
    }

    public void setBIReportTag(String strBIReportTag) {
        this.strBIReportTag = strBIReportTag;
    }

    @Override
    @JsonIgnore
    public List<IBISearchDimension> getBISearchDimensionsIf() {
        if (this.biSearchDimensionList == null) {
            this.biSearchDimensionList = new ArrayList<IBISearchDimension>();
        }
        return this.biSearchDimensionList;
    }

    @Override
    public List<IBISearchDimension> getBISearchDimensions() {
        return this.biSearchDimensionList;
    }

    @Override
    @JsonIgnore
    public List<IBISearchMeasure> getBISearchMeasuresIf() {
        if (this.biSearchMeasureList == null) {
            this.biSearchMeasureList = new ArrayList<IBISearchMeasure>();
        }
        return this.biSearchMeasureList;
    }

    @Override
    public List<IBISearchMeasure> getBISearchMeasures() {
        return this.biSearchMeasureList;
    }

    @Override
    public IBISearchPeriod getBISearchPeriod() {
        return this.iBISearchPeriod;
    }

    public void setBISearchPeriod(IBISearchPeriod iBISearchPeriod) {
        this.iBISearchPeriod = iBISearchPeriod;
    }

    @Override
    public Sort getBISort() {
        return this.biSort;
    }

    public void setBISort(Sort biSort) {
        this.biSort = biSort;
    }

    @JsonIgnore
    public void setBISort(String strSortInfo) {
        Sort sort = null;
        if (StringUtils.hasLength((String)strSortInfo)) {
            String[] parts;
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            for (String strPart : parts = strSortInfo.split("[;]")) {
                String[] items = strPart.split("[,]");
                if (items.length == 1) {
                    list.add(Sort.Order.asc((String)items[0].trim()));
                    continue;
                }
                if (items.length != 2) continue;
                if ("DESC".equalsIgnoreCase(items[1].trim())) {
                    list.add(Sort.Order.desc((String)items[0].trim()));
                    continue;
                }
                list.add(Sort.Order.asc((String)items[0].trim()));
            }
            if (list.size() > 0) {
                sort = Sort.by(list);
            }
        }
        this.setBISort(sort);
    }

    public static IBISearchMeasure getBISearchMeasure(IBISearchContext iBISearchContext, String strName, boolean bTryMode) throws Exception {
        List<IBISearchMeasure> list = iBISearchContext.getBISearchMeasures();
        if (!ObjectUtils.isEmpty(list)) {
            for (IBISearchMeasure iBISearchMeasure : list) {
                if (!strName.equalsIgnoreCase(iBISearchMeasure.getName())) continue;
                return iBISearchMeasure;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9aBI\u641c\u7d22\u6307\u6807[%1$s]", strName));
    }

    public static IBISearchDimension getBISearchDimension(IBISearchContext iBISearchContext, String strName, boolean bTryMode) throws Exception {
        List<IBISearchDimension> list = iBISearchContext.getBISearchDimensions();
        if (!ObjectUtils.isEmpty(list)) {
            for (IBISearchDimension iBISearchDimension : list) {
                if (!strName.equalsIgnoreCase(iBISearchDimension.getName())) continue;
                return iBISearchDimension;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9aBI\u641c\u7d22\u7ef4\u5ea6[%1$s]", strName));
    }
}

