/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.bi.ISysBICubeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntimeContext;
import net.ibizsys.central.bi.SysBICubeRuntime;
import net.ibizsys.central.bi.SysBISchemeRuntimeException;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.bi.IPSSysBICube;
import net.ibizsys.model.bi.IPSSysBIScheme;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysBISchemeRuntimeBase
extends SystemModelRuntimeBase
implements ISysBISchemeRuntime {
    private static final Log log = LogFactory.getLog(SysBISchemeRuntimeBase.class);
    private IPSSysBIScheme iPSSysBIScheme = null;
    private String strServiceUrl = null;
    private String strBIEngineType = null;
    private Object objDataSourceTag = null;
    private Map<String, Object> properties = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strServiceParam = null;
    private String strServiceParam2 = null;
    private String strDBObjNameCase;
    private PSModelEnums.DBObjNameCaseMode dbObjNameCaseMode;
    private Map<String, ISysBICubeRuntime> sysBICubeRuntimeMap;
    private boolean bInstalled;
    private boolean bUpdateSchema;
    private ISysBISchemeRuntimeContext iSysBISchemeRuntimeContext;

    public SysBISchemeRuntimeBase() {
        this.strDBObjNameCase = PSModelEnums.DBObjNameCaseMode.LCASE.value;
        this.dbObjNameCaseMode = PSModelEnums.DBObjNameCaseMode.LCASE;
        this.sysBICubeRuntimeMap = new HashMap<String, ISysBICubeRuntime>();
        this.bInstalled = false;
        this.bUpdateSchema = true;
        this.iSysBISchemeRuntimeContext = new ISysBISchemeRuntimeContext(){

            @Override
            public ISysBISchemeRuntime getModelRuntime() {
                return SysBISchemeRuntimeBase.this.getSelf();
            }
        };
    }

    public static String getConfigFolder(IPSSysBIScheme iPSSysBIScheme) {
        if (iPSSysBIScheme.getPSSysModelGroup() != null) {
            return "syssearchscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysBIScheme.getPSSysModelGroup(), (String)iPSSysBIScheme.getCodeName());
        }
        return "syssearchscheme." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysBIScheme.getPSSystemModule(), (String)iPSSysBIScheme.getCodeName());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysBIScheme iPSSysBIScheme) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSysBIScheme, (String)"\u4f20\u5165\u667a\u80fd\u62a5\u8868\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntimeBase(iSystemRuntimeContext.getSystemRuntime());
        this.iPSSysBIScheme = iPSSysBIScheme;
        this.setConfigFolder(SysBISchemeRuntimeBase.getConfigFolder(iPSSysBIScheme));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSysBIScheme().getServicePath()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysBIScheme().getAuthMode()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysBIScheme().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysBIScheme().getAuthClientSecret()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSysBIScheme().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSysBIScheme().getAuthParam2()));
        this.setServiceParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam", this.getPSSysBIScheme().getServiceParam()));
        this.setServiceParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam2", this.getPSSysBIScheme().getServiceParam2()));
        this.setDBObjNameCase(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbobjnamecase", this.getPSSysBIScheme().getDBObjNameCase()));
        this.setUpdateSchema(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".updateschema", this.isUpdateSchema()));
        super.onInit();
    }

    protected ISysBISchemeRuntimeContext getSysBISchemeRuntimeContext() {
        return this.iSysBISchemeRuntimeContext;
    }

    private SysBISchemeRuntimeBase getSelf() {
        return this;
    }

    protected ISysBICubeRuntime createSysBICubeRuntime(IPSSysBICube iPSSysBICube) {
        return new SysBICubeRuntime();
    }

    @Override
    public IPSSysBIScheme getPSSysBIScheme() {
        return this.iPSSysBIScheme;
    }

    @Override
    public String getBIEngineType() {
        return this.strBIEngineType;
    }

    @Override
    public void setBIEngineType(String strBIEngineType) {
        this.strBIEngineType = strBIEngineType;
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public String getServiceParam() {
        return this.strServiceParam;
    }

    protected void setServiceParam(String strServiceParam) {
        this.strServiceParam = strServiceParam;
    }

    @Override
    public String getServiceParam2() {
        return this.strServiceParam2;
    }

    protected void setServiceParam2(String strServiceParam2) {
        this.strServiceParam2 = strServiceParam2;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    @Override
    public String getDBObjNameCase() {
        return this.strDBObjNameCase;
    }

    protected void setDBObjNameCase(String strDBObjNameCase) {
        if (!StringUtils.hasLength((String)strDBObjNameCase)) {
            strDBObjNameCase = PSModelEnums.DBObjNameCaseMode.LCASE.value;
        }
        this.strDBObjNameCase = strDBObjNameCase;
        this.dbObjNameCaseMode = PSModelEnums.DBObjNameCaseMode.from((String)this.strDBObjNameCase);
    }

    @Override
    public PSModelEnums.DBObjNameCaseMode getDBObjNameCaseMode() {
        return this.dbObjNameCaseMode;
    }

    protected String getRealDBObjName(String strObjName) {
        if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.LCASE) {
            return strObjName.toLowerCase();
        }
        if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.UCASE) {
            return strObjName.toUpperCase();
        }
        return strObjName;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysBIScheme();
    }

    @Override
    public boolean isUpdateSchema() {
        return this.bUpdateSchema;
    }

    public void setUpdateSchema(boolean bUpdateSchema) {
        this.bUpdateSchema = bUpdateSchema;
    }

    @Override
    public Object getDataSourceTag() {
        return this.objDataSourceTag;
    }

    @Override
    public void setDataSourceTag(Object objDataSourceTag) {
        this.objDataSourceTag = objDataSourceTag;
    }

    @Override
    public void setDataSourceProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Object getDataSourceProperty(String strKey, Object objDefault) {
        if (this.properties != null && this.properties.containsKey(strKey)) {
            return this.properties.get(strKey);
        }
        return objDefault;
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
        List psSysBICubeList = this.getPSSysBIScheme().getAllPSSysBICubes();
        if (!ObjectUtils.isEmpty((Object)psSysBICubeList)) {
            for (IPSSysBICube iPSSysBICube : psSysBICubeList) {
                ISysBICubeRuntime iSysBICubeRuntime = this.createSysBICubeRuntime(iPSSysBICube);
                try {
                    iSysBICubeRuntime.init(this.getSysBISchemeRuntimeContext(), iPSSysBICube);
                    this.sysBICubeRuntimeMap.put(iPSSysBICube.getCodeName().toUpperCase(), iSysBICubeRuntime);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u521d\u59cb\u5316\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53[%1$s]\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICube.getName(), ex.getMessage()), ex);
                }
            }
            if (this.isUpdateSchema()) {
                for (IPSSysBICube iPSSysBICube : psSysBICubeList) {
                    try {
                        this.updateSchema(iPSSysBICube);
                    }
                    catch (Exception ex) {
                        throw new Exception(String.format("\u66f4\u65b0\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53[%1$s]\u7ed3\u6784\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICube.getName(), ex.getMessage()), ex);
                    }
                }
            }
        }
    }

    protected void updateSchema(IPSSysBICube iPSSysBICube) throws Exception {
        this.onUpdateSchema(iPSSysBICube);
    }

    protected void onUpdateSchema(IPSSysBICube iPSSysBICube) throws Exception {
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public void uninstall() {
        try {
            this.onUninstall();
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u5378\u8f7d\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
        }
    }

    protected void onUninstall() throws Throwable {
    }

    @Override
    public ISysBICubeRuntime getSysBICubeRuntime(String strBICubeTag, boolean bTryMode) {
        Assert.hasLength((String)strBICubeTag, (String)"\u672a\u4f20\u5165\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53\u6807\u8bb0");
        ISysBICubeRuntime iSysBICubeRuntime = this.sysBICubeRuntimeMap.get(strBICubeTag.toUpperCase());
        if (iSysBICubeRuntime != null || bTryMode) {
            return iSysBICubeRuntime;
        }
        throw new SysBISchemeRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strBICubeTag));
    }

    @Override
    public ISysBICubeRuntime getSysBICubeRuntime(IPSSysBICube iPSSysBICube) {
        Assert.notNull((Object)iPSSysBICube, (String)"\u672a\u4f20\u5165\u667a\u80fd\u62a5\u8868\u7acb\u65b9\u4f53\u5bf9\u8c61");
        return this.getSysBICubeRuntime(iPSSysBICube.getName(), false);
    }

    protected String getLogCat() {
        return "BISCHEME";
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    protected void onShutdown() throws Exception {
    }
}

