/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ibizsys.central.bi.ISysBICubeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.util.BISearchContext;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.bi.util.IBISearchDimension;
import net.ibizsys.central.bi.util.IBISearchMeasure;
import net.ibizsys.central.bi.util.IBISearchPeriod;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.ds.DEDQSQLCustomCondParserBase;
import net.ibizsys.central.dataentity.ds.IDEDQSQLCustomCondParser;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.bi.IPSSysBICubeDimension;
import net.ibizsys.model.bi.IPSSysBICubeMeasure;
import net.ibizsys.model.bi.IPSSysBIHierarchy;
import net.ibizsys.model.bi.IPSSysBILevel;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.SearchCustomCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysBIDrillDetailDEDQSQLCustomCondParser
extends DEDQSQLCustomCondParserBase {
    private static final Log log = LogFactory.getLog(SysBIDrillDetailDEDQSQLCustomCondParser.class);

    @Override
    protected String onParse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, Map<String, Object> params, Set<String> columnList) throws Throwable {
        if (iDEDataQueryCodeRuntime == null) {
            throw new Exception("\u672a\u4f20\u5165\u5b9e\u4f53\u67e5\u8be2\u4ee3\u7801\u8fd0\u884c\u65f6\u5bf9\u8c61");
        }
        if (iSearchContext == null) {
            throw new Exception("\u672a\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61");
        }
        BISearchContext iBISearchContext = new BISearchContext(iSearchContext);
        String strBICubeMeasureTag = null;
        String strConditions = null;
        int nPos = iSearchCustomCond.getCustomCond().indexOf("$");
        if (nPos == -1) {
            strBICubeMeasureTag = iSearchCustomCond.getCustomCond();
        } else {
            strBICubeMeasureTag = iSearchCustomCond.getCustomCond().substring(0, nPos);
            strConditions = iSearchCustomCond.getCustomCond().substring(nPos + 1);
        }
        Map<String, String> conditions = SysBIDrillDetailDEDQSQLCustomCondParser.queryString2Map(strConditions, true);
        String[] items = strBICubeMeasureTag.split("[.]");
        if (items.length < 2) {
            throw new Exception(String.format("\u6307\u5b9a\u667a\u80fd\u7acb\u65b9\u4f53\u6807\u8bc6\u65e0\u6548[%1$s]", strBICubeMeasureTag));
        }
        ISysBISchemeRuntime iSysBISchemeRuntime = iDEDataQueryCodeRuntime.getDataEntityRuntime().getSystemRuntime().getSysBISchemeRuntime(items[0], false);
        ISysBICubeRuntime iSysBICubeRuntime = iSysBISchemeRuntime.getSysBICubeRuntime(items[1], false);
        IDEDQSQLCustomCondParser iDEDQSQLCustomCondParser = iDEDataQueryCodeRuntime.getDataEntityRuntime().getSystemRuntime().getRuntimeObject(IDEDQSQLCustomCondParser.class, "PQL");
        ArrayList<String> list = new ArrayList<String>();
        if (items.length >= 3) {
            IPSSysBICubeMeasure iPSSysBICubeMeasure = iSysBICubeRuntime.getPSSysBICubeMeasure(items[2], false);
            IBISearchMeasure iBISearchMeasure = BISearchContext.getBISearchMeasure(iBISearchContext, items[2], true);
            if (StringUtils.hasLength((String)iPSSysBICubeMeasure.getDrillDetailCustomCond())) {
                String strCustomCond = iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(iPSSysBICubeMeasure.getDrillDetailCustomCond()), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchMeasure != null ? iBISearchMeasure.getParam() : null);
                list.add(strCustomCond);
            }
        }
        if (!ObjectUtils.isEmpty(iBISearchContext.getBISearchDimensions())) {
            for (IBISearchDimension iBISearchDimension : iBISearchContext.getBISearchDimensions()) {
                IPSSysBICubeDimension iPSSysBICubeDimension = iSysBICubeRuntime.getPSSysBICubeDimension(iBISearchDimension.getName(), false);
                String strValue = conditions.get(iBISearchDimension.getName().toLowerCase());
                String strCustomCond = this.getDimensionCustomCond(iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iDEDQSQLCustomCondParser, iSysBICubeRuntime, iBISearchContext, iBISearchDimension, iPSSysBICubeDimension, strValue, conditions);
                list.add(strCustomCond);
            }
        }
        if (ObjectUtils.isEmpty(list)) {
            return "1 = 1";
        }
        return StringUtils.collectionToDelimitedString(list, (String)" AND ");
    }

    protected String getDimensionCustomCond(IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, IDEDQSQLCustomCondParser iDEDQSQLCustomCondParser, ISysBICubeRuntime iSysBICubeRuntime, IBISearchContext iBISearchContext, IBISearchDimension iBISearchDimension, IPSSysBICubeDimension iPSSysBICubeDimension, String strValue, Map<String, String> conditions) throws Throwable {
        IPSDEField iPSDEField = iPSSysBICubeDimension.getPSDEField();
        if (iPSSysBICubeDimension.getPSSysBIDimension() == null) {
            if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                if (iPSDEField == null) {
                    throw new Exception(String.format("\u7ef4\u5ea6[%1$s]\u672a\u6307\u5b9a\u5c5e\u6027", iPSSysBICubeDimension.getName()));
                }
                if (iBISearchDimension.getPeriod() != null) {
                    IBISearchPeriod iBISearchPeriod = iBISearchDimension.getPeriod();
                    String strUnit = iBISearchPeriod.getUnit();
                    String strType = iBISearchPeriod.getType();
                    if (!"STATIC".equals(strType) && !"DYNAMIC".equals(strType)) {
                        throw new Exception(String.format("\u5468\u671f\u7c7b\u578b[%1$s]\u4e0d\u652f\u6301", strType));
                    }
                    if ("DAY".equals(strUnit)) {
                        return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(String.format("DATEFORMAT(%1$s, '%%Y%%m%%d')", iPSDEField.getName())), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
                    }
                    if ("WEEK".equals(strUnit)) {
                        return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(String.format("YEARWEEKCHAR(%1$s)", iPSDEField.getName())), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
                    }
                    if ("MONTH".equals(strUnit)) {
                        return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(String.format("DATEFORMAT(%1$s, '%%Y%%m')", iPSDEField.getName())), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
                    }
                    if ("QUARTER".equals(strUnit)) {
                        return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(String.format("YEARQUARTERCHAR(%1$s)", iPSDEField.getName())), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
                    }
                    if ("YEAR".equals(strUnit)) {
                        return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(String.format("DATEFORMAT(%1$s, '%%Y')", iPSDEField.getName())), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
                    }
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u4f4d[%1$s]", strUnit));
                }
                IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(iPSDEField.getName(), true);
                if (iPSDEDataQueryCodeExp != null) {
                    if (StringUtils.hasLength((String)strValue)) {
                        return iDBDialect.getConditionSQL(iPSDEDataQueryCodeExp.getExpression(), iPSDEField.getStdDataType(), "EQ", strValue, false, null);
                    }
                    return iDBDialect.getConditionSQL(iPSDEDataQueryCodeExp.getExpression(), iPSDEField.getStdDataType(), "ISNULL", null, false, null);
                }
                if (StringUtils.hasLength((String)strValue)) {
                    return iDBDialect.getConditionSQL(iPSDEField.getName(), iPSDEField.getStdDataType(), "EQ", strValue, false, null);
                }
                return iDBDialect.getConditionSQL(iPSDEField.getName(), iPSDEField.getStdDataType(), "ISNULL", null, false, null);
            }
            if (PSModelEnums.BIDimensionType.CALCULATED.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                return String.format("%1$s = '%2$s'", iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(iPSSysBICubeDimension.getDimensionFormula()), iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iBISearchContext.getSearchContext(), iBISearchDimension.getParam()), strValue);
            }
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
        }
        String strHierarchy = iBISearchDimension.getHierarchy();
        IPSSysBIHierarchy iPSSysBIHierarchy = null;
        List list = iPSSysBICubeDimension.getPSSysBIDimension().getAllPSSysBIHierarchies();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (IPSSysBIHierarchy item : list) {
                if (StringUtils.hasLength((String)strHierarchy)) {
                    if (!strHierarchy.equalsIgnoreCase(item.getCodeName())) continue;
                    iPSSysBIHierarchy = item;
                    break;
                }
                iPSSysBIHierarchy = item;
                break;
            }
        }
        if (iPSSysBIHierarchy == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u5c42\u6b21\u4f53\u7cfb[%1$s]", strHierarchy));
        }
        LinkedHashSet<IPSSysBILevel> selectedPSSysBILevelList = new LinkedHashSet<IPSSysBILevel>();
        List psSysBILevelList = iPSSysBIHierarchy.getAllPSSysBILevels();
        if (!ObjectUtils.isEmpty((Object)psSysBILevelList)) {
            block1: for (IPSSysBILevel item : psSysBILevelList) {
                if (item.isUniqueMembers()) {
                    selectedPSSysBILevelList.add(item);
                    continue;
                }
                if (ObjectUtils.isEmpty(iBISearchDimension.getLevels())) continue;
                for (String strLevel : iBISearchDimension.getLevels()) {
                    if (!strLevel.equalsIgnoreCase(item.getCodeName())) continue;
                    selectedPSSysBILevelList.add(item);
                    continue block1;
                }
            }
        }
        String strKeyCode = "";
        if (!PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
        }
        IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(iPSSysBICubeDimension.getPSDEFieldMust().getName(), false);
        strKeyCode = iPSDEDataQueryCodeExp.getExpression();
        IDataEntityRuntime biHierarchyDataEntityRuntime = iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(iPSSysBIHierarchy.getPSDataEntityMust().getId());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("SELECT 1 FROM %1$s %2$s WHERE (%3$s= %2$s.%4$s)", iDBDialect.getDBObjStandardName(biHierarchyDataEntityRuntime.getTableName()), iDBDialect.getDBObjStandardName(iPSSysBICubeDimension.getCodeName().toLowerCase()), strKeyCode, iDBDialect.getDBObjStandardName(biHierarchyDataEntityRuntime.getKeyPSDEField().getName())));
        for (IPSSysBILevel item : selectedPSSysBILevelList) {
            if (item.getValuePSDEField() == null) continue;
            sb.append(" AND ");
            String strFullCodeName = String.format("%1$s__%2$s", iPSSysBICubeDimension.getCodeName(), item.getCodeName());
            String strLevelValue = conditions.get(strFullCodeName.toLowerCase());
            String strExpression = String.format("%1$s.%2$s", iDBDialect.getDBObjStandardName(iPSSysBICubeDimension.getCodeName().toLowerCase()), iDBDialect.getDBObjStandardName(item.getValuePSDEField().getName()));
            if (StringUtils.hasLength((String)strLevelValue)) {
                sb.append(iDBDialect.getConditionSQL(strExpression, item.getValuePSDEField().getStdDataType(), "EQ", strLevelValue, false, null));
                continue;
            }
            sb.append(iDBDialect.getConditionSQL(strExpression, item.getValuePSDEField().getStdDataType(), "ISNULL", null, false, null));
        }
        return String.format("EXISTS(%1$s)", sb.toString());
    }

    public static Map<String, String> queryString2Map(String queryString, boolean bDecode) {
        String[] params;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (!StringUtils.hasLength((String)queryString)) {
            return map;
        }
        for (String paramPair : params = queryString.split("&")) {
            String strValue;
            String strKey;
            String[] keyAndValue = paramPair.split("=");
            if (keyAndValue.length != 2) continue;
            if (bDecode) {
                try {
                    strKey = URLDecoder.decode(keyAndValue[0], "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    strKey = keyAndValue[0];
                    log.error((Object)ex);
                }
                try {
                    strValue = URLDecoder.decode(keyAndValue[1], "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    strValue = keyAndValue[1];
                    log.error((Object)ex);
                }
            } else {
                strKey = keyAndValue[0];
                strValue = keyAndValue[1];
            }
            map.put(strKey.toLowerCase(), strValue);
        }
        return map;
    }
}

