/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.bi.ISysBICubeCalculatedDimensionParser;
import net.ibizsys.central.bi.ISysBICubeCalculatedMeasureParser;
import net.ibizsys.central.bi.ISysBICubeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntimeContext;
import net.ibizsys.central.bi.SysBISchemeRuntimeException;
import net.ibizsys.central.bi.util.BISearchDimension;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.bi.util.IBISearchDimension;
import net.ibizsys.central.bi.util.IBISearchMeasure;
import net.ibizsys.central.bi.util.IBISearchPeriod;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.ds.IDEDQSQLCustomCondParser;
import net.ibizsys.central.dataentity.ds.IDEDQSQLSelectParser;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.dataentity.util.IDEDynaStorageUtilRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.ISearchGroupCond;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.bi.IPSSysBICube;
import net.ibizsys.model.bi.IPSSysBICubeDimension;
import net.ibizsys.model.bi.IPSSysBICubeMeasure;
import net.ibizsys.model.bi.IPSSysBIHierarchy;
import net.ibizsys.model.bi.IPSSysBILevel;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeCond;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysBICubeRuntimeBase
extends ModelRuntimeBase
implements ISysBICubeRuntime {
    private static final Log log = LogFactory.getLog(SysBICubeRuntimeBase.class);
    private ISysBISchemeRuntimeContext iSysBISchemeRuntimeContext = null;
    private IPSSysBICube iPSSysBICube = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private Map<String, IPSSysBICubeMeasure> psSysBICubeMeasureMap = new LinkedHashMap<String, IPSSysBICubeMeasure>();
    private Map<String, IPSSysBICubeDimension> psSysBICubeDimensionMap = new LinkedHashMap<String, IPSSysBICubeDimension>();
    private String strAccessKey = null;
    private ISysBICubeCalculatedDimensionParser iSysBICubeCalculatedDimensionParser = null;
    private ISysBICubeCalculatedMeasureParser iSysBICubeCalculatedMeasureParser = null;
    private boolean bEnableAuthoritySearchCond = false;
    public static final String SEARCHCONDCAT_BISEARCHPERIOD = "BISEARCHPERIOD";

    @Override
    public void init(ISysBISchemeRuntimeContext iSysBISchemeRuntimeContext, IPSSysBICube iPSSysBICube) throws Exception {
        this.iSysBISchemeRuntimeContext = iSysBISchemeRuntimeContext;
        this.iPSSysBICube = iPSSysBICube;
        if (this.iPSSysBICube.getPSSysUniRes() != null) {
            this.strAccessKey = this.iPSSysBICube.getPSSysUniRes().getResCode();
        }
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psSysBICubeDimensionList;
        this.bEnableAuthoritySearchCond = (this.getPSSysBICube().getCubeOption() & PSModelEnums.BICubeOption.REFCHECK.value) == PSModelEnums.BICubeOption.REFCHECK.value;
        List psSysBICubeMeasureList = this.getPSSysBICube().getAllPSSysBICubeMeasures();
        if (!ObjectUtils.isEmpty((Object)psSysBICubeMeasureList)) {
            for (IPSSysBICubeMeasure iPSSysBICubeMeasure : psSysBICubeMeasureList) {
                this.psSysBICubeMeasureMap.put(iPSSysBICubeMeasure.getCodeName().toLowerCase(), iPSSysBICubeMeasure);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psSysBICubeDimensionList = this.getPSSysBICube().getAllPSSysBICubeDimensions()))) {
            for (IPSSysBICubeDimension iPSSysBICubeDimension : psSysBICubeDimensionList) {
                this.psSysBICubeDimensionMap.put(iPSSysBICubeDimension.getCodeName().toLowerCase(), iPSSysBICubeDimension);
            }
        }
        this.iDataEntityRuntime = this.getSysBISchemeRuntime().getSystemRuntime().getDataEntityRuntime(this.getPSSysBICube().getPSDataEntityMust().getId(), true);
        if (this.iDataEntityRuntime == null) {
            throw new Exception("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        }
        if (this.getSysBICubeCalculatedDimensionParser(true) == null) {
            this.setSysBICubeCalculatedDimensionParser(this.iDataEntityRuntime.getSystemRuntime().getRuntimeObject(ISysBICubeCalculatedDimensionParser.class, "SQL"));
            this.getSysBICubeCalculatedDimensionParser(false);
        }
        if (this.getSysBICubeCalculatedMeasureParser(true) == null) {
            this.setSysBICubeCalculatedMeasureParser(this.iDataEntityRuntime.getSystemRuntime().getRuntimeObject(ISysBICubeCalculatedMeasureParser.class, "SQL"));
            this.getSysBICubeCalculatedMeasureParser(false);
        }
        super.onInit();
    }

    public ISystemRuntime getSystemRuntime() {
        return this.getSysBISchemeRuntime().getSystemRuntime();
    }

    protected ISysBISchemeRuntimeContext getSysBISchemeRuntimeContext() {
        return this.iSysBISchemeRuntimeContext;
    }

    protected ISysBICubeCalculatedDimensionParser getSysBICubeCalculatedDimensionParser(boolean bTryMode) throws Exception {
        if (this.iSysBICubeCalculatedDimensionParser != null || bTryMode) {
            return this.iSysBICubeCalculatedDimensionParser;
        }
        throw new Exception("\u7cfb\u7edf\u667a\u80fd\u7acb\u65b9\u4f53\u8ba1\u7b97\u7ef4\u5ea6\u5206\u6790\u5668\u5bf9\u8c61\u65e0\u6548");
    }

    protected void setSysBICubeCalculatedDimensionParser(ISysBICubeCalculatedDimensionParser iSysBICubeCalculatedDimensionParser) {
        this.iSysBICubeCalculatedDimensionParser = iSysBICubeCalculatedDimensionParser;
    }

    protected ISysBICubeCalculatedMeasureParser getSysBICubeCalculatedMeasureParser(boolean bTryMode) throws Exception {
        if (this.iSysBICubeCalculatedMeasureParser != null || bTryMode) {
            return this.iSysBICubeCalculatedMeasureParser;
        }
        throw new Exception("\u7cfb\u7edf\u667a\u80fd\u7acb\u65b9\u4f53\u8ba1\u7b97\u6307\u6807\u5206\u6790\u5668\u5bf9\u8c61\u65e0\u6548");
    }

    protected void setSysBICubeCalculatedMeasureParser(ISysBICubeCalculatedMeasureParser iSysBICubeCalculatedMeasureParser) {
        this.iSysBICubeCalculatedMeasureParser = iSysBICubeCalculatedMeasureParser;
    }

    @Override
    public IPSSysBICube getPSSysBICube() {
        return this.iPSSysBICube;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysBICube();
    }

    @Override
    public String getId() {
        return this.getPSSysBICube().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysBICube().getName();
    }

    @Override
    public String getAccessKey() {
        return this.strAccessKey;
    }

    @Override
    public ISysBISchemeRuntime getSysBISchemeRuntime() {
        return this.getSysBISchemeRuntimeContext().getSysBISchemeRuntime();
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    @Override
    public IPSSysBICubeMeasure getPSSysBICubeMeasure(String strName, boolean bTryMode) {
        Assert.hasLength((String)strName, (String)"\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u6307\u6807\u540d\u79f0");
        IPSSysBICubeMeasure iPSSysBICubeMeasure = this.psSysBICubeMeasureMap.get(strName.toLowerCase());
        if (iPSSysBICubeMeasure != null || bTryMode) {
            return iPSSysBICubeMeasure;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    @Override
    public IPSSysBICubeDimension getPSSysBICubeDimension(String strName, boolean bTryMode) {
        Assert.hasLength((String)strName, (String)"\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u7ef4\u5ea6\u540d\u79f0");
        IPSSysBICubeDimension iPSSysBICubeDimension = this.psSysBICubeDimensionMap.get(strName.toLowerCase());
        if (iPSSysBICubeDimension != null || bTryMode) {
            return iPSSysBICubeDimension;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    @Override
    public List fetch(IBISearchContext iBISearchContext) throws Throwable {
        Assert.notNull((Object)iBISearchContext, (String)"\u4f20\u5165BI\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        try {
            this.onBeforeFetch(iBISearchContext);
            return this.onFetch(iBISearchContext);
        }
        catch (Throwable ex) {
            SysBISchemeRuntimeException.rethrow(this, ex);
            throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), (IModelRuntime)this, String.format("\u67e5\u8be2\u7acb\u65b9\u4f53\u6570\u636e\u53d1\u751f\u5f02\u5e38, %1$s", ex.getMessage()), ex);
        }
    }

    protected void onBeforeFetch(IBISearchContext iBISearchContext) throws Throwable {
        List psSysBICubeDimensionList;
        if (ObjectUtils.isEmpty(iBISearchContext.getBISearchDimensions()) && !ObjectUtils.isEmpty((Object)(psSysBICubeDimensionList = this.getPSSysBICube().getAllPSSysBICubeDimensions()))) {
            for (IPSSysBICubeDimension item : psSysBICubeDimensionList) {
                if (!item.isDefault()) continue;
                BISearchDimension biSearchDimension = new BISearchDimension();
                biSearchDimension.setName(item.getCodeName());
                iBISearchContext.getBISearchDimensionsIf().add(biSearchDimension);
            }
        }
        if (ObjectUtils.isEmpty(iBISearchContext.getBISearchMeasures())) {
            throw new Exception("\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u6307\u6807");
        }
    }

    protected List onFetch(IBISearchContext iBISearchContext) throws Throwable {
        ISearchCond iSearchCond;
        String strSelectCode;
        ObjectNode groupParamNode;
        IPSDEDataSet iPSDEDataSet = this.getPSSysBICube().getPSDEDataSet();
        if (iPSDEDataSet == null) {
            iPSDEDataSet = this.getDataEntityRuntime().getDefaultPSDEDataSet();
        }
        ObjectNode deDataSetNode = iPSDEDataSet.getObjectNode().deepCopy();
        deDataSetNode.put("groupMode", PSModelEnums.DEDataSetGroupMode.GROUPPARAMEX.value);
        deDataSetNode.put("enableGroup", true);
        deDataSetNode.remove("getPSDEDataSetGroupParams");
        ArrayNode groupParamArray = deDataSetNode.putArray("getPSDEDataSetGroupParams");
        LinkedHashSet<String> columnList = new LinkedHashSet<String>();
        if (!ObjectUtils.isEmpty(iBISearchContext.getBISearchMeasures())) {
            for (IBISearchMeasure iBISearchMeasure : iBISearchContext.getBISearchMeasures()) {
                IPSSysBICubeMeasure iPSSysBICubeMeasure = this.getPSSysBICubeMeasure(iBISearchMeasure.getName(), false);
                if (PSModelEnums.BIMeasureType.COMMON.value.equals(iPSSysBICubeMeasure.getMeasureType()) && iPSSysBICubeMeasure.getPSDEField() != null) {
                    columnList.add(iPSSysBICubeMeasure.getPSDEField().getName());
                }
                try {
                    groupParamNode = this.getMeasureDataSetGroupParamModel(iBISearchContext, iBISearchMeasure, iPSSysBICubeMeasure);
                    groupParamArray.add((JsonNode)groupParamNode);
                    if (!groupParamNode.has("selectCode") || !StringUtils.hasLength((String)(strSelectCode = groupParamNode.get("selectCode").asText()))) continue;
                    columnList.addAll(Arrays.asList(strSelectCode.toUpperCase().split("[,]")));
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u8ba1\u7b97\u6307\u6807\u6a21\u578b[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICubeMeasure.getName(), ex.getMessage()));
                }
            }
        }
        if (!ObjectUtils.isEmpty(iBISearchContext.getBISearchDimensions())) {
            for (IBISearchDimension iBISearchDimension : iBISearchContext.getBISearchDimensions()) {
                IPSSysBICubeDimension iPSSysBICubeDimension = this.getPSSysBICubeDimension(iBISearchDimension.getName(), false);
                if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType()) && iPSSysBICubeDimension.getPSDEField() != null) {
                    columnList.add(iPSSysBICubeDimension.getPSDEField().getName());
                }
                try {
                    groupParamNode = this.getDimensionDataSetGroupParamModel(iBISearchContext, iBISearchDimension, iPSSysBICubeDimension, false);
                    groupParamArray.add((JsonNode)groupParamNode);
                    if (groupParamNode.has("selectCode") && StringUtils.hasLength((String)(strSelectCode = groupParamNode.get("selectCode").asText()))) {
                        columnList.addAll(Arrays.asList(strSelectCode.toUpperCase().split("[,]")));
                    }
                    if (iPSSysBICubeDimension.getTextPSDEField() == null) continue;
                    ObjectNode groupParamNode2 = this.getDimensionDataSetGroupParamModel(iBISearchContext, iBISearchDimension, iPSSysBICubeDimension, true);
                    groupParamArray.add((JsonNode)groupParamNode2);
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u8ba1\u7b97\u7ef4\u5ea6\u6a21\u578b[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICubeDimension.getName(), ex.getMessage()));
                }
            }
        }
        HashMap<String, String> ignoreMap = new HashMap<String, String>();
        Collection<ObjectNode> dynaFieldParams = this.getDynaFieldDataSetGroupParamModels(iBISearchContext, columnList);
        if (!ObjectUtils.isEmpty(dynaFieldParams)) {
            groupParamArray.addAll(dynaFieldParams);
            for (ObjectNode node : dynaFieldParams) {
                String strName = JsonUtils.getField(node, "name", null);
                if (!StringUtils.hasLength((String)strName)) continue;
                ignoreMap.put(strName.toLowerCase(), "");
            }
        }
        if (!ObjectUtils.isEmpty(iBISearchContext.getBISearchMeasures())) {
            for (IBISearchMeasure iBISearchMeasure : iBISearchContext.getBISearchMeasures()) {
                if (iBISearchMeasure.isHidden()) {
                    ignoreMap.put(iBISearchMeasure.getName().toLowerCase(), "");
                    continue;
                }
                ignoreMap.remove(iBISearchMeasure.getName().toLowerCase());
            }
        }
        if (this.isEnableAuthoritySearchCond() && (iSearchCond = this.getAuthoritySearchCond(iBISearchContext, columnList)) != null) {
            iBISearchContext.getSearchContext().getSearchCondsIf().add(iSearchCond);
        }
        iPSDEDataSet = (IPSDEDataSet)this.getSysBISchemeRuntime().getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getDataEntityRuntime().getPSDataEntity(), IPSDEDataSet.class, deDataSetNode);
        ArrayList<IEntity> entityList = new ArrayList<IEntity>();
        List page = this.doFetch(iBISearchContext, iPSDEDataSet);
        if (!ObjectUtils.isEmpty((Object)page)) {
            for (Object item : page) {
                entityList.add(this.getSysBISchemeRuntime().getSystemRuntime().createEntity(item));
            }
        }
        if (!ObjectUtils.isEmpty(entityList) && !ObjectUtils.isEmpty(ignoreMap)) {
            for (IEntity iEntity : entityList) {
                for (String strName : ignoreMap.keySet()) {
                    iEntity.reset(strName);
                }
            }
        }
        return entityList;
    }

    protected List doFetch(IBISearchContext iBISearchContext, IPSDEDataSet iPSDEDataSet) throws Throwable {
        ISearchContext iSearchContext = iBISearchContext.getSearchContext();
        iSearchContext.setCount(false);
        iSearchContext.setPageable(0, Integer.MAX_VALUE, 0L);
        iSearchContext.setPageSort(iBISearchContext.getBISort());
        IBISearchPeriod iBISearchPeriod = iBISearchContext.getBISearchPeriod();
        if (iBISearchPeriod != null) {
            Map<String, ISearchCond> conds = null;
            try {
                conds = this.getSearchPeriodConds(iBISearchPeriod);
                if (ObjectUtils.isEmpty(conds)) {
                    throw new Exception(String.format("\u672a\u8fd4\u56de\u4efb\u4f55\u6761\u4ef6", new Object[0]));
                }
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u8ba1\u7b97\u5468\u671f\u6761\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c %1$s", ex.getMessage()), ex);
            }
            ISearchGroupCond iSearchGroupCond = SearchContextDTO.getSearchGroupCondByCat(iSearchContext, SEARCHCONDCAT_BISEARCHPERIOD);
            if (iSearchGroupCond == null) {
                SearchGroupCond searchGroupCond = new SearchGroupCond();
                searchGroupCond.setCondOp("AND");
                searchGroupCond.setCat(SEARCHCONDCAT_BISEARCHPERIOD);
                iSearchContext.getSearchCondsIf().add(searchGroupCond);
                iSearchGroupCond = searchGroupCond;
            }
            ArrayList all = new ArrayList();
            for (Map.Entry<String, ISearchCond> entry : conds.entrySet()) {
                iSearchGroupCond.getSearchCondsIf().clear();
                iSearchGroupCond.getSearchCondsIf().add(entry.getValue());
                List list = this.doFetch(iSearchContext, iPSDEDataSet);
                if (ObjectUtils.isEmpty((Object)list)) continue;
                for (Object item : list) {
                    if (!(item instanceof Map)) continue;
                    ((Map)item).put("srfperiodtype", entry.getKey());
                }
                all.addAll(list);
            }
            return all;
        }
        return this.doFetch(iSearchContext, iPSDEDataSet);
    }

    protected Map<String, ISearchCond> getSearchPeriodConds(IBISearchPeriod iBISearchPeriod) throws Throwable {
        int i;
        String strCond2;
        int i2;
        int nDays;
        Calendar end;
        Calendar start;
        String strCond;
        Calendar end2;
        Calendar start2;
        LinkedHashMap<String, ISearchCond> searchCondMap = new LinkedHashMap<String, ISearchCond>();
        if (!StringUtils.hasLength((String)iBISearchPeriod.getField())) {
            throw new Exception("\u672a\u6307\u5b9a\u65f6\u95f4\u7ef4\u5ea6");
        }
        Timestamp startTime = null;
        Timestamp endTime = null;
        String strUnit = iBISearchPeriod.getUnit();
        String strType = iBISearchPeriod.getType();
        if (StringUtils.hasLength((String)strType) && strType.indexOf("CURRENT_") == 0) {
            String[] items = strType.split("[_]");
            strType = "CURRENT";
            if (items.length == 2) {
                strUnit = items[1];
            }
        }
        if ("STATIC".equals(strType)) {
            startTime = new Timestamp(iBISearchPeriod.getStart() * 1000L);
            endTime = new Timestamp(iBISearchPeriod.getEnd() * 1000L);
        } else if ("DYNAMIC".equals(strType) || "CURRENT".equals(strType)) {
            start2 = Calendar.getInstance();
            start2.setTimeInMillis(System.currentTimeMillis());
            end2 = Calendar.getInstance();
            end2.setTimeInMillis(System.currentTimeMillis());
            if ("DYNAMIC".equals(strType)) {
                if ("DAY".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start2.add(5, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end2.add(5, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("WEEK".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start2.add(3, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end2.add(3, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("MONTH".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start2.add(2, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end2.add(2, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("QUARTER".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start2.add(2, (int)iBISearchPeriod.getStart() * 3);
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end2.add(2, (int)iBISearchPeriod.getEnd() * 3);
                    }
                } else if ("YEAR".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start2.add(1, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end2.add(1, (int)iBISearchPeriod.getEnd());
                    }
                } else {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u4f4d[%1$s]", strUnit));
                }
            }
            startTime = new Timestamp(start2.getTimeInMillis());
            endTime = new Timestamp(end2.getTimeInMillis());
        }
        if (startTime == null) {
            throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4");
        }
        if (endTime == null) {
            throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4");
        }
        if (endTime.getTime() < startTime.getTime()) {
            throw new Exception("\u7ed3\u675f\u65f6\u95f4\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if ("DAY".equals(strUnit)) {
            strCond = String.format("(%1$s >= TIMESTAMP('%2$s')) AND (%1$s <= TIMESTAMP('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            searchCondMap.put("", SearchCustomCond.of(strCond, "PQL"));
            if (iBISearchPeriod.getPoP() > 0) {
                start = Calendar.getInstance();
                start.setTimeInMillis(startTime.getTime());
                end = Calendar.getInstance();
                end.setTimeInMillis(endTime.getTime());
                nDays = (int)(endTime.getTime() / 86400000L - startTime.getTime() / 86400000L + 1L);
                for (i2 = 0; i2 < iBISearchPeriod.getPoP(); ++i2) {
                    start.add(5, -(i2 + 1) * nDays);
                    end.add(5, -(i2 + 1) * nDays);
                    strCond2 = String.format("(%1$s >= TIMESTAMP('%2$s')) AND (%1$s <= TIMESTAMP('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end.getTime()));
                    searchCondMap.put(String.format("PoP%1$s", i2 + 1), SearchCustomCond.of(strCond2, "PQL"));
                }
            }
        } else if ("WEEK".equals(strUnit)) {
            strCond = String.format("(%1$s >= STARTOFWEEK('%2$s')) AND (%1$s <= ENDOFWEEK('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            searchCondMap.put("", SearchCustomCond.of(strCond, "PQL"));
            if (iBISearchPeriod.getPoP() > 0) {
                start = Calendar.getInstance();
                start.setTimeInMillis(startTime.getTime());
                end = Calendar.getInstance();
                end.setTimeInMillis(endTime.getTime());
                nDays = (int)(endTime.getTime() / 86400000L - startTime.getTime() / 86400000L + 1L);
                for (int i3 = 0; i3 < iBISearchPeriod.getPoP(); ++i3) {
                    start.add(5, -(i3 + 1) * nDays);
                    end.add(5, -(i3 + 1) * nDays);
                    strCond2 = String.format("(%1$s >= STARTOFWEEK('%2$s')) AND (%1$s <= ENDOFWEEK('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end.getTime()));
                    searchCondMap.put(String.format("PoP%1$s", i3 + 1), SearchCustomCond.of(strCond2, "PQL"));
                }
            }
        } else if ("MONTH".equals(strUnit)) {
            strCond = String.format("(%1$s >= STARTOFMONTH('%2$s')) AND (%1$s <= ENDOFMONTH('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            searchCondMap.put("", SearchCustomCond.of(strCond, "PQL"));
            if (iBISearchPeriod.getPoP() > 0) {
                start = Calendar.getInstance();
                start.setTimeInMillis(startTime.getTime());
                end = Calendar.getInstance();
                end.setTimeInMillis(endTime.getTime());
                for (i = 0; i < iBISearchPeriod.getPoP(); ++i) {
                    start.add(2, -(i + 1));
                    end.add(2, -(i + 1));
                    String strCond22 = String.format("(%1$s >= STARTOFMONTH('%2$s')) AND (%1$s <= ENDOFMONTH('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end.getTime()));
                    searchCondMap.put(String.format("PoP%1$s", i + 1), SearchCustomCond.of(strCond22, "PQL"));
                }
            }
        } else if ("QUARTER".equals(strUnit)) {
            strCond = String.format("(%1$s >= STARTOFQUARTER('%2$s')) AND (%1$s <= ENDOFQUARTER('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            searchCondMap.put("", SearchCustomCond.of(strCond, "PQL"));
            if (iBISearchPeriod.getPoP() > 0) {
                start = Calendar.getInstance();
                start.setTimeInMillis(startTime.getTime());
                end = Calendar.getInstance();
                end.setTimeInMillis(endTime.getTime());
                for (i = 0; i < iBISearchPeriod.getPoP(); ++i) {
                    start.add(2, -(i + 1) * 3);
                    end.add(2, -(i + 1) * 3);
                    String strCond23 = String.format("(%1$s >= STARTOFQUARTER('%2$s')) AND (%1$s <= ENDOFQUARTER('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end.getTime()));
                    searchCondMap.put(String.format("PoP%1$s", i + 1), SearchCustomCond.of(strCond23, "PQL"));
                }
            }
        } else if ("YEAR".equals(strUnit)) {
            strCond = String.format("(%1$s >= STARTOFYEAR('%2$s')) AND (%1$s <= ENDOFYEAR('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            searchCondMap.put("", SearchCustomCond.of(strCond, "PQL"));
            if (iBISearchPeriod.getPoP() > 0) {
                start = Calendar.getInstance();
                start.setTimeInMillis(startTime.getTime());
                end = Calendar.getInstance();
                end.setTimeInMillis(endTime.getTime());
                for (i = 0; i < iBISearchPeriod.getPoP(); ++i) {
                    start.add(1, -(i + 1));
                    end.add(1, -(i + 1));
                    String strCond24 = String.format("(%1$s >= STARTOFYEAR('%2$s')) AND (%1$s <= ENDOFYEAR('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end.getTime()));
                    searchCondMap.put(String.format("PoP%1$s", i + 1), SearchCustomCond.of(strCond24, "PQL"));
                }
            }
        } else {
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u4f4d[%1$s]", strUnit));
        }
        if (iBISearchPeriod.getYoY() > 0) {
            start2 = Calendar.getInstance();
            start2.setTimeInMillis(startTime.getTime());
            end2 = Calendar.getInstance();
            end2.setTimeInMillis(endTime.getTime());
            int nStartWeekOfYear = start2.get(3);
            int nEndWeekOfYear = end2.get(3);
            for (i2 = 0; i2 < iBISearchPeriod.getYoY(); ++i2) {
                start2.add(1, -(i2 + 1));
                end2.add(1, -(i2 + 1));
                if ("DAY".equals(strUnit)) {
                    strCond2 = String.format("(%1$s >= TIMESTAMP('%2$s')) AND (%1$s <= TIMESTAMP('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start2.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end2.getTime()));
                    searchCondMap.put(String.format("YoY%1$s", i2 + 1), SearchCustomCond.of(strCond2, "PQL"));
                    continue;
                }
                if ("WEEK".equals(strUnit)) {
                    start2.set(3, nStartWeekOfYear);
                    end2.set(3, nEndWeekOfYear);
                    strCond2 = String.format("(%1$s >= STARTOFWEEK('%2$s')) AND (%1$s <= ENDOFWEEK('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start2.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end2.getTime()));
                    searchCondMap.put(String.format("YoY%1$s", i2 + 1), SearchCustomCond.of(strCond2, "PQL"));
                    continue;
                }
                if ("MONTH".equals(strUnit)) {
                    strCond2 = String.format("(%1$s >= STARTOFMONTH('%2$s')) AND (%1$s <= ENDOFMONTH('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start2.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end2.getTime()));
                    searchCondMap.put(String.format("YoY%1$s", i2 + 1), SearchCustomCond.of(strCond2, "PQL"));
                    continue;
                }
                if (!"QUARTER".equals(strUnit)) continue;
                strCond2 = String.format("(%1$s >= STARTOFQUARTER('%2$s')) AND (%1$s <= ENDOFQUARTER('%3$s'))", iBISearchPeriod.getField(), String.format("%1$tY-%1$tm-%1$td 00:00:00", start2.getTime()), String.format("%1$tY-%1$tm-%1$td 23:59:59", end2.getTime()));
                searchCondMap.put(String.format("YoY%1$s", i2 + 1), SearchCustomCond.of(strCond2, "PQL"));
            }
        }
        return searchCondMap;
    }

    protected ISearchCond fillDimensionDataSetGroupParamPeriodModel(ObjectNode groupParamNode, IBISearchPeriod iBISearchPeriod, IBISearchContext iBISearchContext, IBISearchDimension iBISearchDimension, IPSSysBICubeDimension iPSSysBICubeDimension) throws Throwable {
        String strCond;
        String strGroupCode;
        String strField = null;
        strField = PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType()) ? iPSSysBICubeDimension.getPSDEFieldMust().getName() : this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, this, iBISearchContext, null);
        Timestamp startTime = null;
        Timestamp endTime = null;
        String strUnit = iBISearchPeriod.getUnit();
        String strType = iBISearchPeriod.getType();
        if (!"STATIC".equals(strType) && !"DYNAMIC".equals(strType)) {
            throw new Exception(String.format("\u5468\u671f\u7c7b\u578b[%1$s]\u4e0d\u652f\u6301", strType));
        }
        if ("STATIC".equals(strType)) {
            startTime = new Timestamp(iBISearchPeriod.getStart() * 1000L);
            endTime = new Timestamp(iBISearchPeriod.getEnd() * 1000L);
        } else if ("DYNAMIC".equals(strType)) {
            Calendar start = Calendar.getInstance();
            start.setTimeInMillis(System.currentTimeMillis());
            Calendar end = Calendar.getInstance();
            end.setTimeInMillis(System.currentTimeMillis());
            if ("DYNAMIC".equals(strType)) {
                if ("DAY".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start.add(5, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end.add(5, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("WEEK".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start.add(3, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end.add(3, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("MONTH".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start.add(2, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end.add(2, (int)iBISearchPeriod.getEnd());
                    }
                } else if ("QUARTER".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start.add(2, (int)iBISearchPeriod.getStart() * 3);
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end.add(2, (int)iBISearchPeriod.getEnd() * 3);
                    }
                } else if ("YEAR".equals(strUnit)) {
                    if (iBISearchPeriod.getStart() != 0L) {
                        start.add(1, (int)iBISearchPeriod.getStart());
                    }
                    if (iBISearchPeriod.getEnd() != 0L) {
                        end.add(1, (int)iBISearchPeriod.getEnd());
                    }
                } else {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u4f4d[%1$s]", strUnit));
                }
            }
            startTime = new Timestamp(start.getTimeInMillis());
            endTime = new Timestamp(end.getTimeInMillis());
        }
        if (startTime == null) {
            throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4");
        }
        if (endTime == null) {
            throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4");
        }
        if (endTime.getTime() < startTime.getTime()) {
            throw new Exception("\u7ed3\u675f\u65f6\u95f4\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if ("DAY".equals(strUnit)) {
            strGroupCode = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, String.format("DATEFORMAT(%1$s, '%%Y%%m%%d')", strField), this, iBISearchContext, null);
            groupParamNode.put("groupCode", strGroupCode);
            strCond = String.format("(%1$s >= TIMESTAMP('%2$s')) AND (%1$s <= TIMESTAMP('%3$s'))", strField, String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            return SearchCustomCond.of(strCond, "PQL");
        }
        if ("WEEK".equals(strUnit)) {
            strGroupCode = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, String.format("YEARWEEKCHAR(%1$s)", strField), this, iBISearchContext, null);
            groupParamNode.put("groupCode", strGroupCode);
            strCond = String.format("(%1$s >= STARTOFWEEK('%2$s')) AND (%1$s <= ENDOFWEEK('%3$s'))", strField, String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            return SearchCustomCond.of(strCond, "PQL");
        }
        if ("MONTH".equals(strUnit)) {
            strGroupCode = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, String.format("DATEFORMAT(%1$s, '%%Y%%m')", strField), this, iBISearchContext, null);
            groupParamNode.put("groupCode", strGroupCode);
            strCond = String.format("(%1$s >= STARTOFMONTH('%2$s')) AND (%1$s <= ENDOFMONTH('%3$s'))", strField, String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            return SearchCustomCond.of(strCond, "PQL");
        }
        if ("QUARTER".equals(strUnit)) {
            strGroupCode = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, String.format("YEARQUARTERCHAR(%1$s)", strField), this, iBISearchContext, null);
            groupParamNode.put("groupCode", strGroupCode);
            strCond = String.format("(%1$s >= STARTOFQUARTER('%2$s')) AND (%1$s <= ENDOFQUARTER('%3$s'))", strField, String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            return SearchCustomCond.of(strCond, "PQL");
        }
        if ("YEAR".equals(strUnit)) {
            strGroupCode = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, String.format("DATEFORMAT(%1$s, '%%Y')", strField), this, iBISearchContext, null);
            groupParamNode.put("groupCode", strGroupCode);
            strCond = String.format("(%1$s >= STARTOFYEAR('%2$s')) AND (%1$s <= ENDOFYEAR('%3$s'))", strField, String.format("%1$tY-%1$tm-%1$td 00:00:00", startTime), String.format("%1$tY-%1$tm-%1$td 23:59:59", endTime));
            return SearchCustomCond.of(strCond, "PQL");
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5355\u4f4d[%1$s]", strUnit));
    }

    protected List doFetch(final ISearchContext iSearchContext, final IPSDEDataSet iPSDEDataSet) throws Throwable {
        return (List)this.getDataEntityRuntime().execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                Page page = SysBICubeRuntimeBase.this.getDataEntityRuntime().getSystemPersistentAdapterMust().fetchDataSet(SysBICubeRuntimeBase.this.getDataEntityRuntime(), iPSDEDataSet, iSearchContext, null);
                return page != null ? page.getContent() : null;
            }
        }, null);
    }

    protected List<IPSDEField> getDynaFields() throws Throwable {
        List<IPSDEField> psDEFields = this.getDataEntityRuntime().getPSDEFields(true);
        if (ObjectUtils.isEmpty(psDEFields)) {
            return null;
        }
        ArrayList<IPSDEField> list = new ArrayList<IPSDEField>();
        for (IPSDEField iPSDEField : psDEFields) {
            if (!iPSDEField.isDynaStorageDEField()) continue;
            list.add(iPSDEField);
        }
        return list;
    }

    protected Collection<ObjectNode> getDynaFieldDataSetGroupParamModels(IBISearchContext iBISearchContext, Set<String> columnList) throws Throwable {
        LinkedHashMap<String, ObjectNode> map = new LinkedHashMap<String, ObjectNode>();
        LinkedHashSet<String> columnList2 = new LinkedHashSet<String>();
        for (String strColumn : columnList) {
            IPSSysBICubeMeasure iPSSysBICubeMeasure = this.getPSSysBICubeMeasure(strColumn, true);
            if (iPSSysBICubeMeasure == null || !iPSSysBICubeMeasure.isDataItem() || !PSModelEnums.BIMeasureType.CALCULATED.value.equals(iPSSysBICubeMeasure.getMeasureType())) continue;
            String strFormula = this.getSysBICubeCalculatedMeasureParser(false).parse(iPSSysBICubeMeasure, this, iBISearchContext, columnList2);
            String strGroupCode = "";
            strGroupCode = strGroupCode + String.format("(%1$s) AS %2$s", strFormula, iPSSysBICubeMeasure.getCodeName().toUpperCase());
            ObjectNode objectNode = JsonUtils.createObjectNode();
            objectNode.put("name", String.format("%1$s_%2$s", "DATAITEM", iPSSysBICubeMeasure.getCodeName()).toLowerCase());
            objectNode.put("groupCode", strGroupCode);
            objectNode.put("groupJoinCode", "NONE");
            map.put(strColumn, objectNode);
        }
        if (!this.getDataEntityRuntime().isEnableDynaStorage() || this.getDataEntityRuntime().getDEDynaStorageUtilRuntime() == null) {
            return map.values();
        }
        IDEDynaStorageUtilRuntime iDEDynaStorageUtilRuntime = this.getDataEntityRuntime().getDEDynaStorageUtilRuntime();
        IPSDEField parentTypePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
        IPSDEField parentIdPSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        IPSDEField namePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField("NAME", false);
        List<IPSDEField> psDEFields = this.getDynaFields();
        if (ObjectUtils.isEmpty(psDEFields)) {
            return map.values();
        }
        String strMajorAlias = "dataresult";
        String strKeyCode = "";
        strKeyCode = String.format("%1$s.%2$s", strMajorAlias, this.getDataEntityRuntime().getKeyPSDEField().getName());
        for (int i = 0; i < psDEFields.size(); ++i) {
            IPSDEField iPSDEField = psDEFields.get(i);
            if (columnList != null && !columnList.contains(iPSDEField.getName()) || map.containsKey(iPSDEField.getName())) continue;
            String strAlias = String.format("dynaresult%1$s", i);
            IPSDEField storagePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(iPSDEField);
            ObjectNode objectNode = JsonUtils.createObjectNode();
            String strJoinCode = String.format("LEFT JOIN %1$s %2$s ON (%3$s= %2$s.%4$s AND %2$s.%5$s = '%6$s' AND %2$s.%7$s = '%8$s')", iDEDynaStorageUtilRuntime.getStorageDataEntityRuntime().getTableName(), strAlias, strKeyCode, parentIdPSDEField.getName(), parentTypePSDEField.getName(), this.getDataEntityRuntime().getName(), namePSDEField.getName(), iPSDEField.getName());
            String strGroupCode = "";
            strGroupCode = strGroupCode + String.format("%1$s.%2$s AS %3$s", strAlias, storagePSDEField.getName(), iPSDEField.getName());
            objectNode.put("name", String.format("%1$s_%2$s", strAlias, iPSDEField.getName()).toLowerCase());
            objectNode.put("groupCode", strGroupCode);
            objectNode.put("groupJoinCode", strJoinCode);
            map.put(iPSDEField.getName(), objectNode);
        }
        return map.values();
    }

    protected ObjectNode getMeasureDataSetGroupParamModel(IBISearchContext iBISearchContext, IBISearchMeasure iBISearchMeasure, IPSSysBICubeMeasure iPSSysBICubeMeasure) throws Throwable {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("name", iPSSysBICubeMeasure.getCodeName());
        objectNode.put("alias", iPSSysBICubeMeasure.getCodeName());
        IPSDEField iPSDEField = iPSSysBICubeMeasure.getPSDEField();
        if (iPSDEField != null) {
            objectNode.put("getPSDEField", iPSSysBICubeMeasure.getObjectNode().get("getPSDEField").deepCopy());
            objectNode.put("name", iPSDEField.getName());
        }
        objectNode.put("enableGroup", false);
        if (PSModelEnums.BIMeasureType.COMMON.value.equals(iPSSysBICubeMeasure.getMeasureType())) {
            if (iPSDEField == null) {
                throw new Exception(String.format("\u6307\u6807[%1$s]\u672a\u6307\u5b9a\u5c5e\u6027", iPSSysBICubeMeasure.getName()));
            }
            if (StringUtils.hasLength((String)iBISearchMeasure.getAggMode())) {
                objectNode.put("aggMode", iBISearchMeasure.getAggMode());
            } else {
                objectNode.put("aggMode", iPSSysBICubeMeasure.getAggMode());
            }
            if (iPSDEField.getDEFType() == PSModelEnums.DEFType.DYNASTORAGE.value) {
                objectNode.put("selectCode", iPSDEField.getName());
            }
        } else if (PSModelEnums.BIMeasureType.CALCULATED.value.equals(iPSSysBICubeMeasure.getMeasureType())) {
            LinkedHashSet<String> columnList = new LinkedHashSet<String>();
            String strFormula = this.getSysBICubeCalculatedMeasureParser(false).parse(iPSSysBICubeMeasure, this, iBISearchContext, columnList);
            if (!iPSSysBICubeMeasure.isDataItem()) {
                objectNode.put("groupCode", strFormula);
                if (!ObjectUtils.isEmpty(columnList)) {
                    objectNode.put("selectCode", StringUtils.collectionToDelimitedString(columnList, (String)","));
                }
            } else {
                if (StringUtils.hasLength((String)iBISearchMeasure.getAggMode())) {
                    objectNode.put("aggMode", iBISearchMeasure.getAggMode());
                } else {
                    objectNode.put("aggMode", iPSSysBICubeMeasure.getAggMode());
                }
                objectNode.put("selectCode", iPSSysBICubeMeasure.getCodeName());
                objectNode.put("groupCode", iPSSysBICubeMeasure.getCodeName());
            }
        } else {
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6307\u6807\u7c7b\u578b[%1$s]", iPSSysBICubeMeasure.getMeasureType()));
        }
        return objectNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ObjectNode getDimensionDataSetGroupParamModel(IBISearchContext iBISearchContext, IBISearchDimension iBISearchDimension, IPSSysBICubeDimension iPSSysBICubeDimension, boolean bText) throws Throwable {
        IPSDEField iPSDEField;
        ObjectNode objectNode = JsonUtils.createObjectNode();
        IPSDEField iPSDEField2 = iPSDEField = bText ? iPSSysBICubeDimension.getTextPSDEFieldMust() : iPSSysBICubeDimension.getPSDEField();
        if (bText) {
            objectNode.put("name", String.format("%1$s_text", iPSSysBICubeDimension.getCodeName()));
            objectNode.put("alias", String.format("%1$s_text", iPSSysBICubeDimension.getCodeName()));
        } else {
            objectNode.put("name", iPSSysBICubeDimension.getCodeName());
            objectNode.put("alias", iPSSysBICubeDimension.getCodeName());
        }
        if (iPSDEField != null) {
            if (bText) {
                objectNode.put("getPSDEField", iPSSysBICubeDimension.getObjectNode().get("getTextPSDEField").deepCopy());
            } else {
                objectNode.put("getPSDEField", iPSSysBICubeDimension.getObjectNode().get("getPSDEField").deepCopy());
            }
            objectNode.put("name", iPSDEField.getName());
        }
        objectNode.put("enableGroup", true);
        if (bText || iPSSysBICubeDimension.getPSSysBIDimension() == null) {
            if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                ISearchCond iSearchCond;
                if (iPSDEField == null) {
                    throw new Exception(String.format("\u7ef4\u5ea6[%1$s]\u672a\u6307\u5b9a\u5c5e\u6027", iPSSysBICubeDimension.getName()));
                }
                if (bText || iBISearchDimension.getPeriod() == null || !DataTypeUtils.isDateTimeDataType((int)iPSSysBICubeDimension.getStdDataType()) || (iSearchCond = this.fillDimensionDataSetGroupParamPeriodModel(objectNode, iBISearchDimension.getPeriod(), iBISearchContext, iBISearchDimension, iPSSysBICubeDimension)) == null) return objectNode;
                iBISearchContext.getSearchContext().getSearchCondsIf().add(iSearchCond);
                return objectNode;
            } else {
                ISearchCond iSearchCond;
                if (bText || !PSModelEnums.BIDimensionType.CALCULATED.value.equals(iPSSysBICubeDimension.getDimensionType())) throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
                if (iBISearchDimension.getPeriod() != null && DataTypeUtils.isDateTimeDataType((int)iPSSysBICubeDimension.getStdDataType()) && (iSearchCond = this.fillDimensionDataSetGroupParamPeriodModel(objectNode, iBISearchDimension.getPeriod(), iBISearchContext, iBISearchDimension, iPSSysBICubeDimension)) != null) {
                    iBISearchContext.getSearchContext().getSearchCondsIf().add(iSearchCond);
                }
                LinkedHashSet<String> columnList = new LinkedHashSet<String>();
                String strFormula = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, this, iBISearchContext, columnList);
                objectNode.put("groupCode", strFormula);
                if (ObjectUtils.isEmpty(columnList)) return objectNode;
                objectNode.put("selectCode", StringUtils.collectionToDelimitedString(columnList, (String)","));
            }
            return objectNode;
        } else {
            String strHierarchy = iBISearchDimension.getHierarchy();
            IPSSysBIHierarchy iPSSysBIHierarchy = null;
            List list = iPSSysBICubeDimension.getPSSysBIDimension().getAllPSSysBIHierarchies();
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (IPSSysBIHierarchy item : list) {
                    if (StringUtils.hasLength((String)strHierarchy)) {
                        if (!strHierarchy.equalsIgnoreCase(item.getCodeName())) continue;
                        iPSSysBIHierarchy = item;
                        break;
                    }
                    iPSSysBIHierarchy = item;
                    break;
                }
            }
            if (iPSSysBIHierarchy == null) {
                throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u5c42\u6b21\u4f53\u7cfb[%1$s]", strHierarchy));
            }
            LinkedHashSet<IPSSysBILevel> selectedPSSysBILevelList = new LinkedHashSet<IPSSysBILevel>();
            List psSysBILevelList = iPSSysBIHierarchy.getAllPSSysBILevels();
            if (!ObjectUtils.isEmpty((Object)psSysBILevelList)) {
                block1: for (IPSSysBILevel item : psSysBILevelList) {
                    if (item.isUniqueMembers()) {
                        selectedPSSysBILevelList.add(item);
                        continue;
                    }
                    if (ObjectUtils.isEmpty(iBISearchDimension.getLevels())) continue;
                    for (String strLevel : iBISearchDimension.getLevels()) {
                        if (!strLevel.equalsIgnoreCase(item.getCodeName())) continue;
                        selectedPSSysBILevelList.add(item);
                        continue block1;
                    }
                }
            }
            LinkedHashMap<String, String> levelMap = new LinkedHashMap<String, String>();
            for (IPSSysBILevel item : selectedPSSysBILevelList) {
                if (item.getValuePSDEField() == null) continue;
                levelMap.put(item.getValuePSDEField().getName(), String.format("%1$s__%2$s", iPSSysBICubeDimension.getCodeName(), item.getCodeName()));
                if (item.getTextPSDEField() == null) continue;
                levelMap.put(item.getTextPSDEField().getName(), String.format("%1$s__%2$s_text", iPSSysBICubeDimension.getCodeName(), item.getCodeName()));
            }
            String strMajorAlias = "dataresult";
            String strKeyCode = "";
            if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                strKeyCode = String.format("%1$s.%2$s", strMajorAlias, iPSSysBICubeDimension.getPSDEFieldMust().getName());
            } else {
                String strFormula;
                if (!PSModelEnums.BIDimensionType.CALCULATED.value.equals(iPSSysBICubeDimension.getDimensionType())) throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
                LinkedHashSet<String> columnList = new LinkedHashSet<String>();
                strKeyCode = strFormula = this.getSysBICubeCalculatedDimensionParser(false).parse(iPSSysBICubeDimension, this, iBISearchContext, columnList);
            }
            IDataEntityRuntime biHierarchyDataEntityRuntime = this.getDataEntityRuntime().getSystemRuntime().getDataEntityRuntime(iPSSysBIHierarchy.getPSDataEntityMust().getId());
            IDBDialect iDBDialect = this.getDataEntityRuntime().getSysDBSchemeRuntimeMust().getDBDialect();
            String strJoinCode = String.format("LEFT JOIN %1$s %2$s ON (%3$s = %2$s.%4$s)", iDBDialect.getDBObjStandardName(biHierarchyDataEntityRuntime.getTableName()), iDBDialect.getDBObjStandardName(iPSSysBICubeDimension.getCodeName().toLowerCase()), strKeyCode, iDBDialect.getDBObjStandardName(biHierarchyDataEntityRuntime.getKeyPSDEField().getName()));
            String strGroupCode = "";
            for (Map.Entry entry : levelMap.entrySet()) {
                if (StringUtils.hasLength((String)strGroupCode)) {
                    strGroupCode = strGroupCode + ",";
                }
                strGroupCode = strGroupCode + String.format("%1$s.%2$s AS %3$s", iDBDialect.getDBObjStandardName(iPSSysBICubeDimension.getCodeName().toLowerCase()), iDBDialect.getDBObjStandardName((String)entry.getKey()), iDBDialect.getDBObjStandardName((String)entry.getValue()));
            }
            objectNode.put("groupCode", strGroupCode);
            objectNode.put("groupJoinCode", strJoinCode);
        }
        return objectNode;
    }

    protected void resetDimensionFormulaCache(IPSSysBICubeDimension iPSysBICubeDimension) {
    }

    protected void resetMeasureFormulaCache(IPSSysBICubeMeasure iPSysBICubeMeasure) {
    }

    protected ISearchCond getAuthoritySearchCond(IBISearchContext iBISearchContext, Set<String> columnList) throws Throwable {
        if (ObjectUtils.isEmpty(columnList)) {
            return null;
        }
        IUserContext iUserContext = UserContext.getCurrent();
        if (iUserContext == null) {
            return null;
        }
        ArrayList<String> conditionList = new ArrayList<String>();
        for (String strColumn : columnList) {
            IPSDER1N iPSDER1N;
            IPSLinkDEField iPSLinkDEField;
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strColumn, true);
            if (iPSDEField == null) continue;
            IPSPickupDEField iPSPickupDEField = null;
            if (iPSDEField instanceof IPSPickupDEField) {
                iPSPickupDEField = (IPSPickupDEField)iPSDEField;
            } else if (iPSDEField instanceof IPSLinkDEField && (iPSLinkDEField = (IPSLinkDEField)iPSDEField).getRelatedPSDEFieldMust() instanceof IPSPickupDEField) {
                iPSPickupDEField = (IPSPickupDEField)iPSLinkDEField.getRelatedPSDEFieldMust();
            }
            if (iPSPickupDEField == null || ((iPSDER1N = (IPSDER1N)iPSPickupDEField.getPSDERMust()).getMasterRS() & PSModelEnums.DER1NMasterRS.REFCHECK.value) != PSModelEnums.DER1NMasterRS.REFCHECK.value) continue;
            IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDER1N.getMajorPSDataEntityMust().getId());
            IPSDEDataSet iPSDEDataSet = iPSDER1N.getRefPSDEDataSet();
            if (iPSDEDataSet == null) {
                iPSDEDataSet = refDataEntityRuntime.getDefaultPSDEDataSet();
            }
            if (ObjectUtils.isEmpty((Object)iPSDEDataSet.getPSDEDataQueries())) continue;
            IDEDQSQLSelectParser iDEDQSQLSelectParser = this.getSystemRuntime().getRuntimeObject(IDEDQSQLSelectParser.class, null);
            SearchContextDTO searchContextDTO = new SearchContextDTO();
            refDataEntityRuntime.getDataEntityAccessManager().testDataAccessAction(iUserContext, null, null, searchContextDTO, "READ");
            ArrayList<String> dqDataSqls = new ArrayList<String>();
            for (IPSDEDataQuery iPSDEDataQuery : iPSDEDataSet.getPSDEDataQueries()) {
                IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = refDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, refDataEntityRuntime.getSysDBSchemeRuntimeMust().getDBType(), false);
                StringBuilder sb = new StringBuilder();
                IPSDEDataQueryCode curDBPSDEDataQueryCode = iDEDataQueryCodeRuntime.getPSDEDataQueryCode();
                if (iDEDQSQLSelectParser != null) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(refDataEntityRuntime.getKeyPSDEField().getName());
                    sb.append(iDEDQSQLSelectParser.reselect(curDBPSDEDataQueryCode.getQueryCode(), set, iDEDataQueryCodeRuntime.getDBDialect(), refDataEntityRuntime, iDEDataQueryCodeRuntime));
                } else {
                    sb.append(curDBPSDEDataQueryCode.getQueryCode());
                }
                boolean bOutputWhere = false;
                boolean bCondFirst = true;
                if (!ObjectUtils.isEmpty((Object)curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds())) {
                    for (IPSDEDataQueryCodeCond queryCodeCond : curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds()) {
                        String strCondition = queryCodeCond.getCustomCond();
                        if (!StringUtils.hasLength((String)strCondition)) continue;
                        if (StringUtils.hasLength((String)queryCodeCond.getCustomType())) {
                            IDEDQSQLCustomCondParser iDEDQSQLCustomCondParser = this.getSystemRuntime().getRuntimeObject(IDEDQSQLCustomCondParser.class, queryCodeCond.getCustomType());
                            if (iDEDQSQLCustomCondParser == null) {
                                throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a[%1$s]\u81ea\u5b9a\u4e49SQL\u6761\u4ef6\u89e3\u6790\u5668", queryCodeCond.getCustomType()));
                            }
                            try {
                                strCondition = iDEDQSQLCustomCondParser.parse(SearchCustomCond.of(strCondition), iDEDataQueryCodeRuntime.getDBDialect(), iDEDataQueryCodeRuntime.getDataEntityRuntime(), iDEDataQueryCodeRuntime, searchContextDTO, searchContextDTO != null ? searchContextDTO.any() : null);
                            }
                            catch (Throwable ex) {
                                throw new Exception(String.format("\u89e3\u6790\u81ea\u5b9a\u4e49\u6761\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", queryCodeCond.getCustomCond(), ex.getMessage()), ex);
                            }
                        }
                        if (!bOutputWhere) {
                            sb.append(" WHERE ");
                            bOutputWhere = true;
                        }
                        if (bCondFirst) {
                            bCondFirst = false;
                        } else {
                            sb.append(" AND ");
                        }
                        sb.append(String.format("(%1$s)", strCondition));
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                this.genAuthoritySearchCustomCond(stringBuilder, searchContextDTO, iDEDataQueryCodeRuntime, searchContextDTO);
                String strCondition = stringBuilder.toString();
                if (StringUtils.hasLength((String)strCondition)) {
                    if (!bOutputWhere) {
                        sb.append(" WHERE ");
                        bOutputWhere = true;
                    }
                    if (bCondFirst) {
                        bCondFirst = false;
                    } else {
                        sb.append(" AND ");
                    }
                    sb.append(String.format("%1$s", strCondition));
                }
                dqDataSqls.add(sb.toString());
            }
            String strDataSql = String.join((CharSequence)" UNION ", dqDataSqls);
            conditionList.add(String.format("%1$s IN (%2$s)", strColumn, strDataSql));
        }
        if (ObjectUtils.isEmpty(conditionList)) {
            return null;
        }
        return SearchCustomCond.of(String.join((CharSequence)" AND ", conditionList));
    }

    protected void genAuthoritySearchCustomCond(StringBuilder stringBuilder, ISearchCond cond, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext) throws Throwable {
        if (cond instanceof ISearchFieldCond) {
            SearchFieldCond searchFieldCond = (SearchFieldCond)cond;
            IPSDEField iPSDEField = iDEDataQueryCodeRuntime.getDataEntityRuntime().getPSDEField(searchFieldCond.getFieldName(), false);
            String strExpression = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(searchFieldCond.getFieldName(), false).getExpression();
            String condition = iDEDataQueryCodeRuntime.getDBDialect().getConditionSQL(strExpression, iPSDEField.getStdDataType(), searchFieldCond.getCondOp(), searchFieldCond.isParamMode() ? iSearchContext.get(String.valueOf(searchFieldCond.getValue())) : searchFieldCond.getValue(), false, iSearchContext);
            stringBuilder.append(condition);
        } else if (cond instanceof net.ibizsys.runtime.util.ISearchGroupCond) {
            net.ibizsys.runtime.util.ISearchGroupCond searchGroupCond = (net.ibizsys.runtime.util.ISearchGroupCond)cond;
            List<ISearchCond> childConds = searchGroupCond.getSearchCondsIf();
            if (!ObjectUtils.isEmpty(childConds)) {
                stringBuilder.append("(");
                for (int i = 0; i < childConds.size(); ++i) {
                    if (i > 0) {
                        stringBuilder.append(" " + searchGroupCond.getCondOp() + " ");
                    }
                    this.genAuthoritySearchCustomCond(stringBuilder, childConds.get(i), iDEDataQueryCodeRuntime, iSearchContext);
                }
                stringBuilder.append(")");
            }
        } else if (cond instanceof ISearchCustomCond) {
            ISearchCustomCond iSearchCustomCond = (ISearchCustomCond)cond;
            if (StringUtils.hasLength((String)iSearchCustomCond.getCustomType())) {
                IDEDQSQLCustomCondParser iDEDQSQLCustomCondParser = this.getSystemRuntime().getRuntimeObject(IDEDQSQLCustomCondParser.class, iSearchCustomCond.getCustomType());
                if (iDEDQSQLCustomCondParser == null) {
                    throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a[%1$s]\u81ea\u5b9a\u4e49SQL\u6761\u4ef6\u89e3\u6790\u5668", iSearchCustomCond.getCustomType()));
                }
                String strRealCustomCond = null;
                try {
                    strRealCustomCond = iDEDQSQLCustomCondParser.parse(iSearchCustomCond, iDEDataQueryCodeRuntime.getDBDialect(), iDEDataQueryCodeRuntime.getDataEntityRuntime(), null, iSearchContext, iSearchContext != null ? iSearchContext.any() : null);
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u89e3\u6790\u81ea\u5b9a\u4e49\u6761\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSearchCustomCond.getCustomCond(), ex.getMessage()), ex);
                }
                stringBuilder.append(strRealCustomCond);
            } else {
                stringBuilder.append(iSearchCustomCond.getCustomCond());
            }
        }
    }

    protected boolean isEnableAuthoritySearchCond() {
        return this.bEnableAuthoritySearchCond;
    }
}

