/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ISystemRuntimeSetting;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SystemRuntimeSetting
implements ISystemRuntimeSetting {
    private static final Log log = LogFactory.getLog(SystemRuntimeSetting.class);
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private Map<String, Object> paramMap = new ConcurrentHashMap<String, Object>();

    public SystemRuntimeSetting(ISystemRuntimeContext iSystemRuntimeContext, Map<String, Object> map) {
        this.iSystemRuntimeContext = iSystemRuntimeContext;
        if (map != null) {
            this.reload(map);
        }
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntime();
    }

    protected void reload(Map<String, Object> map) {
        this.paramMap.clear();
        this.load("", map, true);
    }

    protected void load(String strPKey, Map<String, Object> map, boolean bOverwrite) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String strKey = null;
            strKey = StringUtils.hasLength((String)strPKey) ? String.format("%1$s.%2$s", strPKey, entry.getKey()).toLowerCase() : entry.getKey().toLowerCase();
            if (entry.getValue() instanceof Map) {
                this.load(strKey, (Map)entry.getValue(), bOverwrite);
                continue;
            }
            if (!bOverwrite && this.containsParam(strKey)) continue;
            this.setParam(strKey, entry.getValue());
        }
    }

    @Override
    public void setParams(String strPKey, Map<String, Object> params) {
        this.load(strPKey, params, true);
    }

    @Override
    public void setParamsIf(String strPKey, Map<String, Object> params) {
        this.load(strPKey, params, false);
    }

    @Override
    public String getDEActionCodeNameFormat() {
        return null;
    }

    @Override
    public String getDEDataSetCodeNameFormat() {
        return "Fetch%1$s";
    }

    @Override
    public boolean isDTOFieldNameLowerCase() {
        return true;
    }

    @Override
    public void setParam(String strKey, Object objValue) {
        Assert.hasLength((String)strKey, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        if (objValue != null) {
            this.paramMap.put(strKey.toLowerCase(), objValue);
        } else {
            this.paramMap.remove(strKey.toLowerCase());
        }
    }

    @Override
    public String getParam(String strKey, String strDefault) {
        Object objValue = this.getParam(strKey);
        if (objValue != null) {
            if (objValue instanceof String) {
                if (!ObjectUtils.isEmpty((Object)objValue)) {
                    return (String)objValue;
                }
            } else {
                return objValue.toString();
            }
        }
        return strDefault;
    }

    @Override
    public int getParam(String strKey, int nDefault) {
        Object objValue = this.getParam(strKey);
        if (objValue != null) {
            try {
                return DataTypeUtils.getIntegerValue(objValue, nDefault);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u8fd0\u884c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strKey, ex.getMessage()), ex);
            }
        }
        return nDefault;
    }

    @Override
    public long getParam(String strKey, long nDefault) {
        Object objValue = this.getParam(strKey);
        if (objValue != null) {
            try {
                return DataTypeUtils.getLongValue(objValue, nDefault);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u8fd0\u884c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strKey, ex.getMessage()), ex);
            }
        }
        return nDefault;
    }

    @Override
    public double getParam(String strKey, double fDefault) {
        Object objValue = this.getParam(strKey);
        if (objValue != null) {
            try {
                return DataTypeUtils.getDoubleValue(objValue, fDefault);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u8fd0\u884c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strKey, ex.getMessage()), ex);
            }
        }
        return fDefault;
    }

    @Override
    public boolean getParam(String strKey, boolean bDefault) {
        Object objValue = this.getParam(strKey);
        if (objValue != null) {
            try {
                return DataTypeUtils.getBooleanValue(objValue, bDefault);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u8fd0\u884c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strKey, ex.getMessage()), ex);
            }
        }
        return bDefault;
    }

    @Override
    public Object getParam(String strKey) {
        Assert.hasLength((String)strKey, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        return this.paramMap.get(strKey.toLowerCase());
    }

    @Override
    public boolean containsParam(String strKey) {
        Assert.hasLength((String)strKey, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        return this.paramMap.containsKey(strKey.toLowerCase());
    }

    @Override
    public Map<String, Object> getParams(String strPKey, Map<String, Object> params) {
        String strPKeyPrefix = (strPKey + ".").toLowerCase();
        int nPKeyLength = strPKeyPrefix.length();
        for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
            int nPos = entry.getKey().indexOf(strPKeyPrefix);
            if (nPos != 0) continue;
            String strKey = entry.getKey().substring(nPKeyLength);
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            params.put(strKey, entry.getValue());
        }
        return params;
    }

    @Override
    public void removeParam(String strKey) {
        Assert.hasLength((String)strKey, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        this.paramMap.remove(strKey.toLowerCase());
    }

    @Override
    public void removeParams(String strPKey) {
        Map<String, Object> params = this.getParams(strPKey, null);
        if (!ObjectUtils.isEmpty(params)) {
            this.removeParams(params.keySet());
        }
    }

    @Override
    public void removeParams(Set<String> keys) {
        Assert.notEmpty(keys, (String)"\u4f20\u5165\u952e\u540d\u96c6\u5408\u4e3a\u7a7a");
        for (String strKey : keys) {
            this.removeParam(strKey);
        }
    }

    @Override
    public String getEnableAPIs() {
        return this.getParam("enableapis", null);
    }
}

