package net.ibizsys.central.msg;

import java.util.Map;

import org.springframework.util.StringUtils;

import net.ibizsys.runtime.msg.SysMsgTemplRuntime;

public abstract class SysMsgTemplRuntimeBase extends net.ibizsys.runtime.msg.SysMsgTemplRuntime implements ISysMsgTemplRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysMsgTemplRuntime.class);
	
	
	@Override
	protected void onInit() throws Exception {
		
		super.onInit();
	}
	
	

	@Override
	public String getContent(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getContent())) {
			return null;
		}
		return getTemplContent(TEMPL_CONTENT, data, params);
	}

	@Override
	public String getSubject(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getSubject())) {
			return null;
		}
		return getTemplContent(TEMPL_SUBJECT, data, params);
	}

	@Override
	public String getSMSContent(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getSMSContent())) {
			return null;
		}
		return getTemplContent(TEMPL_SMSCONTENT, data, params);
	}

	@Override
	public String getWXContent(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getWXContent())) {
			return null;
		}
		return getTemplContent(TEMPL_WXCONTENT, data, params);
	}

	@Override
	public String getDDContent(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getDDContent())) {
			return null;
		}
		return getTemplContent(TEMPL_DDCONTENT, data, params);
	}

	@Override
	public String getIMContent(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getIMContent())) {
			return null;
		}
		return getTemplContent(TEMPL_IMCONTENT, data, params);
	}

	@Override
	public String getUrl(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getUrl())) {
			return null;
		}
		return getTemplContent(TEMPL_URL, data, params);
	}
	
	
	@Override
	public String getMobileUrl(Object data, Map<String, Object> params) {
		if(!StringUtils.hasLength(this.getMobileUrl())) {
			return null;
		}
		return getTemplContent(TEMPL_MOBILEURL, data, params);
	}
	
}
