package net.ibizsys.central.dataentity.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums.DEMethodDTOFieldType;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSInheritDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2ManyDataDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2OneDataDEField;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.defield.DEFDataTypes;

/**
 * 默认实体方法DTO运行时对象实现
 * 
 * @author lionlau
 *
 */
@SuppressWarnings("serial")
public class DEMethodDTORuntime extends DataEntityModelRuntimeBase implements IDEMethodDTORuntime {

	private IDataEntityRuntimeContext iDataEntityRuntimeContext = null;
	private IPSDEMethodDTO iPSDEMethodDTO = null;
	private Map<String, IPSDEMethodDTOField> psDEMethodDTOFieldMap = new HashMap<String, IPSDEMethodDTOField>();
	private Map<String, IPSDEMethodDTOField> psDEMethodDTOFieldMap2 = null;
//	private Map<String, String> dtoNameMap = new HashMap<String, String>();

	@Override
	public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEMethodDTO iPSDEMethodDTO) throws Exception {
		this.iDataEntityRuntimeContext = iDataEntityRuntimeContext;
		this.setDataEntityRuntimeBase(iDataEntityRuntimeContext.getDataEntityRuntime());
		this.iPSDEMethodDTO = iPSDEMethodDTO;

		List<IPSDEMethodDTOField> psDEMethodDTOFieldList = this.iPSDEMethodDTO.getPSDEMethodDTOFields();
		if (psDEMethodDTOFieldList != null) {
			for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
				psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getLowerCaseName(), iPSDEMethodDTOField);
				psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getName(), iPSDEMethodDTOField);
				if(iPSDEMethodDTOField.getPSDER() != null) {
					psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getPSDER().getId(), iPSDEMethodDTOField);
				}
			}
			
			if(isPreparePSDEFieldMap()) {
				psDEMethodDTOFieldMap2 = new HashMap<String, IPSDEMethodDTOField>();
				for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					if(iPSDEMethodDTOField.getPSDEField()!=null) {
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDEField().getLowerCaseName(), iPSDEMethodDTOField);
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDEField().getName(), iPSDEMethodDTOField);
					}
					if(iPSDEMethodDTOField.getPSDER()!=null) {
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getLowerCaseName(), iPSDEMethodDTOField);
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDER().getId(), iPSDEMethodDTOField);
					}
					else
						if(iPSDEMethodDTOField.getPSDEField()!=null &&  DEFDataTypes.INHERIT.equals(iPSDEMethodDTOField.getPSDEField().getDataType()) 
						  && iPSDEMethodDTOField.getRelatedPSDEMethodDTOField()!=null && iPSDEMethodDTOField.getRelatedPSDEMethodDTOField().getPSDER()!=null) {
							psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getLowerCaseName(), iPSDEMethodDTOField);
							psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getRelatedPSDEMethodDTOField().getPSDER().getId(), iPSDEMethodDTOField);
						}
				}
			}
		}

		onInit();
	}
	
	

	@Override
	protected void onInit() throws Exception {
		super.onInit();
	}
	
	protected boolean isPreparePSDEFieldMap() {
		return true;
	}
	

	protected IDataEntityRuntimeContext getDataEntityRuntimeContext() {
		return iDataEntityRuntimeContext;
	}

	@Override
	public IPSDEMethodDTO getPSDEMethodDTO() {
		return this.iPSDEMethodDTO;
	}

	@Override
	public IPSModelObject getPSModelObject() {
		return getPSDEMethodDTO();
	}

	@Override
	public IPSDEMethodDTOField getPSDEMethodDTOField(String strName, boolean bTryMode) {
		IPSDEMethodDTOField iPSDEMethodDTOField = psDEMethodDTOFieldMap.get(strName);
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new DataEntityRuntimeException(this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("无法获取指定属性[%1$s]", strName));
	}

	@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDEField(IPSDEField iPSDEField, boolean bTryMode) {
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(iPSDEField.getName());
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new DataEntityRuntimeException(this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("无法获取实体属性[%1$s]相关属性", iPSDEField.getName()));
	}
	
	@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDEField(String strName, boolean bTryMode) {
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(strName);
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new DataEntityRuntimeException(this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("无法获取实体属性[%1$s]相关属性", strName));
	}
	
	
	@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDER(String strName, boolean bTryMode) {
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(strName);
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new DataEntityRuntimeException(this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("无法获取实体关系[%1$s]相关属性", strName));
	}


	@Override
	public boolean isEnableAny() {
		return true;
	}



	@Override
	public List<IPSDEMethodDTOField> getPSDEMethodDTOFields() {
		return getPSDEMethodDTO().getPSDEMethodDTOFields();
	}
	
	
}
