package net.ibizsys.central.dataentity.ds;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.ISearchCustomCond;

public abstract class DEDQSQLCustomCondParserBase implements IDEDQSQLCustomCondParser {

	private static final Log log = LogFactory.getLog(DEDQSQLCustomCondParserBase.class);
	
	@Override
	public String parse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext) throws Throwable {
		return this.parse(iSearchCustomCond, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, null);
	}
	
	@Override
	public String parse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, Map<String, Object> params) throws Throwable {
		Assert.notNull(iSearchCustomCond, "传入自定义条件对象无效");
		Assert.hasLength(iSearchCustomCond.getCustomCond(), "传入自定义条件对象条件无效");
		Assert.notNull(iDBDialect, "传入数据库设配器对象无效");
		try {
//			if(params == null && iSearchContext != null) {
//				params = iSearchContext.any();
//			}
			return this.onParse(iSearchCustomCond, iDBDialect, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, params);
		}
		catch (Throwable ex) {
			//throw new RuntimeException(arg0);
			throw ex;
		}
	}

	protected abstract String onParse(ISearchCustomCond iSearchCustomCond, IDBDialect iDBDialect, IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, Map<String, Object> params) throws Throwable;
}
