/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipUtils {
    private static final Log log = LogFactory.getLog(ZipUtils.class);

    public static void zip(File file, File zipFile) throws IOException {
        long nBeginTime = System.currentTimeMillis();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            long nTime = System.currentTimeMillis();
            ZipUtils.zip(file, zipOutputStream);
            log.debug((Object)String.format("\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        log.debug((Object)String.format("\u751f\u6210\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", zipFile.getAbsolutePath(), System.currentTimeMillis() - nBeginTime));
    }

    public static void zip(List<File> fileList, File zipFile) throws IOException {
        long nBeginTime = System.currentTimeMillis();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            for (File file : fileList) {
                long nTime = System.currentTimeMillis();
                ZipUtils.zip(file, zipOutputStream);
                log.debug((Object)String.format("\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        log.debug((Object)String.format("\u751f\u6210\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", zipFile.getAbsolutePath(), System.currentTimeMillis() - nBeginTime));
    }

    public static void zip(File file, ZipOutputStream zipOutputStream) throws IOException {
        int nFolderLength = 0;
        nFolderLength = file.isFile() ? file.getParentFile().getAbsolutePath().length() : file.getAbsolutePath().length();
        ZipUtils.zip(file, zipOutputStream, nFolderLength + 1);
    }

    public static void zip(File file, ZipOutputStream zipOutputStream, int nFolderLength) throws IOException {
        if (file.isFile()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            ZipEntry zipEntry = new ZipEntry(file.getAbsolutePath().substring(nFolderLength).replace("\\", "/"));
            zipEntry.setTime(file.lastModified());
            zipOutputStream.putNextEntry(zipEntry);
            try (FileInputStream fis = new FileInputStream(file);
                 FileChannel channel = fis.getChannel();){
                while (true) {
                    byteBuffer.clear();
                    int read = channel.read(byteBuffer);
                    if (read == -1) {
                        break;
                    }
                    zipOutputStream.write(byteBuffer.array(), 0, read);
                }
            }
            zipOutputStream.closeEntry();
        } else {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                ZipEntry zipEntry = new ZipEntry(file.getAbsolutePath().substring(nFolderLength).replace("\\", "/") + "/");
                zipEntry.setTime(file.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
            } else {
                for (File item : files) {
                    ZipUtils.zip(item, zipOutputStream, nFolderLength);
                }
            }
        }
    }

    public static void zipFile(File file, ZipOutputStream zipOutputStream, String strEntry) throws IOException {
        block27: {
            if (file.isFile()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                ZipEntry zipEntry = new ZipEntry(strEntry);
                zipEntry.setTime(file.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream fis = new FileInputStream(file);
                     FileChannel channel = fis.getChannel();){
                    while (true) {
                        byteBuffer.clear();
                        int read = channel.read(byteBuffer);
                        if (read == -1) {
                            break block27;
                        }
                        zipOutputStream.write(byteBuffer.array(), 0, read);
                    }
                }
            }
            throw new IOException("\u6587\u4ef6\u5bf9\u8c61\u4e0d\u652f\u6301\u76ee\u5f55");
        }
        zipOutputStream.closeEntry();
    }

    public static void unzip(File zipFile, File dstFolder) throws IOException {
        if (!dstFolder.exists()) {
            dstFolder.mkdirs();
        }
        String destDir = dstFolder.getAbsolutePath();
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(zipFile);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry ZE = zis.getNextEntry();
            while (ZE != null) {
                String fileName = ZE.getName();
                File newFile = new File(destDir + File.separator + fileName);
                if (ZE.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    int len;
                    new File(newFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zis.closeEntry();
                ZE = zis.getNextEntry();
            }
        }
    }
}

