/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.IReadOnlyEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadOnlyEntityProxy
implements IReadOnlyEntity {
    private static final Log log = LogFactory.getLog(ReadOnlyEntityProxy.class);
    private IEntityBase iEntityBase = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private IReadOnlyEntity iReadOnlyEntity = null;

    public ReadOnlyEntityProxy(IEntityBase iEntityBase, IDataEntityRuntime iDataEntityRuntime) {
        this.iEntityBase = iEntityBase;
        this.iDataEntityRuntime = iDataEntityRuntime;
        this.iReadOnlyEntity = null;
        if (iEntityBase instanceof IReadOnlyEntity) {
            this.iReadOnlyEntity = (IReadOnlyEntity)iEntityBase;
        }
    }

    @Override
    public Object get(String strName) {
        IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
        if (iPSDEField != null) {
            return this.getDataEntityRuntime().getFieldValue(this.getProxyEntity(), iPSDEField);
        }
        log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
        if (this.iReadOnlyEntity != null) {
            return this.iReadOnlyEntity.get(strName);
        }
        return null;
    }

    @Override
    public boolean contains(String strName) {
        IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
        if (iPSDEField != null) {
            return this.getDataEntityRuntime().containsFieldValue(this.getProxyEntity(), iPSDEField);
        }
        log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
        if (this.iReadOnlyEntity != null) {
            return this.iReadOnlyEntity.contains(strName);
        }
        return false;
    }

    public IEntityBase getProxyEntity() {
        return this.iEntityBase;
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }
}

