/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.IModelRuntimeShutdownable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class ModelRuntimeUtils {
    private static final Log log = LogFactory.getLog(ModelRuntimeUtils.class);

    public static void shutdownModelRuntimes(Map<String, ? extends IModelRuntime> modelRuntimes) {
        if (ObjectUtils.isEmpty(modelRuntimes)) {
            return;
        }
        ModelRuntimeUtils.shutdownModelRuntimes(modelRuntimes.values());
    }

    public static void shutdownModelRuntimes(Collection<? extends IModelRuntime> modelRuntimes) {
        if (ObjectUtils.isEmpty(modelRuntimes)) {
            return;
        }
        HashSet<IModelRuntime> set = new HashSet<IModelRuntime>();
        for (IModelRuntime iModelRuntime : modelRuntimes) {
            if (set.contains(iModelRuntime)) continue;
            ModelRuntimeUtils.shutdownModelRuntime(iModelRuntime);
            set.add(iModelRuntime);
        }
    }

    public static void shutdownModelRuntime(IModelRuntime iModelRuntime) {
        if (iModelRuntime instanceof IModelRuntimeShutdownable) {
            try {
                ((IModelRuntimeShutdownable)((Object)iModelRuntime)).shutdown();
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5173\u95ed\u6a21\u578b[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iModelRuntime.getId(), ex.getMessage()), (Throwable)ex);
            }
        }
    }
}

