/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.math.BigInteger;
import java.net.NetworkInterface;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class KeyValueUtils {
    public static final String TEMPKEYPREFIX = "SRFTEMPKEY:";
    private static Map<String, Snowflake> snowflakeMap = new HashMap<String, Snowflake>();
    private static long workerId = 0L;

    public static final long getWorkerId() {
        return workerId;
    }

    public static final void setWorkerId(long workerId) {
        KeyValueUtils.workerId = workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long genNumberId(String strType) {
        Snowflake snowflake = snowflakeMap.get(strType);
        if (snowflake == null) {
            Map<String, Snowflake> map = snowflakeMap;
            synchronized (map) {
                snowflake = snowflakeMap.get(strType);
                if (snowflake == null) {
                    snowflake = new Snowflake(KeyValueUtils.getWorkerId());
                    snowflakeMap.put(strType, snowflake);
                }
            }
        }
        return snowflake.nextId();
    }

    public static final String genGuid() {
        UID uid = new UID();
        String strId = "uid_" + uid.toString();
        strId = strId.replace(":", "");
        strId = strId.replace("-", "");
        return strId;
    }

    public static final String genGuidEx() {
        UUID idOne = UUID.randomUUID();
        return idOne.toString().toUpperCase();
    }

    public static final String genUUIDString() {
        UUID idOne = UUID.randomUUID();
        return idOne.toString().toUpperCase();
    }

    public static BigInteger genUUIDNumber() {
        UUID uuid = UUID.randomUUID();
        BigInteger uuidAsBigInteger = new BigInteger(uuid.toString().replace("-", ""), 16);
        return uuidAsBigInteger;
    }

    private static final String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static final String genMD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = new byte[32];
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            md5hash = md.digest();
            return KeyValueUtils.convertToHex(md5hash);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static final String genMD5Ex(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = new byte[32];
            md.update(text.getBytes("utf-8"));
            md5hash = md.digest();
            return KeyValueUtils.convertToHex(md5hash);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static final String genUniqueId() {
        return KeyValueUtils.genMD5Ex(UUID.randomUUID().toString());
    }

    public static final String genUniqueId(Object strSrc1) {
        if (strSrc1 instanceof String) {
            return KeyValueUtils.genMD5Ex((String)strSrc1);
        }
        return KeyValueUtils.genMD5Ex(String.format("%1$s", strSrc1));
    }

    public static final String genUniqueId(Object strSrc1, Object strSrc2) {
        return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s", strSrc1, strSrc2));
    }

    public static final String genUniqueId(Object strSrc1, Object strSrc2, Object strSrc3) {
        return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s", strSrc1, strSrc2, strSrc3));
    }

    public static final String genUniqueId(Object strSrc1, Object strSrc2, Object strSrc3, Object strSrc4) {
        return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s", strSrc1, strSrc2, strSrc3, strSrc4));
    }

    public static final String genUniqueId(Object strSrc1, Object strSrc2, Object strSrc3, Object strSrc4, Object strSrc5) {
        return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s", strSrc1, strSrc2, strSrc3, strSrc4, strSrc5));
    }

    public static final String genUniqueId(Object strSrc1, Object strSrc2, Object strSrc3, Object strSrc4, Object strSrc5, Object strSrc6) {
        return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s||%6$s", strSrc1, strSrc2, strSrc3, strSrc4, strSrc5, strSrc6));
    }

    public static final boolean isTempKey(String strKeyValue) {
        return strKeyValue.indexOf(TEMPKEYPREFIX) == 0;
    }

    public static final String genUniqueId(Object[] values) {
        switch (values.length) {
            case 1: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s", values[0]));
            }
            case 2: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s", values[0], values[1]));
            }
            case 3: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s", values[0], values[1], values[2]));
            }
            case 4: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s", values[0], values[1], values[2], values[3]));
            }
            case 5: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s", values[0], values[1], values[2], values[3], values[4]));
            }
            case 6: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s||%6$s", values[0], values[1], values[2], values[3], values[4], values[5]));
            }
            case 7: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s||%6$s||%7$s", values[0], values[1], values[2], values[3], values[4], values[5], values[6]));
            }
            case 8: {
                return KeyValueUtils.genMD5Ex(String.format("%1$s||%2$s||%3$s||%4$s||%5$s||%6$s||%7$s||%8$s", values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]));
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u8ba1\u7b97\u552f\u4e00\u6807\u8bb0");
    }

    static {
        Snowflake snowflake = new Snowflake();
        workerId = snowflake.createNodeId();
    }

    private static class Snowflake {
        private static final int UNUSED_BITS = 1;
        public static final int EPOCH_BITS = 41;
        public static final int NODE_ID_BITS = 10;
        public static final int SEQUENCE_BITS = 12;
        public static final long maxNodeId = 1023L;
        public static final long maxSequence = 4095L;
        private static final long DEFAULT_CUSTOM_EPOCH = 1288834974657L;
        private final long nodeId;
        private final long customEpoch;
        private volatile long lastTimestamp = -1L;
        private volatile long sequence = 0L;

        public Snowflake(long nodeId, long customEpoch) {
            if (nodeId < 0L || nodeId > 1023L) {
                throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, 1023L));
            }
            this.nodeId = nodeId;
            this.customEpoch = customEpoch;
        }

        public Snowflake(long nodeId) {
            this(nodeId, 1288834974657L);
        }

        public Snowflake() {
            this.nodeId = this.createNodeId();
            this.customEpoch = 1288834974657L;
        }

        public synchronized long nextId() {
            long currentTimestamp = this.timestamp();
            if (currentTimestamp < this.lastTimestamp) {
                throw new IllegalStateException("Invalid System Clock!");
            }
            if (currentTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    currentTimestamp = this.waitNextMillis(currentTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = currentTimestamp;
            long id = currentTimestamp << 22 | this.nodeId << 12 | this.sequence;
            return id;
        }

        private long timestamp() {
            return Instant.now().toEpochMilli() - this.customEpoch;
        }

        private long waitNextMillis(long currentTimestamp) {
            while (currentTimestamp == this.lastTimestamp) {
                currentTimestamp = this.timestamp();
            }
            return currentTimestamp;
        }

        public long createNodeId() {
            long nodeId;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    byte[] mac = networkInterface.getHardwareAddress();
                    if (mac == null) continue;
                    for (byte macPort : mac) {
                        sb.append(String.format("%02X", macPort));
                    }
                }
                nodeId = sb.toString().hashCode();
            }
            catch (Exception ex) {
                nodeId = new SecureRandom().nextInt();
            }
            return nodeId &= 0x3FFL;
        }

        public long[] parse(long id) {
            long maskNodeId = 0x3FF000L;
            long maskSequence = 4095L;
            long timestamp = (id >> 22) + this.customEpoch;
            long nodeId = (id & maskNodeId) >> 12;
            long sequence = id & maskSequence;
            return new long[]{timestamp, nodeId, sequence};
        }

        public String toString() {
            return "Snowflake Settings [EPOCH_BITS=41, NODE_ID_BITS=10, SEQUENCE_BITS=12, CUSTOM_EPOCH=" + this.customEpoch + ", NodeId=" + this.nodeId + "]";
        }
    }
}

