/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityUtils {
    private static final Log log = LogFactory.getLog(EntityUtils.class);

    public static Object getValue(Object objValue) {
        return EntityUtils.getValue(objValue, true, null);
    }

    public static Object getValue(Object objValue, boolean bLowerCaseFieldName, ISystemRuntime iSystemRuntime) {
        if (objValue instanceof Map) {
            if (iSystemRuntime != null) {
                return iSystemRuntime.createEntity(objValue, bLowerCaseFieldName);
            }
            return EntityUtils.createEntity(objValue);
        }
        if (objValue instanceof List) {
            List list = (List)objValue;
            ArrayList<Object> entityList = new ArrayList<Object>();
            for (Object objItem : list) {
                Object real = EntityUtils.getValue(objItem, bLowerCaseFieldName, iSystemRuntime);
                entityList.add(real);
            }
            return entityList;
        }
        return objValue;
    }

    public static IEntity createEntity(Object objData) {
        return EntityUtils.createEntity(objData, true);
    }

    public static IEntity createEntity(Object objData, boolean bLowerCaseFieldName) {
        return new Entity(objData, bLowerCaseFieldName);
    }

    public static void copyTo(IEntity srcEntity, Object dstObject) {
        Map methodMap = CacheMethodMap.get(dstObject.getClass());
        for (Map.Entry entry : methodMap.entrySet()) {
            String strName = (String)entry.getKey();
            if (!srcEntity.contains(strName)) continue;
            Object objValue = srcEntity.get(strName);
            try {
                if (objValue != null && !((Method)entry.getValue()).getParameterTypes()[0].equals(objValue.getClass()) && !((Method)entry.getValue()).getParameterTypes()[0].isAssignableFrom(objValue.getClass())) {
                    objValue = EntityUtils.parse(((Method)entry.getValue()).getParameterTypes()[0], objValue);
                }
                ((Method)entry.getValue()).invoke(dstObject, objValue);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u8bbe\u7f6e\u76ee\u6807\u5bf9\u8c61[%1$s]\u5c5e\u6027[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", dstObject.getClass().getName(), strName, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void copyTo(Map<String, Object> srcMap, Object dstObject) {
        Map methodMap = CacheMethodMap.get(dstObject.getClass());
        for (Map.Entry entry : methodMap.entrySet()) {
            String strName = ((String)entry.getKey()).toLowerCase();
            if (!srcMap.containsKey(strName)) continue;
            Object objValue = srcMap.get(strName);
            try {
                if (objValue != null && !((Method)entry.getValue()).getParameterTypes()[0].equals(objValue.getClass()) && !((Method)entry.getValue()).getParameterTypes()[0].isAssignableFrom(objValue.getClass())) {
                    objValue = EntityUtils.parse(((Method)entry.getValue()).getParameterTypes()[0], objValue);
                }
                ((Method)entry.getValue()).invoke(dstObject, objValue);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u8bbe\u7f6e\u76ee\u6807\u5bf9\u8c61[%1$s]\u5c5e\u6027[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", dstObject.getClass().getName(), strName, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private static Object parse(Class<?> type, Object objValue) throws Exception {
        if (objValue == null || type == Object.class) {
            return objValue;
        }
        if (type.equals(String.class)) {
            return objValue.toString();
        }
        if (type.equals(BigInteger.class)) {
            return DataTypeUtils.getBigIntegerValue(objValue, null);
        }
        if (type.equals(BigDecimal.class)) {
            return DataTypeUtils.getBigDecimalValue(objValue, null);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return DataTypeUtils.getIntegerValue(objValue, null);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return DataTypeUtils.getLongValue(objValue, null);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return DataTypeUtils.getDoubleValue(objValue, null);
        }
        if (type.isAssignableFrom(Timestamp.class)) {
            return DataTypeUtils.getDateTimeValue(objValue, null);
        }
        if (type.equals(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            String strValue = objValue.toString();
            return strValue.equalsIgnoreCase("1") || strValue.equalsIgnoreCase("true");
        }
        return objValue;
    }

    private static class CacheMethodMap {
        private static Map<String, Map<String, Method>> CacheMap = new HashMap<String, Map<String, Method>>();

        private CacheMethodMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Map<String, Method> get(Class clazz) {
            Map<String, Method> result = CacheMap.get(clazz.getName());
            if (result != null) return result;
            Class<CacheMethodMap> clazz2 = CacheMethodMap.class;
            synchronized (CacheMethodMap.class) {
                if (result != null) return result;
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method method : clazz.getMethods()) {
                    String strName = method.getName();
                    if (strName.indexOf("set") != 0 || method.getGenericParameterTypes() == null || method.getGenericParameterTypes().length != 1) continue;
                    methodMap.put(strName.substring(3).toLowerCase(), method);
                }
                CacheMap.put(clazz.getName(), methodMap);
                return CacheMap.get(clazz.getName());
            }
        }
    }
}

