/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.math.BigDecimal;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;

public class EntityListUtils {
    public static Object max(IEntityBase[] list, IPSDEField iPSDEField, IDataEntityRuntime iDataEntityRuntime) {
        if (list == null || list.length == 0) {
            return null;
        }
        Object maxValue = null;
        for (IEntityBase iEntityBase : list) {
            Object objValue = iDataEntityRuntime.getFieldValue(iEntityBase, iPSDEField);
            if (objValue == null) continue;
            if (maxValue == null) {
                maxValue = objValue;
                continue;
            }
            if (DataTypeUtils.compare(iPSDEField.getStdDataType(), maxValue, objValue) >= 0L) continue;
            maxValue = objValue;
        }
        return maxValue;
    }

    public static Object min(IEntityBase[] list, IPSDEField iPSDEField, IDataEntityRuntime iDataEntityRuntime) {
        if (list == null || list.length == 0) {
            return null;
        }
        Object minValue = null;
        for (IEntityBase iEntityBase : list) {
            Object objValue = iDataEntityRuntime.getFieldValue(iEntityBase, iPSDEField);
            if (objValue == null) continue;
            if (minValue == null) {
                minValue = objValue;
                continue;
            }
            if (DataTypeUtils.compare(iPSDEField.getStdDataType(), minValue, objValue) <= 0L) continue;
            minValue = objValue;
        }
        return minValue;
    }

    public static BigDecimal sum(IEntityBase[] list, IPSDEField iPSDEField, IDataEntityRuntime iDataEntityRuntime) {
        if (list == null || list.length == 0) {
            return null;
        }
        BigDecimal sumValue = null;
        for (IEntityBase iEntityBase : list) {
            Object objValue = iDataEntityRuntime.getFieldValue(iEntityBase, iPSDEField);
            BigDecimal curValue = DataTypeUtils.getBigDecimalValue(objValue, null);
            if (curValue == null) continue;
            sumValue = sumValue == null ? curValue : sumValue.add(curValue);
        }
        return sumValue;
    }

    public static BigDecimal avg(IEntityBase[] list, IPSDEField iPSDEField, IDataEntityRuntime iDataEntityRuntime) {
        if (list == null || list.length == 0) {
            return null;
        }
        BigDecimal sumvalue = EntityListUtils.sum(list, iPSDEField, iDataEntityRuntime);
        if (sumvalue == null) {
            return null;
        }
        return sumvalue.divide(BigDecimal.valueOf(list.length));
    }

    public static Object calc(String strCalcType, IEntityBase[] list, IPSDEField iPSDEField, IDataEntityRuntime iDataEntityRuntime) {
        if ("COUNT".equalsIgnoreCase(strCalcType)) {
            if (list == null) {
                return 0;
            }
            return list.length;
        }
        if ("MAX".equalsIgnoreCase(strCalcType)) {
            return EntityListUtils.max(list, iPSDEField, iDataEntityRuntime);
        }
        if ("MIN".equalsIgnoreCase(strCalcType)) {
            return EntityListUtils.min(list, iPSDEField, iDataEntityRuntime);
        }
        if ("SUM".equalsIgnoreCase(strCalcType)) {
            return EntityListUtils.sum(list, iPSDEField, iDataEntityRuntime);
        }
        if ("AVG".equalsIgnoreCase(strCalcType)) {
            return EntityListUtils.avg(list, iPSDEField, iDataEntityRuntime);
        }
        throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8ba1\u7b97\u7c7b\u578b[%1$s]", strCalcType));
    }
}

