/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.res.SysValueRuleRuntimeBase;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SysRegExValueRuleRuntime
extends SysValueRuleRuntimeBase {
    private static final Log log = LogFactory.getLog(SysRegExValueRuleRuntime.class);
    private static Map<String, Pattern> regExPatternMap = new HashMap<String, Pattern>();
    public static final int PATTERN_MAXCACHE = 2000;
    private Pattern p = null;

    public static Pattern getPattern(String strRegEx) {
        Pattern p = regExPatternMap.get(strRegEx);
        if (p == null) {
            p = Pattern.compile(strRegEx);
            if (regExPatternMap.size() > 2000) {
                regExPatternMap.clear();
            }
            regExPatternMap.put(strRegEx, p);
        }
        return p;
    }

    @Override
    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getPSSysValueRule().getRegExCode())) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), String.format("\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u6ca1\u6709\u6307\u5b9a\u6b63\u5219\u5f0f\u5185\u5bb9", this.getName()));
        }
        this.p = SysRegExValueRuleRuntime.getPattern(this.getPSSysValueRule().getRegExCode());
        super.onInit();
    }

    @Override
    public boolean test(Object objValue, IEntityBase iEntityBase, IPSDEField iPSDEField, IDataEntityRuntimeBase iDataEntityRuntimeBase) throws Throwable {
        String strValue = null;
        if (objValue != null) {
            strValue = (String)objValue;
        }
        if (!StringUtils.hasLength(strValue)) {
            return true;
        }
        Matcher m = this.p.matcher(strValue);
        return m.matches();
    }
}

