/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.runtime.plugin.IRuntimeObjectFactory;
import net.ibizsys.runtime.res.SysSFPluginRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RuntimeObjectFactory
implements IRuntimeObjectFactory {
    private static IRuntimeObjectFactory instance = null;
    private static final Log log = LogFactory.getLog(RuntimeObjectFactory.class);
    private static final Map<String, RuntimeObject> RUNTIMEOBJMAP = new ConcurrentHashMap<String, RuntimeObject>();
    private static final Map<String, Map> RUNTIMEOBJLISTMAP = new ConcurrentHashMap<String, Map>();

    public static IRuntimeObjectFactory getInstance() {
        if (instance == null) {
            instance = new RuntimeObjectFactory();
        }
        return instance;
    }

    public static void setInstance(IRuntimeObjectFactory instance) {
        RuntimeObjectFactory.instance = instance;
    }

    protected static boolean registerRuntimeObject(Class<?> cls, String strType, Object objObject) {
        return RuntimeObjectFactory.registerRuntimeObject(cls, strType, objObject, 100);
    }

    protected static boolean registerRuntimeObject(Class<?> cls, String strType, Object objObject, int nOrder) {
        RuntimeObject lastObject;
        String strTag = null;
        strTag = StringUtils.hasLength((String)strType) ? String.format("%1$s|%2$s", RuntimeObjectFactory.getObjectType(cls), strType) : String.format("%1$s|", RuntimeObjectFactory.getObjectType(cls));
        if (objObject instanceof String) {
            try {
                objObject = Class.forName((String)((Object)objObject));
            }
            catch (Exception ex) {
                return false;
            }
        }
        if ((lastObject = RUNTIMEOBJMAP.get(strTag)) != null) {
            if (nOrder > lastObject.order) {
                log.warn((Object)String.format("\u65e0\u6cd5\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]\uff0c\u4f18\u5148\u7ea7\u4e0d\u8db3", objObject, strTag));
                return false;
            }
            log.warn((Object)String.format("\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]\uff0c\u66ff\u6362[%3$s]", objObject, strTag, lastObject.object));
        } else {
            log.debug((Object)String.format("\u6ce8\u518c\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s][%2$s]", objObject, strTag));
        }
        RuntimeObject runtimeObject = new RuntimeObject();
        runtimeObject.object = objObject;
        runtimeObject.order = nOrder;
        RUNTIMEOBJMAP.put(strTag, runtimeObject);
        return true;
    }

    @Override
    public boolean registerObject(Class<?> cls, String strType, Object strObject) {
        return this.registerObject(cls, strType, strObject, 100);
    }

    @Override
    public boolean registerObjectPrimary(Class<?> cls, String strType, Object strObject) {
        return this.registerObject(cls, strType, strObject, 50);
    }

    @Override
    public boolean registerObject(Class<?> cls, String strType, Object strObject, int nOrderValue) {
        return RuntimeObjectFactory.registerRuntimeObject(cls, strType, strObject, nOrderValue);
    }

    @Override
    public boolean registerObjectIf(Class<?> cls, String strType, Object strObject) {
        if (this.containsObject(cls, strType)) {
            return false;
        }
        return this.registerObject(cls, strType, strObject);
    }

    @Override
    public boolean containsObject(Class<?> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? RUNTIMEOBJMAP.get(String.format("%1$s|%2$s", RuntimeObjectFactory.getObjectType(cls), strType)) : RUNTIMEOBJMAP.get(String.format("%1$s|", RuntimeObjectFactory.getObjectType(cls)));
        return !ObjectUtils.isEmpty((Object)runtimeObject);
    }

    @Override
    public <T> T getObject(Class<T> cls) {
        return this.getObject(cls, "");
    }

    @Override
    public <T> T getObject(Class<T> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? RUNTIMEOBJMAP.get(String.format("%1$s|%2$s", RuntimeObjectFactory.getObjectType(cls), strType)) : RUNTIMEOBJMAP.get(String.format("%1$s|", RuntimeObjectFactory.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        return this.getObject(cls, runtimeObject, false);
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls) {
        return this.getObjectClass(cls, "");
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls, String strType) {
        RuntimeObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)strType) ? RUNTIMEOBJMAP.get(String.format("%1$s|%2$s", RuntimeObjectFactory.getObjectType(cls), strType)) : RUNTIMEOBJMAP.get(String.format("%1$s|", RuntimeObjectFactory.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        Object obj = runtimeObject.object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String) {
            try {
                return Class.forName((String)obj);
            }
            catch (Exception ex) {
                log.warn((Object)String.format("\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\u4e0d\u5b58\u5728", obj));
                return null;
            }
        }
        return obj.getClass();
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls) {
        return this.getObjects(cls, null);
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls, String strTypePrefix) {
        String strTag = null;
        strTag = StringUtils.hasLength((String)strTypePrefix) ? String.format("%1$s|%2$s", RuntimeObjectFactory.getObjectType(cls), strTypePrefix) : String.format("%1$s|", RuntimeObjectFactory.getObjectType(cls));
        Map objMap = RUNTIMEOBJLISTMAP.get(strTag);
        if (objMap != null) {
            return objMap;
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (Map.Entry<String, RuntimeObject> entry : RUNTIMEOBJMAP.entrySet()) {
            T t;
            if (entry.getKey().indexOf(strTag) != 0 || (t = this.getObject(cls, entry.getValue(), true)) == null) continue;
            map.put(entry.getKey().substring(strTag.length()), t);
        }
        RUNTIMEOBJLISTMAP.put(strTag, map);
        return map;
    }

    protected <T> T getObject(Class<T> cls, RuntimeObject runtimeObject, boolean bTryMode) {
        Object obj = runtimeObject.object;
        if (obj instanceof Class) {
            Object objInstance;
            try {
                objInstance = ((Class)obj).newInstance();
            }
            catch (Exception e) {
                if (bTryMode) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u63d2\u4ef6\u5bf9\u8c61[%1$s]", obj));
                    return null;
                }
                throw new RuntimeException(e);
            }
            if (cls.isAssignableFrom(objInstance.getClass())) {
                return objInstance;
            }
        } else if (obj instanceof String) {
            Object objInstance;
            try {
                objInstance = SysSFPluginRuntime.createObject((String)obj);
            }
            catch (Exception e) {
                if (bTryMode) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u63d2\u4ef6\u5bf9\u8c61[%1$s]", obj));
                    return null;
                }
                throw new RuntimeException(e);
            }
            if (cls.isAssignableFrom(objInstance.getClass())) {
                return (T)objInstance;
            }
        } else if (cls.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (bTryMode) {
            return null;
        }
        throw new RuntimeException(String.format("[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", obj));
    }

    protected static String getObjectType(Class<?> cls) {
        return cls.getSimpleName();
    }

    static class RuntimeObject {
        public Object object = null;
        public int order = 100;
    }
}

