/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.plugin;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.runtime.plugin.IModelRTScript;
import net.ibizsys.runtime.util.IAction;

public abstract class ModelRTScriptBase
extends Script
implements IModelRTScript {
    private Object owner = null;
    private Map<String, Closure<?>> closureMap = new HashMap();

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void before(Closure<?> closure) {
        this.before("EXECUTE", closure);
    }

    public void after(Closure<?> closure) {
        this.after("EXECUTE", closure);
    }

    public void execute(Closure<?> closure) {
        this.execute("EXECUTE", closure);
    }

    public void before(String strMethodName, Closure<?> closure) {
        String strTag = String.format("%1$s|%2$s", strMethodName, "BEFORE").toUpperCase();
        closure.setDelegate(this.getOwner());
        this.closureMap.put(strTag, closure);
    }

    public void after(String strMethodName, Closure<?> closure) {
        String strTag = String.format("%1$s|%2$s", strMethodName, "AFTER").toUpperCase();
        closure.setDelegate(this.getOwner());
        this.closureMap.put(strTag, closure);
    }

    public void execute(String strMethodName, Closure<?> closure) {
        String strTag = String.format("%1$s|%2$s", strMethodName, "EXECUTE").toUpperCase();
        closure.setDelegate(this.getOwner());
        this.closureMap.put(strTag, closure);
    }

    @Override
    public Object call(Object ... args) {
        return this.call("EXECUTE", "EXECUTE", args);
    }

    @Override
    public Object call(String strMethodName, String strAttachMode, Object ... args) {
        String strTag = String.format("%1$s|%2$s", strMethodName, strAttachMode).toUpperCase();
        Closure<?> closure = this.closureMap.get(strTag);
        if (closure == null) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6[%1$s]\u5bf9\u5e94\u7684\u95ed\u5305\u51fd\u6570", strTag));
        }
        if (args == null || args.length == 0) {
            return closure.call();
        }
        return closure.call(args);
    }

    @Override
    public boolean contains(String strMethodName, String strAttachMode) {
        String strTag = String.format("%1$s|%2$s", strMethodName, strAttachMode).toUpperCase();
        return this.closureMap.containsKey(strTag);
    }

    @Override
    public boolean support(String strMethodName) {
        String strTag = String.format("%1$s|%2$s", strMethodName, "BEFORE").toUpperCase();
        if (this.closureMap.containsKey(strTag)) {
            return true;
        }
        strTag = String.format("%1$s|%2$s", strMethodName, "EXECUTE").toUpperCase();
        if (this.closureMap.containsKey(strTag)) {
            return true;
        }
        strTag = String.format("%1$s|%2$s", strMethodName, "AFTER").toUpperCase();
        return this.closureMap.containsKey(strTag);
    }

    @Override
    public Object callAround(String strMethodName, IAction iAction, Object ... args) throws Throwable {
        String strTag = String.format("%1$s|%2$s", strMethodName, "BEFORE").toUpperCase();
        Closure<?> closure = this.closureMap.get(strTag);
        if (closure != null) {
            if (args == null || args.length == 0) {
                closure.call();
            } else {
                closure.call(args);
            }
        }
        Object ret = null;
        strTag = String.format("%1$s|%2$s", strMethodName, "EXECUTE").toUpperCase();
        closure = this.closureMap.get(strTag);
        ret = closure != null ? (args == null || args.length == 0 ? closure.call() : closure.call(args)) : iAction.execute(args);
        strTag = String.format("%1$s|%2$s", strMethodName, "AFTER").toUpperCase();
        closure = this.closureMap.get(strTag);
        if (closure != null) {
            int nLength = 1;
            if (args != null) {
                nLength += args.length;
            }
            Object[] newArgs = new Object[nLength];
            newArgs[0] = ret;
            if (nLength > 1) {
                System.arraycopy(args, 0, newArgs, 1, args.length);
            }
            ret = closure.call(args);
        }
        return ret;
    }
}

