/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.msg;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.msg.SysMsgTargetRuntimeBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;

public class SysDEMsgTargetRuntime
extends SysMsgTargetRuntimeBase {
    private static final Log log = LogFactory.getLog(SysDEMsgTargetRuntime.class);
    private IDataEntityRuntime iDataEntityRuntime = null;

    @Override
    protected void onInit() throws Exception {
        this.getPSSysMsgTarget().getPSDataEntityMust();
        this.getPSSysMsgTarget().getPSDEDataSetMust();
        this.getPSSysMsgTarget().getTargetPSDEFieldMust();
        super.onInit();
    }

    @Override
    public Map<String, String> get(IEntityBase iEntityBase) {
        try {
            return this.onGet(iEntityBase);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u6d88\u606f\u76ee\u6807\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Map<String, String> onGet(IEntityBase iEntityBase) throws Throwable {
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime();
        ISearchContextBase iSearchContext = iDataEntityRuntime.createSearchContext();
        iDataEntityRuntime.setSearchPaging(iSearchContext, 0, Integer.MAX_VALUE, null);
        iDataEntityRuntime.setSearchMode(iSearchContext, true, false);
        if (iEntityBase instanceof IEntity) {
            Map<String, Object> any = ((IEntity)iEntityBase).any();
            if (!ObjectUtils.isEmpty(any)) {
                for (Map.Entry<String, Object> entry : any.entrySet()) {
                    Object value = entry.getValue();
                    if ((value = DataTypeUtils.asSimple(value)) == null) continue;
                    iDataEntityRuntime.setSearchDataContext(iSearchContext, entry.getKey(), value);
                }
            }
        } else {
            log.warn((Object)String.format("\u65e0\u6cd5\u4ece\u4f20\u5165\u6570\u636e\u83b7\u53d6\u4e0a\u4e0b\u6587", new Object[0]));
        }
        IPSDEField targetPSDEField = this.getPSSysMsgTarget().getTargetPSDEFieldMust();
        IPSDEField targetTypePSDEField = this.getPSSysMsgTarget().getTargetTypePSDEField();
        Page<? extends IEntityBase> page = iDataEntityRuntime.searchDataSet(this.getPSSysMsgTarget().getPSDEDataSetMust(), iSearchContext);
        if (page != null && page.getContent() != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (IEntityBase item : page.getContent()) {
                String strTargetId = DataTypeUtils.getStringValue(iDataEntityRuntime.getFieldValue(item, targetPSDEField), null);
                if (ObjectUtils.isEmpty((Object)strTargetId)) continue;
                String strTargetType = null;
                if (targetTypePSDEField != null) {
                    strTargetType = DataTypeUtils.getStringValue(iDataEntityRuntime.getFieldValue(item, targetTypePSDEField), null);
                }
                map.put(strTargetId, strTargetType);
            }
            return map;
        }
        return null;
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null) {
            this.iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSSysMsgTarget().getPSDataEntityMust().getId());
        }
        return this.iDataEntityRuntime;
    }
}

