/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dts;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dts.IPSSysDTSQueue;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ModelException;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dts.ISysDTSQueueRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysDTSQueueRuntime
extends SystemModelRuntimeBase
implements ISysDTSQueueRuntime {
    private static final Log log = LogFactory.getLog(SysDTSQueueRuntime.class);
    private IPSSysDTSQueue iPSSysDTSQueue = null;
    private Map<Object, DTSQueueEntity> dtsQueueEntityMap = new HashMap<Object, DTSQueueEntity>();
    private IDataEntityRuntime iDataEntityRuntime = null;
    private IPSDEAction pushPSDEAction = null;
    private IPSDEAction refreshPSDEAction = null;
    private IPSDEAction confirmPSDEAction = null;
    private IPSDEAction cancelPSDEAction = null;
    private IPSDEField statePSDEField = null;
    private IPSDEField errorPSDEField = null;
    private Object createdState = null;
    private Object processingState = null;
    private Object finishedState = null;
    private Object failedState = null;
    private Object cancelledState = null;
    private int nCancelTimeout = 600000;
    private int nRefreshTimer = 2000;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysDTSQueue iPSSysDTSQueue) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysDTSQueue = iPSSysDTSQueue;
        this.onInit();
    }

    public IPSSysDTSQueue getPSSysDTSQueue() {
        return this.iPSSysDTSQueue;
    }

    @Override
    public String getId() {
        return this.getPSSysDTSQueue().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysDTSQueue().getName();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysDTSQueue();
    }

    @Override
    protected void onInit() throws Exception {
        this.setPushPSDEAction(this.getPSSysDTSQueue().getPushPSDEActionMust());
        this.setCancelPSDEAction(this.getPSSysDTSQueue().getCancelPSDEAction());
        this.setConfirmPSDEAction(this.getPSSysDTSQueue().getConfirmPSDEAction());
        this.setRefreshPSDEAction(this.getPSSysDTSQueue().getRefreshPSDEAction());
        this.setStatePSDEField(this.getPSSysDTSQueue().getStatePSDEFieldMust());
        this.setErrorPSDEField(this.getPSSysDTSQueue().getErrorPSDEFieldMust());
        this.setDataEntityRuntime(this.getSystemRuntime().getDataEntityRuntime(this.getPSSysDTSQueue().getPSDataEntityMust().getId(), false));
        if (StringUtils.hasLength((String)this.getPSSysDTSQueue().getCreatedState())) {
            this.setCreatedState(this.getSystemRuntime().convertValue(this.getStatePSDEField().getStdDataType(), this.getPSSysDTSQueue().getCreatedState()));
        }
        if (StringUtils.hasLength((String)this.getPSSysDTSQueue().getProcessingState())) {
            this.setProcessingState(this.getSystemRuntime().convertValue(this.getStatePSDEField().getStdDataType(), this.getPSSysDTSQueue().getProcessingState()));
        }
        if (StringUtils.hasLength((String)this.getPSSysDTSQueue().getFinishedState())) {
            this.setFinishedState(this.getSystemRuntime().convertValue(this.getStatePSDEField().getStdDataType(), this.getPSSysDTSQueue().getFinishedState()));
        }
        if (StringUtils.hasLength((String)this.getPSSysDTSQueue().getFailedState())) {
            this.setFailedState(this.getSystemRuntime().convertValue(this.getStatePSDEField().getStdDataType(), this.getPSSysDTSQueue().getFailedState()));
        }
        if (StringUtils.hasLength((String)this.getPSSysDTSQueue().getCancelledState())) {
            this.setCancelledState(this.getSystemRuntime().convertValue(this.getStatePSDEField().getStdDataType(), this.getPSSysDTSQueue().getCancelledState()));
        }
        if (this.getProcessingState() == null) {
            throw new ModelException((IPSModelObject)this.getPSSysDTSQueue(), "\u672a\u6307\u5b9a\u5904\u7406\u4e2d\u72b6\u6001");
        }
        if (this.getFinishedState() == null) {
            throw new ModelException((IPSModelObject)this.getPSSysDTSQueue(), "\u672a\u6307\u5b9a\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        if (this.getFailedState() == null) {
            throw new ModelException((IPSModelObject)this.getPSSysDTSQueue(), "\u672a\u6307\u5b9a\u5df2\u5931\u8d25\u72b6\u6001");
        }
        if (this.getCancelledState() == null) {
            throw new ModelException((IPSModelObject)this.getPSSysDTSQueue(), "\u672a\u6307\u5b9a\u5df2\u53d6\u6d88\u72b6\u6001");
        }
        super.onInit();
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    protected void setDataEntityRuntime(IDataEntityRuntime iDataEntityRuntime) {
        this.iDataEntityRuntime = iDataEntityRuntime;
    }

    protected IPSDEAction getPushPSDEAction() {
        return this.pushPSDEAction;
    }

    protected void setPushPSDEAction(IPSDEAction pushPSDEAction) {
        this.pushPSDEAction = pushPSDEAction;
    }

    protected IPSDEAction getRefreshPSDEAction() {
        return this.refreshPSDEAction;
    }

    protected void setRefreshPSDEAction(IPSDEAction refreshPSDEAction) {
        this.refreshPSDEAction = refreshPSDEAction;
    }

    protected IPSDEAction getConfirmPSDEAction() {
        return this.confirmPSDEAction;
    }

    protected void setConfirmPSDEAction(IPSDEAction confirmPSDEAction) {
        this.confirmPSDEAction = confirmPSDEAction;
    }

    protected IPSDEAction getCancelPSDEAction() {
        return this.cancelPSDEAction;
    }

    protected void setCancelPSDEAction(IPSDEAction cancelPSDEAction) {
        this.cancelPSDEAction = cancelPSDEAction;
    }

    protected IPSDEField getStatePSDEField() {
        return this.statePSDEField;
    }

    protected void setStatePSDEField(IPSDEField statePSDEField) {
        this.statePSDEField = statePSDEField;
    }

    protected IPSDEField getErrorPSDEField() {
        return this.errorPSDEField;
    }

    protected void setErrorPSDEField(IPSDEField errorPSDEField) {
        this.errorPSDEField = errorPSDEField;
    }

    protected Object getCreatedState() {
        return this.createdState;
    }

    protected void setCreatedState(Object createdState) {
        this.createdState = createdState;
    }

    protected Object getProcessingState() {
        return this.processingState;
    }

    protected void setProcessingState(Object processingState) {
        this.processingState = processingState;
    }

    protected Object getFinishedState() {
        return this.finishedState;
    }

    protected void setFinishedState(Object finishedState) {
        this.finishedState = finishedState;
    }

    protected Object getFailedState() {
        return this.failedState;
    }

    protected void setFailedState(Object failedState) {
        this.failedState = failedState;
    }

    protected Object getCancelledState() {
        return this.cancelledState;
    }

    protected void setCancelledState(Object cancelledState) {
        this.cancelledState = cancelledState;
    }

    protected int getCancelTimeout() {
        return this.nCancelTimeout;
    }

    protected void setCancelTimeout(int nCancelTimeout) {
        this.nCancelTimeout = nCancelTimeout;
    }

    protected int getRefreshTimer() {
        return this.nRefreshTimer;
    }

    protected void setRefreshTimer(int nRefreshTimer) {
        this.nRefreshTimer = nRefreshTimer;
    }

    @Override
    public void timeout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(IEntityBase iEntityBase) {
        Object objKey = this.getDataEntityRuntime().getKeyFieldValue(iEntityBase);
        if (ObjectUtils.isEmpty((Object)objKey)) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "\u6570\u636e\u5bf9\u8c61\u672a\u6307\u5b9a\u952e\u503c");
        }
        DTSQueueEntity dtsQueueEntity = null;
        Map<Object, DTSQueueEntity> map = this.dtsQueueEntityMap;
        synchronized (map) {
            if (!this.dtsQueueEntityMap.containsKey(objKey)) {
                dtsQueueEntity = new DTSQueueEntity(iEntityBase, objKey);
                this.dtsQueueEntityMap.put(objKey, dtsQueueEntity);
            }
        }
        if (dtsQueueEntity == null) {
            return;
        }
        this.push(dtsQueueEntity);
    }

    protected void push(final DTSQueueEntity dtsQueueEntity) {
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SysDTSQueueRuntime.this.executeQueueAction(dtsQueueEntity, SysDTSQueueRuntime.this.getPushPSDEAction(), SysDTSQueueRuntime.this.getProcessingState());
            }
        }, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(final DTSQueueEntity dtsQueueEntity) {
        long nCurTime = System.currentTimeMillis();
        if (nCurTime - dtsQueueEntity.getStartTime() > (long)this.getCancelTimeout()) {
            if (this.getCancelPSDEAction() != null) {
                this.executeQueueAction(dtsQueueEntity, this.getCancelPSDEAction(), this.getCancelledState());
            }
            Map<Object, DTSQueueEntity> map = this.dtsQueueEntityMap;
            synchronized (map) {
                this.dtsQueueEntityMap.remove(dtsQueueEntity.getKey());
            }
            return;
        }
        if (this.getRefreshPSDEAction() != null) {
            this.getSystemRuntime().threadRun(new Runnable(){

                @Override
                public void run() {
                    SysDTSQueueRuntime.this.executeQueueAction(dtsQueueEntity, SysDTSQueueRuntime.this.getRefreshPSDEAction(), SysDTSQueueRuntime.this.getProcessingState());
                }
            }, nCurTime + (long)this.getRefreshTimer());
        } else {
            Map<Object, DTSQueueEntity> map = this.dtsQueueEntityMap;
            synchronized (map) {
                this.dtsQueueEntityMap.remove(dtsQueueEntity.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQueueAction(DTSQueueEntity dtsQueueEntity, IPSDEAction iPSDEAction, Object queueState) {
        IEntityBase et = null;
        Object curState = null;
        DTSQueueEntity moveDTSQueueEntity = null;
        try {
            et = this.getDataEntityRuntime().clone(dtsQueueEntity.getEntity(), false);
            this.getDataEntityRuntime().executeAction(iPSDEAction.getName(), iPSDEAction, new Object[]{et});
            curState = this.getDataEntityRuntime().getFieldValue(et, this.getStatePSDEField());
            if (curState == null) {
                curState = queueState;
            }
            Map<Object, DTSQueueEntity> map = this.dtsQueueEntityMap;
            synchronized (map) {
                DTSQueueEntity dtsQueueEntity2 = this.dtsQueueEntityMap.get(dtsQueueEntity.getKey());
                if (dtsQueueEntity2 != null) {
                    if (curState.equals(this.getFinishedState()) || curState.equals(this.getFailedState()) || curState.equals(this.getCancelledState())) {
                        this.dtsQueueEntityMap.remove(dtsQueueEntity2.getKey());
                        moveDTSQueueEntity = dtsQueueEntity2;
                    } else {
                        dtsQueueEntity2.setState(curState);
                        this.refresh(dtsQueueEntity2);
                        return;
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u6267\u884c\u5f02\u6b65\u5904\u7406\u961f\u5217\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            if (curState.equals(this.getFinishedState()) && this.getConfirmPSDEAction() != null) {
                this.getDataEntityRuntime().executeAction(this.getConfirmPSDEAction().getName(), this.getConfirmPSDEAction(), new Object[]{et});
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex);
        }
    }

    protected class DTSQueueEntity {
        private IEntityBase iEntity = null;
        private long nStartTime = 0L;
        private long nLastRefreshTime = 0L;
        private Object objState = null;
        private Object objKey = null;

        public DTSQueueEntity(IEntityBase iEntity, Object objKey) {
            this.iEntity = iEntity;
            this.objKey = objKey;
            this.nStartTime = System.currentTimeMillis();
            this.updateRefreshTime();
        }

        public IEntityBase getEntity() {
            return this.iEntity;
        }

        public Object getState() {
            return this.objState;
        }

        public void setState(Object objState) {
            this.objState = objState;
        }

        public Object getKey() {
            return this.objKey;
        }

        public void updateRefreshTime() {
            this.nLastRefreshTime = System.currentTimeMillis();
        }

        public long getStartTime() {
            return this.nStartTime;
        }

        public long getLastRefreshTime() {
            return this.nLastRefreshTime;
        }
    }
}

