/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity.report;

import java.io.OutputStream;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.report.IPSDEReport;
import net.ibizsys.runtime.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.report.IDEReportRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DEReportRuntime
extends DataEntityModelRuntimeBase
implements IDEReportRuntime {
    private static final Log log = LogFactory.getLog(DEReportRuntime.class);
    private IPSDEReport iPSDEReport = null;

    @Override
    public void init(IDataEntityRuntimeBase iDataEntityRuntimeBase, IPSDEReport iPSDEReport) throws Exception {
        Assert.notNull((Object)iDataEntityRuntimeBase, (String)"\u4f20\u5165\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDEReport, (String)"\u4f20\u5165\u5b9e\u4f53\u62a5\u8868\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setDataEntityRuntimeBase(iDataEntityRuntimeBase);
        this.iPSDEReport = iPSDEReport;
        this.onInit();
    }

    @Override
    public IPSDEReport getPSDEReport() {
        return this.iPSDEReport;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEReport();
    }

    @Override
    public String getId() {
        if (this.getPSDEReport() != null) {
            return this.getPSDEReport().getId();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.getPSDEReport() != null) {
            return this.getPSDEReport().getName();
        }
        return null;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    protected String getDefaultContentType() {
        return PSModelEnums.ReportContentType.PDF.value;
    }

    @Override
    public void output(OutputStream outputStream, ISearchContextBase iSearchContextBase, String strType, boolean bTestPriv) throws Throwable {
        if (bTestPriv && !this.testPermission()) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), String.format("\u6ca1\u6709\u6388\u6743\u8bbf\u95ee\u6307\u5b9a\u62a5\u8868", new Object[0]), 2);
        }
        this.getDataEntityRuntime().setSearchPaging(iSearchContextBase, 0, this.getMaxRowCount(), null);
        this.getDataEntityRuntime().setSearchMode(iSearchContextBase, true, false);
        List<? extends IEntityBase> data = null;
        if (this.getPSDEReport().getPSDEDataSet() != null) {
            data = this.searchDataSet(this.getPSDEReport().getPSDEDataSet(), iSearchContextBase);
        }
        data = this.onBeforeOutput(data, iSearchContextBase, strType);
        this.onOutput(outputStream, data, iSearchContextBase, strType);
    }

    protected List<? extends IEntityBase> onBeforeOutput(List<? extends IEntityBase> data, ISearchContextBase iSearchContextBase, String strType) throws Throwable {
        return data;
    }

    protected List<? extends IEntityBase> searchDataSet(IPSDEDataSet iPSDEDataSet, ISearchContextBase iSearchContextBase) {
        Page<? extends IEntityBase> page = this.getDataEntityRuntime().searchDataSet(iPSDEDataSet, iSearchContextBase);
        return page.getContent();
    }

    protected boolean testPermission() {
        String strUniResCode = null;
        try {
            if (this.getPSDEReport().getPSSysUniRes() != null) {
                strUniResCode = this.getPSDEReport().getPSSysUniRes().getResCode();
            }
        }
        catch (Exception e) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u83b7\u53d6\u62a5\u8868[%1$s]\u7edf\u4e00\u8d44\u6e90\u6807\u8bc6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), e.getMessage()), 21, e);
        }
        if (StringUtils.hasLength(strUniResCode)) {
            return this.getSystemRuntime().testUniRes(strUniResCode);
        }
        return true;
    }

    protected int getMaxRowCount() {
        return 1000000;
    }

    protected void onOutput(OutputStream outputStream, Object data, ISearchContextBase iSearchContextBase, String strType) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected IUserContext getUserContext() {
        return UserContext.getCurrent();
    }

    protected String getReportModel() {
        return this.getPSDEReport().getReportModel();
    }

    protected String getReportFilePath() {
        return this.getPSDEReport().getReportFile();
    }
}

