/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity.notify;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.model.dataentity.notify.IPSDENotifyTarget;
import net.ibizsys.runtime.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.notify.IDENotifyRuntime;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgTargetRuntime;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.res.ISysNotifyAgentRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.domain.MsgSendQueue;
import net.ibizsys.runtime.util.script.IScriptEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DENotifyRuntime
extends DataEntityModelRuntimeBase
implements IDENotifyRuntime {
    private static final Log log = LogFactory.getLog(DENotifyRuntime.class);
    public static final int MAXCOUNT = 200;
    public static final int PAGESIZE = 200;
    private IPSDENotify iPSDENotify = null;
    private IPSDEDataSet iPSDEDataSet = null;
    private IPSDEField beginTimePSDEField = null;
    private IPSDEField endTimePSDEField = null;
    private ISysMsgTemplRuntime iSysMsgTemplRuntime = null;
    private ISysMsgQueueRuntime iSysMsgQueueRuntime = null;
    private List<IPSDENotifyTarget> psDENotifyTargetList = null;
    private List<ISysMsgTargetRuntime> sysMsgTargetRuntimeList = null;
    private Map<IPSDEField, IPSDEField> deTargetMap = null;

    @Override
    public void init(IDataEntityRuntimeBase iDataEntityRuntimeBase, IPSDENotify iPSDENotify) throws Exception {
        Assert.notNull((Object)iDataEntityRuntimeBase, (String)"\u4f20\u5165\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDENotify, (String)"\u4f20\u5165\u5b9e\u4f53\u901a\u77e5\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setDataEntityRuntimeBase(iDataEntityRuntimeBase);
        this.iPSDENotify = iPSDENotify;
        Assert.notNull((Object)this.getPSDENotify().getPSSysMsgQueue(), (String)"\u6ca1\u6709\u6307\u5b9a\u8f93\u51fa\u7684\u7cfb\u7edf\u6d88\u606f\u961f\u5217");
        Assert.notNull((Object)this.getPSDENotify().getPSSysMsgTempl(), (String)"\u6ca1\u6709\u6307\u5b9a\u7cfb\u7edf\u6d88\u606f\u6a21\u677f");
        this.psDENotifyTargetList = this.getPSDENotify().getPSDENotifyTargets();
        Assert.notEmpty(this.psDENotifyTargetList, (String)"\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u76ee\u6807");
        this.iSysMsgQueueRuntime = this.getSystemRuntimeBase().getSysMsgQueueRuntime(this.getPSDENotify().getPSSysMsgQueue());
        this.iSysMsgTemplRuntime = this.getSystemRuntimeBase().getSysMsgTemplRuntime(this.getPSDENotify().getPSSysMsgTempl());
        ArrayList<ISysMsgTargetRuntime> sysMsgTargetRuntimeList = new ArrayList<ISysMsgTargetRuntime>();
        HashMap<IPSDEField, IPSDEField> deTargetMap = new HashMap<IPSDEField, IPSDEField>();
        for (IPSDENotifyTarget iPSDENotifyTarget : this.psDENotifyTargetList) {
            if ("SYSMSGTARGET".equals(iPSDENotifyTarget.getTargetType())) {
                Assert.notNull((Object)iPSDENotifyTarget.getPSSysMsgTarget(), (String)String.format("\u76ee\u6807[%1$s]\u6ca1\u6709\u6307\u5b9a\u7cfb\u7edf\u6d88\u606f\u76ee\u6807", iPSDENotifyTarget.getName()));
                ISysMsgTargetRuntime iSysMsgTargetRuntime = this.getSystemRuntimeBase().getSysMsgTargetRuntime(iPSDENotifyTarget.getPSSysMsgTarget());
                sysMsgTargetRuntimeList.add(iSysMsgTargetRuntime);
                continue;
            }
            if (!"DEFIELD".equals(iPSDENotifyTarget.getTargetType())) continue;
            Assert.notNull((Object)iPSDENotifyTarget.getTargetPSDEField(), (String)String.format("\u76ee\u6807[%1$s]\u6ca1\u6709\u6307\u5b9a\u76ee\u6807\u5c5e\u6027", iPSDENotifyTarget.getName()));
            deTargetMap.put(iPSDENotifyTarget.getTargetPSDEField(), iPSDENotifyTarget.getTargetTypePSDEField());
        }
        if (sysMsgTargetRuntimeList != null) {
            this.sysMsgTargetRuntimeList = sysMsgTargetRuntimeList;
        }
        if (deTargetMap != null) {
            this.deTargetMap = deTargetMap;
        }
        if (this.getPSDENotify().isTimerMode()) {
            this.iPSDEDataSet = this.getPSDENotify().getPSDEDataSet();
            this.beginTimePSDEField = this.getPSDENotify().getBeginTimePSDEField();
            this.endTimePSDEField = this.getPSDENotify().getEndTimePSDEField();
            Assert.notNull((Object)this.iPSDEDataSet, (String)"\u67e5\u8be2\u7ed3\u679c\u96c6\u5bf9\u8c61\u65e0\u6548");
            Assert.notNull((Object)this.beginTimePSDEField, (String)"\u5f00\u59cb\u65f6\u95f4\u5c5e\u6027\u5bf9\u8c61\u65e0\u6548");
        }
        this.onInit();
    }

    @Override
    public IPSDENotify getPSDENotify() {
        return this.iPSDENotify;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDENotify();
    }

    public IPSDEDataSet getPSDEDataSet() {
        return this.iPSDEDataSet;
    }

    public IPSDEField getBeginTimePSDEField() {
        return this.beginTimePSDEField;
    }

    public IPSDEField getEndTimePSDEField() {
        return this.endTimePSDEField;
    }

    public ISysMsgTemplRuntime getSysMsgTemplRuntime() {
        return this.iSysMsgTemplRuntime;
    }

    public ISysMsgQueueRuntime getSysMsgQueueRuntime() {
        return this.iSysMsgQueueRuntime;
    }

    public List<IPSDENotifyTarget> getPSDENotifyTargets() {
        return this.psDENotifyTargetList;
    }

    protected List<ISysMsgTargetRuntime> getSysMsgTargetRuntimes() {
        return this.sysMsgTargetRuntimeList;
    }

    protected Map<IPSDEField, IPSDEField> getDETargets() {
        return this.deTargetMap;
    }

    @Override
    public String getId() {
        if (this.getPSDENotify() != null) {
            return this.getPSDENotify().getId();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.getPSDENotify() != null) {
            return this.getPSDENotify().getName();
        }
        return null;
    }

    @Override
    protected void onInit() throws Exception {
        ISysNotifyAgentRuntime iSysNotifyAgentRuntime = null;
        if (this.getPSDENotify().isTimerMode()) {
            iSysNotifyAgentRuntime = this.getDynaInstRuntime() != null ? this.getDynaInstRuntime().getSysNotifyAgentRuntime() : this.getSystemRuntime().getSysNotifyAgentRuntime();
        }
        super.onInit();
        if (this.getPSDENotify().isTimerMode()) {
            iSysNotifyAgentRuntime.registerDENotifyRuntime(this);
        }
    }

    @Override
    public void send(IEntityBase iEntityBase) {
        try {
            this.onSend(iEntityBase);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53\u901a\u77e5[%1$s]\u53d1\u9001\u901a\u77e5\u53d1\u751f\u5f02\u5e38\uff0c %2$s", this.getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), String.format("\u5b9e\u4f53\u901a\u77e5[%1$s]\u53d1\u9001\u901a\u77e5\u53d1\u751f\u5f02\u5e38\uff0c %2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    protected void onSend(IEntityBase iEntityBase) throws Throwable {
        MsgSendQueue msgSendQueue = this.getMsgSendQueue(iEntityBase);
        if (msgSendQueue == null) {
            return;
        }
        this.getSysMsgQueueRuntime().send(new MsgSendQueue[]{msgSendQueue});
    }

    @Override
    public void send() {
        if (!this.getPSDENotify().isTimerMode()) {
            return;
        }
        try {
            this.onSend();
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53\u901a\u77e5[%1$s]\u53d1\u9001\u901a\u77e5\u53d1\u751f\u5f02\u5e38\uff0c %2$s", this.getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), String.format("\u5b9e\u4f53\u901a\u77e5[%1$s]\u53d1\u9001\u901a\u77e5\u53d1\u751f\u5f02\u5e38\uff0c %2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    protected void onSend() throws Throwable {
        ISearchContextBase iSearchContextBase = this.getDataEntityRuntime().createSearchContext();
        long nCurTime = System.currentTimeMillis();
        long nFromTime = nCurTime - (long)(this.getPSDENotify().getNotifyStart() * 60000);
        long nToTime = nCurTime + (long)(this.getPSDENotify().getNotifyEnd() * 60000);
        ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
        if (this.getBeginTimePSDEField() != null) {
            this.getDataEntityRuntime().setSearchCondition(iSearchContextBase, this.getBeginTimePSDEField(), "GTANDEQ", (Object)new Timestamp(nFromTime));
            list.add(Sort.Order.asc((String)this.getBeginTimePSDEField().getName()));
        }
        if (this.getEndTimePSDEField() != null) {
            this.getDataEntityRuntime().setSearchCondition(iSearchContextBase, this.getEndTimePSDEField(), "LTANDEQ", (Object)new Timestamp(nToTime));
        } else if (this.getBeginTimePSDEField() != null) {
            this.getDataEntityRuntime().setSearchCondition(iSearchContextBase, this.getBeginTimePSDEField(), "LTANDEQ", (Object)new Timestamp(nToTime));
        }
        String strCustomCond = this.getPSDENotify().getCustomCond();
        if (StringUtils.hasLength((String)strCustomCond)) {
            this.getDataEntityRuntime().setSearchCustomCondition(iSearchContextBase, strCustomCond);
        }
        Sort sort = Sort.by(list);
        HashMap sendEntityMap = new HashMap();
        int nPageNumber = 0;
        do {
            this.getDataEntityRuntime().setSearchPaging(iSearchContextBase, nPageNumber, 200, sort);
            Page<? extends IEntityBase> page = this.getDataEntityRuntime().searchDataSet(this.getPSDEDataSet(), iSearchContextBase);
            if (page == null || page.getNumberOfElements() == 0) break;
            ++nPageNumber;
            HashMap<String, MsgSendQueue[]> entityMap = new HashMap<String, MsgSendQueue[]>();
            for (MsgSendQueue[] iEntity : page.getContent()) {
                Object objKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntity, this.getDataEntityRuntime().getKeyPSDEField());
                String strMsgId = KeyValueUtils.genUniqueId(this.getDataEntityRuntime().getId(), this.getId(), objKey);
                entityMap.put(strMsgId, iEntity);
            }
            MsgSendQueue[] msgSendQueues = this.getSysMsgQueueRuntime().listSimple(entityMap.keySet().toArray(new String[entityMap.size()]));
            if (msgSendQueues != null && msgSendQueues.length > 0) {
                for (MsgSendQueue msgSendQueue : msgSendQueues) {
                    entityMap.remove(msgSendQueue.getMsgSendQueueId());
                }
            }
            sendEntityMap.putAll(entityMap);
        } while (sendEntityMap.size() < 200);
        ArrayList<MsgSendQueue> msgSendQueueList = new ArrayList<MsgSendQueue>();
        for (Map.Entry entry : sendEntityMap.entrySet()) {
            MsgSendQueue msgSendQueue = this.getMsgSendQueue((IEntityBase)entry.getValue());
            if (msgSendQueue == null) continue;
            msgSendQueue.setMsgSendQueueId((String)entry.getKey());
            msgSendQueueList.add(msgSendQueue);
        }
        if (msgSendQueueList.size() == 0) {
            return;
        }
        this.getSysMsgQueueRuntime().send(msgSendQueueList.toArray(new MsgSendQueue[msgSendQueueList.size()]));
    }

    protected MsgSendQueue getMsgSendQueue(IEntityBase iEntityBase) throws Throwable {
        Map<String, String> result;
        int nMsgType = this.getPSDENotify().getMsgType();
        if (nMsgType == 0) {
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u901a\u77e5[%2$s]\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u7c7b\u578b\uff0c\u5ffd\u7565\u5efa\u7acb\u901a\u77e5\u6d88\u606f", this.getDataEntityRuntime().getId(), this.getName()));
            return null;
        }
        HashMap<String, String> targetMap = new HashMap<String, String>();
        if (this.getDETargets() != null) {
            for (Map.Entry entry : this.getDETargets().entrySet()) {
                String strTargetId = DataTypeUtils.getStringValue(this.getDataEntityRuntime().getFieldValue(iEntityBase, (IPSDEField)entry.getKey()), null);
                if (!StringUtils.hasLength((String)strTargetId)) continue;
                String strTargetType = null;
                if (entry.getValue() != null) {
                    strTargetType = DataTypeUtils.getStringValue(this.getDataEntityRuntime().getFieldValue(iEntityBase, (IPSDEField)entry.getValue()), null);
                }
                targetMap.put(strTargetId, strTargetType);
            }
        }
        if (this.getSysMsgTargetRuntimes() != null) {
            for (ISysMsgTargetRuntime iSysMsgTargetRuntime : this.getSysMsgTargetRuntimes()) {
                result = iSysMsgTargetRuntime.get(iEntityBase);
                if (result == null) continue;
                targetMap.putAll(result);
            }
        }
        for (IPSDENotifyTarget iPSDENotifyTarget : this.getPSDENotifyTargets()) {
            result = this.getTarget(iPSDENotifyTarget, iEntityBase);
            if (result == null) continue;
            targetMap.putAll(result);
        }
        if (targetMap.size() == 0) {
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u901a\u77e5[%2$s]\u6ca1\u6709\u4efb\u4f55\u901a\u77e5\u76ee\u6807\uff0c\u5ffd\u7565\u5efa\u7acb\u901a\u77e5\u6d88\u606f", this.getDataEntityRuntime().getId(), this.getName()));
            return null;
        }
        MsgSendQueue msgSendQueue = new MsgSendQueue();
        IScriptEntity iScriptEntity = this.getDataEntityRuntime().createScriptEntity(iEntityBase);
        msgSendQueue.setMsgType(nMsgType);
        msgSendQueue.setSubject(this.getSysMsgTemplRuntime().getSubject(iScriptEntity));
        msgSendQueue.setTemplateId(this.getSysMsgTemplRuntime().getPSSysMsgTempl().getCodeName());
        msgSendQueue.setUrl(this.getSysMsgTemplRuntime().getUrl(iScriptEntity));
        msgSendQueue.setMobileUrl(this.getSysMsgTemplRuntime().getMobileUrl(iScriptEntity));
        if ((nMsgType & 3) != 0) {
            msgSendQueue.setContent(this.getSysMsgTemplRuntime().getContent(iScriptEntity));
            msgSendQueue.setContentType(this.getSysMsgTemplRuntime().getContentType());
        }
        if ((nMsgType & 4) != 0) {
            msgSendQueue.setSMSContent(this.getSysMsgTemplRuntime().getSMSContent(iScriptEntity));
        }
        if ((nMsgType & 0x18) != 0) {
            msgSendQueue.setIMContent(this.getSysMsgTemplRuntime().getIMContent(iScriptEntity));
        }
        if ((nMsgType & 0x20) != 0) {
            msgSendQueue.setWXContent(this.getSysMsgTemplRuntime().getWXContent(iScriptEntity));
        }
        if ((nMsgType & 0x40) != 0) {
            msgSendQueue.setDDContent(this.getSysMsgTemplRuntime().getDDContent(iScriptEntity));
        }
        ArrayNode array = JsonUtils.createArrayNode();
        for (Map.Entry entry : targetMap.entrySet()) {
            array.add((String)entry.getKey());
        }
        msgSendQueue.setDstUsers(array.toString());
        return msgSendQueue;
    }

    protected Map<String, String> getTarget(IPSDENotifyTarget iPSDENotifyTarget, IEntityBase iEntityBase) throws Throwable {
        if ("DEFIELD".equals(iPSDENotifyTarget.getTargetType())) {
            Object objTargetType;
            Object objTargetId = this.getDataEntityRuntime().getFieldValue(iEntityBase, iPSDENotifyTarget.getTargetPSDEFieldMust());
            if (ObjectUtils.isEmpty((Object)objTargetId)) {
                return null;
            }
            List<String> list = this.getTargetIdList(objTargetId);
            if (ObjectUtils.isEmpty(list)) {
                return null;
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            if (iPSDENotifyTarget.getTargetTypePSDEField() != null && !ObjectUtils.isEmpty((Object)(objTargetType = this.getDataEntityRuntime().getFieldValue(iEntityBase, iPSDENotifyTarget.getTargetTypePSDEField())))) {
                for (String strItem : list) {
                    map.put(strItem, objTargetType.toString());
                }
                return map;
            }
            for (String strItem : list) {
                map.put(strItem, null);
            }
            return map;
        }
        if ("SYSMSGTARGET".equals(iPSDENotifyTarget.getTargetType())) {
            return null;
        }
        log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u6d88\u606f\u76ee\u6807[%1$s][%2$s]", iPSDENotifyTarget.getName(), iPSDENotifyTarget.getTargetType()));
        return null;
    }

    protected List<String> getTargetIdList(Object objTargetId) throws Throwable {
        if (ObjectUtils.isEmpty((Object)objTargetId)) {
            return null;
        }
        if (objTargetId instanceof List) {
            List list = (List)objTargetId;
            ArrayList<String> list2 = new ArrayList<String>();
            for (Object item : list) {
                List<String> list4 = this.getTargetIdList(item);
                if (ObjectUtils.isEmpty(list4)) continue;
                list2.addAll(list4);
            }
            return list2.size() > 0 ? list2 : null;
        }
        if (objTargetId instanceof Map) {
            Map map = (Map)objTargetId;
            ArrayList<String> list2 = new ArrayList<String>();
            for (Object item : map.keySet()) {
                List<String> list4 = this.getTargetIdList(item);
                if (ObjectUtils.isEmpty(list4)) continue;
                list2.addAll(list4);
            }
            return list2.size() > 0 ? list2 : null;
        }
        if (objTargetId.getClass().isArray()) {
            ArrayList<String> list2 = new ArrayList<String>();
            if (objTargetId instanceof Object[]) {
                Object[] list3 = (Object[])objTargetId;
                for (int i = 0; i < list3.length; ++i) {
                    List<String> list4 = this.getTargetIdList(list3[i]);
                    if (ObjectUtils.isEmpty(list4)) continue;
                    list2.addAll(list4);
                }
            } else if (objTargetId instanceof int[]) {
                int[] list3 = (int[])objTargetId;
                for (int i = 0; i < list3.length; ++i) {
                    list2.add(Integer.toString(list3[i]));
                }
            } else {
                log.warn((Object)String.format("\u65e0\u6cd5\u4ece\u503c[%1$s]\u8ba1\u7b97\u6d88\u606f\u76ee\u6807", objTargetId));
            }
            return list2.size() > 0 ? list2 : null;
        }
        if (objTargetId instanceof ArrayNode) {
            ArrayList<String> list2 = new ArrayList<String>();
            ArrayNode arrayNode = (ArrayNode)objTargetId;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode jsonNode = arrayNode.get(i);
                String strValue = jsonNode.asText();
                if (ObjectUtils.isEmpty((Object)strValue)) continue;
                list2.add(strValue);
            }
            return list2.size() > 0 ? list2 : null;
        }
        String id = objTargetId.toString();
        if (id.indexOf("[") == 0) {
            ArrayNode arrayNode = JsonUtils.toArrayNode(id);
            return this.getTargetIdList(arrayNode);
        }
        return Arrays.asList(id.replace(",", ";").split("[;]"));
    }
}

