/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity;

import net.ibizsys.runtime.dataentity.IDataEntityEventListener;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DataEntityEventListenerBase
implements IDataEntityEventListener {
    private static final Log log = LogFactory.getLog(DataEntityEventListenerBase.class);

    @Override
    public void receiveEvent(IDataEntityRuntime iDataEntityRuntime, String event, Object[] params) {
        try {
            this.onReceiveEvent(iDataEntityRuntime, event, params);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u4e8b\u4ef6[%2$s]\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), event, ex.getMessage()), ex);
        }
    }

    protected void onReceiveEvent(IDataEntityRuntime iDataEntityRuntime, String event, Object[] params) throws Throwable {
        switch (event) {
            case "SYNCENTITY": {
                this.onSyncEntity(iDataEntityRuntime, params);
                break;
            }
            default: {
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u4e8b\u4ef6[%2$s]\u672a\u8bc6\u522b", iDataEntityRuntime.getName(), event));
            }
        }
    }

    protected void onSyncEntity(IDataEntityRuntime iDataEntityRuntime, Object[] params) throws Throwable {
    }
}

