/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dts.IPSSysDTSQueue;
import net.ibizsys.model.msg.IPSSysMsgQueue;
import net.ibizsys.model.msg.IPSSysMsgTarget;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.res.IPSSysSequence;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.valuerule.IPSSysValueRule;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dts.ISysDTSQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgTargetRuntime;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.res.ISysNotifyAgentRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.res.ISysValueRuleRuntime;
import net.ibizsys.runtime.util.ModelRuntimeUtils;
import net.ibizsys.runtime.wf.IWFRoleRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SystemRuntimeBaseBase
extends ModelRuntimeBase
implements ISystemRuntimeBase {
    private static final Log log = LogFactory.getLog(SystemRuntimeBaseBase.class);
    private Map<String, IPSSysLogic> psSysLogicMap = new HashMap<String, IPSSysLogic>();
    private Map<String, ISysValueRuleRuntime> sysValueRuleRuntimeMap = new HashMap<String, ISysValueRuleRuntime>();
    private Map<String, ISysSequenceRuntime> sysSequenceRuntimeMap = new HashMap<String, ISysSequenceRuntime>();
    private Map<String, ISysTranslatorRuntime> sysTranslatorRuntimeMap = new HashMap<String, ISysTranslatorRuntime>();
    private Map<String, ICodeListRuntime> codeListRuntimeMap = new HashMap<String, ICodeListRuntime>();
    private Map<String, ISysDataSyncAgentRuntime> sysDataSyncAgentRuntimeMap = new HashMap<String, ISysDataSyncAgentRuntime>();
    private List<ISysDataSyncAgentRuntime> inSysDataSyncAgentRuntimeList = new ArrayList<ISysDataSyncAgentRuntime>();
    private Map<String, ISysMsgQueueRuntime> sysMsgQueueRuntimeMap = new HashMap<String, ISysMsgQueueRuntime>();
    private Map<String, ISysMsgTemplRuntime> sysMsgTemplRuntimeMap = new HashMap<String, ISysMsgTemplRuntime>();
    private Map<String, ISysMsgTargetRuntime> sysMsgTargetRuntimeMap = new HashMap<String, ISysMsgTargetRuntime>();
    private Map<String, ISysLogicRuntime> sysLogicRuntimeMap = new HashMap<String, ISysLogicRuntime>();
    private Map<String, IPSWFRole> psWFRoleMap = new HashMap<String, IPSWFRole>();
    private Map<String, IWFRoleRuntime> wfRoleRuntimeMap = new HashMap<String, IWFRoleRuntime>();
    private Map<String, ISysDTSQueueRuntime> sysDTSQueueRuntimeMap = new HashMap<String, ISysDTSQueueRuntime>();
    private List<ISysDTSQueueRuntime> sysDTSQueueRuntimeList = new ArrayList<ISysDTSQueueRuntime>();
    private ISysNotifyAgentRuntime iSysNotifyAgentRuntime = null;
    private Map<String, Object> globalParamMap = new HashMap<String, Object>();
    private int nEngineVer = 0;

    protected abstract ISystemRuntimeContext getSystemRuntimeContext();

    protected abstract ISystemRuntimeBaseContext getSystemRuntimeBaseContext();

    @Override
    protected void onInit() throws Exception {
        List psSysDTSQueues;
        List psWFRoles;
        super.onInit();
        List psSysLogics = this.getPSSystem().getAllPSSysLogics();
        if (psSysLogics != null) {
            for (IPSSysLogic iPSSysLogic : psSysLogics) {
                String strCodeName = iPSSysLogic.getCodeName();
                if (!StringUtils.hasLength((String)strCodeName)) continue;
                this.psSysLogicMap.put(strCodeName.toUpperCase(), iPSSysLogic);
            }
        }
        if (this.isEnableWFRuntime() && (psWFRoles = this.getPSSystem().getAllPSWFRoles()) != null) {
            for (IPSWFRole iPSWFRole : psWFRoles) {
                String strName;
                String strUniqueTag = iPSWFRole.getUniqueTag();
                if (StringUtils.hasLength((String)strUniqueTag)) {
                    this.psWFRoleMap.put(strUniqueTag.toUpperCase(), iPSWFRole);
                }
                if (!StringUtils.hasLength((String)(strName = iPSWFRole.getName()))) continue;
                this.psWFRoleMap.put(strName.toUpperCase(), iPSWFRole);
            }
        }
        if ((psSysDTSQueues = this.getPSSystem().getAllPSSysDTSQueues()) != null) {
            for (IPSSysDTSQueue iPSSysDTSQueue : psSysDTSQueues) {
                this.getSysDTSQueueRuntime(iPSSysDTSQueue);
            }
        }
    }

    @Override
    public int getPSModelEngineVer() {
        return this.nEngineVer;
    }

    protected void setPSModelEngineVer(int nEngineVer) {
        this.nEngineVer = nEngineVer;
    }

    @Override
    public ISysValueRuleRuntime getSysValueRuleRuntime(IPSSysValueRule iPSSysValueRule) {
        ISysValueRuleRuntime iSysValueRuleRuntime = this.sysValueRuleRuntimeMap.get(iPSSysValueRule.getDynaModelFilePath());
        if (iSysValueRuleRuntime == null) {
            iSysValueRuleRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysValueRuleRuntime(iPSSysValueRule);
            try {
                iSysValueRuleRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysValueRule);
                this.sysValueRuleRuntimeMap.put(iPSSysValueRule.getDynaModelFilePath(), iSysValueRuleRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysValueRule.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysValueRule.getName(), ex.getMessage()), ex);
            }
        }
        return iSysValueRuleRuntime;
    }

    @Override
    public ISysSequenceRuntime getSysSequenceRuntime(IPSSysSequence iPSSysSequence) {
        Assert.notNull((Object)iPSSysSequence, (String)"\u4f20\u5165\u7cfb\u7edf\u503c\u5e8f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysSequenceRuntime iSysSequenceRuntime = this.sysSequenceRuntimeMap.get(iPSSysSequence.getDynaModelFilePath());
        if (iSysSequenceRuntime == null) {
            iSysSequenceRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysSequenceRuntime(iPSSysSequence);
            try {
                iSysSequenceRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysSequence);
                this.sysSequenceRuntimeMap.put(iPSSysSequence.getDynaModelFilePath(), iSysSequenceRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u5e8f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSequence.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u5e8f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSequence.getName(), ex.getMessage()), ex);
            }
        }
        return iSysSequenceRuntime;
    }

    @Override
    public ISysTranslatorRuntime getSysTranslatorRuntime(IPSSysTranslator iPSSysTranslator) {
        Assert.notNull((Object)iPSSysTranslator, (String)"\u4f20\u5165\u7cfb\u7edf\u503c\u8f6c\u6362\u5668\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysTranslatorRuntime iSysTranslatorRuntime = this.sysTranslatorRuntimeMap.get(iPSSysTranslator.getDynaModelFilePath());
        if (iSysTranslatorRuntime == null) {
            iSysTranslatorRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysTranslatorRuntime(iPSSysTranslator);
            try {
                iSysTranslatorRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysTranslator);
                this.sysTranslatorRuntimeMap.put(iPSSysTranslator.getDynaModelFilePath(), iSysTranslatorRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u8f6c\u6362\u5668[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysTranslator.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u503c\u8f6c\u6362\u5668[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysTranslator.getName(), ex.getMessage()), ex);
            }
        }
        return iSysTranslatorRuntime;
    }

    @Override
    public ICodeListRuntime getCodeListRuntime(IPSCodeList iPSCodeList) {
        Assert.notNull((Object)iPSCodeList, (String)"\u4f20\u5165\u7cfb\u7edf\u4ee3\u7801\u8868\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ICodeListRuntime iCodeListRuntime = this.codeListRuntimeMap.get(iPSCodeList.getDynaModelFilePath());
        if (iCodeListRuntime == null) {
            iCodeListRuntime = this.getSystemRuntimeContext().getSystemRuntime().createCodeListRuntime(iPSCodeList);
            try {
                iCodeListRuntime.init(this.getSystemRuntimeBaseContext(), iPSCodeList);
                this.codeListRuntimeMap.put(iPSCodeList.getDynaModelFilePath(), iCodeListRuntime);
                if (StringUtils.hasLength((String)iPSCodeList.getCodeListTag())) {
                    this.codeListRuntimeMap.put(iPSCodeList.getCodeListTag(), iCodeListRuntime);
                }
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u4ee3\u7801\u8868[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSCodeList.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u4ee3\u7801\u8868[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSCodeList.getName(), ex.getMessage()), ex);
            }
        }
        return iCodeListRuntime;
    }

    @Override
    public ISysDataSyncAgentRuntime getSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        Assert.notNull((Object)iPSSysDataSyncAgent, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime = this.sysDataSyncAgentRuntimeMap.get(iPSSysDataSyncAgent.getDynaModelFilePath());
        if (iSysDataSyncAgentRuntime == null) {
            iSysDataSyncAgentRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
            try {
                iSysDataSyncAgentRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysDataSyncAgent);
                this.sysDataSyncAgentRuntimeMap.put(iPSSysDataSyncAgent.getDynaModelFilePath(), iSysDataSyncAgentRuntime);
                if ("IN".equals(iPSSysDataSyncAgent.getSyncDir()) || "INOUT".equals(iPSSysDataSyncAgent.getSyncDir())) {
                    this.inSysDataSyncAgentRuntimeList.add(iSysDataSyncAgentRuntime);
                }
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDataSyncAgent.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDataSyncAgent.getName(), ex.getMessage()), ex);
            }
        }
        return iSysDataSyncAgentRuntime;
    }

    @Override
    public Collection<ISysDataSyncAgentRuntime> getInSysDataSyncAgentRuntimes() {
        if (ObjectUtils.isEmpty(this.inSysDataSyncAgentRuntimeList)) {
            return null;
        }
        return this.inSysDataSyncAgentRuntimeList;
    }

    @Override
    public ISysNotifyAgentRuntime getSysNotifyAgentRuntime() {
        if (this.iSysNotifyAgentRuntime == null) {
            ISysNotifyAgentRuntime iSysNotifyAgentRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysNotifyAgentRuntime();
            try {
                iSysNotifyAgentRuntime.init(this.getSystemRuntimeBaseContext());
                this.iSysNotifyAgentRuntime = iSysNotifyAgentRuntime;
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u901a\u77e5\u4ee3\u7406[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", "\u9ed8\u8ba4", ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", "\u9ed8\u8ba4", ex.getMessage()), ex);
            }
        }
        return this.iSysNotifyAgentRuntime;
    }

    @Override
    public ISysMsgQueueRuntime getSysMsgQueueRuntime(IPSSysMsgQueue iPSSysMsgQueue) {
        Assert.notNull((Object)iPSSysMsgQueue, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u6d88\u606f\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgQueueRuntime iSysMsgQueueRuntime = this.sysMsgQueueRuntimeMap.get(iPSSysMsgQueue.getDynaModelFilePath());
        if (iSysMsgQueueRuntime == null) {
            iSysMsgQueueRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysMsgQueueRuntime(iPSSysMsgQueue);
            try {
                iSysMsgQueueRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysMsgQueue);
                this.sysMsgQueueRuntimeMap.put(iPSSysMsgQueue.getDynaModelFilePath(), iSysMsgQueueRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u606f\u961f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgQueue.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u606f\u961f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgQueue.getName(), ex.getMessage()), ex);
            }
        }
        return iSysMsgQueueRuntime;
    }

    @Override
    public ISysMsgTemplRuntime getSysMsgTemplRuntime(IPSSysMsgTempl iPSSysMsgTempl) {
        Assert.notNull((Object)iPSSysMsgTempl, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u6d88\u606f\u6a21\u677f\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgTemplRuntime iSysMsgTemplRuntime = this.sysMsgTemplRuntimeMap.get(iPSSysMsgTempl.getDynaModelFilePath());
        if (iSysMsgTemplRuntime == null) {
            iSysMsgTemplRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysMsgTemplRuntime(iPSSysMsgTempl);
            try {
                iSysMsgTemplRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysMsgTempl);
                this.sysMsgTemplRuntimeMap.put(iPSSysMsgTempl.getDynaModelFilePath(), iSysMsgTemplRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u6a21\u677f[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgTempl.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u606f\u6a21\u677f[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgTempl.getName(), ex.getMessage()), ex);
            }
        }
        return iSysMsgTemplRuntime;
    }

    @Override
    public ISysMsgTargetRuntime getSysMsgTargetRuntime(IPSSysMsgTarget iPSSysMsgTarget) {
        Assert.notNull((Object)iPSSysMsgTarget, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u6d88\u606f\u76ee\u6807\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgTargetRuntime iSysMsgTargetRuntime = this.sysMsgTargetRuntimeMap.get(iPSSysMsgTarget.getDynaModelFilePath());
        if (iSysMsgTargetRuntime == null) {
            iSysMsgTargetRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysMsgTargetRuntime(iPSSysMsgTarget);
            try {
                iSysMsgTargetRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysMsgTarget);
                this.sysMsgTargetRuntimeMap.put(iPSSysMsgTarget.getDynaModelFilePath(), iSysMsgTargetRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u606f\u76ee\u6807[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgTarget.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d88\u606f\u76ee\u6807[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysMsgTarget.getName(), ex.getMessage()), ex);
            }
        }
        return iSysMsgTargetRuntime;
    }

    @Override
    public IPSSysLogic getPSSysLogic(String strName) {
        return this.psSysLogicMap.get(strName.toUpperCase());
    }

    @Override
    public ISysLogicRuntime getSysLogicRuntime(IPSSysLogic iPSSysLogic) {
        Assert.notNull((Object)iPSSysLogic, (String)"\u4f20\u5165\u7cfb\u7edf\u9884\u7f6e\u903b\u8f91\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysLogicRuntime iSysLogicRuntime = this.sysLogicRuntimeMap.get(iPSSysLogic.getDynaModelFilePath());
        if (iSysLogicRuntime == null) {
            iSysLogicRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysLogicRuntime(iPSSysLogic);
            try {
                iSysLogicRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysLogic);
                this.sysLogicRuntimeMap.put(iPSSysLogic.getDynaModelFilePath(), iSysLogicRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u903b\u8f91[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysLogic.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u903b\u8f91[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysLogic.getName(), ex.getMessage()), ex);
            }
        }
        return iSysLogicRuntime;
    }

    @Override
    public IPSWFRole getPSWFRole(String strName) {
        return this.psWFRoleMap.get(strName.toUpperCase());
    }

    @Override
    public IWFRoleRuntime getWFRoleRuntime(IPSWFRole iPSWFRole) {
        Assert.notNull((Object)iPSWFRole, (String)"\u4f20\u5165\u7cfb\u7edf\u5de5\u4f5c\u6d41\u89d2\u8272\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        IWFRoleRuntime iWFRoleRuntime = this.wfRoleRuntimeMap.get(iPSWFRole.getDynaModelFilePath());
        if (iWFRoleRuntime == null) {
            iWFRoleRuntime = this.getSystemRuntimeContext().getSystemRuntime().createWFRoleRuntime(iPSWFRole);
            try {
                iWFRoleRuntime.init(this.getSystemRuntimeBaseContext(), iPSWFRole);
                this.wfRoleRuntimeMap.put(iPSWFRole.getDynaModelFilePath(), iWFRoleRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u89d2\u8272[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSWFRole.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u89d2\u8272[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSWFRole.getName(), ex.getMessage()), ex);
            }
        }
        return iWFRoleRuntime;
    }

    @Override
    public ISysDTSQueueRuntime getSysDTSQueueRuntime(IPSSysDTSQueue iPSSysDTSQueue) {
        Assert.notNull((Object)iPSSysDTSQueue, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u5f02\u6b65\u5904\u7406\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysDTSQueueRuntime iSysDTSQueueRuntime = this.sysDTSQueueRuntimeMap.get(iPSSysDTSQueue.getDynaModelFilePath());
        if (iSysDTSQueueRuntime == null) {
            iSysDTSQueueRuntime = this.getSystemRuntimeContext().getSystemRuntime().createSysDTSQueueRuntime(iPSSysDTSQueue);
            try {
                iSysDTSQueueRuntime.init(this.getSystemRuntimeBaseContext(), iPSSysDTSQueue);
                this.sysDTSQueueRuntimeMap.put(iPSSysDTSQueue.getDynaModelFilePath(), iSysDTSQueueRuntime);
                this.sysDTSQueueRuntimeList.add(iSysDTSQueueRuntime);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u5f02\u6b65\u5904\u7406\u961f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDTSQueue.getName(), ex.getMessage()), (Throwable)ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u5f02\u6b65\u5904\u7406\u961f\u5217[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDTSQueue.getName(), ex.getMessage()), ex);
            }
        }
        return iSysDTSQueueRuntime;
    }

    @Override
    public Collection<ISysDTSQueueRuntime> getSysDTSQueueRuntimes() {
        if (ObjectUtils.isEmpty(this.sysDTSQueueRuntimeList)) {
            return null;
        }
        return this.sysDTSQueueRuntimeList;
    }

    @Override
    public Object getGlobalParam(String strKey) {
        return this.globalParamMap.get(strKey);
    }

    @Override
    public void setGlobalParam(String strKey, Object objValue) {
        this.globalParamMap.put(strKey, objValue);
    }

    protected boolean isEnableWFRuntime() {
        return false;
    }

    protected void onBeforeStart() throws Exception {
    }

    protected void onStart() throws Exception {
    }

    protected void onAfterStart() throws Exception {
    }

    protected void onLoad() throws Exception {
    }

    protected void onShutdown() throws Exception {
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysValueRuleRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysSequenceRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysTranslatorRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.codeListRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysDataSyncAgentRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysMsgQueueRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysMsgTemplRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysMsgTargetRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysLogicRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.wfRoleRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysDTSQueueRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysValueRuleRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntime(this.iSysNotifyAgentRuntime);
    }
}

