/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSDynaInst;
import net.ibizsys.model.IPSDynaInstService;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.IDynaInstRuntimeContext;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.SystemRuntimeBaseBase;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DynaInstRuntime
extends SystemRuntimeBaseBase
implements IDynaInstRuntime {
    private static final Log log = LogFactory.getLog(DynaInstRuntime.class);
    private IPSDynaInstService iPSDynaInstService = null;
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private long nLastActiveTime = 0L;
    private long nLastCheckTime = 0L;
    private IPSSystem iPSSystem = null;
    private Map<String, IDynaInstDataEntityRuntime> dataEntityMap = new HashMap<String, IDynaInstDataEntityRuntime>();
    private long nLoadedTime = 0L;
    private String strInstallTag = null;
    private IDynaInstRuntimeContext iDynaInstRuntimeContext = new IDynaInstRuntimeContext(){

        @Override
        public IDynaInstRuntime getSystemRuntime() {
            return DynaInstRuntime.this.getSelf();
        }

        @Override
        public IPSSystemService getPSSystemService() {
            return DynaInstRuntime.this.getSelf().getPSDynaInstService();
        }
    };

    @Override
    public void init(IPSDynaInstService iPSDynaInstService, ISystemRuntimeContext iSystemRuntimeContext) throws Exception {
        this.iPSDynaInstService = iPSDynaInstService;
        this.iSystemRuntimeContext = iSystemRuntimeContext;
        this.nLoadedTime = System.currentTimeMillis();
        this.iPSSystem = this.getPSDynaInstService().getPSSystem();
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        JsonNode jsonNode;
        if (this.iPSSystem.getObjectNode() != null && (jsonNode = this.iPSSystem.getObjectNode().get("preloadDEs")) != null && jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                String strDEId = arrayNode.get(i).asText();
                if (!StringUtils.hasLength((String)strDEId)) continue;
                log.debug((Object)String.format("\u52a8\u6001\u5b9e\u4f8b[%1$s]\u9884\u8f7d\u5b9e\u4f53\u8fd0\u884c\u65f6[%2$s]", this.getId(), strDEId));
                this.getDynaInstDataEntityRuntime(strDEId);
            }
        }
        super.onInit();
    }

    private DynaInstRuntime getSelf() {
        return this;
    }

    protected IDynaInstRuntimeContext getDynaInstRuntimeContext() {
        return this.iDynaInstRuntimeContext;
    }

    @Override
    protected ISystemRuntimeBaseContext getSystemRuntimeBaseContext() {
        return this.getDynaInstRuntimeContext();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime(String strIdOrName) {
        IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = this.dataEntityMap.get(strIdOrName);
        if (iDynaInstDataEntityRuntime == null) {
            IDynaInstDataEntityRuntime iDynaInstDataEntityRuntimeLast;
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(strIdOrName);
            if (iDataEntityRuntime != null) {
                iDynaInstDataEntityRuntime = iDataEntityRuntime.createDynaInstDataEntityRuntime(this);
            }
            if ((iDynaInstDataEntityRuntimeLast = this.dataEntityMap.get(strIdOrName)) != null) {
                return iDynaInstDataEntityRuntimeLast;
            }
            this.dataEntityMap.put(strIdOrName, iDynaInstDataEntityRuntime);
        }
        return iDynaInstDataEntityRuntime;
    }

    @Override
    public IPSDynaInstService getPSDynaInstService() {
        return this.iPSDynaInstService;
    }

    @Override
    public IPSSystemService getPSSystemService() {
        return this.getPSDynaInstService();
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public IPSSystem getPSSystem() {
        return this.iPSSystem;
    }

    @Override
    public void active() {
        this.nLastActiveTime = System.currentTimeMillis();
    }

    @Override
    public long getLastActiveTime() {
        return this.nLastActiveTime;
    }

    @Override
    public String getChildDynaInstId(String strDynaInstTag, String strDynaInstTag2) {
        IPSDynaInst iPSDynaInst = this.getPSDynaInstService().getChildPSDynaInst(strDynaInstTag, strDynaInstTag2);
        return iPSDynaInst == null ? null : iPSDynaInst.getId();
    }

    @Override
    public String getDynaInstFolderPath() {
        return this.getPSDynaInstService().getPSModelFolderPath();
    }

    @Override
    public String getId() {
        return this.iPSDynaInstService.getPSDynaInstId();
    }

    @Override
    public String getName() {
        return "\u672a\u77e5";
    }

    @Override
    public long getLastCheckTime() {
        return this.nLastCheckTime;
    }

    @Override
    public void markChecked() {
        this.nLastCheckTime = System.currentTimeMillis();
    }

    @Override
    public long getLoadedTime() {
        return this.nLoadedTime;
    }

    @Override
    public boolean check() {
        String strCurTag = this.getPSDynaInstService().getInstallTag();
        if (StringUtils.hasLength((String)strCurTag)) {
            if (StringUtils.hasLength((String)this.strInstallTag)) {
                return this.strInstallTag.equals(strCurTag);
            }
            this.strInstallTag = strCurTag;
        }
        return true;
    }

    @Override
    public int getDynaInstMode() {
        return this.getPSDynaInstService().getDynaInstMode();
    }

    @Override
    public ISysLogicRuntime getSysLogicRuntime(IPSSysLogic iPSSysLogic) {
        return super.getSysLogicRuntime(iPSSysLogic);
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSystem();
    }

    @Override
    public ICodeListRuntime getCodeListRuntime(IPSCodeList iPSCodeList) {
        return this.getSystemRuntimeContext().getSystemRuntime().getCodeListRuntime(iPSCodeList);
    }
}

