/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.testing;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.testing.ISysTestCaseRuntime;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.central.testing.TestRollbackException;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.PropertiesUtils;
import net.ibizsys.runtime.util.script.IScriptEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysTestCaseRuntimeBase
extends SystemModelRuntimeBase
implements ISysTestCaseRuntime {
    private static final Log log = LogFactory.getLog(SysTestCaseRuntimeBase.class);
    private Map<String, Map<String, Object>> inputDataMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Invocable> inputCodeMap = new HashMap<String, Invocable>();
    private Map<String, Map<String, Object>> assertDataMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Invocable> assertCodeMap = new HashMap<String, Invocable>();
    private IPSSysTestCase iPSSysTestCase = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysTestCase iPSSysTestCase) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysTestCase = iPSSysTestCase;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psSysTestCaseAssertList;
        List psSysTestCaseInputList = this.getPSSysTestCase().getPSSysTestCaseInputs();
        if (!ObjectUtils.isEmpty((Object)psSysTestCaseInputList)) {
            for (IPSSysTestCaseInput iPSSysTestCaseInput : psSysTestCaseInputList) {
                String strType = iPSSysTestCaseInput.getInputType();
                if (!StringUtils.hasLength((String)strType)) {
                    strType = "DATA";
                }
                this.inputDataMap.put(iPSSysTestCaseInput.getName(), this.prepareDataMode(iPSSysTestCaseInput.getInputValue()));
                if (!"CUSTOMCODE".equals(strType)) continue;
                this.inputCodeMap.put(iPSSysTestCaseInput.getName(), this.prepareCodeMode(iPSSysTestCaseInput.getScriptCode()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psSysTestCaseAssertList = this.getPSSysTestCase().getPSSysTestCaseAsserts()))) {
            for (IPSSysTestCaseAssert iPSSysTestCaseAssert : psSysTestCaseAssertList) {
                String strType = iPSSysTestCaseAssert.getAssertType();
                if (!StringUtils.hasLength((String)strType)) {
                    strType = "RESULT";
                }
                if ("RESULT".equals(strType)) {
                    this.assertDataMap.put(iPSSysTestCaseAssert.getName(), this.prepareDataMode(iPSSysTestCaseAssert.getAssertValue()));
                    continue;
                }
                if (!"CUSTOMCODE".equals(strType)) continue;
                this.assertCodeMap.put(iPSSysTestCaseAssert.getName(), this.prepareCodeMode(iPSSysTestCaseAssert.getScriptCode()));
            }
        }
        super.onInit();
    }

    protected Map<String, Object> prepareDataMode(String strData) throws Exception {
        if (!StringUtils.hasLength((String)strData)) {
            return null;
        }
        if (!StringUtils.hasLength((String)(strData = strData.toString()))) {
            return null;
        }
        if (strData.indexOf("{") == 0) {
            ObjectNode objectNode = JsonUtils.toObjectNode(strData);
            return (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        }
        Properties properties = PropertiesUtils.load(strData);
        if (properties != null) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (Object objKey : properties.keySet()) {
                String strName = (String)objKey;
                data.put(strName, PropertiesUtils.getProperty(properties, strName));
            }
            return data;
        }
        return null;
    }

    protected Invocable prepareCodeMode(String strCustomCode) throws Exception {
        if (!StringUtils.hasLength((String)strCustomCode)) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u6ca1\u6709\u6307\u5b9a\u811a\u672c\u4ee3\u7801", new Object[0]));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String strJSCode = "function main(";
        strJSCode = strJSCode + "sys,entity";
        strJSCode = strJSCode + "){";
        strJSCode = strJSCode + strCustomCode;
        strJSCode = strJSCode + "}";
        engine.eval(strJSCode);
        return (Invocable)((Object)engine);
    }

    protected Map<String, Object> getInputDataMap(String strName) {
        return this.inputDataMap.get(strName);
    }

    protected Map<String, Object> getAssertDataMap(String strName) {
        return this.assertDataMap.get(strName);
    }

    protected Invocable getInputInvocable(String strName) {
        return this.inputCodeMap.get(strName);
    }

    protected Invocable getAssertInvocable(String strName) {
        return this.assertCodeMap.get(strName);
    }

    public IPSSysTestCase getPSSysTestCase() {
        return this.iPSSysTestCase;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysTestCase();
    }

    protected Object invokeInputScript(String strName, IScriptEntity iScriptEntity) {
        try {
            Invocable invocable = this.inputCodeMap.get(strName);
            if (invocable == null) {
                throw new Exception("\u811a\u672c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            return invocable.invokeFunction("main", this.getSystemRuntime().getSystemRTScriptContext(), iScriptEntity);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            log.error((Object)ex);
            this.getSystemRuntime().log(40000, "SCRIPT", String.format("\u6267\u884c\u8f93\u5165\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), String.format("\u6267\u884c\u8f93\u5165\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u6267\u884c\u8f93\u5165\u811a\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected Object invokeAssertScript(String strName, IScriptEntity iScriptEntity) {
        try {
            Invocable invocable = this.assertCodeMap.get(strName);
            if (invocable == null) {
                throw new Exception("\u811a\u672c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            return invocable.invokeFunction("main", this.getSystemRuntime().getSystemRTScriptContext(), iScriptEntity);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            log.error((Object)ex);
            this.getSystemRuntime().log(40000, "SCRIPT", String.format("\u6267\u884c\u65ad\u8a00\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), String.format("\u6267\u884c\u65ad\u8a00\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u6267\u884c\u65ad\u8a00\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public TestCaseRunResult run() {
        try {
            TestCaseRunResult testCaseRunResult = this.onRun();
            this.fillTestCaseInfo(testCaseRunResult);
            return testCaseRunResult;
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u6267\u884c\u7cfb\u7edf\u6d4b\u8bd5\u7528\u4f8b[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            TestCaseRunResult testCaseRunResult = new TestCaseRunResult();
            testCaseRunResult.setStatus("FAILURE");
            testCaseRunResult.setActualResult(ex.getMessage());
            this.fillTestCaseInfo(testCaseRunResult);
            return testCaseRunResult;
        }
    }

    protected void fillTestCaseInfo(TestCaseRunResult testCaseRunResult) {
        testCaseRunResult.setType(this.getPSSysTestCase().getTestCaseType());
        testCaseRunResult.setTestCaseTag(this.getPSSysTestCase().getCodeName());
    }

    protected TestCaseRunResult onRun() throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected boolean isTestRollbackException(Throwable ex) {
        if (ex instanceof TestRollbackException) {
            return true;
        }
        if (ex.getCause() != null) {
            return this.isTestRollbackException(ex.getCause());
        }
        return false;
    }

    protected boolean testResult(IEntity iEntity, IPSSysTestCaseAssert iPSSysTestCaseAssert) {
        return true;
    }

    protected boolean testException(Throwable ex, IPSSysTestCaseAssert iPSSysTestCaseAssert) {
        return true;
    }
}

