/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.sysutil;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.central.ISystemLogListener;
import net.ibizsys.central.sysutil.SysUtilRuntimeBase;
import net.ibizsys.runtime.util.ObjectNodeUtils;
import net.ibizsys.runtime.util.domain.Log;
import org.apache.commons.logging.LogFactory;

public class SysLogListenerUtilRuntime
extends SysUtilRuntimeBase
implements ISystemLogListener {
    private static final org.apache.commons.logging.Log logger = LogFactory.getLog(SysLogListenerUtilRuntime.class);
    private String strTopic = null;
    private String strEventTopic = null;
    private String strAuditTopic = null;
    private String strPOTopic = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getOutSysEAIAgentRuntime() == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u8f93\u51fa\u7cfb\u7edf\u5e94\u7528\u96c6\u6210\u4ee3\u7406\u5bf9\u8c61", new Object[0]));
        }
        super.onInit();
        ObjectNode utilParams = this.getPSSysUtil().getUtilParams();
        if (utilParams != null) {
            this.setDefaultTopic(ObjectNodeUtils.getFieldValue(utilParams, "topic", null));
            this.setEventTopic(ObjectNodeUtils.getFieldValue(utilParams, "topic.event", null));
            this.setAuditTopic(ObjectNodeUtils.getFieldValue(utilParams, "topic.audit", null));
            this.setPOTopic(ObjectNodeUtils.getFieldValue(utilParams, "topic.po", null));
        }
        this.getSystemRuntime().registerSystemLogListener(this);
    }

    protected String getDefaultTopic() {
        return this.strTopic;
    }

    protected void setDefaultTopic(String strTopic) {
        this.strTopic = strTopic;
    }

    protected String getEventTopic() {
        return this.strEventTopic;
    }

    protected void setEventTopic(String strEventTopic) {
        this.strEventTopic = strEventTopic;
    }

    protected String getAuditTopic() {
        return this.strAuditTopic;
    }

    protected void setAuditTopic(String strAuditTopic) {
        this.strAuditTopic = strAuditTopic;
    }

    protected String getPOTopic() {
        return this.strPOTopic;
    }

    protected void setPOTopic(String strPOTopic) {
        this.strPOTopic = strPOTopic;
    }

    protected String getTopic(Log log) {
        if ("EVENT".equals(log.getLogType())) {
            return this.getEventTopic();
        }
        if ("AUDIT".equals(log.getLogType())) {
            return this.getAuditTopic();
        }
        if ("PO".equals(log.getLogType())) {
            return this.getPOTopic();
        }
        return this.getDefaultTopic();
    }

    @Override
    public void log(Log log) {
        this.onLog(log);
    }

    protected void onLog(Log log) {
        String strTopic = this.getTopic(log);
        if (strTopic != null && strTopic.length() == 0) {
            return;
        }
        String strData = (String)this.getSystemRuntime().serialize(log);
        try {
            this.getOutSysEAIAgentRuntime().send(strTopic, strData);
        }
        catch (Throwable ex) {
            logger.error((Object)String.format("\u8f93\u51fa\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }
}

