/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.sysutil;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.res.ISysFileResourceRuntime;
import net.ibizsys.central.res.ISysResourceRuntime;
import net.ibizsys.central.res.ISysSCMResourceRuntime;
import net.ibizsys.central.sysutil.ISysCodeGenUtilRuntime;
import net.ibizsys.central.sysutil.ISysCodeGenUtilRuntimeContext;
import net.ibizsys.central.sysutil.SysUtilRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysCodeGenUtilRuntimeBase
extends SysUtilRuntimeBase
implements ISysCodeGenUtilRuntime {
    private static final Log log = LogFactory.getLog(SysCodeGenUtilRuntimeBase.class);
    private ThreadLocal<String> templatePathThreadLocal = new ThreadLocal();
    private boolean bTemplateFromResource = true;
    private Map<String, String> templateAliasMap = new HashMap<String, String>();
    private Map<String, Object> params = new HashMap<String, Object>();
    private String strDefautTemplatePath = null;
    private ISysFileResourceRuntime templSysFileResourceRuntime = null;
    private ISysFileResourceRuntime codeSysFileResourceRuntime = null;
    private ISysCodeGenUtilRuntimeContext iSysCodeGenUtilRuntimeContext = new ISysCodeGenUtilRuntimeContext(){

        @Override
        public String output(Object data, String strTemplateId) throws Throwable {
            return this.output(data, strTemplateId, null);
        }

        @Override
        public String output(Object data, String strTemplateId, String strIndent) throws Throwable {
            String strContent = SysCodeGenUtilRuntimeBase.this.getContent(data, strTemplateId, null);
            if (!StringUtils.hasLength((String)strContent) || !StringUtils.hasLength((String)strIndent)) {
                return strContent;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String[] lines = strContent.replace("\r\n", "\n").replace("\r", "\n").split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(strIndent);
                if (!StringUtils.hasLength((String)lines[i])) continue;
                stringBuilder.append(lines[i]);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean contains(String strTemplateId) {
            try {
                return StringUtils.hasLength((String)SysCodeGenUtilRuntimeBase.this.getTemplateContent(strTemplateId, true));
            }
            catch (Exception ex) {
                return false;
            }
        }
    };

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.prepareTemplate();
        this.prepareOutput();
    }

    protected void prepareTemplate() throws Exception {
        if (this.getPSSysUtil().getPSSysResource() == null) {
            log.warn((Object)String.format("\u4ee3\u7801\u751f\u6210\u7ec4\u4ef6[%1$s]\u672a\u6307\u5b9a\u6a21\u677f\u8d44\u6e90", this.getName()));
            return;
        }
        ISysResourceRuntime iSysResourceRuntime = this.getSystemRuntime().getSysResourceRuntime(this.getPSSysUtil().getPSSysResource());
        if (iSysResourceRuntime instanceof ISysFileResourceRuntime) {
            this.setTemplateFromResource(false);
            this.setTemplSysFileResourceRuntime((ISysFileResourceRuntime)iSysResourceRuntime);
        }
    }

    protected void prepareOutput() throws Exception {
        if (this.getPSSysUtil().getOutPSSysResource() == null) {
            log.warn((Object)String.format("\u4ee3\u7801\u751f\u6210\u7ec4\u4ef6[%1$s]\u672a\u6307\u5b9a\u4ee3\u7801\u8f93\u51fa\u8d44\u6e90", this.getName()));
            return;
        }
        ISysResourceRuntime iSysResourceRuntime = this.getSystemRuntime().getSysResourceRuntime(this.getPSSysUtil().getOutPSSysResource());
        if (iSysResourceRuntime instanceof ISysFileResourceRuntime) {
            this.setCodeSysFileResourceRuntime((ISysFileResourceRuntime)iSysResourceRuntime);
        }
    }

    @Override
    protected Object onExecuteAction(String strActionName, Object[] args) throws Throwable {
        if ("GENERATE".equalsIgnoreCase(strActionName)) {
            if (args != null && args.length > 0) {
                Object target = args[0];
                Map params = null;
                if (args.length >= 2 && args[1] instanceof Map) {
                    params = (Map)args[1];
                }
                this.generate(target, params);
            } else {
                this.generate(null, null);
            }
            return null;
        }
        return super.onExecuteAction(strActionName, args);
    }

    @Override
    public void generate(final Object target, final Map<String, Object> params) {
        this.executeAction("\u751f\u6210\u4ee3\u7801", new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                SysCodeGenUtilRuntimeBase.this.onGenerate(target, params);
                return null;
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onGenerate(Object target, Map<String, Object> params) throws Throwable {
        String strDstPath = null;
        if (params != null) {
            strDstPath = (String)params.get("dstpath");
        }
        String strLastTemplatePath = this.getTemplatePath();
        try {
            ISysFileResourceRuntime templSysFileResourceRuntime = this.getTemplSysFileResourceRuntime(true);
            if (templSysFileResourceRuntime != null) {
                this.setTemplatePath(templSysFileResourceRuntime.getFile(target).getCanonicalPath());
            } else {
                this.setTemplatePath(this.getDefautTemplatePath());
            }
            if (StringUtils.hasLength((String)strDstPath)) {
                this.doGenerate(target, strDstPath, params);
            } else {
                ISysFileResourceRuntime codeSysFileResourceRuntime = this.getCodeSysFileResourceRuntime(false);
                if (codeSysFileResourceRuntime instanceof ISysSCMResourceRuntime) {
                    ISysSCMResourceRuntime iSysSCMResourceRuntime = (ISysSCMResourceRuntime)codeSysFileResourceRuntime;
                    iSysSCMResourceRuntime.checkout(target);
                    this.doGenerate(target, codeSysFileResourceRuntime.getFile(target).getCanonicalPath(), params);
                    iSysSCMResourceRuntime.checkin(target);
                } else {
                    this.doGenerate(target, codeSysFileResourceRuntime.getFile(target).getCanonicalPath(), params);
                }
            }
        }
        finally {
            this.setTemplatePath(strLastTemplatePath);
        }
    }

    protected void doGenerate(Object data, String strDstPath, Map<String, Object> params) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected String getTemplatePath() {
        return this.templatePathThreadLocal.get();
    }

    protected void setTemplatePath(String strTemplatePath) {
        this.templatePathThreadLocal.set(strTemplatePath);
    }

    public boolean isTemplateFromResource() {
        return this.bTemplateFromResource;
    }

    protected void setTemplateFromResource(boolean bTemplateFromResource) {
        this.bTemplateFromResource = bTemplateFromResource;
    }

    public String getDefautTemplatePath() {
        return this.strDefautTemplatePath;
    }

    protected void setDefautTemplatePath(String strDefautTemplatePath) {
        this.strDefautTemplatePath = strDefautTemplatePath;
    }

    protected Map<String, Object> getTemplateParams() {
        return this.params;
    }

    protected void setTemplateParams(Map<String, Object> params) {
        this.params.clear();
        if (!ObjectUtils.isEmpty(params)) {
            this.params.putAll(params);
        }
    }

    protected ISysCodeGenUtilRuntimeContext getContext() {
        return this.iSysCodeGenUtilRuntimeContext;
    }

    protected void registerTemplateAlias(String strAlias, String strTemplateId) {
        this.templateAliasMap.put(strAlias, strTemplateId);
    }

    protected boolean unregisterTemplateAlias(String strAlias, String strTemplateId) {
        return this.templateAliasMap.remove(strAlias, strTemplateId);
    }

    protected String getRealTemplateId(String strTemplateId) {
        String strRealTemplateId = this.templateAliasMap.get(strTemplateId);
        if (StringUtils.hasLength((String)strRealTemplateId)) {
            return strRealTemplateId;
        }
        return strTemplateId;
    }

    protected String getTemplateContent(String strTemplateId, boolean bTryMode) throws Exception {
        String strRealTemplateId = this.getRealTemplateId(strTemplateId);
        if (!StringUtils.hasLength((String)strRealTemplateId)) {
            throw new Exception(String.format("\u4f20\u5165\u6a21\u677f\u6807\u8bc6[%1$s]\u65e0\u6548", strTemplateId));
        }
        if (this.isTemplateFromResource()) {
            String strFullModelPath = this.getTemplatePath() + strRealTemplateId.replace("\\", "/");
            InputStream is = this.getClass().getResourceAsStream(strFullModelPath);
            if (is != null) {
                return IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            if (bTryMode) {
                return null;
            }
        } else {
            String strFullModelPath = this.getTemplatePath() + strRealTemplateId;
            File file = new File(strFullModelPath);
            if (file.exists()) {
                return FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            if (bTryMode) {
                return null;
            }
        }
        throw new Exception(String.format("\u6307\u5b9a\u6a21\u677f[%1$s]\u4e0d\u5b58\u5728", strTemplateId));
    }

    protected void output(Object target, String strOutputPath, Object[] filters, Map<String, Object> fileMap, boolean bIgnoreException) throws Throwable {
        this.onOutput(target, strOutputPath, filters, fileMap, bIgnoreException);
    }

    protected void onOutput(Object target, String strOutputPath, Object[] filters, Map<String, Object> fileMap, boolean bIgnoreException) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected void output(Object data, Map<String, String> outputMap, Map<String, Object> params, Map<String, Object> fileMap, boolean bIgnoreException) throws Throwable {
        for (Map.Entry<String, String> entry : outputMap.entrySet()) {
            this.output(data, entry.getKey(), params, entry.getValue(), fileMap, bIgnoreException);
        }
    }

    protected boolean output(Object data, String strTemplateId, Map<String, Object> params, String strDestFilePath, Map<String, Object> fileMap, boolean bIgnoreException) throws Throwable {
        String strLastContent;
        String strContent = null;
        try {
            strContent = this.getContent(data, strTemplateId, params);
        }
        catch (Exception ex) {
            if (!bIgnoreException) {
                throw ex;
            }
            strContent = ex.getMessage();
        }
        File file = new File(strDestFilePath);
        if (StringUtils.hasLength((String)strContent) && file.exists() && strContent.equals(strLastContent = FileUtils.readFileToString((File)file, (String)"UTF-8"))) {
            if (fileMap != null) {
                fileMap.put(strDestFilePath, data);
            }
            return false;
        }
        FileUtils.writeStringToFile((File)file, (String)strContent, (String)"UTF-8", (boolean)false);
        log.debug((Object)String.format("\u5199\u5165[%1$s]\u6a21\u677f[%2$s]", strDestFilePath, strTemplateId));
        if (fileMap != null) {
            fileMap.put(strDestFilePath, data);
        }
        return true;
    }

    protected boolean outputRaw(Object data, String strContent, String strDestFilePath, Map<String, Object> fileMap) throws Throwable {
        String strLastContent;
        File file = new File(strDestFilePath);
        if (StringUtils.hasLength((String)strContent) && file.exists() && strContent.equals(strLastContent = FileUtils.readFileToString((File)file, (String)"UTF-8"))) {
            if (fileMap != null) {
                fileMap.put(strDestFilePath, data);
            }
            return false;
        }
        FileUtils.writeStringToFile((File)file, (String)strContent, (String)"UTF-8", (boolean)false);
        if (fileMap != null) {
            fileMap.put(strDestFilePath, data);
        }
        return true;
    }

    protected String getContent(Object data, String strTemplateId, Map<String, Object> params) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public ISysFileResourceRuntime getTemplSysFileResourceRuntime(boolean bTryMode) {
        if (this.templSysFileResourceRuntime != null || bTryMode) {
            return this.templSysFileResourceRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this, String.format("\u672a\u6307\u5b9a\u6a21\u677f\u7cfb\u7edf\u6587\u4ef6\u8d44\u6e90\u8fd0\u884c\u65f6\u5bf9\u8c61", new Object[0]));
    }

    @Override
    public ISysFileResourceRuntime getCodeSysFileResourceRuntime(boolean bTryMode) {
        if (this.codeSysFileResourceRuntime != null || bTryMode) {
            return this.codeSysFileResourceRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this, String.format("\u672a\u6307\u5b9a\u8f93\u51fa\u4ee3\u7801\u7cfb\u7edf\u6587\u4ef6\u8d44\u6e90\u8fd0\u884c\u65f6\u5bf9\u8c61", new Object[0]));
    }

    protected void setTemplSysFileResourceRuntime(ISysFileResourceRuntime templSysFileResourceRuntime) {
        this.templSysFileResourceRuntime = templSysFileResourceRuntime;
    }

    protected void setCodeSysFileResourceRuntime(ISysFileResourceRuntime codeSysFileResourceRuntime) {
        this.codeSysFileResourceRuntime = codeSysFileResourceRuntime;
    }

    protected boolean copyDir(String strTemplateId, String strDestDirPath) throws Throwable {
        String strRealTemplateId = this.getRealTemplateId(strTemplateId);
        if (!StringUtils.hasLength((String)strRealTemplateId)) {
            throw new Exception(String.format("\u4f20\u5165\u6a21\u677f\u6807\u8bc6[%1$s]\u65e0\u6548", strTemplateId));
        }
        if (this.isTemplateFromResource()) {
            String strFullModelPath = this.getTemplatePath() + strRealTemplateId.replace("\\", "/");
            throw new Exception("\u4e0d\u652f\u6301");
        }
        String strSrcDirPath = this.getTemplatePath() + strRealTemplateId;
        return this.copyDirRaw(strSrcDirPath, strDestDirPath);
    }

    protected boolean copyDirRaw(String strSrcDirPath, String strDestDirPath) throws Throwable {
        FileUtils.copyDirectory((File)new File(strSrcDirPath), (File)new File(strDestDirPath));
        return true;
    }

    protected boolean copyFile(String strTemplateId, String strDestFilePath) throws Throwable {
        String strRealTemplateId = this.getRealTemplateId(strTemplateId);
        if (!StringUtils.hasLength((String)strRealTemplateId)) {
            throw new Exception(String.format("\u4f20\u5165\u6a21\u677f\u6807\u8bc6[%1$s]\u65e0\u6548", strTemplateId));
        }
        if (this.isTemplateFromResource()) {
            String strFullModelPath = this.getTemplatePath() + strRealTemplateId.replace("\\", "/");
            throw new Exception("\u4e0d\u652f\u6301");
        }
        String strSrcFilePath = this.getTemplatePath() + strRealTemplateId;
        return this.copyFileRaw(strSrcFilePath, strDestFilePath);
    }

    protected boolean copyFileRaw(String strSrcFilePath, String strDestFilePath) throws Throwable {
        FileUtils.copyFile((File)new File(strSrcFilePath), (File)new File(strDestFilePath));
        return true;
    }
}

