/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.system;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.der.IDERRuntime;
import net.ibizsys.central.system.ISystemModuleUtilRuntime;
import net.ibizsys.central.system.SystemModuleRuntime;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.dataentity.action.IDEActionRuntime;
import net.ibizsys.runtime.dataentity.dataexport.IDEDataExportRuntime;
import net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.runtime.dataentity.ds.IDEDataSetRuntime;
import net.ibizsys.runtime.dataentity.logic.IDELogicRuntime;
import net.ibizsys.runtime.dataentity.logic.IDEMSLogicRuntime;
import net.ibizsys.runtime.dataentity.notify.IDENotifyRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class SystemModuleUtilRuntimeBase
extends SystemModuleRuntime
implements ISystemModuleUtilRuntime {
    private static final Log log = LogFactory.getLog(SystemModuleUtilRuntimeBase.class);
    private IPSSystemService iPSSystemService = null;
    private ISystemPersistentAdapter iSystemPersistentAdapter = null;
    private Map<String, Object> utilParamMap = new HashMap<String, Object>();
    private boolean bInstalled = false;

    public void init(IPSSystemService iPSSystemService, IPSSystemModule iPSSystemModule) throws Exception {
        this.iPSSystemService = iPSSystemService;
        this.setPSSystemModule(iPSSystemModule);
        this.onInit();
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
    }

    @Override
    public synchronized void uninstall() {
        try {
            if (this.bInstalled) {
                this.onUninstall();
                this.bInstalled = false;
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u6a21\u5757\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getClass().getName(), String.format("\u5378\u8f7d\u6a21\u5757\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
        }
    }

    protected void onUninstall() throws Throwable {
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public IPSSystemService getPSSystemService() {
        if (this.iPSSystemService != null) {
            return this.iPSSystemService;
        }
        return super.getPSSystemService();
    }

    @Override
    public ISystemPersistentAdapter getSystemPersistentAdapter(IPSDataEntity iPSDataEntity) throws Exception {
        if (this.getSystemPersistentAdapter() != null) {
            return this.getSystemPersistentAdapter();
        }
        return this.getSystemRuntimeContext().getSystemPersistentAdapter(iPSDataEntity);
    }

    protected void setSystemPersistentAdapter(ISystemPersistentAdapter iSystemPersistentAdapter) {
        this.iSystemPersistentAdapter = iSystemPersistentAdapter;
    }

    public ISystemPersistentAdapter getSystemPersistentAdapter() {
        return this.iSystemPersistentAdapter;
    }

    @Override
    public int getStorageMode(IPSDataEntity iPSDataEntity) {
        return this.getSystemRuntimeContext().getStorageMode(iPSDataEntity);
    }

    @Override
    public IDataEntityRuntime createDataEntityRuntime(IPSDataEntity iPSDataEntity) {
        return null;
    }

    @Override
    public IDELogicRuntime createDELogicRuntime(IPSDELogic iPSDELogic) {
        return null;
    }

    @Override
    public IDEMSLogicRuntime createDEMSLogicRuntime(IPSDEMSLogic iPSDEMSLogic) {
        return null;
    }

    @Override
    public IDEDataSetRuntime createDEDataSetRuntime(IPSDEDataSet iPSDEDataSet) {
        return null;
    }

    @Override
    public IDEActionRuntime createDEActionRuntime(IPSDEAction iPSDEAction) {
        return null;
    }

    @Override
    public IDEDataImportRuntime createDEDataImportRuntime(IPSDEDataImport iPSDEDataImport) {
        return null;
    }

    @Override
    public IDEDataExportRuntime createDEDataExportRuntime(IPSDEDataExport iPSDEDataExport) {
        return null;
    }

    @Override
    public IDENotifyRuntime createDENotifyRuntime(IPSDENotify iPSDENotify) {
        return null;
    }

    @Override
    public IDERRuntime createDERRuntime(IPSDERBase iPSDERBase) {
        return null;
    }

    @Override
    public void setUtilParam(String strName, Object objValue) {
        Assert.hasLength((String)strName, (String)"\u4f20\u5165\u529f\u80fd\u53c2\u6570\u540d\u79f0\u65e0\u6548");
        this.utilParamMap.put(strName.toUpperCase(), objValue);
    }

    @Override
    public Object getUtilParam(String strName) {
        Assert.hasLength((String)strName, (String)"\u4f20\u5165\u529f\u80fd\u53c2\u6570\u540d\u79f0\u65e0\u6548");
        return this.utilParamMap.get(strName.toUpperCase());
    }

    public String getUtilParam(String strName, String strDefault) {
        Object objValue = this.getUtilParam(strName);
        if (objValue == null) {
            return strDefault;
        }
        return String.valueOf(objValue);
    }
}

