/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.system;

import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.system.ISysRefRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.system.IPSSysRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysRefRuntimeBase
extends SystemModelRuntimeBase
implements ISysRefRuntime {
    private static final Log log = LogFactory.getLog(SysRefRuntimeBase.class);
    private IPSSysRef iPSSysRef = null;
    private boolean bInstalled = false;

    public static String getConfigFolder(IPSSysRef iPSSysRef) {
        return "sysref." + PSModelUtils.calcUniqueTag((String)iPSSysRef.getSysRefTag());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysRef iPSSysRef) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysRef = iPSSysRef;
        this.setConfigFolder(SysRefRuntimeBase.getConfigFolder(iPSSysRef));
        this.onInit();
    }

    @Override
    public IPSSysRef getPSSysRef() {
        return this.iPSSysRef;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysRef();
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public void uninstall() {
        try {
            this.onUninstall();
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u7cfb\u7edf\u5f15\u7528[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    protected void onUninstall() throws Throwable {
    }
}

