/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.service.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntimeException;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.service.client.WebClientInvocationHandler;
import net.ibizsys.central.service.client.WebClientRep;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class WebClientBase
implements IWebClient {
    private static final Log log = LogFactory.getLog(WebClientBase.class);
    public static ObjectMapper MAPPER = new ObjectMapper();
    public static ObjectMapper OUTMAPPER = new ObjectMapper();
    private static int maxFileSize = 0x2000000;
    private static int maxRequestSize = 0x2000000;
    private static int maxInMemorySize = 0x2000000;
    private ISystemRuntime iSystemRuntime;
    private ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime;
    private String strServiceUrl = null;
    private Map<String, Object> globalHeaderMap = null;

    public static int getMaxFileSize() {
        return maxFileSize;
    }

    public static void setMaxFileSize(int nMaxFileSize) {
        maxFileSize = nMaxFileSize;
    }

    public static int getMaxRequestSize() {
        return maxRequestSize;
    }

    public static void setMaxRequestSize(int nMaxRequestSize) {
        maxRequestSize = nMaxRequestSize;
    }

    public static int getMaxInMemorySize() {
        return maxInMemorySize;
    }

    public static void setMaxInMemorySize(int nMaxInMemorySize) {
        maxInMemorySize = nMaxInMemorySize;
    }

    @Override
    public void init(ISystemRuntime iSystemRuntime) throws Exception {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntime = iSystemRuntime;
        this.onInit();
    }

    @Override
    public void init(ISystemRuntime iSystemRuntime, String strServiceUrl, Map<String, ?> headers) throws Exception {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntime = iSystemRuntime;
        this.strServiceUrl = strServiceUrl;
        if (headers != null) {
            this.setHeaders(headers);
        }
        this.onInit();
    }

    @Override
    public void init(ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime) throws Exception {
        Assert.notNull((Object)iSubSysServiceAPIRuntime, (String)"\u4f20\u5165\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        this.iSubSysServiceAPIRuntime = iSubSysServiceAPIRuntime;
        this.iSystemRuntime = this.iSubSysServiceAPIRuntime.getSystemRuntime();
        this.setServiceUrl(iSubSysServiceAPIRuntime.getServiceUrl());
        this.onInit();
    }

    @Override
    public void init(ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime, String strServiceUrl) throws Exception {
        Assert.notNull((Object)iSubSysServiceAPIRuntime, (String)"\u4f20\u5165\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        this.iSubSysServiceAPIRuntime = iSubSysServiceAPIRuntime;
        this.iSystemRuntime = this.iSubSysServiceAPIRuntime.getSystemRuntime();
        this.setServiceUrl(strServiceUrl);
        this.onInit();
    }

    protected void onInit() throws Exception {
    }

    @Override
    public <T> T getProxyClient(Class<?> cls) {
        WebClientInvocationHandler webClientInvocationHandler = new WebClientInvocationHandler(this, cls);
        return (T)webClientInvocationHandler.getProxyClient();
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
        return this.iSubSysServiceAPIRuntime;
    }

    protected void setHeaders(Map<String, ?> headers) {
        ConcurrentHashMap map = null;
        if (headers != null) {
            map = new ConcurrentHashMap();
            map.putAll(headers);
        }
        this.globalHeaderMap = map;
    }

    @Override
    public Map<String, ?> getHeaders() {
        ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = this.getSubSysServiceAPIRuntime();
        if (iSubSysServiceAPIRuntime != null) {
            return iSubSysServiceAPIRuntime.getHeaders();
        }
        return this.globalHeaderMap;
    }

    @Override
    public Map<String, ?> getHeaders(boolean bAuthMode) {
        ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = this.getSubSysServiceAPIRuntime();
        if (iSubSysServiceAPIRuntime != null) {
            return iSubSysServiceAPIRuntime.getHeaders(bAuthMode);
        }
        return this.globalHeaderMap;
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public <T> IWebClientRep<T> get(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("GET[%1$s], uri=%2$s, header=%3$s, queries=%4$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries)));
            }
            return this.onGet(strUri, uriParams, headers, queries, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onGet(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> get(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.get(strUri, uriParams, headers, queries, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public <T> IWebClientRep<T> post(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("POST[%1$s], uri=%2$s, header=%3$s, queries=%4$s, body=%5$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries), this.getParamString(objBody)));
            }
            return this.onPost(strUri, uriParams, headers, queries, this.getBodyContent(objBody, strContentType), strContentType, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onPost(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> post(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.post(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public <T> IWebClientRep<T> put(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("PUT[%1$s], uri=%2$s, header=%3$s, queries=%4$s, body=%5$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries), this.getParamString(objBody)));
            }
            return this.onPut(strUri, uriParams, headers, queries, this.getBodyContent(objBody, strContentType), strContentType, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onPut(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> put(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.put(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public <T> IWebClientRep<T> patch(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("PATCH[%1$s], uri=%2$s, header=%3$s, queries=%4$s, body=%5$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries), this.getParamString(objBody)));
            }
            return this.onPatch(strUri, uriParams, headers, queries, this.getBodyContent(objBody, strContentType), strContentType, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onPatch(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> patch(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody, String strContentType, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.patch(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public <T> IWebClientRep<T> delete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("DELETE[%1$s], uri=%2$s, header=%3$s, queries=%4$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries)));
            }
            return this.onDelete(strUri, uriParams, headers, queries, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onDelete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> delete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.delete(strUri, uriParams, headers, queries, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public <T> IWebClientRep<T> head(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("HEADER[%1$s], uri=%2$s, header=%3$s, queries=%4$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries)));
            }
            return this.onHead(strUri, uriParams, headers, queries, cls, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected <T> IWebClientRep<T> onHead(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> head(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, TypeReference<T> type, Object objTag) throws Throwable {
        IWebClientRep<String> rep = this.head(strUri, uriParams, headers, queries, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    @Override
    public IWebClientRep<String> get(String strUri, Map<String, ?> uriParams) throws Throwable {
        return this.get(strUri, uriParams, null);
    }

    @Override
    public IWebClientRep<String> get(String strUri, Map<String, ?> uriParams, Map<String, ?> headers) throws Throwable {
        return this.get(strUri, uriParams, headers, null);
    }

    @Override
    public IWebClientRep<String> get(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries) throws Throwable {
        return this.get(strUri, uriParams, headers, queries, String.class, null);
    }

    @Override
    public IWebClientRep<String> post(String strUri, Map<String, ?> uriParams, Object objBody) throws Throwable {
        return this.post(strUri, uriParams, null, objBody);
    }

    @Override
    public IWebClientRep<String> post(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Object objBody) throws Throwable {
        return this.post(strUri, uriParams, headers, null, objBody);
    }

    @Override
    public IWebClientRep<String> post(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody) throws Throwable {
        return this.post(strUri, uriParams, headers, queries, objBody, null, String.class, null);
    }

    @Override
    public IWebClientRep<String> put(String strUri, Map<String, ?> uriParams, Object objBody) throws Throwable {
        return this.put(strUri, uriParams, null, objBody);
    }

    @Override
    public IWebClientRep<String> put(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Object objBody) throws Throwable {
        return this.put(strUri, uriParams, headers, null, objBody);
    }

    @Override
    public IWebClientRep<String> put(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objBody) throws Throwable {
        return this.put(strUri, uriParams, headers, queries, objBody, null, String.class, null);
    }

    @Override
    public IWebClientRep<String> delete(String strUri, Map<String, ?> uriParams) throws Throwable {
        return this.delete(strUri, uriParams, null);
    }

    @Override
    public IWebClientRep<String> delete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers) throws Throwable {
        return this.delete(strUri, uriParams, headers, null);
    }

    @Override
    public IWebClientRep<String> delete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries) throws Throwable {
        return this.delete(strUri, uriParams, headers, queries, String.class, null);
    }

    @Override
    public IWebClientRep<?> upload(String strUri, Map<String, ?> uriParams, Object objFile) throws Throwable {
        return this.upload(strUri, uriParams, null, objFile);
    }

    @Override
    public IWebClientRep<?> upload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Object objFile) throws Throwable {
        return this.upload(strUri, uriParams, headers, null, objFile);
    }

    @Override
    public IWebClientRep<?> upload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile) throws Throwable {
        return this.upload(strUri, uriParams, headers, queries, objFile, null);
    }

    @Override
    public IWebClientRep<?> download(String strUri, Map<String, ?> uriParams, Object objFile) throws Throwable {
        return this.download(strUri, uriParams, null, objFile);
    }

    @Override
    public IWebClientRep<?> download(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Object objFile) throws Throwable {
        return this.download(strUri, uriParams, headers, null, objFile);
    }

    @Override
    public IWebClientRep<?> download(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile) throws Throwable {
        return this.download(strUri, uriParams, headers, queries, objFile, null);
    }

    @Override
    public IWebClientRep<String> get(String strUri) throws Throwable {
        return this.get(strUri, null);
    }

    @Override
    public IWebClientRep<String> post(String strUri, Object objBody) throws Throwable {
        return this.post(strUri, null, objBody);
    }

    @Override
    public IWebClientRep<String> put(String strUri, Object objBody) throws Throwable {
        return this.put(strUri, null, objBody);
    }

    @Override
    public IWebClientRep<String> delete(String strUri) throws Throwable {
        return this.delete(strUri, null);
    }

    @Override
    public IWebClientRep<?> upload(String strUri, Object objFile) throws Throwable {
        return this.upload(strUri, null, objFile);
    }

    @Override
    public IWebClientRep<?> download(String strUri, Object objFile) throws Throwable {
        return this.download(strUri, null, objFile);
    }

    @Override
    public IWebClientRep<?> upload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UPLOAD[%1$s], uri=%2$s, header=%3$s, queries=%4$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries)));
            }
            return this.onUpload(strUri, uriParams, headers, queries, objFile, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected IWebClientRep<?> onUpload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public IWebClientRep<?> download(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("DOWNLOAD[%1$s], uri=%2$s, header=%3$s, queries=%4$s", strUri, this.getParamString(uriParams), this.getParamString(headers), this.getParamString(queries)));
            }
            return this.onDownload(strUri, uriParams, headers, queries, objFile, objTag);
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    protected IWebClientRep<?> onDownload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objData, Object objTag) throws Throwable {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSubSysServiceAPIRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> IWebClientRep<T> execute(String strMethod, String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objData, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        Assert.hasLength((String)strMethod, (String)"\u672a\u4f20\u5165\u8bf7\u6c42\u65b9\u5f0f");
        if ("POST".equalsIgnoreCase(strMethod)) {
            return this.post(strUri, uriParams, headers, queries, objData, strContentType, cls, objTag);
        }
        if ("PUT".equalsIgnoreCase(strMethod)) {
            return this.put(strUri, uriParams, headers, queries, objData, strContentType, cls, objTag);
        }
        if ("PATCH".equalsIgnoreCase(strMethod)) {
            return this.patch(strUri, uriParams, headers, queries, objData, strContentType, cls, objTag);
        }
        if (queries == null && objData != null) {
            if (objData instanceof Map) {
                queries = (Map<String, Object>)objData;
            } else if (objData instanceof IEntity) {
                queries = ((IEntity)objData).any();
            }
        }
        if ("GET".equalsIgnoreCase(strMethod)) {
            return this.get(strUri, uriParams, headers, queries, cls, objTag);
        }
        if ("HEAD".equalsIgnoreCase(strMethod)) {
            return this.head(strUri, uriParams, headers, queries, cls, objTag);
        }
        if ("DELETE".equalsIgnoreCase(strMethod)) {
            return this.delete(strUri, uriParams, headers, queries, cls, objTag);
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getSubSysServiceAPIRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8bf7\u6c42\u65b9\u5f0f[%1$s]", strMethod));
    }

    @Override
    public <T> IWebClientRep<T> execute(String strMethod, String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objData, String strContentType, TypeReference<T> type, Object objTag) throws Throwable {
        Assert.hasLength((String)strMethod, (String)"\u672a\u4f20\u5165\u8bf7\u6c42\u65b9\u5f0f");
        IWebClientRep<String> rep = this.execute(strMethod, strUri, uriParams, headers, queries, objData, strContentType, String.class, objTag);
        try {
            Object t = null;
            if (StringUtils.hasLength((String)rep.getBody())) {
                t = MAPPER.readValue(rep.getBody(), type);
            }
            return new WebClientRep<Object>(t, rep.getHeaders());
        }
        catch (Throwable ex) {
            this.getSystemRuntime().log(40000, "WEBCLIENT", ex.getMessage(), null);
            throw this.dealException(ex);
        }
    }

    public static String getUrlParams(Object params) throws Exception {
        return WebClientBase.getUrlParams(params, true);
    }

    public static String getUrlParams(Map<String, ?> map) throws Exception {
        return WebClientBase.getUrlParams(map, true);
    }

    public static String getUrlParams(Object params, boolean bEncode) throws Exception {
        if (params == null) {
            return "";
        }
        Map<String, Object> map = null;
        if (params instanceof Map) {
            map = (Map<String, Object>)params;
        } else if (params instanceof IEntity) {
            map = ((IEntity)params).any();
        } else {
            throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8bf7\u6c42\u53c2\u6570\u5bf9\u8c61");
        }
        return WebClientBase.getUrlParams(map, bEncode);
    }

    public static String getUrlParams(Map<String, ?> map, boolean bEncode) throws Exception {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean bFirst = true;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("&");
            }
            if (bEncode && entry.getValue() instanceof String) {
                sb.append(entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                continue;
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    protected Throwable dealException(Throwable ex) {
        if (ex instanceof ISubSysServiceAPIRuntimeException && ((ISubSysServiceAPIRuntimeException)((Object)ex)).getStatusCode() == HttpStatus.UNAUTHORIZED.value() && this.getSubSysServiceAPIRuntime() != null) {
            this.getSubSysServiceAPIRuntime().requestToken();
        }
        return ex;
    }

    protected String getParamString(Object objValue) {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        try {
            return OUTMAPPER.writeValueAsString(objValue);
        }
        catch (Throwable ex) {
            return ex.getMessage();
        }
    }

    protected Object getBodyContent(Object objValue, String strContentType) throws JsonProcessingException {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return objValue;
        }
        if (!StringUtils.hasLength((String)strContentType) || strContentType.equals("application/json")) {
            return OUTMAPPER.writeValueAsString(objValue);
        }
        return objValue;
    }
}

