/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.security.ISysUniResRuntime;
import net.ibizsys.central.security.ISysUserRoleRuntime;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.model.security.IPSSysUserRoleData;
import net.ibizsys.model.security.IPSSysUserRoleRes;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SysUserRoleRuntime
extends SystemModelRuntimeBase
implements ISysUserRoleRuntime {
    private static final Log log = LogFactory.getLog(SysUserRoleRuntime.class);
    private IPSSysUserRole iPSSysUserRole = null;
    private Map<String, ISysUniResRuntime> sysUniResRuntimeMap = null;
    private Map<String, List<IPSDEUserRole>> psDEUserRoleListMap = null;
    private ISystemAccessManager iSystemAccessManager = null;
    private boolean bEnableTestUser = false;
    private PSModelEnums.SysUserRoleType roleType = PSModelEnums.SysUserRoleType.CUSTOM;
    private IDataEntityRuntime iDataEntityRuntime = null;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, ISystemAccessManager iSystemAccessManager, IPSSysUserRole iPSSysUserRole) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysUserRole = iPSSysUserRole;
        this.iSystemAccessManager = iSystemAccessManager;
        if (this.iSystemAccessManager == null) {
            this.iSystemAccessManager = this.getSystemRuntime().getSystemAccessManager();
        }
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        if (this.getPSSysUserRole() != null) {
            if (StringUtils.hasLength((String)this.getPSSysUserRole().getRoleType())) {
                this.roleType = PSModelEnums.SysUserRoleType.from((String)this.getPSSysUserRole().getRoleType());
            }
            if (PSModelEnums.SysUserRoleType.DEDATASET == this.getRoleType()) {
                if (this.getPSSysUserRole().getPSDataEntity() != null && this.getPSSysUserRole().getPSDEDataSet() != null && this.getPSSysUserRole().getUserIdPSDEField() != null) {
                    this.setEnableTestUser(true);
                } else {
                    log.warn((Object)String.format("\u89d2\u8272[%1$s]\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u96c6\u6a21\u5f0f\uff0c\u4f46\u672a\u63d0\u4f9b\u76f8\u5173\u7684\u914d\u7f6e", this.getName()));
                }
            }
            this.sysUniResRuntimeMap = new HashMap<String, ISysUniResRuntime>();
            List psSysUserRoleResList = this.getPSSysUserRole().getPSSysUserRoleReses();
            if (psSysUserRoleResList != null) {
                for (IPSSysUserRoleRes iPSSysUserRoleRes : psSysUserRoleResList) {
                    this.sysUniResRuntimeMap.put(iPSSysUserRoleRes.getSysUniResCode(), this.getSystemAccessManager().getSysUniResRuntime(iPSSysUserRoleRes.getSysUniResCode(), false));
                }
            }
            this.psDEUserRoleListMap = new HashMap<String, List<IPSDEUserRole>>();
            List psSysUserRoleDataList = this.getPSSysUserRole().getPSSysUserRoleDatas();
            if (psSysUserRoleDataList != null) {
                for (IPSSysUserRoleData iPSSysUserRoleData : psSysUserRoleDataList) {
                    List<IPSDEUserRole> list = this.psDEUserRoleListMap.get(iPSSysUserRoleData.getPSDataEntityMust().getId());
                    if (list == null) {
                        list = new ArrayList<IPSDEUserRole>();
                        this.psDEUserRoleListMap.put(iPSSysUserRoleData.getPSDataEntityMust().getId(), list);
                    }
                    list.add(iPSSysUserRoleData.getPSDEUserRoleMust());
                }
            }
        }
        super.onInit();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysUserRole();
    }

    @Override
    public IPSSysUserRole getPSSysUserRole() {
        return this.iPSSysUserRole;
    }

    @Override
    public ISystemAccessManager getSystemAccessManager() {
        return this.iSystemAccessManager;
    }

    @Override
    public List<IPSDEUserRole> getPSDEUserRoles(String strDEId) {
        if (this.psDEUserRoleListMap == null) {
            return null;
        }
        return this.psDEUserRoleListMap.get(strDEId);
    }

    @Override
    public Boolean testSysUniRes(IUserContext iUserContext, String strUniResCode) {
        return this.testSysUniRes(iUserContext, strUniResCode, null);
    }

    @Override
    public Boolean testSysUniRes(IUserContext iUserContext, String strUniResCode, IEntity iEntity) {
        ISysUniResRuntime iSysUniResRuntime;
        if (this.sysUniResRuntimeMap != null && (iSysUniResRuntime = this.sysUniResRuntimeMap.get(strUniResCode)) != null) {
            return iSysUniResRuntime.test(iUserContext, iEntity);
        }
        return null;
    }

    @Override
    public String getDefaultUser() {
        return this.getPSSysUserRole().getDefaultUser();
    }

    @Override
    public boolean testUser(IUserContext iUserContext) {
        Assert.notNull((Object)iUserContext, (String)"\u4f20\u5165\u7528\u6237\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        if (!this.isEnableTestUser()) {
            return false;
        }
        try {
            return this.onTestUser(iUserContext);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u5224\u65ad\u7528\u6237\u662f\u5426\u5728\u89d2\u8272\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected boolean onTestUser(IUserContext iUserContext) throws Throwable {
        if (PSModelEnums.SysUserRoleType.DEDATASET == this.getRoleType()) {
            ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
            iSearchContextDTO.eq(this.getPSSysUserRole().getUserIdPSDEFieldMust().getLowerCaseName(), iUserContext.getUserid());
            return this.getDataEntityRuntime().existsData(this.getPSSysUserRole().getPSDEDataSetMust(), iSearchContextDTO);
        }
        return false;
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null) {
            this.iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSSysUserRole().getPSDataEntityMust().getId());
        }
        return this.iDataEntityRuntime;
    }

    @Override
    public boolean isEnableTestUser() {
        return this.bEnableTestUser;
    }

    protected void setEnableTestUser(boolean bEnableTestUser) {
        this.bEnableTestUser = bEnableTestUser;
    }

    @Override
    public String getRoleTag() {
        return this.getPSSysUserRole().getRoleTag();
    }

    @Override
    public PSModelEnums.SysUserRoleType getRoleType() {
        return this.roleType;
    }
}

