/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.search;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.search.ISysSearchDocRuntime;
import net.ibizsys.central.search.ISysSearchSchemeRuntime;
import net.ibizsys.central.search.ISysSearchSchemeRuntimeContext;
import net.ibizsys.central.search.SysSearchDocRuntime;
import net.ibizsys.central.search.SysSearchSchemeRuntimeException;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.search.IPSSysSearchDoc;
import net.ibizsys.model.search.IPSSysSearchScheme;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.ISystemRuntimeException;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysSearchSchemeRuntimeBase
extends SystemModelRuntimeBase
implements ISysSearchSchemeRuntime {
    private static final Log log = LogFactory.getLog(SysSearchSchemeRuntimeBase.class);
    private IPSSysSearchScheme iPSSysSearchScheme = null;
    private String strServiceUrl = null;
    private String strSearchEngineType = null;
    private Object objDataSourceTag = null;
    private Map<String, Object> properties = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strServiceParam = null;
    private String strServiceParam2 = null;
    private String strDBName = null;
    private static ThreadLocal<String> dbNameThreadLocal = new ThreadLocal();
    private String strDBObjNameCase;
    private PSModelEnums.DBObjNameCaseMode dbObjNameCaseMode;
    private ISysBDSchemeRuntime iSysBDSchemeRuntime;
    private Map<String, ISysSearchDocRuntime> sysSearchDocRuntimeMap;
    private boolean bInstalled;
    private boolean bUpdateSchema;
    private IPSSysBDScheme iPSSysBDScheme;
    private ISysSearchSchemeRuntimeContext iSysSearchSchemeRuntimeContext;

    public SysSearchSchemeRuntimeBase() {
        this.strDBObjNameCase = PSModelEnums.DBObjNameCaseMode.LCASE.value;
        this.dbObjNameCaseMode = PSModelEnums.DBObjNameCaseMode.LCASE;
        this.iSysBDSchemeRuntime = null;
        this.sysSearchDocRuntimeMap = new HashMap<String, ISysSearchDocRuntime>();
        this.bInstalled = false;
        this.bUpdateSchema = true;
        this.iPSSysBDScheme = null;
        this.iSysSearchSchemeRuntimeContext = new ISysSearchSchemeRuntimeContext(){

            @Override
            public ISysSearchSchemeRuntime getSysSearchSchemeRuntime() {
                return SysSearchSchemeRuntimeBase.this.getSelf();
            }
        };
    }

    public static void setCurrentDBName(String strDBName) {
        dbNameThreadLocal.set(strDBName);
    }

    public static String getCurrentDBName() {
        return dbNameThreadLocal.get();
    }

    public static String getConfigFolder(IPSSysSearchScheme iPSSysSearchScheme) {
        if (iPSSysSearchScheme.getPSSysModelGroup() != null) {
            return "syssearchscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysSearchScheme.getPSSysModelGroup(), (String)iPSSysSearchScheme.getCodeName());
        }
        return "syssearchscheme." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysSearchScheme.getPSSystemModule(), (String)iPSSysSearchScheme.getCodeName());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysSearchScheme iPSSysSearchScheme) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSysSearchScheme, (String)"\u4f20\u5165\u68c0\u7d22\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntimeBase(iSystemRuntimeContext.getSystemRuntime());
        this.iPSSysSearchScheme = iPSSysSearchScheme;
        this.setConfigFolder(SysSearchSchemeRuntimeBase.getConfigFolder(iPSSysSearchScheme));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        if (StringUtils.hasLength((String)this.getPSSysSearchScheme().getCodeName())) {
            this.setDBName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbname", this.getPSSysSearchScheme().getCodeName().toLowerCase()));
        } else {
            this.setDBName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbname", null));
        }
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSysSearchScheme().getServicePath()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysSearchScheme().getAuthMode()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysSearchScheme().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysSearchScheme().getAuthClientSecret()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSysSearchScheme().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSysSearchScheme().getAuthParam2()));
        this.setServiceParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam", this.getPSSysSearchScheme().getServiceParam()));
        this.setServiceParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam2", this.getPSSysSearchScheme().getServiceParam2()));
        this.setDBObjNameCase(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbobjnamecase", this.getPSSysSearchScheme().getDBObjNameCase()));
        this.setUpdateSchema(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".updateschema", this.isUpdateSchema()));
        List psSysSearchDocList = this.getPSSysSearchScheme().getAllPSSysSearchDocs();
        if (!ObjectUtils.isEmpty((Object)psSysSearchDocList)) {
            for (IPSSysSearchDoc iPSSysSearchDoc : psSysSearchDocList) {
                ISysSearchDocRuntime iSysSearchDocRuntime = this.createSysSearchDocRuntime(iPSSysSearchDoc);
                try {
                    iSysSearchDocRuntime.init(this.getSysSearchSchemeRuntimeContext(), iPSSysSearchDoc);
                    this.sysSearchDocRuntimeMap.put(iPSSysSearchDoc.getName().toUpperCase(), iSysSearchDocRuntime);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u521d\u59cb\u5316\u68c0\u7d22\u6587\u6863[%1$s]\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSearchDoc.getName(), ex.getMessage()), ex);
                }
            }
        }
        super.onInit();
        if (this.getPSSysBDScheme(true) == null) {
            this.preparePSSysBDScheme();
            if (this.getPSSysBDScheme(true) == null) {
                log.warn((Object)String.format("\u68c0\u7d22\u4f53\u7cfb[%1$s]\u672a\u7ed1\u5b9a\u9ed8\u8ba4\u5927\u6570\u636e\u4f53\u7cfb", this.getName()));
            } else {
                log.debug((Object)String.format("\u68c0\u7d22\u4f53\u7cfb[%1$s]\u7ed1\u5b9a\u5927\u6570\u636e\u4f53\u7cfb[%2$s]", this.getName(), this.getPSSysBDScheme(true).getName()));
            }
        }
    }

    protected ISysSearchSchemeRuntimeContext getSysSearchSchemeRuntimeContext() {
        return this.iSysSearchSchemeRuntimeContext;
    }

    private SysSearchSchemeRuntimeBase getSelf() {
        return this;
    }

    protected ISysSearchDocRuntime createSysSearchDocRuntime(IPSSysSearchDoc iPSSysSearchDoc) {
        return new SysSearchDocRuntime();
    }

    @Override
    public IPSSysSearchScheme getPSSysSearchScheme() {
        return this.iPSSysSearchScheme;
    }

    @Override
    public ISysBDSchemeRuntime getSysBDSchemeRuntime() {
        return this.getSysBDSchemeRuntime(false);
    }

    protected void preparePSSysBDScheme() throws Exception {
        String strTag = null;
        strTag = this.getPSSysSearchScheme().getPSSysModelGroup() != null ? PSModelUtils.calcUniqueTag((IPSSysModelGroup)this.getPSSysSearchScheme().getPSSysModelGroup(), (String)this.getPSSysSearchScheme().getCodeName()) : PSModelUtils.calcUniqueTag((IPSSystemModule)this.getPSSysSearchScheme().getPSSystemModule(), (String)this.getPSSysSearchScheme().getCodeName());
        List psSysBDSchemeList = this.getSystemRuntime().getPSSystem().getAllPSSysBDSchemes();
        if (!ObjectUtils.isEmpty((Object)psSysBDSchemeList)) {
            for (IPSSysBDScheme item : psSysBDSchemeList) {
                String strTag2;
                if (this.getPSSysSearchScheme().getPSSysModelGroup() != null) {
                    if (item.getPSSysModelGroup() == null || !strTag.equals(strTag2 = PSModelUtils.calcUniqueTag((IPSSysModelGroup)item.getPSSysModelGroup(), (String)item.getCodeName()))) continue;
                    this.setPSSysBDScheme(item);
                    break;
                }
                strTag2 = PSModelUtils.calcUniqueTag((IPSSystemModule)item.getPSSystemModule(), (String)item.getCodeName());
                if (!strTag.equals(strTag2)) continue;
                this.setPSSysBDScheme(item);
                break;
            }
        }
    }

    protected void setPSSysBDScheme(IPSSysBDScheme iPSSysBDScheme) {
        this.iPSSysBDScheme = iPSSysBDScheme;
    }

    protected IPSSysBDScheme getPSSysBDScheme(boolean bTryMode) throws Exception {
        if (this.iPSSysBDScheme != null || bTryMode) {
            return this.iPSSysBDScheme;
        }
        throw new Exception("\u5927\u6570\u636e\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
    }

    public ISysBDSchemeRuntime getSysBDSchemeRuntime(boolean bTryMode) {
        try {
            if (this.getPSSysBDScheme(true) != null && this.iSysBDSchemeRuntime == null) {
                this.iSysBDSchemeRuntime = this.getSystemRuntime().getSysBDSchemeRuntime(this.getPSSysBDScheme(true));
            }
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u83b7\u53d6\u5927\u6570\u636e\u4f53\u7cfb\u8fd0\u884c\u65f6\u4f53\u7cfb\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (this.iSysBDSchemeRuntime != null || bTryMode) {
            return this.iSysBDSchemeRuntime;
        }
        throw new SysSearchSchemeRuntimeException(this, String.format("\u672a\u5b9a\u4e49\u68c0\u7d22\u4f53\u7cfb\u76f8\u5173\u7684\u5927\u6570\u636e\u4f53\u7cfb", new Object[0]));
    }

    protected void setSysBDSchemeRuntime(ISysBDSchemeRuntime iSysBDSchemeRuntime) {
        this.iSysBDSchemeRuntime = iSysBDSchemeRuntime;
    }

    @Override
    public String getId() {
        return this.getPSSysSearchScheme().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysSearchScheme().getName();
    }

    @Override
    public String getSearchEngineType() {
        return this.strSearchEngineType;
    }

    @Override
    public void setSearchEngineType(String strSearchEngineType) {
        this.strSearchEngineType = strSearchEngineType;
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public String getServiceParam() {
        return this.strServiceParam;
    }

    protected void setServiceParam(String strServiceParam) {
        this.strServiceParam = strServiceParam;
    }

    @Override
    public String getServiceParam2() {
        return this.strServiceParam2;
    }

    protected void setServiceParam2(String strServiceParam2) {
        this.strServiceParam2 = strServiceParam2;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    @Override
    public String getDBObjNameCase() {
        return this.strDBObjNameCase;
    }

    protected void setDBObjNameCase(String strDBObjNameCase) {
        if (!StringUtils.hasLength((String)strDBObjNameCase)) {
            strDBObjNameCase = PSModelEnums.DBObjNameCaseMode.LCASE.value;
        }
        this.strDBObjNameCase = strDBObjNameCase;
        this.dbObjNameCaseMode = PSModelEnums.DBObjNameCaseMode.from((String)this.strDBObjNameCase);
    }

    @Override
    public PSModelEnums.DBObjNameCaseMode getDBObjNameCaseMode() {
        return this.dbObjNameCaseMode;
    }

    protected String getRealDBObjName(String strObjName) {
        if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.LCASE) {
            return strObjName.toLowerCase();
        }
        if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.UCASE) {
            return strObjName.toUpperCase();
        }
        return strObjName;
    }

    public String getDBName() {
        String strCurrentDBName = SysSearchSchemeRuntimeBase.getCurrentDBName();
        if (StringUtils.hasLength((String)strCurrentDBName)) {
            return strCurrentDBName;
        }
        return this.strDBName;
    }

    protected void setDBName(String strDBName) {
        this.strDBName = strDBName;
    }

    protected Map<String, Object> getRealMap(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map)) {
            return map;
        }
        LinkedHashMap<String, Object> real = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("srfkey".equals(entry.getKey())) {
                real.put(entry.getKey(), entry.getValue());
                continue;
            }
            real.put(this.getRealDBObjName(entry.getKey()), entry.getValue());
        }
        return real;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysSearchScheme();
    }

    @Override
    public boolean isUpdateSchema() {
        return this.bUpdateSchema;
    }

    public void setUpdateSchema(boolean bUpdateSchema) {
        this.bUpdateSchema = bUpdateSchema;
    }

    @Override
    public Object getDataSourceTag() {
        return this.objDataSourceTag;
    }

    @Override
    public void setDataSourceTag(Object objDataSourceTag) {
        this.objDataSourceTag = objDataSourceTag;
    }

    @Override
    public void setDataSourceProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Object getDataSourceProperty(String strKey, Object objDefault) {
        if (this.properties != null && this.properties.containsKey(strKey)) {
            return this.properties.get(strKey);
        }
        return objDefault;
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
        List psSysSearchDocList;
        if (this.isUpdateSchema() && !ObjectUtils.isEmpty((Object)(psSysSearchDocList = this.getPSSysSearchScheme().getAllPSSysSearchDocs()))) {
            for (IPSSysSearchDoc iPSSysSearchDoc : psSysSearchDocList) {
                try {
                    this.updateSchema(iPSSysSearchDoc);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u66f4\u65b0\u68c0\u7d22\u6587\u6863[%1$s]\u7ed3\u6784\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSearchDoc.getName(), ex.getMessage()), ex);
                }
            }
        }
    }

    protected void updateSchema(IPSSysSearchDoc iPSSysSearchDoc) throws Exception {
        this.onUpdateSchema(iPSSysSearchDoc);
    }

    protected void onUpdateSchema(IPSSysSearchDoc iPSSysSearchDoc) throws Exception {
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public void uninstall() {
        try {
            this.onUninstall();
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u68c0\u7d22\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u5378\u8f7d\u68c0\u7d22\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
        }
    }

    protected void onUninstall() throws Throwable {
    }

    @Override
    public ISysSearchDocRuntime getSysSearchDocRuntime(String strDocName, boolean bTryMode) {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u68c0\u7d22\u6587\u6863\u540d\u79f0");
        ISysSearchDocRuntime iSysSearchDocRuntime = this.sysSearchDocRuntimeMap.get(strDocName.toUpperCase());
        if (iSysSearchDocRuntime != null || bTryMode) {
            return iSysSearchDocRuntime;
        }
        throw new SysSearchSchemeRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u68c0\u7d22\u6587\u6863[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strDocName));
    }

    @Override
    public ISysSearchDocRuntime getSysSearchDocRuntime(IPSSysSearchDoc iPSSysSearchDoc) {
        Assert.notNull((Object)iPSSysSearchDoc, (String)"\u672a\u4f20\u5165\u68c0\u7d22\u6587\u6863\u5bf9\u8c61");
        return this.getSysSearchDocRuntime(iPSSysSearchDoc.getName(), false);
    }

    @Override
    public Object insert(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(args, (String)"\u672a\u4f20\u5165\u63d2\u5165\u6570\u636e");
        try {
            return this.onInsert(strDocName, args, extParamMap);
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u6279\u65b0\u5efa\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onInsert(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.insert(strDocName, args, extParamMap);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object update(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(args, (String)"\u672a\u4f20\u5165\u66f4\u65b0\u6570\u636e");
        try {
            return this.onUpdate(strDocName, args, extParamMap, bAppendMode);
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u6279\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onUpdate(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.update(strDocName, args, extParamMap, bAppendMode);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object delete(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(args, (String)"\u672a\u4f20\u5165\u5220\u9664\u6570\u636e");
        try {
            return this.onDelete(strDocName, args, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u6279\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onDelete(String strDocName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.delete(strDocName, args, extParamMap);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object insert(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(arg, (String)"\u672a\u4f20\u5165\u63d2\u5165\u6570\u636e");
        try {
            return this.onInsert(strDocName, arg, extParamMap);
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u65b0\u5efa\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onInsert(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.insert(strDocName, arg, extParamMap);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object update(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(arg, (String)"\u672a\u4f20\u5165\u66f4\u65b0\u6570\u636e");
        try {
            return this.onUpdate(strDocName, arg, extParamMap, bAppendMode);
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onUpdate(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.update(strDocName, arg, extParamMap, bAppendMode);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object delete(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strDocName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(arg, (String)"\u672a\u4f20\u5165\u5220\u9664\u6570\u636e");
        try {
            return this.onDelete(strDocName, arg, extParamMap);
        }
        catch (Throwable ex) {
            SysSearchSchemeRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onDelete(String strDocName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.delete(strDocName, arg, extParamMap);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Page fetch(String strDocName, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        try {
            return this.onFetch(strDocName, iSearchContext, outputFields, extParamMap);
        }
        catch (Throwable ex) {
            SystemRuntimeException.rethrow(this, ex);
            throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u96c6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strDocName, ex.getMessage()), ex);
        }
    }

    protected Page onFetch(String strDocName, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime.fetch(strDocName, iSearchContext, outputFields, extParamMap);
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    protected String getLogCat() {
        return "SEARCHSCHEME";
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    protected void onShutdown() throws Exception {
    }
}

