/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.res;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Set;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.res.ISysUniStateRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.sysutil.ISysUniStateListener;
import net.ibizsys.central.sysutil.ISysUniStateUtilRuntime;
import net.ibizsys.central.sysutil.ISysUniStateUtilRuntimeBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysUniState;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.IModelRuntimeShutdownable;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SysUniStateRuntimeBase
extends SystemModelRuntimeBase
implements ISysUniStateRuntime,
IModelRuntimeShutdownable {
    private static final Log log = LogFactory.getLog(SysUniStateRuntimeBase.class);
    private IPSSysUniState iPSSysUniState = null;
    private ISysUniStateUtilRuntimeBase iSysUniStateUtilRuntimeBase = null;
    private PSModelEnums.UniStateType uniStateType = PSModelEnums.UniStateType.DE;
    private PSModelEnums.UniStateMode uniStateMode = PSModelEnums.UniStateMode.DEFAULT;
    private String strMonitorPath = null;

    public static String getConfigFolder(IPSSysUniState iPSSysUniState) {
        return "sysunistate." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysUniState.getPSSystemModule(), (String)iPSSysUniState.getUniqueTag());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysUniState iPSSysUniState) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSysUniState, (String)"\u4f20\u5165\u7cfb\u7edf\u7edf\u4e00\u72b6\u6001\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysUniState = iPSSysUniState;
        this.setConfigFolder(SysUniStateRuntimeBase.getConfigFolder(iPSSysUniState));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        if (StringUtils.hasLength((String)this.getPSSysUniState().getUniStateType())) {
            this.uniStateType = PSModelEnums.UniStateType.from((String)this.getPSSysUniState().getUniStateType());
        }
        if (StringUtils.hasLength((String)this.getPSSysUniState().getUniStateMode())) {
            this.uniStateMode = PSModelEnums.UniStateMode.from((String)this.getPSSysUniState().getUniStateMode());
        }
        if (this.getSysUniStateUtilRuntimeBase(true) == null) {
            this.prepareSysUniStateUtilRuntimeBase();
            this.getSysUniStateUtilRuntimeBase(false);
        }
        super.onInit();
    }

    protected void prepareSysUniStateUtilRuntimeBase() throws Exception {
        if (PSModelEnums.UniStateMode.CACHE.value.equals(this.getPSSysUniState().getUniStateMode())) {
            this.setSysUniStateUtilRuntimeBase(this.getSystemRuntime().getSysUtilRuntime(ISysCacheUtilRuntime.class, false));
            return;
        }
        this.setSysUniStateUtilRuntimeBase(this.getSystemRuntime().getSysUtilRuntime(ISysUniStateUtilRuntime.class, false));
    }

    @Override
    public IPSSysUniState getPSSysUniState() {
        return this.iPSSysUniState;
    }

    @Override
    public String getId() {
        return this.getPSSysUniState().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysUniState().getName();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysUniState();
    }

    @Override
    public ISysUniStateUtilRuntimeBase getSysUniStateUtilRuntimeBase() {
        try {
            return this.getSysUniStateUtilRuntimeBase(false);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected ISysUniStateUtilRuntimeBase getSysUniStateUtilRuntimeBase(boolean bTryMode) throws Exception {
        if (this.iSysUniStateUtilRuntimeBase != null || bTryMode) {
            return this.iSysUniStateUtilRuntimeBase;
        }
        throw new Exception(String.format("\u7cfb\u7edf\u7edf\u4e00\u72b6\u6001\u7ec4\u4ef6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setSysUniStateUtilRuntimeBase(ISysUniStateUtilRuntimeBase iSysUniStateUtilRuntimeBase) {
        this.iSysUniStateUtilRuntimeBase = iSysUniStateUtilRuntimeBase;
    }

    @Override
    public String getMonitorPath() {
        return this.strMonitorPath;
    }

    protected void setMonitorPath(String strMonitorPath) {
        this.strMonitorPath = strMonitorPath;
    }

    @Override
    public boolean contains(String strPath) {
        return this.getSysUniStateUtilRuntimeBase().contains(strPath);
    }

    @Override
    public void set(String strPath, String strValue) {
        this.getSysUniStateUtilRuntimeBase().set(strPath, strValue);
    }

    @Override
    public void set(String strPath, Object objValue) {
        this.getSysUniStateUtilRuntimeBase().set(strPath, objValue);
    }

    @Override
    public <T> T get(String strPath, Class<T> cls) {
        return this.getSysUniStateUtilRuntimeBase().get(strPath, cls);
    }

    @Override
    public <T> T get(String strPath, TypeReference<T> type) {
        return this.getSysUniStateUtilRuntimeBase().get(strPath, type);
    }

    @Override
    public String get(String strPath) {
        return this.getSysUniStateUtilRuntimeBase().get(strPath);
    }

    @Override
    public void reset(String strPath) {
        this.getSysUniStateUtilRuntimeBase().reset(strPath);
    }

    @Override
    public String getPathFormat(Set<String> folderList) {
        return this.getSysUniStateUtilRuntimeBase().getPathFormat(folderList);
    }

    @Override
    public boolean isEnableListener(boolean bPattern) {
        return this.getSysUniStateUtilRuntimeBase().isEnableListener(bPattern);
    }

    @Override
    public void registerListener(String strPath, boolean bPattern, ISysUniStateListener iSysUniStateListener) {
        this.getSysUniStateUtilRuntimeBase().registerListener(strPath, bPattern, iSysUniStateListener);
    }

    @Override
    public void unregisterListener(String strPath, boolean bPattern, ISysUniStateListener iSysUniStateListener) {
        this.getSysUniStateUtilRuntimeBase().unregisterListener(strPath, bPattern, iSysUniStateListener);
    }

    @Override
    public PSModelEnums.UniStateType getUniStateType() {
        return this.uniStateType;
    }

    @Override
    public PSModelEnums.UniStateMode getUniStateMode() {
        return this.uniStateMode;
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    protected void onShutdown() throws Exception {
    }
}

