/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.res;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.res.ISysResourceRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysResource;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class SysResourceRuntimeBase
extends SystemModelRuntimeBase
implements ISysResourceRuntime {
    private static final Log log = LogFactory.getLog(SysResourceRuntimeBase.class);
    private IPSSysResource iPSSysResource = null;
    private String strResourceUri = null;
    private String strResourceParam = null;
    private String strResourceParam2 = null;
    private String strAccessTokenUrl = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strContent = null;
    private String strLogCat = null;

    public static String getConfigFolder(IPSSysResource iPSSysResource) {
        return "sysresource." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysResource.getPSSystemModule(), (String)iPSSysResource.getResTag());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysResource iPSSysResource) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysResource = iPSSysResource;
        this.strLogCat = this.iPSSysResource.getResTag();
        this.setConfigFolder(SysResourceRuntimeBase.getConfigFolder(iPSSysResource));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.setContent(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".content", this.getPSSysResource().getContent()));
        this.setResourceUri(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".resourceuri", this.getPSSysResource().getResourceUri()));
        if (!StringUtils.hasLength((String)this.getResourceUri()) && (PSModelEnums.ResourceType.ZIPFILE.value.equals(this.getPSSysResource().getResourceType()) || PSModelEnums.ResourceType.GITPROJECT.value.equals(this.getPSSysResource().getResourceType()))) {
            this.setResourceUri(this.getContent());
        }
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysResource().getAuthMode()));
        this.setAccessTokenUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".accesstokenurl", this.getPSSysResource().getAuthAccessTokenUrl()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysResource().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysResource().getAuthClientSecret()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSysResource().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSysResource().getAuthParam2()));
        super.onInit();
    }

    @Override
    public IPSSysResource getPSSysResource() {
        return this.iPSSysResource;
    }

    @Override
    public String getId() {
        return this.getPSSysResource().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysResource().getName();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysResource();
    }

    @Override
    public String getContent() {
        return this.strContent;
    }

    protected void setContent(String strContent) {
        this.strContent = strContent;
    }

    @Override
    public String getResourceUri() {
        return this.strResourceUri;
    }

    protected void setResourceUri(String strResourceUri) {
        this.strResourceUri = strResourceUri;
    }

    @Override
    public String getResourceParam() {
        return this.strResourceParam;
    }

    protected void setResourceParam(String strResourceParam) {
        this.strResourceParam = strResourceParam;
    }

    @Override
    public String getResourceParam2() {
        return this.strResourceParam2;
    }

    protected void setResourceParam2(String strResourceParam2) {
        this.strResourceParam2 = strResourceParam2;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    @Override
    public String getAccessTokenUrl() {
        return this.strAccessTokenUrl;
    }

    protected void setAccessTokenUrl(String strAccessTokenUrl) {
        this.strAccessTokenUrl = strAccessTokenUrl;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    protected String getResourceParam(String strKey, String strDefault) {
        JsonNode node;
        if (this.getPSSysResource().getResourceParams() != null && (node = this.getPSSysResource().getResourceParams().get(strKey)) != null) {
            return node.asText(strDefault);
        }
        return strDefault;
    }

    protected int getResourceParam(String strKey, int nDefault) {
        JsonNode node;
        if (this.getPSSysResource().getResourceParams() != null && (node = this.getPSSysResource().getResourceParams().get(strKey)) != null) {
            return node.asInt(nDefault);
        }
        return nDefault;
    }

    protected double getResourceParam(String strKey, double fDefault) {
        JsonNode node;
        if (this.getPSSysResource().getResourceParams() != null && (node = this.getPSSysResource().getResourceParams().get(strKey)) != null) {
            return node.asDouble(fDefault);
        }
        return fDefault;
    }

    protected void executeAction(String strActionName, IAction iAction) {
        this.executeAction(strActionName, iAction, null, Object.class, this.getLogPOTime());
    }

    protected Object executeAction(String strActionName, IAction iAction, Object[] args) {
        return this.executeAction(strActionName, iAction, args, Object.class, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls) {
        return this.executeAction(strActionName, iAction, args, cls, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type) {
        return this.executeAction(strActionName, iAction, args, type, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    protected RuntimeException dealException(String strMessage, Throwable ex) {
        this.getSystemRuntime().log(40000, this.getLogCat(), String.format("%1$s%2$s", this.getLogicName(), strMessage), null);
        return new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, strMessage, ex);
    }

    protected String getLogCat() {
        return this.strLogCat;
    }

    protected int getLogPOTime() {
        return ActionSessionManager.getLogPOTime();
    }
}

