/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.eai;

import java.util.List;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncInRuntime;
import net.ibizsys.runtime.res.SysDataSyncAgentRuntimeBase;
import net.ibizsys.runtime.util.domain.DataSyncIn;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalDataSyncAgentRuntime
extends SysDataSyncAgentRuntimeBase {
    private static final Log log = LogFactory.getLog(InternalDataSyncAgentRuntime.class);

    @Override
    public boolean isInternalAgent() {
        return true;
    }

    @Override
    public boolean isRawDataMode() {
        return false;
    }

    @Override
    public void send(DataSyncOut[] dataSyncOuts) {
        if (dataSyncOuts == null || dataSyncOuts.length == 0) {
            return;
        }
        List<IDEDataSyncInRuntime> list = this.getDEDataSyncInRuntimeList();
        if (list == null || list.size() == 0) {
            return;
        }
        try {
            DataSyncIn[] dataSyncIns = this.getDataSyncIns(dataSyncOuts);
            for (IDEDataSyncInRuntime iDEDataSyncInRuntime : list) {
                iDEDataSyncInRuntime.recv(dataSyncIns);
            }
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u53d1\u9001\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected DataSyncIn[] getDataSyncIns(DataSyncOut[] dataSyncOuts) throws Throwable {
        DataSyncIn[] dataSyncIns = new DataSyncIn[dataSyncOuts.length];
        for (int i = 0; i < dataSyncOuts.length; ++i) {
            dataSyncIns[i] = this.getDataSyncIn(dataSyncOuts[i]);
        }
        return dataSyncIns;
    }

    protected DataSyncIn getDataSyncIn(DataSyncOut dataSyncOut) throws Throwable {
        DataSyncIn dataSyncIn = new DataSyncIn();
        dataSyncIn.putAll(dataSyncOut.any());
        return dataSyncIn;
    }
}

