/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.action.IDEActionPluginRuntime;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.ITransactionalUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class DEServiceBase<T extends IEntityDTO, F extends ISearchContextDTO>
implements IDEService<T, F> {
    private static final Log log = LogFactory.getLog(DEServiceBase.class);
    private ISystemRuntime iSystemRuntime = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private boolean bPrepare = false;
    private boolean bPreparing = false;

    @Override
    public void init(ISystemRuntime iSystemRuntime, IDataEntityRuntime iDataEntityRuntime) throws Exception {
        this.setDataEntityRuntime(iDataEntityRuntime);
        this.setSystemRuntime(iSystemRuntime);
        this.onInit();
        this.prepare();
    }

    protected void onInit() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        if (this.bPrepare) {
            return;
        }
        DEServiceBase dEServiceBase = this;
        synchronized (dEServiceBase) {
            if (!this.bPrepare && !this.bPreparing) {
                this.bPreparing = true;
                this.onPrepare();
                this.bPrepare = true;
                this.bPreparing = false;
            }
        }
    }

    protected void onPrepare() {
    }

    protected void registerDEActionPluginRuntime(String strAction, IDEActionPluginRuntime iDEActionPluginRuntime) {
        try {
            this.getDataEntityRuntime().registerDEActionPluginRuntime(strAction, iDEActionPluginRuntime);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u6ce8\u518c\u5b9e\u4f53\u884c\u4e3a\u63d2\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected void setSystemRuntime(ISystemRuntime iSystemRuntime) {
        this.iSystemRuntime = iSystemRuntime;
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null) {
            ISystemRuntime iSystemRuntime = this.getSystemRuntime();
            if (iSystemRuntime == null) {
                throw new RuntimeException("\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
            }
            this.iDataEntityRuntime = iSystemRuntime.getDataEntityRuntime(this.getDataEntityId());
        }
        return this.iDataEntityRuntime;
    }

    protected void setDataEntityRuntime(IDataEntityRuntime iDataEntityRuntime) {
        this.iDataEntityRuntime = iDataEntityRuntime;
    }

    @Override
    public void wfStart(IEntityBase iEntityBase, IPSDEWF iPSDEWF) throws Throwable {
        this.getDataEntityRuntime().wfStart(iEntityBase, iPSDEWF, true);
    }

    @Override
    public T selectOne(F f, boolean bTryMode) throws Throwable {
        return (T)this.getDataEntityRuntime().selectOne((ISearchContextDTO)f, bTryMode);
    }

    @Override
    public boolean existsData(F iSearchContextBase) throws Throwable {
        return this.getDataEntityRuntime().existsData((ISearchContextBase)iSearchContextBase);
    }

    @Override
    public List<T> executeSelectSQL(String strSQL, List<Object> params) throws Throwable {
        ISysDBSchemeRuntime iSysDBSchemeRuntime = this.getDataEntityRuntime().getSysDBSchemeRuntime();
        if (iSysDBSchemeRuntime == null) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u672a\u63d0\u4f9bSQL\u652f\u6301", this.getDataEntityRuntime().getName()));
        }
        List list = iSysDBSchemeRuntime.executeSelectSQL(strSQL, params);
        if (list != null) {
            ArrayList<IEntityDTO> ret = new ArrayList<IEntityDTO>();
            for (Object item : list) {
                IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
                iEntityDTO.reload(item, false);
                ret.add(iEntityDTO);
            }
            return ret;
        }
        return null;
    }

    @Override
    public int executeSQL(String strSQL, List<Object> params) throws Throwable {
        ISysDBSchemeRuntime iSysDBSchemeRuntime = this.getDataEntityRuntime().getSysDBSchemeRuntime();
        if (iSysDBSchemeRuntime == null) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u672a\u63d0\u4f9bSQL\u652f\u6301", this.getDataEntityRuntime().getName()));
        }
        return iSysDBSchemeRuntime.executeSQL(strSQL, params);
    }

    @Override
    public boolean get(T t, boolean bTryMode) throws Throwable {
        IEntityDTO t2 = this.getDataEntityRuntime().get(this.getDataEntityRuntime().getFieldValue((IEntityBase)t, this.getDataEntityRuntime().getKeyPSDEField()), bTryMode);
        if (t2 == null) {
            return false;
        }
        t.reload(t2, true);
        return true;
    }

    @Override
    public T get(Object key, boolean bTryMode) throws Throwable {
        return (T)this.getDataEntityRuntime().get(key, bTryMode);
    }

    @Override
    public void rawCreate(List<T> list, boolean bSysMode) throws Throwable {
        this.getDataEntityRuntime().rawCreate(list, bSysMode);
    }

    @Override
    public void rawCreate(List<T> list) throws Throwable {
        this.rawCreate(list, true);
    }

    @Override
    public void rawUpdate(List<T> list, boolean bSysMode) throws Throwable {
        this.getDataEntityRuntime().rawUpdate(list, bSysMode);
    }

    @Override
    public void rawUpdate(List<T> list) throws Throwable {
        this.rawUpdate(list, true);
    }

    @Override
    public void rawSave(List<T> list, boolean bSysMode) throws Throwable {
        this.getDataEntityRuntime().rawSave(list, bSysMode);
    }

    @Override
    public void rawSave(List<T> list) throws Throwable {
        this.rawSave(list, true);
    }

    @Override
    public void rawRemove(List<Object> list, boolean bSysMode) throws Throwable {
        this.getDataEntityRuntime().rawRemove(list, bSysMode);
    }

    @Override
    public void rawRemove(List<Object> list) throws Throwable {
        this.rawRemove(list, true);
    }

    @Override
    public List<T> update(F f, Object data) throws Throwable {
        IEntity srcEntity = null;
        Map srcMap = null;
        if (data instanceof IEntity) {
            srcEntity = (IEntity)data;
        } else if (data instanceof Map) {
            srcMap = (Map)data;
        } else {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u66f4\u65b0\u6570\u636e[%1$s]", data));
        }
        IPSDEDataQuery defaultPSDEDataQuery = this.getDataEntityRuntime().getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? this.getDataEntityRuntime().selectDataQuery(defaultPSDEDataQuery, (ISearchContextDTO)f) : this.getDataEntityRuntime().select((ISearchContextDTO)f);
        if (!ObjectUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    IEntityDTO iEntityDTO = list.get(i);
                    if (srcEntity != null) {
                        srcEntity.copyTo(iEntityDTO);
                    } else {
                        iEntityDTO.putAll(srcMap);
                    }
                    this.getDataEntityRuntime().update(iEntityDTO);
                    continue;
                }
                catch (Throwable ex) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u66f4\u65b0\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getKeyFieldValue(list.get(i)), ex.getMessage()), ex);
                }
            }
        }
        return list;
    }

    @Override
    public List<T> rawUpdate(F f, Object objData) throws Throwable {
        return this.rawUpdate(f, objData, true);
    }

    @Override
    public List<T> rawUpdate(F f, Object data, boolean bSysMode) throws Throwable {
        IEntity srcEntity = null;
        Map srcMap = null;
        if (data instanceof IEntity) {
            srcEntity = (IEntity)data;
        } else if (data instanceof Map) {
            srcMap = (Map)data;
        } else {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u66f4\u65b0\u6570\u636e[%1$s]", data));
        }
        IPSDEDataQuery defaultPSDEDataQuery = this.getDataEntityRuntime().getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? this.getDataEntityRuntime().selectDataQuery(defaultPSDEDataQuery, (ISearchContextDTO)f) : this.getDataEntityRuntime().select((ISearchContextDTO)f);
        if (!ObjectUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                IEntityDTO iEntityDTO = list.get(i);
                if (srcEntity != null) {
                    srcEntity.copyTo(iEntityDTO);
                    continue;
                }
                iEntityDTO.putAll(srcMap);
            }
            this.rawUpdate(list, bSysMode);
        }
        return list;
    }

    @Override
    public Object rawExecute(IAction iAction, Object[] args) throws Throwable {
        return this.rawExecute(iAction, args, 0);
    }

    @Override
    public Object rawExecute(IAction iAction, Object[] args, int nTransactionalPropagation) throws Throwable {
        return this.getDataEntityRuntime().rawExecute(iAction, args, nTransactionalPropagation);
    }

    @Override
    public int remove(F f) throws Throwable {
        IPSDEDataQuery defaultPSDEDataQuery = this.getDataEntityRuntime().getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? this.getDataEntityRuntime().selectDataQuery(defaultPSDEDataQuery, (ISearchContextDTO)f) : this.getDataEntityRuntime().select((ISearchContextDTO)f);
        if (!ObjectUtils.isEmpty(list)) {
            for (IEntityDTO iEntityDTO : list) {
                this.getDataEntityRuntime().remove(this.getDataEntityRuntime().getKeyFieldValue(iEntityDTO));
            }
            return list.size();
        }
        return 0;
    }

    @Override
    public int rawRemove(F f, boolean bSysMode) throws Throwable {
        IPSDEDataQuery defaultPSDEDataQuery = this.getDataEntityRuntime().getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? this.getDataEntityRuntime().selectDataQuery(defaultPSDEDataQuery, (ISearchContextDTO)f) : this.getDataEntityRuntime().select((ISearchContextDTO)f);
        if (!ObjectUtils.isEmpty(list)) {
            ArrayList<Object> keyList = new ArrayList<Object>();
            for (IEntityDTO iEntityDTO : list) {
                keyList.add(this.getDataEntityRuntime().getKeyFieldValue(iEntityDTO));
            }
            this.getDataEntityRuntime().rawRemove(keyList, bSysMode);
            return list.size();
        }
        return 0;
    }

    @Override
    public List<IEntityDTO> createEntityDTOList(IPSDEMethodDTO iPSDEMethodDTO) {
        return null;
    }

    @Override
    public ISearchContextDTO createSearchContextDTO(Map<String, Object> params) {
        try {
            return this.getDataEntityRuntime().createSearchContext(params);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5efa\u7acb\u5b9e\u4f53\u9ed8\u8ba4\u67e5\u8be2\u4e0a\u4e0b\u6587\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ITransactionalUtil getTransactionalUtil() {
        return this.getTransactionalUtil(false);
    }

    protected ITransactionalUtil getTransactionalUtil(boolean bTryMode) {
        ITransactionalUtil iTransactionalUtil = ActionSessionManager.getTransactionalUtil();
        if (iTransactionalUtil != null || bTryMode) {
            return iTransactionalUtil;
        }
        throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u672a\u5b9a\u4e49\u4e8b\u52a1\u529f\u80fd\u7ec4\u4ef6", new Object[0]));
    }
}

