/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.central.dataentity.security.DEUserRoleRuntime;
import net.ibizsys.central.dataentity.security.IDEUserRoleRuntime;
import net.ibizsys.central.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.priv.IPSDEOPPriv;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataEntityAccessManager
implements IDataEntityAccessManager {
    private static final Log log = LogFactory.getLog(DataEntityAccessManager.class);
    private IDataEntityRuntimeContext iDataEntityRuntimeContext = null;
    private Map<String, IPSDEOPPriv> psDEOPPrivMap = null;
    private int nDataAccCtrlMode = 1;
    private ISystemAccessManager iSystemAccessManager = null;
    private List<IDEUserRoleRuntime> defaultDEUserRoleRuntimeList = null;
    private Map<String, IDEUserRoleRuntime> deUserRoleRuntimeMap = null;

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, ISystemAccessManager iSystemAccessManager) throws Exception {
        this.iDataEntityRuntimeContext = iDataEntityRuntimeContext;
        this.nDataAccCtrlMode = this.getDataEntityRuntime().getDataAccCtrlMode();
        this.iSystemAccessManager = iSystemAccessManager;
        if (this.iSystemAccessManager == null) {
            this.iSystemAccessManager = this.getDataEntityRuntime().getSystemRuntime().getSystemAccessManager();
        }
        this.onInit();
    }

    protected void onInit() throws Exception {
        this.prepareDEOPPrivs();
        this.prepareDEUserRoles();
    }

    protected IDataEntityRuntimeContext getDataEntityRuntimeContext() {
        return this.iDataEntityRuntimeContext;
    }

    public IDataEntityRuntime getDataEntityRuntime() {
        return this.getDataEntityRuntimeContext().getDataEntityRuntime();
    }

    public ISystemRuntime getSystemRuntime() {
        return this.getDataEntityRuntime().getSystemRuntime();
    }

    protected void prepareDEUserRoles() throws Exception {
        if (this.defaultDEUserRoleRuntimeList != null) {
            return;
        }
        ArrayList<IDEUserRoleRuntime> defaultDEUserRoleRuntimeList = new ArrayList<IDEUserRoleRuntime>();
        HashMap<String, IDEUserRoleRuntime> deUserRoleRuntimeMap = new HashMap<String, IDEUserRoleRuntime>();
        List psDEUserRoleList = this.getDataEntityRuntimeContext().getDataEntityRuntime().getPSDataEntity().getAllPSDEUserRoles();
        if (psDEUserRoleList != null) {
            for (IPSDEUserRole iPSDEUserRole : psDEUserRoleList) {
                IDEUserRoleRuntime iDEUserRoleRuntime = this.createDEUserRoleRuntime(iPSDEUserRole);
                iDEUserRoleRuntime.init(this.getDataEntityRuntimeContext(), iPSDEUserRole);
                if (iDEUserRoleRuntime.isDefaultMode()) {
                    defaultDEUserRoleRuntimeList.add(iDEUserRoleRuntime);
                }
                deUserRoleRuntimeMap.put(iDEUserRoleRuntime.getRoleTag(), iDEUserRoleRuntime);
            }
        }
        if (this.defaultDEUserRoleRuntimeList == null) {
            this.defaultDEUserRoleRuntimeList = defaultDEUserRoleRuntimeList;
        }
        if (this.deUserRoleRuntimeMap == null) {
            this.deUserRoleRuntimeMap = deUserRoleRuntimeMap;
        }
    }

    protected IDEUserRoleRuntime createDEUserRoleRuntime(IPSDEUserRole iPSDEUserRole) {
        return new DEUserRoleRuntime();
    }

    protected void prepareDEOPPrivs() throws Exception {
        if (this.psDEOPPrivMap != null) {
            return;
        }
        HashMap<String, IPSDEOPPriv> psDEOPPrivMap = new HashMap<String, IPSDEOPPriv>();
        List psDEOPPrivList = this.getDataEntityRuntimeContext().getDataEntityRuntime().getPSDataEntity().getAllPSDEOPPrivs();
        if (psDEOPPrivList != null) {
            for (IPSDEOPPriv iPSDEOPPriv : psDEOPPrivList) {
                if (StringUtils.hasLength((String)iPSDEOPPriv.getMapPSDEName())) {
                    String strKey = String.format("%1$s|%2$s", iPSDEOPPriv.getMapPSDEName(), iPSDEOPPriv.getName());
                    psDEOPPrivMap.put(strKey, iPSDEOPPriv);
                    continue;
                }
                psDEOPPrivMap.put(iPSDEOPPriv.getName(), iPSDEOPPriv);
            }
        }
        if (this.psDEOPPrivMap == null) {
            this.psDEOPPrivMap = psDEOPPrivMap;
        }
    }

    protected IPSDEOPPriv getPSDEOPPriv(IDataEntityRuntime parentDataEntityRuntime, String strAccessAction) {
        return this.getPSDEOPPriv(parentDataEntityRuntime, strAccessAction, false);
    }

    protected IPSDEOPPriv getPSDEOPPriv(IDataEntityRuntime parentDataEntityRuntime, String strAccessAction, boolean bMustMapMode) {
        IPSDEOPPriv iPSDEOPPriv = null;
        if (parentDataEntityRuntime != null) {
            String tag = String.format("%1$s|%2$s", parentDataEntityRuntime.getName(), strAccessAction);
            iPSDEOPPriv = this.psDEOPPrivMap.get(tag);
            if (iPSDEOPPriv != null) {
                return iPSDEOPPriv;
            }
            iPSDEOPPriv = this.getSystemAccessManager().getPSSysDEOPPriv(tag, true);
            if (iPSDEOPPriv != null) {
                return iPSDEOPPriv;
            }
            if (bMustMapMode) {
                return null;
            }
        }
        if ((iPSDEOPPriv = this.psDEOPPrivMap.get(strAccessAction)) == null) {
            iPSDEOPPriv = this.getSystemAccessManager().getPSSysDEOPPriv(strAccessAction, true);
        }
        return iPSDEOPPriv;
    }

    @Override
    public boolean testDataAccessAction(Object objKey, IEntityDTO iEntityDTO, String strAccessAction) throws Exception {
        return this.testDataAccessAction(UserContext.getCurrentMust(), null, null, objKey, iEntityDTO, strAccessAction);
    }

    @Override
    public boolean testDataAccessAction(IUserContext iUserContext, IDataEntityRuntime parentDataEntityRuntime, String strParentKey, Object objKey, IEntityDTO inputEntityDTO, String strAccessAction) throws Exception {
        if (!StringUtils.hasLength((String)strAccessAction)) {
            return false;
        }
        if ("DENY".equalsIgnoreCase(strAccessAction)) {
            return false;
        }
        if ("NONE".equalsIgnoreCase(strAccessAction)) {
            return true;
        }
        IEntityDTO iEntityDTO = null;
        int nDataAccCtrlMode = this.getDataAccCtrlMode();
        if (nDataAccCtrlMode != 0) {
            IPSDEOPPriv iPSDEOPPriv = null;
            switch (nDataAccCtrlMode) {
                case 1: {
                    iPSDEOPPriv = this.getPSDEOPPriv(null, strAccessAction);
                    if (!(iPSDEOPPriv != null && StringUtils.hasLength((String)iPSDEOPPriv.getMapSysUniResCode()) ? !this.getSystemAccessManager().testSysUniRes(iUserContext, iPSDEOPPriv.getMapSysUniResCode(), inputEntityDTO) : !this.onTestDataAccessAction(iUserContext, objKey, inputEntityDTO, strAccessAction))) break;
                    return false;
                }
                case 3: {
                    if (parentDataEntityRuntime != null && (iPSDEOPPriv = this.getPSDEOPPriv(parentDataEntityRuntime, strAccessAction, true)) != null) {
                        if (ObjectUtils.isEmpty((Object)objKey)) {
                            if (inputEntityDTO == null) {
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u672a\u6307\u5b9a\u4f20\u5165\u6570\u636e\u5bf9\u8c61", 2);
                            }
                            Object objParentKey = null;
                            IPSDERBase masterPSDERBase = iPSDEOPPriv.getMapPSDERMust();
                            if (masterPSDERBase instanceof IPSDER1N) {
                                objParentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, (IPSDEField)((IPSDER1N)masterPSDERBase).getPSPickupDEFieldMust());
                            } else if (masterPSDERBase instanceof IPSDERCustom) {
                                objParentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, ((IPSDERCustom)masterPSDERBase).getPickupPSDEFieldMust());
                            }
                            if (ObjectUtils.isEmpty(objParentKey)) {
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u6307\u5b9a\u7236\u6570\u636e", 2);
                            }
                            if (!strParentKey.equals(objParentKey)) {
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u6570\u636e\u5bf9\u8c61\u4e2d\u7236\u6570\u636e\u4e0d\u4e00\u81f4", 2);
                            }
                        } else {
                            iEntityDTO = this.getSimpleEntity(iPSDEOPPriv.getMapPSDERMust(), strParentKey, objKey);
                        }
                        return parentDataEntityRuntime.getDataEntityAccessManager().testDataAccessActionIf(iUserContext, strParentKey, iPSDEOPPriv.getMapPSDEOPPrivName());
                    }
                    iPSDEOPPriv = this.getPSDEOPPriv(null, strAccessAction);
                    if (!(iPSDEOPPriv != null && StringUtils.hasLength((String)iPSDEOPPriv.getMapSysUniResCode()) ? !this.getSystemAccessManager().testSysUniRes(iUserContext, iPSDEOPPriv.getMapSysUniResCode(), inputEntityDTO) : !this.onTestDataAccessAction(iUserContext, objKey, inputEntityDTO, strAccessAction))) break;
                    return false;
                }
                case 2: {
                    if (parentDataEntityRuntime == null) {
                        IEntityDTO simpleEntityDTO = this.getDataEntityRuntime().createEntity();
                        if (ObjectUtils.isEmpty((Object)objKey)) {
                            inputEntityDTO.copyTo(simpleEntityDTO);
                        } else {
                            simpleEntityDTO = this.getSimpleEntity(objKey);
                        }
                        IPSDERBase iPSDERBase = this.getDataEntityRuntime().getMasterPSDER(simpleEntityDTO, true);
                        if (iPSDERBase != null) {
                            IPSPickupDEField pickupPSDEField = null;
                            if (iPSDERBase instanceof IPSDER1N) {
                                pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                            } else if (iPSDERBase instanceof IPSDERCustom) {
                                pickupPSDEField = ((IPSDERCustom)iPSDERBase).getPickupPSDEFieldMust();
                            }
                            if (pickupPSDEField != null) {
                                parentDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId(), false);
                                Object parentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)simpleEntityDTO, (IPSDEField)pickupPSDEField);
                                if (parentKey != null) {
                                    strParentKey = parentKey.toString();
                                }
                            }
                        }
                        if (parentDataEntityRuntime == null) {
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u672a\u6307\u5b9a\u6743\u9650\u63a7\u5236\u5b9e\u4f53", 2);
                        }
                    }
                    IPSDERBase masterPSDERBase = null;
                    iPSDEOPPriv = this.getPSDEOPPriv(parentDataEntityRuntime, strAccessAction, true);
                    String strAction = "UPDATE";
                    if ("READ".equals(strAccessAction)) {
                        strAction = "READ";
                    }
                    if (iPSDEOPPriv != null) {
                        masterPSDERBase = iPSDEOPPriv.getMapPSDERMust();
                        strAction = iPSDEOPPriv.getMapPSDEOPPrivName();
                        if ("DENY".equalsIgnoreCase(strAccessAction)) {
                            return false;
                        }
                    } else {
                        masterPSDERBase = this.getDataEntityRuntime().getMasterPSDER(parentDataEntityRuntime.getId(), false);
                    }
                    if (ObjectUtils.isEmpty((Object)objKey)) {
                        if (inputEntityDTO == null) {
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u672a\u6307\u5b9a\u4f20\u5165\u6570\u636e\u5bf9\u8c61", 2);
                        }
                        Object objParentKey = null;
                        if (masterPSDERBase instanceof IPSDER1N) {
                            objParentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, (IPSDEField)((IPSDER1N)masterPSDERBase).getPSPickupDEFieldMust());
                        } else if (masterPSDERBase instanceof IPSDERCustom) {
                            objParentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, ((IPSDERCustom)masterPSDERBase).getPickupPSDEFieldMust());
                        }
                        if (ObjectUtils.isEmpty(objParentKey)) {
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u6307\u5b9a\u7236\u6570\u636e", 2);
                        }
                        if (!strParentKey.equals(objParentKey)) {
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u6570\u636e\u5bf9\u8c61\u4e2d\u7236\u6570\u636e\u4e0d\u4e00\u81f4", 2);
                        }
                    } else {
                        iEntityDTO = this.getSimpleEntity(masterPSDERBase, strParentKey, objKey);
                    }
                    return parentDataEntityRuntime.getDataEntityAccessManager().testDataAccessActionIf(iUserContext, strParentKey, strAction);
                }
                default: {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u8bbf\u95ee\u63a7\u5236\u6a21\u5f0f[%1$s]", nDataAccCtrlMode), 2);
                }
            }
        }
        return this.getDataEntityRuntime().testDataAccessAction(iEntityDTO == null ? objKey : iEntityDTO, strAccessAction);
    }

    protected boolean onTestDataAccessAction(IUserContext iUserContext, Object objKey, IEntityDTO inputEntityDTO, String strAccessAction) throws Exception {
        return true;
    }

    @Override
    public boolean testDataAccessAction(ISearchContextDTO iSearchContextDTO, String strAccessAction) throws Exception {
        return this.testDataAccessAction(UserContext.getCurrentMust(), null, null, iSearchContextDTO, strAccessAction);
    }

    @Override
    public boolean testDataAccessAction(IUserContext iUserContext, IDataEntityRuntime parentDataEntityRuntime, String strParentKey, ISearchContextDTO iSearchContextDTO, String strAccessAction) throws Exception {
        if (iSearchContextDTO == null) {
            log.warn((Object)String.format("\u672a\u4f20\u5165\u6570\u636e\u8fc7\u6ee4\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5224\u65ad", new Object[0]));
            return false;
        }
        if (!StringUtils.hasLength((String)strAccessAction)) {
            log.warn((Object)String.format("\u672a\u4f20\u5165\u6570\u636e\u8bbf\u95ee\u64cd\u4f5c\uff0c\u65e0\u6cd5\u5224\u65ad", new Object[0]));
            return false;
        }
        if ("DENY".equalsIgnoreCase(strAccessAction)) {
            return false;
        }
        if ("NONE".equalsIgnoreCase(strAccessAction)) {
            return true;
        }
        int nDataAccCtrlMode = this.getDataAccCtrlMode();
        if (nDataAccCtrlMode == 0) {
            return true;
        }
        if (parentDataEntityRuntime == null && (nDataAccCtrlMode == 3 || nDataAccCtrlMode == 2)) {
            Object parentDEName = iSearchContextDTO.get("srfparentdename");
            Object parentKey = iSearchContextDTO.get("srfparentkey");
            if (!ObjectUtils.isEmpty((Object)parentDEName) && !ObjectUtils.isEmpty((Object)parentKey) && (parentDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(parentDEName.toString(), true)) != null) {
                strParentKey = parentKey.toString();
            }
        }
        IPSDEOPPriv iPSDEOPPriv = null;
        switch (nDataAccCtrlMode) {
            case 1: {
                iPSDEOPPriv = this.getPSDEOPPriv(null, strAccessAction);
                if (iPSDEOPPriv != null && StringUtils.hasLength((String)iPSDEOPPriv.getMapSysUniResCode())) {
                    return this.getSystemAccessManager().testSysUniRes(iUserContext, iPSDEOPPriv.getMapSysUniResCode(), null);
                }
                return this.onTestDataAccessAction(iUserContext, null, null, iSearchContextDTO, strAccessAction);
            }
            case 3: {
                if (parentDataEntityRuntime != null && (iPSDEOPPriv = this.getPSDEOPPriv(parentDataEntityRuntime, strAccessAction, true)) != null && parentDataEntityRuntime.getDataEntityAccessManager().testDataAccessActionIf(iUserContext, strParentKey, iPSDEOPPriv.getMapPSDEOPPrivName())) {
                    IPSPickupDEField pickupPSDEField = null;
                    IPSDERBase masterPSDERBase = iPSDEOPPriv.getMapPSDERMust();
                    if (masterPSDERBase instanceof IPSDER1N) {
                        pickupPSDEField = ((IPSDER1N)masterPSDERBase).getPSPickupDEFieldMust();
                    } else if (masterPSDERBase instanceof IPSDERCustom) {
                        pickupPSDEField = ((IPSDERCustom)masterPSDERBase).getPickupPSDEFieldMust();
                    }
                    if (pickupPSDEField == null) {
                        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u63a7\u5236\u5173\u7cfb\u8fde\u63a5\u5c5e\u6027\u65e0\u6548", 2);
                    }
                    Object objParentKey = DataTypeUtils.parse(pickupPSDEField.getStdDataType(), strParentKey);
                    SearchContextDTO.addSearchFieldCondIf(iSearchContextDTO, pickupPSDEField.getLowerCaseName(), "EQ", objParentKey, null);
                    return true;
                }
                iPSDEOPPriv = this.getPSDEOPPriv(null, strAccessAction);
                if (iPSDEOPPriv != null && StringUtils.hasLength((String)iPSDEOPPriv.getMapSysUniResCode())) {
                    return this.getSystemAccessManager().testSysUniRes(iUserContext, iPSDEOPPriv.getMapSysUniResCode(), null);
                }
                return this.onTestDataAccessAction(iUserContext, null, null, iSearchContextDTO, strAccessAction);
            }
            case 2: {
                if (parentDataEntityRuntime == null) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u672a\u6307\u5b9a\u6743\u9650\u63a7\u5236\u5b9e\u4f53", 2);
                }
                IPSDERBase masterPSDERBase = null;
                iPSDEOPPriv = this.getPSDEOPPriv(parentDataEntityRuntime, strAccessAction, true);
                String strAction = "UPDATE";
                if ("READ".equals(strAccessAction)) {
                    strAction = "READ";
                }
                if (iPSDEOPPriv != null) {
                    masterPSDERBase = iPSDEOPPriv.getMapPSDERMust();
                    strAction = iPSDEOPPriv.getMapPSDEOPPrivName();
                    if ("DENY".equalsIgnoreCase(strAccessAction)) {
                        return false;
                    }
                } else {
                    masterPSDERBase = this.getDataEntityRuntime().getMasterPSDER(parentDataEntityRuntime.getId(), false);
                }
                if (parentDataEntityRuntime.getDataEntityAccessManager().testDataAccessActionIf(iUserContext, strParentKey, strAction)) {
                    IPSPickupDEField pickupPSDEField = null;
                    if (masterPSDERBase instanceof IPSDER1N) {
                        pickupPSDEField = ((IPSDER1N)masterPSDERBase).getPSPickupDEFieldMust();
                    } else if (masterPSDERBase instanceof IPSDERCustom) {
                        pickupPSDEField = ((IPSDERCustom)masterPSDERBase).getPickupPSDEFieldMust();
                    }
                    if (pickupPSDEField == null) {
                        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), "\u63a7\u5236\u5173\u7cfb\u8fde\u63a5\u5c5e\u6027\u65e0\u6548", 2);
                    }
                    Object objParentKey = DataTypeUtils.parse(pickupPSDEField.getStdDataType(), strParentKey);
                    SearchContextDTO.addSearchFieldCondIf(iSearchContextDTO, pickupPSDEField.getLowerCaseName(), "EQ", objParentKey, null);
                    return true;
                }
                return false;
            }
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u8bbf\u95ee\u63a7\u5236\u6a21\u5f0f[%1$s]", nDataAccCtrlMode), 2);
    }

    protected boolean onTestDataAccessAction(IUserContext iUserContext, IDataEntityRuntime parentDataEntityRuntime, String strParentKey, ISearchContextDTO iSearchContextDTO, String strAccessAction) throws Exception {
        return true;
    }

    @Override
    public int getDataAccCtrlMode() {
        return this.nDataAccCtrlMode;
    }

    @Override
    public ISystemAccessManager getSystemAccessManager() {
        return this.iSystemAccessManager;
    }

    protected IEntityDTO getSimpleEntity(IPSDERBase iPSDERBase, String strParentKey, Object objKey) throws Exception {
        IPSPickupDEField iPSDEField = null;
        if (iPSDERBase instanceof IPSDER1N) {
            iPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
        } else if (iPSDERBase instanceof IPSDERCustom) {
            iPSDEField = ((IPSDERCustom)iPSDERBase).getPickupPSDEFieldMust();
        } else {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u4ece\u5b9e\u4f53\u5173\u7cfb[%1$s]\u83b7\u53d6\u8fde\u63a5\u5c5e\u6027", iPSDERBase.getName()));
        }
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        Object objParentKey = this.getDataEntityRuntime().getSystemRuntime().convertValue(iPSDEField.getStdDataType(), strParentKey);
        if (objKey instanceof String && !DataTypeUtils.isStringDataType(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType())) {
            objKey = this.getDataEntityRuntime().getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), (String)objKey);
        }
        SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getName(), "EQ", objParentKey, null);
        SearchContextDTO.addSearchFieldCond(iSearchContextDTO, this.getDataEntityRuntime().getKeyPSDEField().getName(), "EQ", objKey, null);
        List<IEntityDTO> iEntityDTO = this.getDataEntityRuntime().selectSimple(iSearchContextDTO);
        if (iEntityDTO == null || iEntityDTO.size() == 0) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u6307\u5b9a\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]), 2);
        }
        return iEntityDTO.get(0);
    }

    protected IEntityDTO getSimpleEntity(Object objKey) throws Exception {
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        if (objKey instanceof String && !DataTypeUtils.isStringDataType(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType())) {
            objKey = this.getDataEntityRuntime().getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), (String)objKey);
        }
        SearchContextDTO.addSearchFieldCond(iSearchContextDTO, this.getDataEntityRuntime().getKeyPSDEField().getName(), "EQ", objKey, null);
        List<IEntityDTO> iEntityDTO = this.getDataEntityRuntime().selectSimple(iSearchContextDTO);
        if (iEntityDTO == null || iEntityDTO.size() == 0) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u6307\u5b9a\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]), 2);
        }
        return iEntityDTO.get(0);
    }

    @Override
    public List<IDEUserRoleRuntime> getDefaultDEUserRoleRuntimes() {
        if (this.defaultDEUserRoleRuntimeList == null || this.defaultDEUserRoleRuntimeList.size() == 0) {
            return null;
        }
        return this.defaultDEUserRoleRuntimeList;
    }

    @Override
    public IDEUserRoleRuntime getDEUserRoleRuntime(String strUserRoleTag, boolean bTryMode) {
        IDEUserRoleRuntime iDEUserRoleRuntime = null;
        if (this.deUserRoleRuntimeMap != null) {
            iDEUserRoleRuntime = this.deUserRoleRuntimeMap.get(strUserRoleTag);
        }
        if (iDEUserRoleRuntime != null || bTryMode) {
            return iDEUserRoleRuntime;
        }
        throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u89d2\u8272\u6a21\u578b\u5bf9\u8c61[%1$s]", strUserRoleTag));
    }

    @Override
    public boolean testDataAccessActionIf(IUserContext iUserContext, Object objKey, String strAccessAction) throws Exception {
        if (this.getDataAccCtrlMode() == 3 || this.getDataAccCtrlMode() == 2) {
            IEntityDTO iEntityDTO = this.getSimpleEntity(objKey);
            IPSDERBase iPSDERBase = this.getDataEntityRuntime().getMasterPSDER(iEntityDTO, true);
            if (iPSDERBase != null) {
                Object parentKey = null;
                if (iPSDERBase instanceof IPSDER1N) {
                    parentKey = iEntityDTO.get(((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust().getLowerCaseName());
                } else if (iPSDERBase instanceof IPSDERCustom) {
                    parentKey = iEntityDTO.get(((IPSDERCustom)iPSDERBase).getPickupPSDEFieldMust().getLowerCaseName());
                }
                if (!ObjectUtils.isEmpty(parentKey)) {
                    return this.testDataAccessAction(iUserContext, this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId()), parentKey.toString(), objKey, null, strAccessAction);
                }
            }
        }
        return this.testDataAccessAction(iUserContext, null, null, objKey, null, strAccessAction);
    }
}

