/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.search;

import java.util.LinkedHashMap;
import java.util.List;
import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.search.IDESearchRuntime;
import net.ibizsys.central.search.ISysSearchSchemeRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.search.IPSDESearch;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.search.IPSSysSearchDEField;
import net.ibizsys.model.search.IPSSysSearchDoc;
import net.ibizsys.model.search.IPSSysSearchField;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DESearchRuntimeBase
extends DataEntityModelRuntimeBase
implements IDESearchRuntime {
    private static final Log log = LogFactory.getLog(DESearchRuntimeBase.class);
    private IPSDESearch iPSDESearch = null;
    private ISysSearchSchemeRuntime iSysSearchSchemeRuntime = null;
    private boolean bThreadMode = true;
    private IPSSysSearchDoc iPSSysSearchDoc = null;

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDESearch iPSDESearch) throws Exception {
        this.setDataEntityRuntimeBase(iDataEntityRuntimeContext.getDataEntityRuntime());
        this.setPSDESearch(iPSDESearch);
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.iPSSysSearchDoc = this.getPSDESearch().getPSSysSearchDEMust().getPSSysSearchDocMust();
        if (ObjectUtils.isEmpty((Object)this.getPSDESearch().getPSSysSearchDEMust().getAllPSSysSearchDEFields())) {
            throw new Exception(String.format("\u672a\u5b9a\u4e49\u68c0\u7d22\u5b9e\u4f53\u5c5e\u6027", new Object[0]));
        }
        this.iSysSearchSchemeRuntime = this.getSystemRuntime().getSysSearchSchemeRuntime(this.getPSDESearch().getPSSysSearchSchemeMust());
        super.onInit();
    }

    @Override
    public IPSDESearch getPSDESearch() {
        return this.iPSDESearch;
    }

    protected void setPSDESearch(IPSDESearch iPSDESearch) {
        this.iPSDESearch = iPSDESearch;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDESearch();
    }

    @Override
    public ISysSearchSchemeRuntime getSysSearchSchemeRuntime() {
        return this.iSysSearchSchemeRuntime;
    }

    protected IPSSysSearchDoc getPSSysSearchDoc() {
        return this.iPSSysSearchDoc;
    }

    protected boolean isThreadMode() {
        return this.bThreadMode;
    }

    @Override
    public void syncEntity(final int nEvent, final Object arg0) {
        try {
            if (this.isThreadMode()) {
                this.getSystemRuntime().threadRun(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DESearchRuntimeBase.this.onSyncEntity(nEvent, arg0);
                        }
                        catch (Throwable ex) {
                            log.error((Object)String.format("\u540c\u6b65\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                        }
                    }
                });
            } else {
                this.onSyncEntity(nEvent, arg0);
            }
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u540c\u6b65\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onSyncEntity(int nEvent, Object arg0) throws Throwable {
        switch (nEvent) {
            case 1: {
                IEntityDTO iEntityDTO = null;
                if (arg0 instanceof IEntityDTO) {
                    iEntityDTO = (IEntityDTO)arg0;
                }
                if (iEntityDTO == null) {
                    throw new Exception(String.format("\u4f20\u5165\u6570\u636e\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
                }
                this.onCreateEntity(iEntityDTO);
                break;
            }
            case 2: {
                IEntityDTO iEntityDTO = null;
                if (arg0 instanceof IEntityDTO) {
                    iEntityDTO = (IEntityDTO)arg0;
                }
                if (iEntityDTO == null) {
                    throw new Exception(String.format("\u4f20\u5165\u6570\u636e\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
                }
                this.onUpdateEntity(iEntityDTO);
                break;
            }
            case 4: {
                this.onRemoveEntity(arg0);
                break;
            }
        }
    }

    protected void onCreateEntity(IEntityDTO iEntityDTO) throws Throwable {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List psSysSearchDEFieldList = this.getPSDESearch().getPSSysSearchDEMust().getAllPSSysSearchDEFields();
        if (ObjectUtils.isEmpty((Object)psSysSearchDEFieldList)) {
            return;
        }
        for (IPSSysSearchDEField iPSSysSearchDEField : psSysSearchDEFieldList) {
            IPSSysSearchField iPSSysSearchField = iPSSysSearchDEField.getPSSysSearchFieldMust();
            IPSDEField iPSDEField = iPSSysSearchDEField.getPSDEField();
            Object value = null;
            if (iPSDEField != null) {
                if (iEntityDTO.contains(iPSDEField.getLowerCaseName())) {
                    value = iEntityDTO.get(iPSDEField.getLowerCaseName());
                } else if (StringUtils.hasLength((String)iPSSysSearchDEField.getDefaultValueType()) || StringUtils.hasLength((String)iPSSysSearchDEField.getDefaultValue())) {
                    value = this.getDataEntityRuntime().getDefaultValue(iPSSysSearchDEField.getDefaultValueType(), iPSSysSearchDEField.getDefaultValue(), iEntityDTO, iPSSysSearchField.getStdDataType());
                }
            } else if (StringUtils.hasLength((String)iPSSysSearchDEField.getDefaultValueType()) || StringUtils.hasLength((String)iPSSysSearchDEField.getDefaultValue())) {
                value = this.getDataEntityRuntime().getDefaultValue(iPSSysSearchDEField.getDefaultValueType(), iPSSysSearchDEField.getDefaultValue(), iEntityDTO, iPSSysSearchField.getStdDataType());
            }
            IPSSysTranslator iPSSysTranslator = iPSSysSearchDEField.getPSSysTranslator();
            if (iPSSysTranslator != null) {
                value = this.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator).translate(value, false, iEntityDTO, iPSDEField, this.getDataEntityRuntime());
            }
            map.put(iPSSysSearchField.getName(), value);
        }
        if (!map.containsKey("srfkey")) {
            Object value = iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName());
            map.put("srfkey", this.getUniqueId(value));
        }
        this.getSysSearchSchemeRuntime().insert(this.getPSSysSearchDoc().getName(), map, null);
    }

    protected void onUpdateEntity(IEntityDTO iEntityDTO) throws Throwable {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List psSysSearchDEFieldList = this.getPSDESearch().getPSSysSearchDEMust().getAllPSSysSearchDEFields();
        if (ObjectUtils.isEmpty((Object)psSysSearchDEFieldList)) {
            return;
        }
        for (IPSSysSearchDEField iPSSysSearchDEField : psSysSearchDEFieldList) {
            IPSSysSearchField iPSSysSearchField = iPSSysSearchDEField.getPSSysSearchFieldMust();
            IPSDEField iPSDEField = iPSSysSearchDEField.getPSDEField();
            Object value = null;
            if (iPSDEField == null || !iEntityDTO.contains(iPSDEField.getLowerCaseName())) continue;
            value = iEntityDTO.get(iPSDEField.getLowerCaseName());
            IPSSysTranslator iPSSysTranslator = iPSSysSearchDEField.getPSSysTranslator();
            if (iPSSysTranslator != null) {
                value = this.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator).translate(value, false, iEntityDTO, iPSDEField, this.getDataEntityRuntime());
            }
            map.put(iPSSysSearchField.getName(), value);
        }
        if (!map.containsKey("srfkey")) {
            Object value = iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName());
            map.put("srfkey", this.getUniqueId(value));
        }
        this.getSysSearchSchemeRuntime().update(this.getPSSysSearchDoc().getName(), map, null, true);
    }

    protected void onRemoveEntity(Object obj) throws Throwable {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Object key = null;
        key = obj instanceof IEntityDTO ? ((IEntityDTO)obj).get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()) : obj;
        if (ObjectUtils.isEmpty((Object)key)) {
            return;
        }
        List psSysSearchDEFieldList = this.getPSDESearch().getPSSysSearchDEMust().getAllPSSysSearchDEFields();
        if (!ObjectUtils.isEmpty((Object)psSysSearchDEFieldList)) {
            for (IPSSysSearchDEField iPSSysSearchDEField : psSysSearchDEFieldList) {
                IPSSysSearchField iPSSysSearchField = iPSSysSearchDEField.getPSSysSearchFieldMust();
                if (iPSSysSearchField.isPKey()) {
                    map.put(iPSSysSearchField.getName(), key);
                    continue;
                }
                IPSDEField iPSDEField = iPSSysSearchDEField.getPSDEField();
                if (iPSDEField == null || !iPSDEField.isKeyDEField()) continue;
                map.put(iPSSysSearchField.getName(), key);
            }
        }
        if (!map.containsKey("srfkey")) {
            map.put("srfkey", this.getUniqueId(key));
        }
        this.getSysSearchSchemeRuntime().delete(this.getPSSysSearchDoc().getName(), map, null);
    }

    protected String getUniqueId(Object id) {
        return KeyValueUtils.genUniqueId(this.getDataEntityRuntime().getName(), id);
    }
}

