/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.report;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.dataentity.report.IDEReportRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.report.DEReportRuntime;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class DEReportRuntimeBase
extends DEReportRuntime
implements IDEReportRuntime {
    private static final Log log = LogFactory.getLog(DEReportRuntimeBase.class);
    private String strReportFilePath = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (!StringUtils.hasLength((String)this.getReportFilePath())) {
            this.prepareReportFilePath();
        }
    }

    @Override
    protected String getReportFilePath() {
        return this.strReportFilePath;
    }

    protected void setReportFilePath(String strReportFilePath) {
        this.strReportFilePath = strReportFilePath;
    }

    protected void prepareReportFilePath() throws Exception {
        String strReportFilePath = this.getPSDEReport().getReportFile();
        if (!StringUtils.hasLength((String)strReportFilePath)) {
            return;
        }
        String strReportFilePath2 = strReportFilePath.toLowerCase();
        if (strReportFilePath2.indexOf("http://") == 0 || strReportFilePath2.indexOf("https://") == 0) {
            File tempFile = File.createTempFile("dereport", this.getDefaultReportFileSuffix());
            try {
                this.getSystemRuntime().getDefaultWebClient().download(strReportFilePath, null, null, null, tempFile, null);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u4e0b\u8f7d\u8fdc\u7a0b\u62a5\u8868\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.setReportFilePath(tempFile.getCanonicalPath());
        } else {
            if (!StringUtils.hasLength((String)this.getSystemRuntime().getReportFolder())) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u62a5\u8868\u5b58\u50a8\u6587\u4ef6\u5939", new Object[0]));
            }
            File file = new File(this.getSystemRuntime().getReportFolder() + strReportFilePath);
            if (!file.exists()) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u6307\u5b9a\u62a5\u8868\u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]));
            }
            this.setReportFilePath(file.getCanonicalPath());
        }
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
        return (IDynaInstDataEntityRuntime)super.getDynaInstDataEntityRuntime();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public IDynaInstRuntime getDynaInstRuntime() {
        return (IDynaInstRuntime)super.getDynaInstRuntime();
    }

    protected String getDefaultReportFileSuffix() {
        return null;
    }

    @Override
    public void output(ServletResponse servletResponse, ISearchContext iSearchContext, String strType, boolean bTestPriv) throws Throwable {
        try {
            this.onOutput(servletResponse, iSearchContext, strType, bTestPriv);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u8f93\u51fa\u62a5\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onOutput(ServletResponse servletResponse, ISearchContext iSearchContext, String strType, boolean bTestPriv) throws Throwable {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.output(bos, (ISearchContextBase)iSearchContext, strType, bTestPriv);
        this.outputContentType(servletResponse, strType, null);
        bos.writeTo((OutputStream)servletResponse.getOutputStream());
    }

    protected void outputContentType(ServletResponse servletResponse, String strType, String strFileName) throws Exception {
        if (StringUtils.hasLength((String)strType)) {
            PSModelEnums.ReportContentType reportContentType = PSModelEnums.ReportContentType.from((String)strType.toUpperCase());
            DEReportRuntimeBase.outputContentType(servletResponse, reportContentType);
            if (!StringUtils.hasLength((String)strFileName)) {
                switch (reportContentType) {
                    case DOCX: {
                        strFileName = "report.docx";
                        break;
                    }
                    case PDF: {
                        strFileName = "report.pdf";
                        break;
                    }
                }
            }
        }
        if (!StringUtils.hasLength((String)strFileName)) {
            return;
        }
        if (servletResponse instanceof HttpServletResponse) {
            String strFileName2 = new String(URLEncoder.encode(strFileName, "utf-8").getBytes("utf-8"), "iso8859-1");
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "0");
            httpServletResponse.setHeader("charset", "utf-8");
            if (StringUtils.hasLength((String)strFileName)) {
                httpServletResponse.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", strFileName2, URLEncoder.encode(strFileName, "utf-8")));
            }
        }
    }

    public static void outputContentType(ServletResponse servletResponse, PSModelEnums.ReportContentType reportContentType) {
        switch (reportContentType) {
            case DOCX: {
                servletResponse.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                break;
            }
            case PDF: {
                servletResponse.setContentType("application/pdf");
                break;
            }
            case HTML: {
                servletResponse.setContentType("text/html");
                break;
            }
            case JSON: {
                servletResponse.setContentType("application/json");
                break;
            }
            case XML: {
                servletResponse.setContentType("application/xml");
                break;
            }
            case TEXT: {
                servletResponse.setContentType("text/plain");
                break;
            }
            default: {
                log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u7c7b\u578b[%1$s]", reportContentType.value));
            }
        }
    }

    @Override
    protected void onOutput(OutputStream outputStream, Object data, ISearchContextBase iSearchContextBase, String strType) throws Throwable {
        this.onOutput(outputStream, data, (ISearchContext)iSearchContextBase, strType);
    }

    protected void onOutput(OutputStream outputStream, Object data, ISearchContext iSearchContext, String strType) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

