/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.ds;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.ds.DEDataSetRuntimeBase;
import net.ibizsys.central.dataentity.ds.IDEGroupDataSetRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.der.IPSDERAggDataDEFieldMap;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetGroupParam;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEGroupDataSetRuntimeBase
extends DEDataSetRuntimeBase
implements IDEGroupDataSetRuntime {
    private Map<String, IPSDEDataSetGroupParam> psDEDataSetGroupParamMap = null;
    private Map<String, IPSDERAggDataDEFieldMap> psDERAggDataDEFieldMapMap = null;
    private Map<String, IPSDERAggDataDEFieldMap> timeGroupPSDERAggDataDEFieldMapMap = null;
    private Map<String, IPSDERAggDataDEFieldMap> metricPSDERAggDataDEFieldMapMap = null;
    private Map<String, IPSDERAggDataDEFieldMap> popPSDERAggDataDEFieldMapMap = null;
    private List<String> timeGroupList = null;
    private static final String[] TimeGroups = new String[]{"GROUPBY_YEAR", "GROUPBY_QUARTER", "GROUPBY_MONTH", "GROUPBY_DAYOFMONTH"};

    @Override
    protected void onInit() throws Exception {
        if (!ObjectUtils.isEmpty((Object)this.getPSDEDataSet().getPSDEDataSetGroupParams())) {
            this.psDEDataSetGroupParamMap = new HashMap<String, IPSDEDataSetGroupParam>();
            for (IPSDEDataSetGroupParam iPSDEDataSetGroupParam : this.getPSDEDataSet().getPSDEDataSetGroupParams()) {
                this.psDEDataSetGroupParamMap.put(iPSDEDataSetGroupParam.getName().toUpperCase(), iPSDEDataSetGroupParam);
            }
        }
        if (this.getPSDEDataSet().getPSDERAggData() != null && !ObjectUtils.isEmpty((Object)this.getPSDEDataSet().getPSDERAggData().getPSDERAggDataDEFieldMaps())) {
            this.psDERAggDataDEFieldMapMap = new HashMap<String, IPSDERAggDataDEFieldMap>();
            this.timeGroupPSDERAggDataDEFieldMapMap = new HashMap<String, IPSDERAggDataDEFieldMap>();
            this.popPSDERAggDataDEFieldMapMap = new HashMap<String, IPSDERAggDataDEFieldMap>();
            this.metricPSDERAggDataDEFieldMapMap = new HashMap<String, IPSDERAggDataDEFieldMap>();
            for (IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap : this.getPSDEDataSet().getPSDERAggData().getPSDERAggDataDEFieldMaps()) {
                if (this.psDEDataSetGroupParamMap != null && !this.psDEDataSetGroupParamMap.containsKey(iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getName())) continue;
                this.psDERAggDataDEFieldMapMap.put(iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getName(), iPSDERAggDataDEFieldMap);
                String strMapType = iPSDERAggDataDEFieldMap.getMapType();
                if (strMapType.equals("AVG") || strMapType.equals("COUNT") || strMapType.equals("MAX") || strMapType.equals("MIN") || strMapType.equals("SUM")) {
                    this.metricPSDERAggDataDEFieldMapMap.put(iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName(), iPSDERAggDataDEFieldMap);
                    String strMajorFieldName = iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getName();
                    String strMajorFieldName__YOY = String.format("%1$s__YOY", strMajorFieldName);
                    if (this.getDataEntityRuntime().getPSDEField(strMajorFieldName__YOY, true) != null) {
                        this.popPSDERAggDataDEFieldMapMap.put(strMajorFieldName__YOY, iPSDERAggDataDEFieldMap);
                    }
                    String strMajorFieldName__POP = String.format("%1$s__POP", strMajorFieldName);
                    if (this.getDataEntityRuntime().getPSDEField(strMajorFieldName__POP, true) != null) {
                        this.popPSDERAggDataDEFieldMapMap.put(strMajorFieldName__POP, iPSDERAggDataDEFieldMap);
                    }
                }
                if (!strMapType.equals("GROUPBY_DAYOFMONTH") && !strMapType.equals("GROUPBY_DAYOFWEEK") && !strMapType.equals("GROUPBY_DAYOFYEAR") && !strMapType.equals("GROUPBY_HOUR") && !strMapType.equals("GROUPBY_MINUTE") && !strMapType.equals("GROUPBY_MONTH") && !strMapType.equals("GROUPBY_QUARTER") && !strMapType.equals("GROUPBY_WEEK") && !strMapType.equals("GROUPBY_YEAR")) continue;
                this.timeGroupPSDERAggDataDEFieldMapMap.put(strMapType, iPSDERAggDataDEFieldMap);
            }
            if (ObjectUtils.isEmpty(this.timeGroupPSDERAggDataDEFieldMapMap)) {
                this.timeGroupPSDERAggDataDEFieldMapMap = null;
            }
            if (ObjectUtils.isEmpty(this.popPSDERAggDataDEFieldMapMap)) {
                this.popPSDERAggDataDEFieldMapMap = null;
            }
            if (this.timeGroupPSDERAggDataDEFieldMapMap != null) {
                this.timeGroupList = new ArrayList<String>();
                for (String strTimeGroup : TimeGroups) {
                    if (!this.timeGroupPSDERAggDataDEFieldMapMap.containsKey(strTimeGroup)) continue;
                    this.timeGroupList.add(strTimeGroup);
                }
                if (ObjectUtils.isEmpty(this.timeGroupList)) {
                    this.timeGroupList = null;
                }
            }
        }
        super.onInit();
    }

    @Override
    public Object fetch(Object[] args) throws Throwable {
        String strSearchMode;
        Object objYear;
        int nYear;
        IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap;
        Page page;
        ISearchContext iSearchContext = (ISearchContext)args[0];
        Object result = this.onFetch(iSearchContext);
        if (!(StringUtils.hasLength((String)iSearchContext.getDrillDownCond()) || ObjectUtils.isEmpty(this.popPSDERAggDataDEFieldMapMap) || ObjectUtils.isEmpty(this.timeGroupPSDERAggDataDEFieldMapMap) || ObjectUtils.isEmpty(this.timeGroupList) || !(result instanceof Page) || ObjectUtils.isEmpty((Object)(page = (Page)result).getContent()) || (iPSDERAggDataDEFieldMap = this.timeGroupPSDERAggDataDEFieldMapMap.get("GROUPBY_YEAR")) == null || (nYear = DataTypeUtils.getIntegerValue(objYear = iSearchContext.get(strSearchMode = String.format("n_%1$s_eq", iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName())), -1).intValue()) == -1)) {
            IEntityDTO iEntityDTO;
            Page page2;
            HashMap<String, Object> metricMap = new HashMap<String, Object>();
            for (Object item : page.getContent()) {
                if (!(item instanceof IEntityDTO)) continue;
                IEntityDTO iEntityDTO2 = (IEntityDTO)item;
                for (Map.Entry<String, IPSDERAggDataDEFieldMap> metric : this.metricPSDERAggDataDEFieldMapMap.entrySet()) {
                    this.fillMetricMap(metricMap, iEntityDTO2, metric.getValue());
                }
            }
            iSearchContext.set(strSearchMode, nYear - 1);
            Object result2 = this.onFetch(iSearchContext);
            if (result2 instanceof Page && !ObjectUtils.isEmpty((Object)(page2 = (Page)result2).getContent())) {
                for (Object e : page2.getContent()) {
                    if (!(e instanceof IEntityDTO)) continue;
                    iEntityDTO = (IEntityDTO)e;
                    for (Map.Entry<String, IPSDERAggDataDEFieldMap> metric : this.metricPSDERAggDataDEFieldMapMap.entrySet()) {
                        this.fillMetricMap(metricMap, iEntityDTO, metric.getValue());
                    }
                }
            }
            iSearchContext.set(strSearchMode, objYear);
            HashMap timeMap = new HashMap();
            for (Object e : page.getContent()) {
                if (!(e instanceof IEntityDTO)) continue;
                iEntityDTO = (IEntityDTO)e;
                Long nTime = this.getEntityTime(iEntityDTO);
                timeMap.put(e, nTime);
            }
            for (Map.Entry entry : this.popPSDERAggDataDEFieldMapMap.entrySet()) {
                String strMetricName = ((String)entry.getKey()).toLowerCase();
                IPSDERAggDataDEFieldMap metricPSDERAggDataDEFieldMap = (IPSDERAggDataDEFieldMap)entry.getValue();
                String strPOPMode = strMetricName.toUpperCase().replace(metricPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getName() + "__", "");
                for (Object item : page.getContent()) {
                    if (!(item instanceof IEntityDTO)) continue;
                    IEntityDTO iEntityDTO3 = (IEntityDTO)item;
                    Long nTime = (Long)timeMap.get(item);
                    if (nTime == null) continue;
                    Object objValue = this.getPOPMetricValue(metricMap, nTime, metricPSDERAggDataDEFieldMap, strPOPMode);
                    iEntityDTO3.set(strMetricName, objValue);
                }
            }
        }
        return result;
    }

    protected Long getEntityTime(IEntityDTO iEntityDTO) throws Throwable {
        IPSDERAggDataDEFieldMap yearPSDERAggDataDEFieldMap = this.timeGroupPSDERAggDataDEFieldMapMap.get("GROUPBY_YEAR");
        if (yearPSDERAggDataDEFieldMap == null) {
            return null;
        }
        Object objYear = iEntityDTO.get(yearPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName());
        int nYear = DataTypeUtils.getIntegerValue(objYear, -1);
        if (nYear == -1) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(nYear, 0, 1, 0, 0, 0);
        int nMonth = -1;
        int nDay = -1;
        for (String strGroupTag : this.timeGroupList) {
            IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap;
            if ("GROUPBY_YEAR".equals(strGroupTag) || (iPSDERAggDataDEFieldMap = this.timeGroupPSDERAggDataDEFieldMapMap.get(strGroupTag)) == null) continue;
            Object objValue = iEntityDTO.get(iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName());
            int nValue = DataTypeUtils.getIntegerValue(objValue, -1);
            if (nValue == -1) {
                return null;
            }
            if ("GROUPBY_QUARTER".equals(strGroupTag)) {
                nMonth = (nValue - 1) * 3 + 1;
                continue;
            }
            if ("GROUPBY_MONTH".equals(strGroupTag)) {
                nMonth = nValue;
                continue;
            }
            if (!"GROUPBY_DAYOFMONTH".equals(strGroupTag)) continue;
            nDay = nValue;
        }
        if (nMonth != -1) {
            calendar.set(2, nMonth - 1);
        }
        if (nDay != -1) {
            calendar.set(5, nDay);
        }
        return calendar.getTimeInMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getPOPMetricValue(Map<String, Object> metricMap, long nTime, IPSDERAggDataDEFieldMap metricPSDERAggDataDEFieldMap, String strPOPMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(nTime);
        if ("YOY".equals(strPOPMode)) {
            calendar.add(1, -1);
        } else {
            if (!"POP".equals(strPOPMode)) return null;
            String strLastGroup = this.timeGroupList.get(this.timeGroupList.size() - 1);
            if ("GROUPBY_YEAR".equals(strLastGroup)) {
                calendar.add(1, -1);
            } else if ("GROUPBY_QUARTER".equals(strLastGroup)) {
                calendar.add(2, -3);
            } else if ("GROUPBY_MONTH".equals(strLastGroup)) {
                calendar.add(2, -1);
            } else {
                if (!"GROUPBY_DAYOFMONTH".equals(strLastGroup)) return null;
                calendar.add(5, -1);
            }
        }
        String strMetricName = metricPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName();
        StringBuilder sb = new StringBuilder();
        for (String strGroupTag : this.timeGroupList) {
            IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap = this.timeGroupPSDERAggDataDEFieldMapMap.get(strGroupTag);
            if (iPSDERAggDataDEFieldMap == null) continue;
            Integer objValue = null;
            if ("GROUPBY_YEAR".equals(strGroupTag)) {
                objValue = calendar.get(1);
            } else if ("GROUPBY_QUARTER".equals(strGroupTag)) {
                int nMonth = calendar.get(2) + 1;
                objValue = (nMonth - 1) / 3 + 1;
            } else if ("GROUPBY_MONTH".equals(strGroupTag)) {
                objValue = calendar.get(2) + 1;
            } else {
                if (!"GROUPBY_DAYOFMONTH".equals(strGroupTag)) return null;
                objValue = calendar.get(5);
            }
            sb.append(String.format("%1$s|", objValue));
        }
        sb.append(strMetricName);
        return metricMap.get(sb.toString());
    }

    protected void fillMetricMap(Map<String, Object> metricMap, IEntityDTO iEntityDTO, IPSDERAggDataDEFieldMap metricPSDERAggDataDEFieldMap) {
        String strMetricName = metricPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName();
        StringBuilder sb = new StringBuilder();
        for (String strGroupTag : this.timeGroupList) {
            IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap = this.timeGroupPSDERAggDataDEFieldMapMap.get(strGroupTag);
            if (iPSDERAggDataDEFieldMap == null) continue;
            Object objValue = iEntityDTO.get(iPSDERAggDataDEFieldMap.getMajorPSDEFieldMust().getLowerCaseName());
            sb.append(String.format("%1$s|", objValue));
        }
        sb.append(strMetricName);
        metricMap.put(sb.toString(), iEntityDTO.get(strMetricName));
    }

    @Override
    public IPSDEDataSetGroupParam getPSDEDataSetGroupParam(String strName, boolean bTryMode) {
        Assert.notNull((Object)strName, (String)"\u4f20\u5165\u5206\u7ec4\u53c2\u6570\u540d\u79f0\u65e0\u6548");
        IPSDEDataSetGroupParam iPSDEDataSetGroupParam = null;
        if (this.psDEDataSetGroupParamMap != null) {
            iPSDEDataSetGroupParam = this.psDEDataSetGroupParamMap.get(strName.toUpperCase());
        }
        if (iPSDEDataSetGroupParam != null || bTryMode) {
            return iPSDEDataSetGroupParam;
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5206\u7ec4\u53c2\u6570[%1$s]", strName));
    }

    @Override
    public IPSDERAggDataDEFieldMap getPSDERAggDataDEFieldMapByMajorField(String strName, boolean bTryMode) {
        Assert.notNull((Object)strName, (String)"\u4f20\u5165\u4e3b\u5c5e\u6027\u540d\u79f0\u65e0\u6548");
        IPSDERAggDataDEFieldMap iPSDERAggDataDEFieldMap = null;
        if (this.psDEDataSetGroupParamMap != null) {
            iPSDERAggDataDEFieldMap = this.psDERAggDataDEFieldMapMap.get(strName.toUpperCase());
        }
        if (iPSDERAggDataDEFieldMap != null || bTryMode) {
            return iPSDERAggDataDEFieldMap;
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u805a\u5408\u6570\u636e\u5173\u7cfb\u5c5e\u6027\u6620\u5c04[%1$s]", strName));
    }

    @Override
    public boolean hasPSDEDataSetGroupParams() {
        return ObjectUtils.isEmpty(this.psDEDataSetGroupParamMap);
    }
}

