/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database.mssql;

import net.ibizsys.central.database.DBDialectBase;
import net.ibizsys.central.util.ISearchContext;

public class MSSQLDialect
extends DBDialectBase {
    @Override
    public String getDBType() {
        return "SQLSERVER";
    }

    @Override
    public String getDBObjStandardName(String strOriginName) throws Throwable {
        String[] items = strOriginName.split("[.]");
        if (items.length == 1) {
            return String.format("[%1$s]", strOriginName);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(String.format("[%1$s]", items[i]));
        }
        return sb.toString();
    }

    @Override
    protected String getStringConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (bParam) {
            if ("LIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE '%%' + UPPER(%2$s) + '%%'", strFieldName, objValueOrParam);
            }
            if ("LEFTLIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE UPPER(%2$s) + '%%'", strFieldName, objValueOrParam);
            }
            if ("RIGHTLIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE '%%' + UPPER(%2$s)", strFieldName, objValueOrParam);
            }
        }
        return super.getStringConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
    }
}

