/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemPersistentAdapterBase;
import net.ibizsys.central.database.DBDialectUtils;
import net.ibizsys.central.database.ISysDBPersistentAdapter;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.central.util.IEntity;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupObjectDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.der.IPSDERMultiInherit;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SqlParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysDBPersistentAdapter
extends SystemPersistentAdapterBase
implements ISysDBPersistentAdapter {
    private static final Log log = LogFactory.getLog(SysDBPersistentAdapter.class);
    private ISysDBSchemeRuntime iSysDBSchemeRuntime = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, ISysDBSchemeRuntime iSysDBSchemeRuntime) throws Exception {
        Assert.notNull((Object)iSysDBSchemeRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u5e93\u4f53\u7cfb\u65e0\u6548");
        this.iSysDBSchemeRuntime = iSysDBSchemeRuntime;
        super.init(iSystemRuntimeContext);
    }

    @Override
    public ISysDBSchemeRuntime getSysDBSchemeRuntime() {
        return this.iSysDBSchemeRuntime;
    }

    @Override
    public String getDBType() {
        return this.getSysDBSchemeRuntime().getDBType();
    }

    @Override
    public Object create(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, IEntity iEntity, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        List<IPSDERMultiInherit> psDERMultiInheritList;
        IPSLinkDEField iPSLinkDEField;
        IEntityDTO majorEntity;
        IDataEntityRuntime majorDataEntityRuntime;
        List psDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (ObjectUtils.isEmpty((Object)psDEFieldList)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u4efb\u4f55\u5c5e\u6027", new Object[0]));
        }
        Object objKeyValue = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
        if (!iDataEntityRuntime.isVirtual() || iDataEntityRuntime.getVirtualMode() == 4) {
            List psDEMethodDTOFieldList;
            IEntityDTO iEntityDTO;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (IPSDEField iPSDEField : psDEFieldList) {
                if (!iPSDEField.isPhisicalDEField() || !iEntity.contains(iPSDEField.getLowerCaseName())) continue;
                Object objValue = iEntity.get(iPSDEField.getLowerCaseName());
                if (objValue != null && DataTypeUtils.isStringDataType(iPSDEField.getStdDataType()) && !(objValue instanceof String)) {
                    objValue = JsonUtils.toString(objValue);
                }
                map.put(iPSDEField.getLowerCaseName(), objValue);
            }
            HashMap<String, Object> extParamMap = null;
            if (!bSysMode) {
                IPSDEField iPSDEField;
                if (extParamMap == null) {
                    extParamMap = new HashMap<String, Object>();
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
            }
            if (iDataEntityRuntime.isEnableLogicValid()) {
                if (extParamMap == null) {
                    extParamMap = new HashMap();
                }
                extParamMap.put(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), iDataEntityRuntime.getValidLogicValue());
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                majorDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime();
                majorEntity = majorDataEntityRuntime.createEntity();
                majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), objKeyValue);
                if (majorDataEntityRuntime.getMajorPSDEField() != null && iDataEntityRuntime.getMajorPSDEField() != null && iEntity.contains(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName())) {
                    majorEntity.set(majorDataEntityRuntime.getMajorPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()));
                }
                for (Object iPSDEField : psDEFieldList) {
                    if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                    majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                }
                if (majorDataEntityRuntime.getDataTypePSDEField() != null) {
                    majorEntity.set(majorDataEntityRuntime.getDataTypePSDEField().getLowerCaseName(), this.getSystemRuntimeContext().getSystemRuntime().convertValue(majorDataEntityRuntime.getDataTypePSDEField().getStdDataType(), iDataEntityRuntime.getPSDERInherit().getTypeValue()));
                }
                this.create(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
                if (objKeyValue == null) {
                    objKeyValue = majorEntity.get(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                }
            }
            this.executeInsert(strTableName, map, extParamMap, iDataEntityRuntime, iEntity, bSysMode);
            if (objKeyValue == null && (objKeyValue = map.get(iDataEntityRuntime.getKeyPSDEField().getName())) == null) {
                objKeyValue = this.getLastInsertId();
                iEntity.set(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), objKeyValue);
            }
            if (iEntity instanceof IEntityDTO && (iEntityDTO = (IEntityDTO)iEntity).getDEMethodDTORuntime() != null && (psDEMethodDTOFieldList = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields()) != null) {
                Iterator objNameValue = iDataEntityRuntime.getMajorPSDEField() != null ? iEntityDTO.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()) : null;
                for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
                    IDataEntityRuntime refDataEntityRuntime;
                    Object dtoData;
                    IPSDEField iPSDEField;
                    if (!"DTO".equals(iPSDEMethodDTOField.getType()) && !"DTOS".equals(iPSDEMethodDTOField.getType()) || iPSDEMethodDTOField.getRefPSDataEntity() == null || (iPSDEField = iPSDEMethodDTOField.getPSDEField()) instanceof IPSPickupObjectDEField || iPSDEField == null || "INHERIT".equals(iPSDEField.getDataType()) || (dtoData = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName())) == null || (refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId())).getStorageMode() == 0 && refDataEntityRuntime.getVirtualMode() != 1) continue;
                    if ("DTOS".equals(iPSDEMethodDTOField.getType())) {
                        Collection<Object> list = null;
                        if (iPSDEMethodDTOField.isListMap()) {
                            if (!(dtoData instanceof Map)) {
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                            }
                            list = ((Map)dtoData).values();
                        } else {
                            if (!(dtoData instanceof List)) {
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                            }
                            list = (List)dtoData;
                        }
                        IPSPickupDEField pickupPSDEField = null;
                        IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
                        if (iPSDERBase instanceof IPSDER1N) {
                            pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                        } else if (iPSDERBase instanceof IPSDERCustom) {
                            pickupPSDEField = ((IPSDERCustom)iPSDERBase).getPickupPSDEField();
                        }
                        if (pickupPSDEField == null) {
                            log.warn((Object)String.format("\u5c5e\u6027[%1$s]\u6ca1\u6709\u5b9a\u4e49DTO\u8fde\u63a5\u5c5e\u6027\uff0c\u5ffd\u7565\u9ed8\u8ba4\u5904\u7406", iPSDEMethodDTOField.getName()));
                            continue;
                        }
                        for (Object item : list) {
                            if (item instanceof IEntity) {
                                refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                refDataEntityRuntime.create((IEntity)item);
                                continue;
                            }
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                        }
                        continue;
                    }
                    if (dtoData instanceof IEntity) {
                        refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                        refDataEntityRuntime.create((IEntity)dtoData);
                        continue;
                    }
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                }
            }
        }
        if (iDataEntityRuntime.isVirtual() && !ObjectUtils.isEmpty(psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits())) {
            for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                majorEntity = majorDataEntityRuntime.createEntity();
                majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), objKeyValue);
                for (Object iPSDEField : psDEFieldList) {
                    if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iPSDERMultiInherit.getId().equals(iPSLinkDEField.getPSDERMust().getId()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                    majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                }
                boolean bCreate = true;
                if (objKeyValue != null) {
                    boolean bl = bCreate = this.checkKeyState(majorDataEntityRuntime, null, objKeyValue) == 0;
                }
                if (bCreate) {
                    this.create(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
                } else {
                    this.update(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
                }
                if (objKeyValue != null) continue;
                objKeyValue = majorEntity.get(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
            }
        }
        if (bGet) {
            IPSDEDataQuery iPSDEDataQuery = null;
            if (iPSDEAction != null) {
                iPSDEDataQuery = iPSDEAction.getPSDEActionReturnMust().getPSDEDataQuery();
            }
            if (iPSDEDataQuery == null) {
                iPSDEDataQuery = iDataEntityRuntime.getViewPSDEDataQuery();
            }
            return this.get(iDataEntityRuntime, iPSDEDataQuery, objKeyValue, outputFields, false);
        }
        return null;
    }

    @Override
    public Object update(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, IEntity iEntity, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        List<IPSDERMultiInherit> psDERMultiInheritList;
        IDataEntityRuntime majorDataEntityRuntime;
        List psDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (ObjectUtils.isEmpty((Object)psDEFieldList)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u4efb\u4f55\u5c5e\u6027", new Object[0]));
        }
        Object objKeyValue = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
        if (ObjectUtils.isEmpty((Object)objKeyValue)) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u65e0\u6cd5\u83b7\u53d6\u66f4\u65b0\u6570\u636e\u6807\u8bc6", new Object[0]), 4);
        }
        if (!iDataEntityRuntime.isVirtual() || iDataEntityRuntime.getVirtualMode() == 4) {
            List psDEMethodDTOFieldList;
            IEntityDTO iEntityDTO;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (IPSDEField iPSDEField : psDEFieldList) {
                if (!iPSDEField.isPhisicalDEField() || !iEntity.contains(iPSDEField.getLowerCaseName())) continue;
                Object objValue = iEntity.get(iPSDEField.getLowerCaseName());
                if (objValue != null && DataTypeUtils.isStringDataType(iPSDEField.getStdDataType()) && !(objValue instanceof String)) {
                    objValue = JsonUtils.toString(objValue);
                }
                map.put(iPSDEField.getLowerCaseName(), objValue);
            }
            if (iDataEntityRuntime.isEnableLogicValid()) {
                map.remove(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName());
            }
            HashMap<String, Object> extParamMap = null;
            if (!bSysMode) {
                IPSDEField iPSDEField;
                extParamMap = new HashMap<String, Object>();
                iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEMAN", true);
                if (iPSDEField != null) {
                    map.remove(iPSDEField.getLowerCaseName());
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEDATE", true)) != null) {
                    map.remove(iPSDEField.getLowerCaseName());
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                majorDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime();
                String strMajorTableName = majorDataEntityRuntime.getTableName();
                if (!StringUtils.hasLength((String)strMajorTableName)) {
                    throw new DataEntityRuntimeException(majorDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
                }
                IEntityDTO majorEntity = majorDataEntityRuntime.createEntity();
                majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName()));
                if (majorDataEntityRuntime.getMajorPSDEField() != null && iDataEntityRuntime.getMajorPSDEField() != null && iEntity.contains(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName())) {
                    majorEntity.set(majorDataEntityRuntime.getMajorPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()));
                }
                for (IPSDEField iPSDEField : psDEFieldList) {
                    IPSLinkDEField iPSLinkDEField;
                    if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                    majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                }
                if (majorDataEntityRuntime.getDataTypePSDEField() != null) {
                    majorEntity.set(majorDataEntityRuntime.getDataTypePSDEField().getLowerCaseName(), this.getSystemRuntimeContext().getSystemRuntime().convertValue(majorDataEntityRuntime.getDataTypePSDEField().getStdDataType(), iDataEntityRuntime.getPSDERInherit().getTypeValue()));
                }
                this.update(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
            }
            if (iEntity instanceof IEntityDTO && (iEntityDTO = (IEntityDTO)iEntity).getDEMethodDTORuntime() != null && (psDEMethodDTOFieldList = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields()) != null) {
                Iterator objNameValue = iDataEntityRuntime.getMajorPSDEField() != null ? iEntityDTO.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()) : null;
                for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
                    IDataEntityRuntime refDataEntityRuntime;
                    IPSDEField iPSDEField;
                    if (!"DTO".equals(iPSDEMethodDTOField.getType()) && !"DTOS".equals(iPSDEMethodDTOField.getType()) || iPSDEMethodDTOField.getRefPSDataEntity() == null || (iPSDEField = iPSDEMethodDTOField.getPSDEField()) instanceof IPSPickupObjectDEField || iPSDEField == null || "INHERIT".equals(iPSDEField.getDataType()) || !iEntityDTO.contains(iPSDEMethodDTOField.getLowerCaseName()) || (refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId())).getStorageMode() == 0 && refDataEntityRuntime.getVirtualMode() != 1) continue;
                    IPSPickupDEField pickupPSDEField = null;
                    IPSDEField parentTypePSDEField = null;
                    IPSDEField parentNamePSDEField = null;
                    IPSDEField parentSubTypePSDEField = null;
                    String strParentSubType = null;
                    String strParentType = null;
                    IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
                    IPSDEDataSet nestedPSDEDataSet = null;
                    if (iPSDERBase instanceof IPSDER1N) {
                        IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                        pickupPSDEField = iPSDER1N.getPSPickupDEFieldMust();
                        nestedPSDEDataSet = iPSDER1N.getNestedPSDEDataSet();
                    } else if (iPSDERBase instanceof IPSDERCustom) {
                        IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                        pickupPSDEField = iPSDERCustom.getPickupPSDEField();
                        nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
                        parentTypePSDEField = refDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, refDataEntityRuntime.getDEType() != 4);
                        if (parentTypePSDEField != null && !StringUtils.hasLength((String)(strParentType = ((IPSDERCustom)iPSDERBase).getParentType()))) {
                            strParentType = iDataEntityRuntime.getName();
                        }
                        parentNamePSDEField = refDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTNAME.value, true);
                        parentSubTypePSDEField = refDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE.value, true);
                        if (parentSubTypePSDEField != null && !StringUtils.hasLength((String)(strParentSubType = ((IPSDERCustom)iPSDERBase).getParentSubType()))) {
                            strParentSubType = iPSDERBase.getMinorCodeName();
                        }
                    }
                    if (pickupPSDEField == null) {
                        log.warn((Object)String.format("\u5c5e\u6027[%1$s]\u6ca1\u6709\u5b9a\u4e49DTO\u8fde\u63a5\u5c5e\u6027\uff0c\u5ffd\u7565\u9ed8\u8ba4\u5904\u7406", iPSDEMethodDTOField.getName()));
                        continue;
                    }
                    ISearchContextDTO iSearchContextDTO = refDataEntityRuntime.createSearchContext();
                    refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", objKeyValue);
                    if (parentTypePSDEField != null) {
                        refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", strParentType);
                    }
                    if (parentSubTypePSDEField != null) {
                        if (StringUtils.hasLength(strParentSubType)) {
                            refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
                        } else {
                            refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
                        }
                    }
                    iSearchContextDTO.all().count(false);
                    List<IEntityDTO> lastList = null;
                    lastList = nestedPSDEDataSet != null ? refDataEntityRuntime.selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : refDataEntityRuntime.select(iSearchContextDTO);
                    HashMap<Object, IEntityDTO> lastMap = new HashMap<Object, IEntityDTO>();
                    if (lastList != null) {
                        for (IEntityDTO item : lastList) {
                            Object objKey = refDataEntityRuntime.getFieldValue((IEntityBase)item, refDataEntityRuntime.getKeyPSDEField());
                            lastMap.put(objKey, item);
                        }
                    }
                    ArrayList<IEntity> createList = null;
                    ArrayList<IEntity> updateList = null;
                    Object dtoData = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName());
                    if (dtoData != null) {
                        if ("DTOS".equals(iPSDEMethodDTOField.getType())) {
                            Collection<Object> list = null;
                            if (iPSDEMethodDTOField.isListMap()) {
                                if (!(dtoData instanceof Map)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = ((Map)dtoData).values();
                            } else {
                                if (!(dtoData instanceof List)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = (List)dtoData;
                            }
                            for (Object item : list) {
                                if (item instanceof IEntity) {
                                    Object objKey;
                                    IEntity last;
                                    String strUniqueTag;
                                    if (refDataEntityRuntime.getUniTagPSDEField() != null && refDataEntityRuntime.getUnionKeyValuePSDEFields() != null && refDataEntityRuntime.getUniTagPSDEField().isKeyDEField() && StringUtils.hasLength((String)(strUniqueTag = refDataEntityRuntime.getUniTagValue((IEntity)item, refDataEntityRuntime.getUnionKeyValuePSDEFields())))) {
                                        refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), refDataEntityRuntime.getUniTagPSDEField(), (Object)strUniqueTag);
                                    }
                                    if ((last = (IEntity)lastMap.remove(objKey = refDataEntityRuntime.getFieldValue((IEntityBase)((IEntity)item), refDataEntityRuntime.getKeyPSDEField()))) != null) {
                                        refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                        if (updateList == null) {
                                            updateList = new ArrayList();
                                        }
                                        updateList.add((IEntity)item);
                                        continue;
                                    }
                                    refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                    if (createList == null) {
                                        createList = new ArrayList();
                                    }
                                    createList.add((IEntity)item);
                                    continue;
                                }
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                            }
                        } else if (dtoData instanceof IEntity) {
                            Object objKey = refDataEntityRuntime.getFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField());
                            IEntity last = (IEntity)lastMap.remove(objKey);
                            if (last == null) {
                                refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                                if (createList == null) {
                                    createList = new ArrayList<IEntity>();
                                }
                                createList.add((IEntity)dtoData);
                            } else {
                                refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                                if (updateList == null) {
                                    updateList = new ArrayList<IEntity>();
                                }
                                updateList.add((IEntity)dtoData);
                            }
                        } else {
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                        }
                    }
                    for (Map.Entry entry : lastMap.entrySet()) {
                        refDataEntityRuntime.remove(entry.getKey());
                    }
                    if (updateList != null) {
                        for (IEntity item : updateList) {
                            refDataEntityRuntime.update(item);
                        }
                    }
                    if (createList == null) continue;
                    for (IEntity item : createList) {
                        refDataEntityRuntime.create(item);
                    }
                }
            }
            this.executeUpdate(strTableName, map, extParamMap, iDataEntityRuntime, iEntity, bSysMode);
        }
        if (iDataEntityRuntime.isVirtual() && !ObjectUtils.isEmpty(psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits())) {
            for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                IEntityDTO majorEntity = majorDataEntityRuntime.createEntity();
                majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), objKeyValue);
                for (IPSDEField iPSDEField : psDEFieldList) {
                    IPSLinkDEField iPSLinkDEField;
                    if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iPSDERMultiInherit.getId().equals(iPSLinkDEField.getPSDERMust().getId()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                    majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                }
                boolean bCreate = true;
                if (objKeyValue != null) {
                    boolean bl = bCreate = this.checkKeyState(majorDataEntityRuntime, null, objKeyValue) == 0;
                }
                if (bCreate) {
                    this.create(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
                    continue;
                }
                this.update(majorDataEntityRuntime, null, majorEntity, null, false, null, bSysMode);
            }
        }
        if (bGet) {
            IPSDEDataQuery iPSDEDataQuery = null;
            if (iPSDEAction != null) {
                iPSDEDataQuery = iPSDEAction.getPSDEActionReturnMust().getPSDEDataQuery();
            }
            if (iPSDEDataQuery == null) {
                iPSDEDataQuery = iDataEntityRuntime.getViewPSDEDataQuery();
            }
            return this.get(iDataEntityRuntime, iPSDEDataQuery, objKeyValue, outputFields, false);
        }
        return null;
    }

    @Override
    public void remove(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object key, boolean bSysMode) throws Throwable {
        IDataEntityRuntime majorDataEntityRuntime;
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u65e0\u6cd5\u6307\u5b9a\u5220\u9664\u6570\u636e\u6807\u8bc6", new Object[0]), 4);
        }
        if (iDataEntityRuntime.isVirtual()) {
            List<IPSDERMultiInherit> psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits();
            IPSDERMultiInherit firstPSDERMultiInherit = null;
            if (!ObjectUtils.isEmpty(psDERMultiInheritList)) {
                for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                    if (firstPSDERMultiInherit == null) {
                        firstPSDERMultiInherit = iPSDERMultiInherit;
                        continue;
                    }
                    IDataEntityRuntime majorDataEntityRuntime2 = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                    if (this.checkKeyState(majorDataEntityRuntime2, null, key) != 1) continue;
                    majorDataEntityRuntime2.remove(key);
                }
            }
            if (firstPSDERMultiInherit != null && this.checkKeyState(majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(firstPSDERMultiInherit.getMajorPSDataEntityMust().getId()), null, key) == 1) {
                majorDataEntityRuntime.remove(key);
            }
        }
        if (!iDataEntityRuntime.isVirtual() || iDataEntityRuntime.getVirtualMode() == 4) {
            HashMap<String, Object> map;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            if (!iDataEntityRuntime.isEnableLogicValid()) {
                map = new HashMap<String, Object>();
                map.put(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), key);
                this.getSysDBSchemeRuntime().delete(strTableName, map, null);
            } else {
                map = new HashMap();
                map.put(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), key);
                map.put(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), iDataEntityRuntime.getInvalidLogicValue());
                if (bSysMode) {
                    IPSDEField iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true);
                    if (iPSDEField != null) {
                        map.put(iPSDEField.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                    }
                    if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                        map.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                    }
                }
                this.getSysDBSchemeRuntime().update(strTableName, map, null);
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
                if (actionSession.registerRecursion("INHERITACTION", (majorDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime()).getId(), key, "remove")) {
                    majorDataEntityRuntime.remove(key);
                    actionSession.unregisterRecursion("INHERITACTION", majorDataEntityRuntime.getId(), key, "remove");
                } else {
                    throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u7ee7\u627f\u4e3b\u5b9e\u4f53\u6b63\u5728\u5220\u9664\u5f53\u524d\u6570\u636e", new Object[0]));
                }
            }
        }
    }

    @Override
    public Page fetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        Sort sort;
        if (iSearchContext != null && (sort = iSearchContext.getPageSort()) != null && sort != Sort.unsorted() && !ObjectUtils.isEmpty((Object)sort.iterator())) {
            boolean bConvert = false;
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(order.getProperty());
                if (iPSDEField == null) {
                    bConvert = true;
                    log.warn((Object)String.format("\u5ffd\u7565\u65e0\u6cd5\u8bc6\u522b\u7684\u6392\u5e8f\u5c5e\u6027[%1$s]", order.getProperty()));
                    continue;
                }
                int nDEFType = iPSDEField.getDEFType();
                if (nDEFType != 1 && nDEFType != 2 && nDEFType != 3) {
                    bConvert = true;
                    log.warn((Object)String.format("\u5ffd\u7565\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5c5e\u6027[%1$s]", order.getProperty()));
                    continue;
                }
                String strFieldExp = iPSDEField.getName();
                bConvert = true;
                order = order.withProperty(strFieldExp);
                list.add(order);
            }
            if (bConvert) {
                iSearchContext.setPageSort(Sort.by(list));
            }
        }
        return this.getSysDBSchemeRuntime().fetchDataSet(iDataEntityRuntime, iPSDEDataSet, iSearchContext, outputFields, null);
    }

    @Override
    public List query(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        Sort sort;
        if (iSearchContext != null && (sort = iSearchContext.getPageSort()) != null && sort != Sort.unsorted() && !ObjectUtils.isEmpty((Object)sort.iterator())) {
            boolean bConvert = false;
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(order.getProperty());
                if (iPSDEField == null) {
                    list.add(order);
                    continue;
                }
                String strFieldExp = iPSDEField.getName();
                if (!StringUtils.hasLength((String)strFieldExp)) {
                    list.add(order);
                    continue;
                }
                bConvert = true;
                order = order.withProperty(strFieldExp);
                list.add(order);
            }
            if (bConvert) {
                iSearchContext.setPageSort(Sort.by(list));
            }
        }
        return this.getSysDBSchemeRuntime().query(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, null);
    }

    @Override
    public Page query2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        Sort sort;
        if (iSearchContext != null && (sort = iSearchContext.getPageSort()) != null && sort != Sort.unsorted() && !ObjectUtils.isEmpty((Object)sort.iterator())) {
            boolean bConvert = false;
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(order.getProperty());
                if (iPSDEField == null) {
                    list.add(order);
                    continue;
                }
                String strFieldExp = iPSDEField.getName();
                if (!StringUtils.hasLength((String)strFieldExp)) {
                    list.add(order);
                    continue;
                }
                bConvert = true;
                order = order.withProperty(strFieldExp);
                list.add(order);
            }
            if (bConvert) {
                iSearchContext.setPageSort(Sort.by(list));
            }
        }
        return this.getSysDBSchemeRuntime().query2(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object create(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<? extends IEntity> datas, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        List<IPSDERMultiInherit> psDERMultiInheritList;
        if (ObjectUtils.isEmpty(datas)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        List psDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (ObjectUtils.isEmpty((Object)psDEFieldList)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u4efb\u4f55\u5c5e\u6027", new Object[0]));
        }
        if (!iDataEntityRuntime.isVirtual() || iDataEntityRuntime.getVirtualMode() == 4) {
            List psDEMethodDTOFieldList;
            void var12_22;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            for (IEntity iEntity : datas) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (IPSDEField iPSDEField : psDEFieldList) {
                    if (!iPSDEField.isPhisicalDEField() || !iEntity.contains(iPSDEField.getLowerCaseName())) continue;
                    map.put(iPSDEField.getLowerCaseName(), iEntity.get(iPSDEField.getLowerCaseName()));
                }
                mapList.add(map);
            }
            HashMap<String, Object> extParamMap = null;
            if (!bSysMode) {
                IPSDEField iPSDEField;
                IPSDEField iPSDEField2;
                IPSDEField iPSDEField3;
                IPSDEField iPSDEField4;
                if (extParamMap == null) {
                    extParamMap = new HashMap<String, Object>();
                }
                if ((iPSDEField4 = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField4.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField3 = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField3.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
                if ((iPSDEField2 = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField2.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
            }
            if (iDataEntityRuntime.isEnableLogicValid()) {
                if (extParamMap == null) {
                    extParamMap = new HashMap();
                }
                extParamMap.put(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), iDataEntityRuntime.getValidLogicValue());
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                IDataEntityRuntime iDataEntityRuntime2 = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime();
                ArrayList<IEntityDTO> majorList = new ArrayList<IEntityDTO>();
                for (IEntity iEntity : datas) {
                    IEntityDTO majorEntity = iDataEntityRuntime2.createEntity();
                    majorEntity.set(iDataEntityRuntime2.getKeyPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName()));
                    if (iDataEntityRuntime2.getMajorPSDEField() != null && iDataEntityRuntime.getMajorPSDEField() != null && iEntity.contains(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName())) {
                        majorEntity.set(iDataEntityRuntime2.getMajorPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()));
                    }
                    for (IPSDEField iPSDEField : psDEFieldList) {
                        IPSLinkDEField iPSLinkDEField;
                        if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                        majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                    }
                    if (iDataEntityRuntime2.getDataTypePSDEField() != null) {
                        majorEntity.set(iDataEntityRuntime2.getDataTypePSDEField().getLowerCaseName(), this.getSystemRuntimeContext().getSystemRuntime().convertValue(iDataEntityRuntime2.getDataTypePSDEField().getStdDataType(), iDataEntityRuntime.getPSDERInherit().getTypeValue()));
                    }
                    majorList.add(majorEntity);
                }
                this.create(iDataEntityRuntime2, null, majorList, null, false, null, bSysMode);
            }
            this.executeInsert(strTableName, mapList, extParamMap, iDataEntityRuntime, datas, bSysMode);
            Object var12_20 = null;
            if (datas.get(0) instanceof IEntityDTO) {
                IDEMethodDTORuntime iDEMethodDTORuntime = ((IEntityDTO)datas.get(0)).getDEMethodDTORuntime();
            }
            if (var12_22 != null && (psDEMethodDTOFieldList = var12_22.getPSDEMethodDTO().getPSDEMethodDTOFields()) != null) {
                Object objNameValue = iDataEntityRuntime.getMajorPSDEField() != null ? ((IEntityDTO)datas.get(0)).get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()) : null;
                for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
                    IDataEntityRuntime refDataEntityRuntime;
                    IPSDEField iPSDEField;
                    if (!"DTO".equals(iPSDEMethodDTOField.getType()) && !"DTOS".equals(iPSDEMethodDTOField.getType()) || iPSDEMethodDTOField.getRefPSDataEntity() == null || (iPSDEField = iPSDEMethodDTOField.getPSDEField()) instanceof IPSPickupObjectDEField || iPSDEField == null || "INHERIT".equals(iPSDEField.getDataType()) || (refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId())).getStorageMode() == 0 && refDataEntityRuntime.getVirtualMode() != 1) continue;
                    IPSPickupDEField pickupPSDEField = null;
                    IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
                    if (iPSDERBase instanceof IPSDER1N) {
                        pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                    } else if (iPSDERBase instanceof IPSDERCustom) {
                        pickupPSDEField = ((IPSDERCustom)iPSDERBase).getPickupPSDEField();
                    }
                    if (pickupPSDEField == null) {
                        log.warn((Object)String.format("\u5c5e\u6027[%1$s]\u6ca1\u6709\u5b9a\u4e49DTO\u8fde\u63a5\u5c5e\u6027\uff0c\u5ffd\u7565\u9ed8\u8ba4\u5904\u7406", iPSDEMethodDTOField.getName()));
                        continue;
                    }
                    ArrayList<IEntity> childList = new ArrayList<IEntity>();
                    for (IEntity iEntity : datas) {
                        Object objKeyValue = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                        IEntityDTO iEntityDTO = (IEntityDTO)iEntity;
                        Object dtoData = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName());
                        if (dtoData == null) continue;
                        if ("DTOS".equals(iPSDEMethodDTOField.getType())) {
                            Collection<Object> list = null;
                            if (iPSDEMethodDTOField.isListMap()) {
                                if (!(dtoData instanceof Map)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = ((Map)dtoData).values();
                            } else {
                                if (!(dtoData instanceof List)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = (List)dtoData;
                            }
                            for (Object item : list) {
                                if (item instanceof IEntity) {
                                    refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                    childList.add((IEntity)item);
                                    continue;
                                }
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                            }
                            continue;
                        }
                        if (dtoData instanceof IEntity) {
                            refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                            childList.add((IEntity)dtoData);
                            continue;
                        }
                        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                    }
                    if (childList.size() <= 0) continue;
                    this.create(refDataEntityRuntime, null, childList, null, false, null, bSysMode);
                }
            }
        }
        if (iDataEntityRuntime.isVirtual() && !ObjectUtils.isEmpty(psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits())) {
            for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                ArrayList<IEntityDTO> arrayList = new ArrayList<IEntityDTO>();
                IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                for (IEntity iEntity : datas) {
                    Object objKeyValue = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                    IEntityDTO majorEntity = majorDataEntityRuntime.createEntity();
                    majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), objKeyValue);
                    for (IPSDEField iPSDEField : psDEFieldList) {
                        IPSLinkDEField iPSLinkDEField;
                        if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iPSDERMultiInherit.getId().equals(iPSLinkDEField.getPSDERMust().getId()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                        majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                    }
                    arrayList.add(majorEntity);
                }
                this.create(majorDataEntityRuntime, null, arrayList, null, false, null, bSysMode);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object update(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<? extends IEntity> datas, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        if (ObjectUtils.isEmpty(datas)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        List psDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (ObjectUtils.isEmpty((Object)psDEFieldList)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u4efb\u4f55\u5c5e\u6027", new Object[0]));
        }
        if (iDataEntityRuntime.isVirtual()) {
            List<IPSDERMultiInherit> psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits();
            if (!ObjectUtils.isEmpty(psDERMultiInheritList)) {
                for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                    ArrayList<IEntityDTO> arrayList = new ArrayList<IEntityDTO>();
                    IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                    for (IEntity iEntity : datas) {
                        Object object = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                        IEntityDTO majorEntity = majorDataEntityRuntime.createEntity();
                        majorEntity.set(majorDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), object);
                        for (IPSDEField iPSDEField : psDEFieldList) {
                            IPSLinkDEField iPSLinkDEField;
                            if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iPSDERMultiInherit.getId().equals(iPSLinkDEField.getPSDERMust().getId()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                            majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                        }
                        arrayList.add(majorEntity);
                    }
                    this.update(majorDataEntityRuntime, null, arrayList, null, false, null, bSysMode);
                }
            }
        } else {
            List psDEMethodDTOFieldList;
            void var12_26;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            for (IEntity iEntity : datas) {
                Iterator map = new HashMap();
                for (IPSDEField iPSDEField : psDEFieldList) {
                    if (!iPSDEField.isPhisicalDEField() || !iEntity.contains(iPSDEField.getLowerCaseName())) continue;
                    map.put(iPSDEField.getLowerCaseName(), iEntity.get(iPSDEField.getLowerCaseName()));
                }
                if (iDataEntityRuntime.isEnableLogicValid()) {
                    map.remove(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName());
                }
                mapList.add((Map<String, Object>)((Object)map));
            }
            HashMap<String, Object> extParamMap = null;
            if (!bSysMode) {
                IPSDEField iPSDEField;
                IPSDEField iPSDEField2;
                IPSDEField iPSDEField3;
                extParamMap = new HashMap<String, Object>();
                IPSDEField iPSDEField4 = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEMAN", true);
                if (iPSDEField4 != null) {
                    for (Map map : mapList) {
                        map.remove(iPSDEField4.getLowerCaseName());
                    }
                }
                if ((iPSDEField3 = iDataEntityRuntime.getPSDEFieldByPredefinedType("CREATEDATE", true)) != null) {
                    for (Map map : mapList) {
                        map.remove(iPSDEField3.getLowerCaseName());
                    }
                }
                if ((iPSDEField2 = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true)) != null) {
                    extParamMap.put(iPSDEField2.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                }
                if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                    extParamMap.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                }
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                IDataEntityRuntime iDataEntityRuntime2 = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime();
                String strMajorTableName = iDataEntityRuntime2.getTableName();
                if (!StringUtils.hasLength((String)strMajorTableName)) {
                    throw new DataEntityRuntimeException(iDataEntityRuntime2, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
                }
                ArrayList<IEntityDTO> arrayList = new ArrayList<IEntityDTO>();
                for (IEntity iEntity : datas) {
                    IEntityDTO majorEntity = iDataEntityRuntime2.createEntity();
                    majorEntity.set(iDataEntityRuntime2.getKeyPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName()));
                    if (iDataEntityRuntime2.getMajorPSDEField() != null && iDataEntityRuntime.getMajorPSDEField() != null && iEntity.contains(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName())) {
                        majorEntity.set(iDataEntityRuntime2.getMajorPSDEField().getLowerCaseName(), iEntity.get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()));
                    }
                    for (IPSDEField iPSDEField : psDEFieldList) {
                        IPSLinkDEField iPSLinkDEField;
                        if (!iPSDEField.isLinkDEField() || !"INHERIT".equals((iPSLinkDEField = (IPSLinkDEField)iPSDEField).getDataType()) || !iEntity.contains(iPSLinkDEField.getLowerCaseName())) continue;
                        majorEntity.set(iPSLinkDEField.getRelatedPSDEFieldMust().getLowerCaseName(), iEntity.get(iPSLinkDEField.getLowerCaseName()));
                    }
                    if (iDataEntityRuntime2.getDataTypePSDEField() != null) {
                        majorEntity.set(iDataEntityRuntime2.getDataTypePSDEField().getLowerCaseName(), this.getSystemRuntimeContext().getSystemRuntime().convertValue(iDataEntityRuntime2.getDataTypePSDEField().getStdDataType(), iDataEntityRuntime.getPSDERInherit().getTypeValue()));
                    }
                    arrayList.add(majorEntity);
                }
                this.update(iDataEntityRuntime2, null, arrayList, null, false, null, bSysMode);
            }
            Object var12_24 = null;
            if (datas.get(0) instanceof IEntityDTO) {
                IDEMethodDTORuntime iDEMethodDTORuntime = ((IEntityDTO)datas.get(0)).getDEMethodDTORuntime();
            }
            if (var12_26 != null && (psDEMethodDTOFieldList = var12_26.getPSDEMethodDTO().getPSDEMethodDTOFields()) != null) {
                Object object = iDataEntityRuntime.getMajorPSDEField() != null ? ((IEntityDTO)datas.get(0)).get(iDataEntityRuntime.getMajorPSDEField().getLowerCaseName()) : null;
                for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
                    IDataEntityRuntime refDataEntityRuntime;
                    IPSDEField iPSDEField;
                    if (!"DTO".equals(iPSDEMethodDTOField.getType()) && !"DTOS".equals(iPSDEMethodDTOField.getType()) || iPSDEMethodDTOField.getRefPSDataEntity() == null || (iPSDEField = iPSDEMethodDTOField.getPSDEField()) instanceof IPSPickupObjectDEField || iPSDEField == null || "INHERIT".equals(iPSDEField.getDataType()) || (refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId())).getStorageMode() == 0 && refDataEntityRuntime.getVirtualMode() != 1) continue;
                    IPSPickupDEField pickupPSDEField = null;
                    IPSDEField parentTypePSDEField = null;
                    IPSDEField parentSubTypePSDEField = null;
                    String strParentType = null;
                    String strParentSubType = null;
                    IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
                    IPSDEDataSet nestedPSDEDataSet = null;
                    if (iPSDERBase instanceof IPSDER1N) {
                        IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                        pickupPSDEField = iPSDER1N.getPSPickupDEFieldMust();
                        nestedPSDEDataSet = iPSDER1N.getNestedPSDEDataSet();
                    } else if (iPSDERBase instanceof IPSDERCustom) {
                        IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                        pickupPSDEField = iPSDERCustom.getPickupPSDEField();
                        nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
                        parentTypePSDEField = refDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, refDataEntityRuntime.getDEType() != 4);
                        if (parentTypePSDEField != null && !StringUtils.hasLength((String)(strParentType = ((IPSDERCustom)iPSDERBase).getParentType()))) {
                            strParentType = iDataEntityRuntime.getName();
                        }
                        if ((parentSubTypePSDEField = refDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE.value, true)) != null && !StringUtils.hasLength((String)(strParentSubType = ((IPSDERCustom)iPSDERBase).getParentSubType()))) {
                            strParentSubType = iPSDERBase.getMinorCodeName();
                        }
                    }
                    if (pickupPSDEField == null) {
                        log.warn((Object)String.format("\u5c5e\u6027[%1$s]\u6ca1\u6709\u5b9a\u4e49DTO\u8fde\u63a5\u5c5e\u6027\uff0c\u5ffd\u7565\u9ed8\u8ba4\u5904\u7406", iPSDEMethodDTOField.getName()));
                        continue;
                    }
                    ArrayList<IEntity> createList = new ArrayList<IEntity>();
                    ArrayList<IEntity> updateList = new ArrayList<IEntity>();
                    HashMap<Iterator<Object>, IEntityDTO> lastMap = new HashMap<Iterator<Object>, IEntityDTO>();
                    for (IEntity iEntity : datas) {
                        Object dtoData;
                        Object objKeyValue = iEntity.get(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                        IEntityDTO iEntityDTO = (IEntityDTO)iEntity;
                        if (!iEntityDTO.contains(iPSDEMethodDTOField.getLowerCaseName())) continue;
                        boolean nOrderValue = true;
                        ISearchContextDTO iSearchContextDTO = refDataEntityRuntime.createSearchContext();
                        refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", objKeyValue);
                        if (parentTypePSDEField != null) {
                            refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", (Object)strParentType);
                        }
                        if (parentSubTypePSDEField != null) {
                            if (StringUtils.hasLength((String)strParentSubType)) {
                                refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
                            } else {
                                refDataEntityRuntime.setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
                            }
                        }
                        List<IEntityDTO> lastList = null;
                        lastList = nestedPSDEDataSet != null ? refDataEntityRuntime.selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : refDataEntityRuntime.select(iSearchContextDTO);
                        if (lastList != null) {
                            for (IEntityDTO item : lastList) {
                                Iterator<Object> objKey = refDataEntityRuntime.getFieldValue((IEntityBase)item, refDataEntityRuntime.getKeyPSDEField());
                                lastMap.put(objKey, item);
                            }
                        }
                        if ((dtoData = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName())) == null) continue;
                        if ("DTOS".equals(iPSDEMethodDTOField.getType())) {
                            Collection<Object> list = null;
                            if (iPSDEMethodDTOField.isListMap()) {
                                if (!(dtoData instanceof Map)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = ((Map)dtoData).values();
                            } else {
                                if (!(dtoData instanceof List)) {
                                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                                }
                                list = (List)dtoData;
                            }
                            for (Object item : list) {
                                if (item instanceof IEntity) {
                                    Object objKey;
                                    IEntity last;
                                    String strUniqueTag;
                                    if (refDataEntityRuntime.getUniTagPSDEField() != null && refDataEntityRuntime.getUnionKeyValuePSDEFields() != null && refDataEntityRuntime.getUniTagPSDEField().isKeyDEField() && StringUtils.hasLength((String)(strUniqueTag = refDataEntityRuntime.getUniTagValue((IEntity)item, refDataEntityRuntime.getUnionKeyValuePSDEFields())))) {
                                        refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), refDataEntityRuntime.getUniTagPSDEField(), (Object)strUniqueTag);
                                    }
                                    if ((last = (IEntity)lastMap.remove(objKey = refDataEntityRuntime.getFieldValue((IEntityBase)((IEntity)item), refDataEntityRuntime.getKeyPSDEField()))) != null) {
                                        refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                        updateList.add((IEntity)item);
                                        continue;
                                    }
                                    refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)item), (IPSDEField)pickupPSDEField, objKeyValue);
                                    createList.add((IEntity)item);
                                    continue;
                                }
                                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                            }
                            continue;
                        }
                        if (dtoData instanceof IEntity) {
                            Object objKey = refDataEntityRuntime.getFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField());
                            IEntity last = (IEntity)lastMap.remove(objKey);
                            if (last == null) {
                                refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                                createList.add((IEntity)dtoData);
                                continue;
                            }
                            refDataEntityRuntime.setFieldValue((IEntityBase)((IEntity)dtoData), refDataEntityRuntime.getKeyPSDEField(), objKeyValue);
                            updateList.add((IEntity)dtoData);
                            continue;
                        }
                        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, iEntityDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u4f20\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", iPSDEMethodDTOField.getName()));
                    }
                    if (createList.size() > 0) {
                        this.create(refDataEntityRuntime, null, createList, null, false, null, bSysMode);
                    }
                    if (updateList.size() > 0) {
                        this.update(refDataEntityRuntime, null, updateList, null, false, null, bSysMode);
                    }
                    if (lastMap.size() <= 0) continue;
                    this.remove(refDataEntityRuntime, null, new ArrayList<Object>(lastMap.keySet()), bSysMode);
                }
            }
            this.executeUpdate(strTableName, mapList, extParamMap, iDataEntityRuntime, datas, bSysMode);
        }
        return null;
    }

    @Override
    public List get(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<Object> keys, String[] outputFields) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public Object get(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object key, String[] outputFields, boolean bTryMode) throws Throwable {
        IPSDEDataQuery iPSDEDataQuery = null;
        if (iPSDEAction != null) {
            iPSDEDataQuery = iPSDEAction.getPSDEActionReturnMust().getPSDEDataQuery();
        }
        if (iPSDEDataQuery == null) {
            iPSDEDataQuery = iDataEntityRuntime.getViewPSDEDataQuery();
        }
        return this.get(iDataEntityRuntime, iPSDEDataQuery, key, outputFields, bTryMode);
    }

    @Override
    public Object get(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, Object key, String[] outputFields, boolean bTryMode) throws Throwable {
        Assert.notNull((Object)iPSDEDataQuery, (String)"\u6ca1\u6709\u4f20\u5165\u6570\u636e\u67e5\u8be2\u6a21\u578b\u5bf9\u8c61");
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u952e\u503c", new Object[0]), 4);
        }
        String strKey = String.format("n_%1$s_eq", iDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
        ISearchContextDTO iSearchContext = iDataEntityRuntime.createSearchContext(null);
        SearchContextDTO.addSearchFieldCond(iSearchContext, iDataEntityRuntime.getKeyPSDEField().getName(), "EQ", key, strKey);
        List list = this.getSysDBSchemeRuntime().query(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, null);
        if (list == null || list.size() == 0) {
            if (bTryMode) {
                return null;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e[%1$s]", key), 3);
        }
        return list.get(0);
    }

    @Override
    public void remove(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<Object> keys, boolean bSysMode) throws Throwable {
        if (ObjectUtils.isEmpty(keys)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u4f20\u5165\u6570\u636e\u5217\u8868\u65e0\u6548", new Object[0]));
        }
        List psDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (ObjectUtils.isEmpty((Object)psDEFieldList)) {
            throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u4efb\u4f55\u5c5e\u6027", new Object[0]));
        }
        if (iDataEntityRuntime.isVirtual()) {
            List<IPSDERMultiInherit> psDERMultiInheritList = iDataEntityRuntime.getPSDERMultiInherits();
            IPSDERMultiInherit firstPSDERMultiInherit = null;
            if (!ObjectUtils.isEmpty(psDERMultiInheritList)) {
                for (IPSDERMultiInherit iPSDERMultiInherit : psDERMultiInheritList) {
                    if (firstPSDERMultiInherit == null) {
                        firstPSDERMultiInherit = iPSDERMultiInherit;
                        continue;
                    }
                    IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                    this.remove(majorDataEntityRuntime, null, keys, bSysMode);
                }
            }
            if (firstPSDERMultiInherit != null) {
                Iterator<Object> majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(firstPSDERMultiInherit.getMajorPSDataEntityMust().getId());
                this.remove((IDataEntityRuntime)((Object)majorDataEntityRuntime), null, keys, bSysMode);
            }
        }
        if (!iDataEntityRuntime.isVirtual() || iDataEntityRuntime.getVirtualMode() == 4) {
            HashMap<String, Object> map;
            ArrayList<Map<String, Object>> mapList;
            String strTableName = iDataEntityRuntime.getTableName();
            if (!StringUtils.hasLength((String)strTableName)) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
            }
            if (!iDataEntityRuntime.isEnableLogicValid()) {
                mapList = new ArrayList<Map<String, Object>>();
                for (Object key : keys) {
                    map = new HashMap<String, Object>();
                    map.put(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), key);
                    mapList.add(map);
                }
                this.getSysDBSchemeRuntime().delete(strTableName, mapList, null);
            } else {
                mapList = new ArrayList();
                for (Object key : keys) {
                    map = new HashMap();
                    map.put(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), key);
                    map.put(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), iDataEntityRuntime.getInvalidLogicValue());
                    if (bSysMode) {
                        IPSDEField iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEMAN", true);
                        if (iPSDEField != null) {
                            map.put(iPSDEField.getLowerCaseName(), SqlParam.value(this.getUserContext().getUserid()));
                        }
                        if ((iPSDEField = iDataEntityRuntime.getPSDEFieldByPredefinedType("UPDATEDATE", true)) != null) {
                            map.put(iPSDEField.getLowerCaseName(), SqlParam.value(new Timestamp(System.currentTimeMillis())));
                        }
                    }
                    mapList.add(map);
                }
                this.getSysDBSchemeRuntime().update(strTableName, mapList, null);
            }
            if (iDataEntityRuntime.isInheritMinor()) {
                IDataEntityRuntime majorDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntime.getInheritDataEntityRuntime();
                String strMajorTableName = majorDataEntityRuntime.getTableName();
                if (!StringUtils.hasLength((String)strMajorTableName)) {
                    throw new DataEntityRuntimeException(majorDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u8868\u540d\u79f0", new Object[0]));
                }
                this.remove(majorDataEntityRuntime, null, keys, bSysMode);
            }
        }
    }

    @Override
    public int checkKeyState(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object key) throws Throwable {
        String strTableName = iDataEntityRuntime.getTableName();
        if (!StringUtils.hasLength((String)strTableName)) {
            if (ObjectUtils.isEmpty((Object)this.get(iDataEntityRuntime, iDataEntityRuntime.getDefaultPSDEDataQuery(), key, null, true))) {
                return 0;
            }
            return 1;
        }
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u952e\u503c", new Object[0]), 4);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (iDataEntityRuntime.getUniTagPSDEField() != null) {
            map.put(iDataEntityRuntime.getUniTagPSDEField().getLowerCaseName(), SqlParam.value(key, true));
        } else {
            map.put(iDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), SqlParam.value(key, true));
        }
        if (iDataEntityRuntime.isEnableLogicValid()) {
            map.put(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), SqlParam.NOTSET);
        } else {
            map.put("1", SqlParam.NOTSET);
        }
        List list = this.getSysDBSchemeRuntime().select(strTableName, map, null);
        if (list == null || list.size() == 0) {
            return 0;
        }
        if (!iDataEntityRuntime.isEnableLogicValid()) {
            return 1;
        }
        Object objRow = list.get(0);
        if (!(objRow instanceof Map)) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u503c\u5bf9\u8c61\u578b[%1$s]", objRow), 4);
        }
        Map rowMap = (Map)objRow;
        Object objValue = rowMap.get(iDataEntityRuntime.getLogicValidPSDEField().getName());
        long nRet = this.getSystemRuntimeContext().getSystemRuntime().compareValue(iDataEntityRuntime.getInvalidLogicValue(), objValue, iDataEntityRuntime.getLogicValidPSDEField().getStdDataType());
        if (nRet == 0L) {
            return 2;
        }
        return 1;
    }

    @Override
    public List executeSelectSQL(String strSQL, List<Object> params) throws Throwable {
        return this.getSysDBSchemeRuntime().executeSelectSQL(strSQL, params);
    }

    @Override
    public int executeSQL(String strSQL, List<Object> params) throws Throwable {
        return this.getSysDBSchemeRuntime().executeSQL(strSQL, params);
    }

    protected Object executeInsert(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap, IDataEntityRuntime iDataEntityRuntime, List<? extends IEntity> datas, boolean bSysMode) throws Throwable {
        return this.getSysDBSchemeRuntime().insert(strTableName, args, extParamMap);
    }

    protected Object executeUpdate(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap, IDataEntityRuntime iDataEntityRuntime, List<? extends IEntity> datas, boolean bSysMode) throws Throwable {
        return this.getSysDBSchemeRuntime().update(strTableName, args, extParamMap);
    }

    protected Object executeInsert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, IDataEntityRuntime iDataEntityRuntime, IEntity iEntity, boolean bSysMode) throws Throwable {
        return this.getSysDBSchemeRuntime().insert(strTableName, arg, extParamMap);
    }

    protected Object executeUpdate(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, IDataEntityRuntime iDataEntityRuntime, IEntity iEntity, boolean bSysMode) throws Throwable {
        return this.getSysDBSchemeRuntime().update(strTableName, arg, extParamMap);
    }

    protected Object getLastInsertId() throws Throwable {
        String strSQL = DBDialectUtils.getInstance().get(this.getDBType()).getLastInsertIdSQL("ID");
        if (!StringUtils.hasLength((String)strSQL)) {
            return null;
        }
        List list = this.executeSelectSQL(strSQL, null);
        if (list == null || list.size() == 0) {
            return null;
        }
        Object objRow = list.get(0);
        if (objRow instanceof Map) {
            return ((Map)objRow).get("ID");
        }
        if (objRow instanceof IEntity) {
            return ((IEntity)objRow).get("ID");
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5bf9\u8c61\u7c7b\u578b");
    }
}

