/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.SimpleDBDialect;
import net.ibizsys.central.database.mssql.MSSQLDialect;
import net.ibizsys.central.database.mysql.MySQL5Dialect;
import net.ibizsys.central.database.oracle.OracleDialect;

public class DBDialectUtils {
    private static DBDialectUtils instance = null;
    private Map<String, IDBDialect> dbDialectMap = new HashMap<String, IDBDialect>();

    public static DBDialectUtils getInstance() {
        if (instance == null) {
            instance = new DBDialectUtils();
        }
        return instance;
    }

    public static void setInstance(DBDialectUtils instance) {
        DBDialectUtils.instance = instance;
    }

    public IDBDialect get(String strType) {
        IDBDialect iDBDialect = this.dbDialectMap.get(strType);
        if (iDBDialect == null) {
            iDBDialect = this.createDBDialect(strType);
            this.dbDialectMap.put(strType, iDBDialect);
        }
        return iDBDialect;
    }

    public void setDBDialect(String strType, IDBDialect iDBDialect) {
        this.dbDialectMap.put(strType, iDBDialect);
    }

    public boolean containsDBDialect(String strType) {
        return this.dbDialectMap.containsKey(strType);
    }

    protected IDBDialect createDBDialect(String strType) {
        if ("MYSQL5".equals(strType)) {
            return new MySQL5Dialect();
        }
        if ("ORACLE".equals(strType)) {
            return new OracleDialect();
        }
        if ("SQLSERVER".equals(strType)) {
            return new MSSQLDialect();
        }
        return new SimpleDBDialect(strType);
    }
}

