/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.codelist;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.codelist.DynamicCodeListRuntimeBase;
import net.ibizsys.central.codelist.IDEMainStateCodeListRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEMainStateCodeListRuntimeBase
extends DynamicCodeListRuntimeBase
implements IDEMainStateCodeListRuntime {
    private static final Log log = LogFactory.getLog(DEMainStateCodeListRuntimeBase.class);
    private IDEMSLogicRuntime iDEMSLogicRuntime = null;
    private IDataEntityRuntime iDataEntityRuntime = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getPSCodeList().getPSDataEntity() == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61", new Object[0]));
        }
        super.onInit();
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null) {
            this.iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSCodeList().getPSDataEntityMust().getId());
        }
        return this.iDataEntityRuntime;
    }

    public IDEMSLogicRuntime getDEMSLogicRuntime(boolean bTryMode) {
        IPSDEMSLogic iPSDEMSLogic;
        if (this.iDEMSLogicRuntime == null && (iPSDEMSLogic = this.getPSCodeList().getPSDEMSLogic()) != null) {
            this.iDEMSLogicRuntime = (IDEMSLogicRuntime)this.getSystemRuntime().getDataEntityRuntime(this.getPSCodeList().getPSDataEntityMust().getId()).getDEMSLogicRuntime(iPSDEMSLogic);
        }
        if (this.iDEMSLogicRuntime != null || bTryMode) {
            return this.iDEMSLogicRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u672a\u6307\u5b9a\u5b9e\u4f53\u4e3b\u72b6\u6001\u903b\u8f91", new Object[0]));
    }

    @Override
    public List<IPSCodeItem> getPSCodeItems(Object dataOrKey) {
        try {
            IDEMSLogicRuntime iDEMSLogicRuntime;
            IEntity iEntity = this.getEntity(dataOrKey);
            IDEMSLogicRuntime iDEMSLogicRuntime2 = iDEMSLogicRuntime = iEntity != null ? this.getDEMSLogicRuntime(iEntity) : null;
            if (iDEMSLogicRuntime != null) {
                List psDEMSLogicNodeList;
                ArrayList<IPSCodeItem> psCodeItemList = new ArrayList<IPSCodeItem>();
                List<IPSDEMSLogicNode> nextPSDEMSLogicNodeList = iDEMSLogicRuntime.getNextPSDEMSLogicNodes(iEntity);
                if (!ObjectUtils.isEmpty(nextPSDEMSLogicNodeList)) {
                    for (IPSDEMSLogicNode iPSDEMSLogicNode : nextPSDEMSLogicNodeList) {
                        IPSCodeItem iPSCodeItem = this.getPSCodeItem(iPSDEMSLogicNode, false);
                        psCodeItemList.add(iPSCodeItem);
                    }
                }
                if (!ObjectUtils.isEmpty((Object)(psDEMSLogicNodeList = iDEMSLogicRuntime.getPSDEMSLogic().getPSDEMSLogicNodes()))) {
                    for (IPSDEMSLogicNode iPSDEMSLogicNode : psDEMSLogicNodeList) {
                        if (nextPSDEMSLogicNodeList != null && nextPSDEMSLogicNodeList.contains(iPSDEMSLogicNode)) continue;
                        IPSCodeItem iPSCodeItem = this.getPSCodeItem(iPSDEMSLogicNode, true);
                        psCodeItemList.add(iPSCodeItem);
                    }
                }
                return psCodeItemList;
            }
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u4ee3\u7801\u9879\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        return super.getPSCodeItems(dataOrKey);
    }

    protected IDEMSLogicRuntime getDEMSLogicRuntime(IEntity iEntity) throws Throwable {
        IDEMSLogicRuntime iDEMSLogicRuntime = this.getDataEntityRuntime().getDEMSLogicRuntime(iEntity, true);
        if (iDEMSLogicRuntime != null) {
            return iDEMSLogicRuntime;
        }
        return this.getDEMSLogicRuntime(true);
    }

    protected IPSCodeItem getPSCodeItem(IPSDEMSLogicNode iPSDEMSLogicNode, boolean bDisabled) {
        String strValue = StringUtils.hasLength((String)iPSDEMSLogicNode.getStateValue()) ? iPSDEMSLogicNode.getStateValue() : iPSDEMSLogicNode.getCodeName();
        ObjectNode objNode = JsonUtils.createObjectNode();
        objNode.put("codeName", iPSDEMSLogicNode.getCodeName());
        objNode.put("name", iPSDEMSLogicNode.getName());
        objNode.put("value", strValue);
        objNode.put("text", iPSDEMSLogicNode.getName());
        if (StringUtils.hasLength((String)iPSDEMSLogicNode.getBKColor())) {
            objNode.put("bKColor", iPSDEMSLogicNode.getBKColor());
        }
        if (StringUtils.hasLength((String)iPSDEMSLogicNode.getColor())) {
            objNode.put("color", iPSDEMSLogicNode.getColor());
        }
        if (StringUtils.hasLength((String)iPSDEMSLogicNode.getCssClass())) {
            objNode.put("textCls", iPSDEMSLogicNode.getCssClass());
        }
        if (StringUtils.hasLength((String)iPSDEMSLogicNode.getMemo())) {
            objNode.put("tooltip", iPSDEMSLogicNode.getMemo());
        }
        if (iPSDEMSLogicNode.isDefaultMode()) {
            objNode.put("default", true);
        }
        if (bDisabled) {
            objNode.put("disableSelect", bDisabled);
        }
        return (IPSCodeItem)this.getSystemRuntimeBaseContext().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSCodeList(), IPSCodeItem.class, objNode);
    }

    protected IEntity getEntity(Object keyOrData) throws Throwable {
        if (keyOrData instanceof IEntity) {
            return (IEntity)keyOrData;
        }
        if (keyOrData instanceof Map) {
            return this.getDataEntityRuntime().createEntity((Map)keyOrData, false);
        }
        Object objKeyValue = DataTypeUtils.asSimple(keyOrData);
        IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
        iEntityDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), objKeyValue);
        return iEntityDTO;
    }
}

