/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.bi.util.BISearchDimension;
import net.ibizsys.central.bi.util.BISearchMeasure;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.bi.util.IBISearchDimension;
import net.ibizsys.central.bi.util.IBISearchMeasure;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BISearchContext
implements IBISearchContext {
    public static final TypeReference<List<BISearchDimension>> BISearchDimensionListType = new TypeReference<List<BISearchDimension>>(){};
    public static final TypeReference<List<BISearchMeasure>> BISearchMeasureListType = new TypeReference<List<BISearchMeasure>>(){};
    final transient ISearchContext iSearchContext;
    transient String strBICubeTag = null;
    transient String strBIReportTag = null;
    transient List<IBISearchMeasure> biSearchMeasureList = null;
    transient List<IBISearchDimension> biSearchDimensionList = null;

    public BISearchContext(ISearchContext iSearchContext) {
        Object bidimensions;
        Assert.notNull((Object)iSearchContext, (String)"\u672a\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587");
        this.iSearchContext = iSearchContext;
        this.strBICubeTag = DataTypeUtils.getStringValue(this.getSearchContext().get("bicubetag"), null);
        this.strBIReportTag = DataTypeUtils.getStringValue(this.getSearchContext().get("bireporttag"), null);
        Object bimeasures = this.getSearchContext().get("bimeasures");
        if (!ObjectUtils.isEmpty((Object)bimeasures)) {
            List<BISearchMeasure> list = JsonUtils.as(bimeasures, BISearchMeasureListType);
            this.biSearchMeasureList = list;
        }
        if (!ObjectUtils.isEmpty((Object)(bidimensions = this.getSearchContext().get("bidimensions")))) {
            List<BISearchDimension> list = JsonUtils.as(bidimensions, BISearchDimensionListType);
            this.biSearchDimensionList = list;
        }
    }

    @Override
    public ISearchContext getSearchContext() {
        return this.iSearchContext;
    }

    @Override
    public String getBICubeTag() {
        return this.strBICubeTag;
    }

    @Override
    public String getBIReportTag() {
        return this.strBIReportTag;
    }

    @Override
    public List<IBISearchDimension> getBISearchDimensionsIf() {
        if (this.biSearchDimensionList == null) {
            this.biSearchDimensionList = new ArrayList<IBISearchDimension>();
        }
        return this.biSearchDimensionList;
    }

    @Override
    public List<IBISearchDimension> getBISearchDimensions() {
        return this.biSearchDimensionList;
    }

    @Override
    public List<IBISearchMeasure> getBISearchMeasuresIf() {
        if (this.biSearchMeasureList == null) {
            this.biSearchMeasureList = new ArrayList<IBISearchMeasure>();
        }
        return this.biSearchMeasureList;
    }

    @Override
    public List<IBISearchMeasure> getBISearchMeasures() {
        return this.biSearchMeasureList;
    }
}

