/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.bi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.bi.ISysBICubeCalculatedDimensionParser;
import net.ibizsys.central.bi.ISysBICubeCalculatedMeasureParser;
import net.ibizsys.central.bi.ISysBICubeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntimeContext;
import net.ibizsys.central.bi.SysBISchemeRuntimeException;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.bi.util.IBISearchDimension;
import net.ibizsys.central.bi.util.IBISearchMeasure;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.IDEDynaStorageUtilRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.bi.IPSSysBICube;
import net.ibizsys.model.bi.IPSSysBICubeDimension;
import net.ibizsys.model.bi.IPSSysBICubeMeasure;
import net.ibizsys.model.bi.IPSSysBIHierarchy;
import net.ibizsys.model.bi.IPSSysBILevel;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysBICubeRuntimeBase
extends ModelRuntimeBase
implements ISysBICubeRuntime {
    private static final Log log = LogFactory.getLog(SysBICubeRuntimeBase.class);
    private ISysBISchemeRuntimeContext iSysBISchemeRuntimeContext = null;
    private IPSSysBICube iPSSysBICube = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private Map<String, IPSSysBICubeMeasure> psSysBICubeMeasureMap = new LinkedHashMap<String, IPSSysBICubeMeasure>();
    private Map<String, IPSSysBICubeDimension> psSysBICubeDimensionMap = new LinkedHashMap<String, IPSSysBICubeDimension>();
    private Map<String, String> dimensionFormulaMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> measureFormulaMap = new ConcurrentHashMap<String, String>();

    @Override
    public void init(ISysBISchemeRuntimeContext iSysBISchemeRuntimeContext, IPSSysBICube iPSSysBICube) throws Exception {
        this.iSysBISchemeRuntimeContext = iSysBISchemeRuntimeContext;
        this.iPSSysBICube = iPSSysBICube;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psSysBICubeDimensionList;
        List psSysBICubeMeasureList = this.getPSSysBICube().getAllPSSysBICubeMeasures();
        if (!ObjectUtils.isEmpty((Object)psSysBICubeMeasureList)) {
            for (IPSSysBICubeMeasure iPSSysBICubeMeasure : psSysBICubeMeasureList) {
                this.psSysBICubeMeasureMap.put(iPSSysBICubeMeasure.getCodeName().toLowerCase(), iPSSysBICubeMeasure);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psSysBICubeDimensionList = this.getPSSysBICube().getAllPSSysBICubeDimensions()))) {
            for (IPSSysBICubeDimension iPSSysBICubeDimension : psSysBICubeDimensionList) {
                this.psSysBICubeDimensionMap.put(iPSSysBICubeDimension.getCodeName().toLowerCase(), iPSSysBICubeDimension);
            }
        }
        this.iDataEntityRuntime = this.getSysBISchemeRuntime().getSystemRuntime().getDataEntityRuntime(this.getPSSysBICube().getPSDataEntityMust().getId(), true);
        if (this.iDataEntityRuntime == null) {
            throw new Exception("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        }
        super.onInit();
    }

    protected ISysBISchemeRuntimeContext getSysBISchemeRuntimeContext() {
        return this.iSysBISchemeRuntimeContext;
    }

    @Override
    public IPSSysBICube getPSSysBICube() {
        return this.iPSSysBICube;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysBICube();
    }

    @Override
    public String getId() {
        return this.getPSSysBICube().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysBICube().getName();
    }

    @Override
    public ISysBISchemeRuntime getSysBISchemeRuntime() {
        return this.getSysBISchemeRuntimeContext().getSysBISchemeRuntime();
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    @Override
    public IPSSysBICubeMeasure getPSSysBICubeMeasure(String strName, boolean bTryMode) {
        Assert.hasLength((String)strName, (String)"\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u6307\u6807\u540d\u79f0");
        IPSSysBICubeMeasure iPSSysBICubeMeasure = this.psSysBICubeMeasureMap.get(strName.toLowerCase());
        if (iPSSysBICubeMeasure != null || bTryMode) {
            return iPSSysBICubeMeasure;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    @Override
    public IPSSysBICubeDimension getPSSysBICubeDimension(String strName, boolean bTryMode) {
        Assert.hasLength((String)strName, (String)"\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u7ef4\u5ea6\u540d\u79f0");
        IPSSysBICubeDimension iPSSysBICubeDimension = this.psSysBICubeDimensionMap.get(strName.toLowerCase());
        if (iPSSysBICubeDimension != null || bTryMode) {
            return iPSSysBICubeDimension;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    @Override
    public List fetch(IBISearchContext iBISearchContext) throws Throwable {
        try {
            return this.onFetch(iBISearchContext);
        }
        catch (Throwable ex) {
            SysBISchemeRuntimeException.rethrow(this, ex);
            throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), (IModelRuntime)this, String.format("\u67e5\u8be2\u7acb\u65b9\u4f53\u6570\u636e\u53d1\u751f\u5f02\u5e38, %1$s", ex.getMessage()), ex);
        }
    }

    protected List onFetch(IBISearchContext iBISearchContext) throws Throwable {
        ObjectNode groupParamNode;
        if (ObjectUtils.isEmpty(iBISearchContext.getBISearchDimensions())) {
            throw new Exception("\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u7ef4\u5ea6");
        }
        if (ObjectUtils.isEmpty(iBISearchContext.getBISearchMeasures())) {
            throw new Exception("\u672a\u4f20\u5165\u7acb\u65b9\u4f53\u6307\u6807");
        }
        IPSDEDataSet iPSDEDataSet = this.getPSSysBICube().getPSDEDataSet();
        if (iPSDEDataSet == null) {
            iPSDEDataSet = this.getDataEntityRuntime().getDefaultPSDEDataSet();
        }
        ObjectNode deDataSetNode = iPSDEDataSet.getObjectNode().deepCopy();
        deDataSetNode.put("groupMode", PSModelEnums.DEDataSetGroupMode.GROUPPARAMEX.value);
        deDataSetNode.put("enableGroup", true);
        deDataSetNode.remove("getPSDEDataSetGroupParams");
        ArrayNode groupParamArray = deDataSetNode.putArray("getPSDEDataSetGroupParams");
        List<ObjectNode> dynaFieldParams = this.getDynaFieldDataSetGroupParamModels(iBISearchContext);
        if (!ObjectUtils.isEmpty(dynaFieldParams)) {
            groupParamArray.addAll(dynaFieldParams);
        }
        for (IBISearchMeasure iBISearchMeasure : iBISearchContext.getBISearchMeasures()) {
            IPSSysBICubeMeasure iPSSysBICubeMeasure = this.getPSSysBICubeMeasure(iBISearchMeasure.getName(), false);
            try {
                groupParamNode = this.getMeasureDataSetGroupParamModel(iBISearchContext, iBISearchMeasure, iPSSysBICubeMeasure);
                groupParamArray.add((JsonNode)groupParamNode);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u8ba1\u7b97\u6307\u6807\u6a21\u578b[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICubeMeasure.getName(), ex.getMessage()));
            }
        }
        for (IBISearchDimension iBISearchDimension : iBISearchContext.getBISearchDimensions()) {
            IPSSysBICubeDimension iPSSysBICubeDimension = this.getPSSysBICubeDimension(iBISearchDimension.getName(), false);
            try {
                groupParamNode = this.getDimensionDataSetGroupParamModel(iBISearchContext, iBISearchDimension, iPSSysBICubeDimension);
                groupParamArray.add((JsonNode)groupParamNode);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u8ba1\u7b97\u7ef4\u5ea6\u6a21\u578b[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBICubeDimension.getName(), ex.getMessage()));
            }
        }
        iPSDEDataSet = (IPSDEDataSet)this.getSysBISchemeRuntime().getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getDataEntityRuntime().getPSDataEntity(), IPSDEDataSet.class, deDataSetNode);
        Page page = this.doFetch(iBISearchContext, iPSDEDataSet);
        ArrayList<IEntity> entityList = new ArrayList<IEntity>();
        if (!ObjectUtils.isEmpty((Object)page.getContent())) {
            for (Object item : page.getContent()) {
                entityList.add(this.getSysBISchemeRuntime().getSystemRuntime().createEntity(item));
            }
        }
        return entityList;
    }

    protected Page doFetch(final IBISearchContext iBISearchContext, final IPSDEDataSet iPSDEDataSet) throws Throwable {
        ISearchContext iSearchContext = iBISearchContext.getSearchContext();
        iSearchContext.setCount(false);
        iSearchContext.setPageable(0, Integer.MAX_VALUE, 0L);
        return (Page)this.getDataEntityRuntime().execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return SysBICubeRuntimeBase.this.getDataEntityRuntime().getSystemPersistentAdapterMust().fetchDataSet(SysBICubeRuntimeBase.this.getDataEntityRuntime(), iPSDEDataSet, iBISearchContext.getSearchContext(), null);
            }
        }, null);
    }

    protected List<IPSDEField> getDynaFields() throws Throwable {
        List<IPSDEField> psDEFields = this.getDataEntityRuntime().getPSDEFields(true);
        if (ObjectUtils.isEmpty(psDEFields)) {
            return null;
        }
        ArrayList<IPSDEField> list = new ArrayList<IPSDEField>();
        for (IPSDEField iPSDEField : psDEFields) {
            if (!iPSDEField.isDynaStorageDEField()) continue;
            list.add(iPSDEField);
        }
        return list;
    }

    protected List<ObjectNode> getDynaFieldDataSetGroupParamModels(IBISearchContext iBISearchContext) throws Throwable {
        if (!this.getDataEntityRuntime().isEnableDynaStorage() || this.getDataEntityRuntime().getDEDynaStorageUtilRuntime() == null) {
            return null;
        }
        IDEDynaStorageUtilRuntime iDEDynaStorageUtilRuntime = this.getDataEntityRuntime().getDEDynaStorageUtilRuntime();
        IPSDEField parentTypePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
        IPSDEField parentIdPSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        IPSDEField namePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField("NAME", false);
        List<IPSDEField> psDEFields = this.getDynaFields();
        if (ObjectUtils.isEmpty(psDEFields)) {
            return null;
        }
        String strMajorAlias = "dataresult";
        String strKeyCode = "";
        strKeyCode = String.format("%1$s.%2$s", strMajorAlias, this.getDataEntityRuntime().getKeyPSDEField().getName());
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (int i = 0; i < psDEFields.size(); ++i) {
            IPSDEField iPSDEField = psDEFields.get(i);
            String strAlias = String.format("dynaresult%1$s", i);
            IPSDEField storagePSDEField = iDEDynaStorageUtilRuntime.getStoragePSDEField(iPSDEField);
            ObjectNode objectNode = JsonUtils.createObjectNode();
            String strJoinCode = String.format("LEFT JOIN %1$s %2$s ON (%3$s= %2$s.%4$s AND %2$s.%5$s = '%6$s' AND %2$s.%7$s = '%8$s')", iDEDynaStorageUtilRuntime.getStorageDataEntityRuntime().getTableName(), strAlias, strKeyCode, parentIdPSDEField.getName(), parentTypePSDEField.getName(), this.getDataEntityRuntime().getName(), namePSDEField.getName(), iPSDEField.getName());
            String strGroupCode = "";
            strGroupCode = strGroupCode + String.format("%1$s.%2$s AS %3$s", strAlias, storagePSDEField.getName(), iPSDEField.getName());
            objectNode.put("name", String.format("%1$s_%2$s", strAlias, iPSDEField.getName()).toLowerCase());
            objectNode.put("groupCode", strGroupCode);
            objectNode.put("groupJoinCode", strJoinCode);
            list.add(objectNode);
        }
        return list;
    }

    protected ObjectNode getMeasureDataSetGroupParamModel(IBISearchContext iBISearchContext, IBISearchMeasure iBISearchMeasure, IPSSysBICubeMeasure iPSSysBICubeMeasure) throws Throwable {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("name", iPSSysBICubeMeasure.getCodeName());
        objectNode.put("alias", iPSSysBICubeMeasure.getCodeName());
        IPSDEField iPSDEField = iPSSysBICubeMeasure.getPSDEField();
        if (iPSDEField != null) {
            objectNode.put("getPSDEField", iPSSysBICubeMeasure.getObjectNode().get("getPSDEField").deepCopy());
            objectNode.put("name", iPSDEField.getName());
        }
        if (StringUtils.hasLength((String)iBISearchMeasure.getAggMode())) {
            objectNode.put("aggMode", iBISearchMeasure.getAggMode());
        } else {
            objectNode.put("aggMode", iPSSysBICubeMeasure.getAggMode());
        }
        objectNode.put("enableGroup", false);
        if (PSModelEnums.BIMeasureType.COMMON.value.equals(iPSSysBICubeMeasure.getMeasureType())) {
            if (iPSDEField == null) {
                throw new Exception(String.format("\u6307\u6807[%1$s]\u672a\u6307\u5b9a\u5c5e\u6027", iPSSysBICubeMeasure.getName()));
            }
        } else if (PSModelEnums.BIMeasureType.CALCULATED.value.equals(iPSSysBICubeMeasure.getMeasureType())) {
            String strFormula = this.measureFormulaMap.get(iPSSysBICubeMeasure.getCodeName());
            if (!StringUtils.hasLength((String)strFormula)) {
                ISysBICubeCalculatedMeasureParser iSysBICubeCalculatedMeasureParser = this.iDataEntityRuntime.getSystemRuntime().getRuntimeObject(ISysBICubeCalculatedMeasureParser.class, "SQL");
                if (iSysBICubeCalculatedMeasureParser == null) {
                    throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a[%1$s]\u8ba1\u7b97\u6307\u6807\u5206\u6790\u5668", "SQL"));
                }
                strFormula = iSysBICubeCalculatedMeasureParser.parse(iPSSysBICubeMeasure, this, iBISearchContext);
                this.measureFormulaMap.put(iPSSysBICubeMeasure.getCodeName(), strFormula);
            }
            objectNode.put("groupCode", strFormula);
        } else {
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6307\u6807\u7c7b\u578b[%1$s]", iPSSysBICubeMeasure.getMeasureType()));
        }
        return objectNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ObjectNode getDimensionDataSetGroupParamModel(IBISearchContext iBISearchContext, IBISearchDimension iBISearchDimension, IPSSysBICubeDimension iPSSysBICubeDimension) throws Throwable {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        IPSDEField iPSDEField = iPSSysBICubeDimension.getPSDEField();
        objectNode.put("name", iPSSysBICubeDimension.getCodeName());
        objectNode.put("alias", iPSSysBICubeDimension.getCodeName());
        if (iPSDEField != null) {
            objectNode.put("getPSDEField", iPSSysBICubeDimension.getObjectNode().get("getPSDEField").deepCopy());
            objectNode.put("name", iPSDEField.getName());
        }
        objectNode.put("enableGroup", true);
        if (iPSSysBICubeDimension.getPSSysBIDimension() == null) {
            if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                if (iPSDEField != null) return objectNode;
                throw new Exception(String.format("\u7ef4\u5ea6[%1$s]\u672a\u6307\u5b9a\u5c5e\u6027", iPSSysBICubeDimension.getName()));
            }
            if (!PSModelEnums.BIDimensionType.CALCULATED.value.equals(iPSSysBICubeDimension.getDimensionType())) throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
            String strFormula = this.dimensionFormulaMap.get(iPSSysBICubeDimension.getCodeName());
            if (!StringUtils.hasLength((String)strFormula)) {
                ISysBICubeCalculatedDimensionParser iSysBICubeCalculatedDimensionParser = this.iDataEntityRuntime.getSystemRuntime().getRuntimeObject(ISysBICubeCalculatedDimensionParser.class, "SQL");
                if (iSysBICubeCalculatedDimensionParser == null) {
                    throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a[%1$s]\u8ba1\u7b97\u7ef4\u5ea6\u5206\u6790\u5668", "SQL"));
                }
                strFormula = iSysBICubeCalculatedDimensionParser.parse(iPSSysBICubeDimension, this, iBISearchContext);
                this.dimensionFormulaMap.put(iPSSysBICubeDimension.getCodeName(), strFormula);
            }
            objectNode.put("groupCode", strFormula);
            return objectNode;
        } else {
            String strHierarchy = iBISearchDimension.getHierarchy();
            IPSSysBIHierarchy iPSSysBIHierarchy = null;
            List list = iPSSysBICubeDimension.getPSSysBIDimension().getAllPSSysBIHierarchies();
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (IPSSysBIHierarchy item : list) {
                    if (StringUtils.hasLength((String)strHierarchy)) {
                        if (!strHierarchy.equalsIgnoreCase(item.getCodeName())) continue;
                        iPSSysBIHierarchy = item;
                        break;
                    }
                    iPSSysBIHierarchy = item;
                    break;
                }
            }
            if (iPSSysBIHierarchy == null) {
                throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u5c42\u6b21\u4f53\u7cfb[%1$s]", strHierarchy));
            }
            LinkedHashSet<IPSSysBILevel> selectedPSSysBILevelList = new LinkedHashSet<IPSSysBILevel>();
            List psSysBILevelList = iPSSysBIHierarchy.getAllPSSysBILevels();
            if (!ObjectUtils.isEmpty((Object)psSysBILevelList)) {
                block1: for (IPSSysBILevel item : psSysBILevelList) {
                    if (item.isUniqueMembers()) {
                        selectedPSSysBILevelList.add(item);
                        continue;
                    }
                    if (ObjectUtils.isEmpty(iBISearchDimension.getLevels())) continue;
                    for (String strLevel : iBISearchDimension.getLevels()) {
                        if (!strLevel.equalsIgnoreCase(item.getCodeName())) continue;
                        selectedPSSysBILevelList.add(item);
                        continue block1;
                    }
                }
            }
            LinkedHashMap<String, String> levelMap = new LinkedHashMap<String, String>();
            for (IPSSysBILevel item : selectedPSSysBILevelList) {
                if (item.getValuePSDEField() == null) continue;
                levelMap.put(item.getValuePSDEField().getName(), item.getCodeName());
                if (item.getTextPSDEField() == null) continue;
                levelMap.put(item.getTextPSDEField().getName(), item.getTextPSDEField().getCodeName());
            }
            String strMajorAlias = "dataresult";
            String strKeyCode = "";
            if (PSModelEnums.BIDimensionType.COMMON.value.equals(iPSSysBICubeDimension.getDimensionType())) {
                strKeyCode = String.format("%1$s.%2$s", strMajorAlias, iPSSysBICubeDimension.getPSDEFieldMust().getName());
            } else {
                if (!PSModelEnums.BIDimensionType.CALCULATED.value.equals(iPSSysBICubeDimension.getDimensionType())) throw new Exception(String.format("\u672a\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b[%1$s]", iPSSysBICubeDimension.getDimensionType()));
                String strFormula = this.dimensionFormulaMap.get(iPSSysBICubeDimension.getCodeName());
                if (!StringUtils.hasLength((String)strFormula)) {
                    ISysBICubeCalculatedDimensionParser iSysBICubeCalculatedDimensionParser = this.getDataEntityRuntime().getSystemRuntime().getRuntimeObject(ISysBICubeCalculatedDimensionParser.class, "SQL");
                    if (iSysBICubeCalculatedDimensionParser == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a[%1$s]\u8ba1\u7b97\u7ef4\u5ea6\u5206\u6790\u5668", "SQL"));
                    }
                    strFormula = iSysBICubeCalculatedDimensionParser.parse(iPSSysBICubeDimension, this, iBISearchContext);
                    this.dimensionFormulaMap.put(iPSSysBICubeDimension.getCodeName(), strFormula);
                }
                strKeyCode = strFormula;
            }
            IDataEntityRuntime biHierarchyDataEntityRuntime = this.getDataEntityRuntime().getSystemRuntime().getDataEntityRuntime(iPSSysBIHierarchy.getPSDataEntityMust().getId());
            String strJoinCode = String.format("LEFT JOIN %1$s %2$s ON (%3$s= %2$s.%4$s)", biHierarchyDataEntityRuntime.getTableName(), iPSSysBICubeDimension.getCodeName(), strKeyCode, biHierarchyDataEntityRuntime.getKeyPSDEField().getName());
            String strGroupCode = "";
            for (Map.Entry entry : levelMap.entrySet()) {
                if (StringUtils.hasLength((String)strGroupCode)) {
                    strGroupCode = strGroupCode + ",";
                }
                strGroupCode = strGroupCode + String.format("%1$s.%2$s AS %3$s", iPSSysBICubeDimension.getCodeName(), entry.getKey(), entry.getValue());
            }
            objectNode.put("groupCode", strGroupCode);
            objectNode.put("groupJoinCode", strJoinCode);
        }
        return objectNode;
    }
}

