/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.app;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.app.ApplicationRuntimeException;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.app.IApplicationRuntimeContext;
import net.ibizsys.central.app.dataentity.AppDataEntityRSRuntime;
import net.ibizsys.central.app.dataentity.AppDataEntityRuntime;
import net.ibizsys.central.app.dataentity.IAppDataEntityRSRuntime;
import net.ibizsys.central.app.dataentity.IAppDataEntityRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDERS;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.runtime.util.domain.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ApplicationRuntimeBase
extends SystemModelRuntimeBase
implements IApplicationRuntime {
    private static final Log log = LogFactory.getLog(ApplicationRuntimeBase.class);
    private IPSApplication iPSApplication = null;
    private Map<String, IAppDataEntityRuntime> appDataEntityRuntimeMap = null;
    private Map<String, IAppDataEntityRSRuntime> appDataEntityRSRuntimeMap = null;
    private IApplicationRuntimeContext iApplicationRuntimeContext = new IApplicationRuntimeContext(){

        @Override
        public IApplicationRuntime getApplicationRuntime() {
            return ApplicationRuntimeBase.this.getSelf();
        }
    };

    public static String getConfigFolder(IPSApplication iPSApplication) {
        return "app." + PSModelUtils.calcUniqueTag((String)iPSApplication.getCodeName());
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSApplication iPSApplication) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSApplication = iPSApplication;
        Assert.notNull((Object)this.iPSApplication, (String)"\u4f20\u5165\u7cfb\u7edf\u524d\u7aef\u5e94\u7528\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setConfigFolder(ApplicationRuntimeBase.getConfigFolder(iPSApplication));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.preparePSAppDataEntities();
    }

    protected void preparePSAppDataEntities() throws Exception {
        List psAppDataEntitys = this.getPSApplication().getAllPSAppDataEntities();
        if (psAppDataEntitys != null) {
            for (IPSAppDataEntity iPSAppDataEntity : psAppDataEntitys) {
                this.registerPSAppDataEntity(iPSAppDataEntity);
            }
            for (IPSAppDataEntity iPSAppDataEntity : psAppDataEntitys) {
                List psAppDERSs = iPSAppDataEntity.getMinorPSAppDERSs();
                if (psAppDERSs == null) continue;
                for (IPSAppDERS iPSAppDERS : psAppDERSs) {
                    this.registerPSAppDERS(iPSAppDERS);
                }
            }
        }
    }

    @Override
    public IPSApplication getPSApplication() {
        return this.iPSApplication;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSApplication();
    }

    @Override
    public String getId() {
        return this.getPSApplication().getId();
    }

    @Override
    public String getName() {
        return this.getPSApplication().getName();
    }

    protected IApplicationRuntimeContext getApplicationRuntimeContext() {
        return this.iApplicationRuntimeContext;
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return (ISystemRuntimeContext)super.getSystemRuntimeBaseContext();
    }

    private IApplicationRuntime getSelf() {
        return this;
    }

    @Override
    public IAppDataEntityRuntime getAppDataEntityRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bb0\u65e0\u6548");
        IAppDataEntityRuntime iAppDataEntityRuntime = null;
        if (this.appDataEntityRuntimeMap != null && (iAppDataEntityRuntime = this.appDataEntityRuntimeMap.get(strTag)) == null) {
            iAppDataEntityRuntime = this.appDataEntityRuntimeMap.get(strTag.toUpperCase());
        }
        if (iAppDataEntityRuntime != null || bTryMode) {
            return iAppDataEntityRuntime;
        }
        throw new ApplicationRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5e94\u7528\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
    }

    protected IAppDataEntityRuntime registerPSAppDataEntity(IPSAppDataEntity iPSAppDataEntity) {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.createAppDataEntityRuntime(iPSAppDataEntity);
        if (iAppDataEntityRuntime == null) {
            return null;
        }
        try {
            iAppDataEntityRuntime.init(this.getApplicationRuntimeContext(), iPSAppDataEntity);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("\u521d\u59cb\u5316\u5e94\u7528\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSAppDataEntity.getName(), ex.getMessage()), ex);
        }
        if (this.appDataEntityRuntimeMap == null) {
            this.appDataEntityRuntimeMap = new HashMap<String, IAppDataEntityRuntime>();
        }
        this.appDataEntityRuntimeMap.put(iPSAppDataEntity.getName().toUpperCase(), iAppDataEntityRuntime);
        this.appDataEntityRuntimeMap.put(iPSAppDataEntity.getId(), iAppDataEntityRuntime);
        return iAppDataEntityRuntime;
    }

    protected IAppDataEntityRuntime createAppDataEntityRuntime(IPSAppDataEntity iPSAppDataEntity) {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getSystemRuntime().getRuntimeObject(iPSAppDataEntity.getPSSysSFPlugin(), IAppDataEntityRuntime.class, true);
        if (iAppDataEntityRuntime != null) {
            return iAppDataEntityRuntime;
        }
        return this.createDefaultAppDataEntityRuntime();
    }

    protected IAppDataEntityRuntime createDefaultAppDataEntityRuntime() {
        return new AppDataEntityRuntime();
    }

    @Override
    public IAppDataEntityRSRuntime getAppDataEntityRSRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u524d\u7aef\u5e94\u7528\u5173\u7cfb\u6807\u8bb0\u65e0\u6548");
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (this.appDataEntityRSRuntimeMap != null && (iAppDataEntityRSRuntime = this.appDataEntityRSRuntimeMap.get(strTag)) == null) {
            iAppDataEntityRSRuntime = this.appDataEntityRSRuntimeMap.get(strTag.toUpperCase());
        }
        if (iAppDataEntityRSRuntime != null || bTryMode) {
            return iAppDataEntityRSRuntime;
        }
        throw new ApplicationRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5e94\u7528\u5b9e\u4f53\u5173\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
    }

    protected IAppDataEntityRSRuntime registerPSAppDERS(IPSAppDERS iPSAppDERS) {
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = this.createAppDataEntityRSRuntime(iPSAppDERS);
        if (iAppDataEntityRSRuntime == null) {
            return null;
        }
        try {
            iAppDataEntityRSRuntime.init(this.getApplicationRuntimeContext(), iPSAppDERS);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("\u521d\u59cb\u5316\u5e94\u7528\u5b9e\u4f53\u5173\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSAppDERS.getName(), ex.getMessage()), ex);
        }
        if (this.appDataEntityRSRuntimeMap == null) {
            this.appDataEntityRSRuntimeMap = new HashMap<String, IAppDataEntityRSRuntime>();
        }
        this.appDataEntityRSRuntimeMap.put(String.format("%1$s|%2$s", iPSAppDERS.getMajorPSAppDataEntityMust().getName(), iPSAppDERS.getMinorPSAppDataEntityMust().getName()).toUpperCase(), iAppDataEntityRSRuntime);
        this.appDataEntityRSRuntimeMap.put(iPSAppDERS.getId(), iAppDataEntityRSRuntime);
        return iAppDataEntityRSRuntime;
    }

    protected IAppDataEntityRSRuntime createAppDataEntityRSRuntime(IPSAppDERS iPSAppDERS) {
        return this.createDefaultAppDataEntityRSRuntime();
    }

    protected IAppDataEntityRSRuntime createDefaultAppDataEntityRSRuntime() {
        return new AppDataEntityRSRuntime();
    }

    @Override
    public Object invokeDEMethod(String strScope, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        return this.invokeDEMethod(strScope, null, null, strDataEntityName, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEMethod(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.invokeMethod(strScope, iAppDataEntityRSRuntime, strParentKey, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.importData(strScope, iAppDataEntityRSRuntime, strParentKey, strImportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.exportData(strScope, iAppDataEntityRSRuntime, strParentKey, strExportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.exportData(strScope, iAppDataEntityRSRuntime, strParentKey, strExportTag, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEPrintData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.printData(strScope, iAppDataEntityRSRuntime, strParentKey, strPrintTag, strPrintType, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEWFStart(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.wfStart(strScope, iAppDataEntityRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEWFCancel(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.wfCancel(strScope, iAppDataEntityRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEUploadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.uploadFile(strScope, iAppDataEntityRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
    }

    @Override
    public Object invokeDEDownloadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        IAppDataEntityRuntime iAppDataEntityRuntime = this.getAppDataEntityRuntime(strDataEntityName, false);
        IAppDataEntityRSRuntime iAppDataEntityRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName)) {
            iAppDataEntityRSRuntime = this.getAppDataEntityRSRuntime(String.format("%1$s|%2$s", strParentDEName, iAppDataEntityRuntime.getName()).toUpperCase(), false);
        }
        return iAppDataEntityRuntime.downloadFile(strScope, iAppDataEntityRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
    }
}

