/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central;

import com.fasterxml.jackson.core.type.TypeReference;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.ibizsys.central.DefaultSystemLogAdapter;
import net.ibizsys.central.ISystemGatewayContext;
import net.ibizsys.central.ISystemLogAdapter;
import net.ibizsys.central.ISystemLogListener;
import net.ibizsys.central.ISystemLogListenerProxy;
import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ISystemRuntimeSetting;
import net.ibizsys.central.SystemPersistentAdapter;
import net.ibizsys.central.SystemRuntimeSetting;
import net.ibizsys.central.app.ApplicationRuntime;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.backend.ISysBackendTaskRuntime;
import net.ibizsys.central.backend.SysAdminBackendTaskRuntime;
import net.ibizsys.central.backend.SysDEActionBackendTaskRuntime;
import net.ibizsys.central.backend.SysDENotifyBackendTaskRuntime;
import net.ibizsys.central.backend.SysDataSyncAgentBackendTaskRuntime;
import net.ibizsys.central.backend.SysUserBackendTaskRuntime;
import net.ibizsys.central.backend.SysWFCallbackBackendTaskRuntime;
import net.ibizsys.central.bi.ISysBICubeCalculatedDimensionParser;
import net.ibizsys.central.bi.ISysBICubeCalculatedMeasureParser;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.bi.SysBISchemeRuntime;
import net.ibizsys.central.codelist.DynamicCodeListRuntime;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.SimpleDBDialect;
import net.ibizsys.central.database.SysDBSchemeRuntime;
import net.ibizsys.central.database.mysql.MySQL5Dialect;
import net.ibizsys.central.dataentity.DataEntityGroupRuntime;
import net.ibizsys.central.dataentity.DataEntityRuntime;
import net.ibizsys.central.dataentity.IDataEntityGroupRuntime;
import net.ibizsys.central.dataentity.IDataEntityGroupUtilRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.datasync.DEDataSyncInRuntime;
import net.ibizsys.central.dataentity.datasync.DEDataSyncOutRuntime;
import net.ibizsys.central.dataentity.demap.DEMapRuntime;
import net.ibizsys.central.dataentity.demap.IDEMapRuntime;
import net.ibizsys.central.dataentity.ds.IDEDQSQLCustomCondParser;
import net.ibizsys.central.dataentity.logic.DELogicAppContextParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicAppGlobalParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicAppendParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicBindParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicCommitNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicCopyParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEActionNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEDataFlowNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEDataQueryNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEDataSetNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEDataSyncNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDELogicNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDENotifyNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDEPrintNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicDebugParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicEndNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicEntityListParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicEntityPageParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicEntityParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicEnvParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicFileListParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicFileParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicFilterParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicLastParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicLastReturnParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicLoopSubCallNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicMergeParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicPrepareParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRawSFCodeNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRawSqlAndLoopCallNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRawSqlCallNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRawWebCallNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRenewParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicResetParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicRollbackNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSFPluginNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSessionParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSimpleListParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSimpleParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSortParamNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicStartWFNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSubSysSAMethodNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSubmitWFNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSysDataSyncAgentOutNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSysLogicNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicSysUtilNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicThrowExceptionNodeRuntime;
import net.ibizsys.central.dataentity.logic.DELogicWebContextParamRuntime;
import net.ibizsys.central.dataentity.logic.DELogicWebResponseParamRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicNodeRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicParamRuntime;
import net.ibizsys.central.dataentity.logic.SimpleDELogicNodeRuntime;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.dataentity.testing.DEActionTestCaseRuntime;
import net.ibizsys.central.eai.SysEAIAgentRuntimeBase;
import net.ibizsys.central.msg.ISysMsgTemplRuntime;
import net.ibizsys.central.msg.SysRTMsgQueueRuntime;
import net.ibizsys.central.res.ISysResourceRuntime;
import net.ibizsys.central.res.ISysUniStateRuntime;
import net.ibizsys.central.res.SysContentCatResourceRuntime;
import net.ibizsys.central.res.SysResourceRuntime;
import net.ibizsys.central.res.SysUniStateRuntime;
import net.ibizsys.central.res.SysZipFileResourceRuntime;
import net.ibizsys.central.search.ISysSearchSchemeRuntime;
import net.ibizsys.central.search.SysSearchSchemeRuntime;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.security.SystemAccessManager;
import net.ibizsys.central.security.UserContextRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIScriptLogicRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.SubSysServiceAPIRuntime;
import net.ibizsys.central.service.SubSysServiceAPIScriptLogicRuntime;
import net.ibizsys.central.service.SysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.system.ISysRefRuntime;
import net.ibizsys.central.system.ISystemModuleRuntime;
import net.ibizsys.central.system.ISystemModuleUtilRuntime;
import net.ibizsys.central.system.SysRefRuntime;
import net.ibizsys.central.system.SystemModuleRuntime;
import net.ibizsys.central.sysutil.DefaultSysFileUtilRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.sysutil.ISysUniStateUtilRuntime;
import net.ibizsys.central.sysutil.ISysUtilRuntime;
import net.ibizsys.central.sysutil.SysLogListenerUtilRuntime;
import net.ibizsys.central.testing.ISysTestCaseRuntime;
import net.ibizsys.central.testing.ISysTestDataRuntime;
import net.ibizsys.central.testing.SysTestDataRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.IWebResponse;
import net.ibizsys.central.util.groovy.ISystemRTGroovyContext;
import net.ibizsys.central.util.groovy.MetaClassCreationHandle;
import net.ibizsys.central.util.groovy.SystemRTGroovyContext;
import net.ibizsys.central.util.script.IScriptList;
import net.ibizsys.central.util.script.IScriptPage;
import net.ibizsys.central.util.script.IScriptWebResponse;
import net.ibizsys.central.util.script.ISystemRTScriptContext;
import net.ibizsys.central.util.script.ScriptEntity;
import net.ibizsys.central.util.script.ScriptList;
import net.ibizsys.central.util.script.ScriptPage;
import net.ibizsys.central.util.script.ScriptWebResponse;
import net.ibizsys.central.util.script.SystemRTScriptContext;
import net.ibizsys.model.IPSDynaInstService;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.backservice.IPSSysBackService;
import net.ibizsys.model.bi.IPSSysBIScheme;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.dataentity.IPSDEGroup;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.datasync.IPSDEDataSync;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.msg.IPSSysMsgQueue;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysResource;
import net.ibizsys.model.res.IPSSysUniState;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.search.IPSSysSearchScheme;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSysRef;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestData;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncInRuntime;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncOutRuntime;
import net.ibizsys.runtime.dataentity.print.IDEPrintRuntime;
import net.ibizsys.runtime.dataentity.report.IDEReportRuntime;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ModelRuntimeUtils;
import net.ibizsys.runtime.util.script.IScriptEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SystemRuntime
extends SystemRuntimeBase
implements ISystemRuntime {
    private static final Log log = LogFactory.getLog(SystemRuntime.class);
    private String strDeploySystemId = null;
    private ISystemGatewayContext iSystemGatewayContext = null;
    private Object data = null;
    private ISystemRuntimeSetting iSystemRuntimeSetting = null;
    private Map<String, IPSDataEntity> psDataEntityMap = new ConcurrentHashMap<String, IPSDataEntity>();
    private Map<String, IDataEntityRuntime> dataEntityRuntimeMap = new ConcurrentHashMap<String, IDataEntityRuntime>();
    private Map<String, ISysResourceRuntime> sysResourceRuntimeMap = null;
    private Map<String, ISysUniStateRuntime> sysUniStateRuntimeMap = null;
    private Map<String, ISysRefRuntime> sysRefRuntimeMap = null;
    private Map<String, ISystemModuleRuntime> systemModuleRuntimeMap = null;
    private Map<String, IDataEntityGroupRuntime> dataEntityGroupRuntimeMap = null;
    private List<IDataEntityGroupUtilRuntime> dataEntityGroupUtilRuntimeList = null;
    private Map<String, ISysServiceAPIRuntime> sysServiceAPIRuntimeMap = null;
    private Map<String, IApplicationRuntime> applicationRuntimeMap = null;
    private Map<String, ISysDBSchemeRuntime> sysDBSchemeRuntimeMap = null;
    private Map<String, ISysBDSchemeRuntime> sysBDSchemeRuntimeMap = null;
    private ISysBDSchemeRuntime defaultSysBDSchemeRuntime = null;
    private Map<String, ISysSearchSchemeRuntime> sysSearchSchemeRuntimeMap = null;
    private Map<String, ISysBISchemeRuntime> sysBISchemeRuntimeMap = null;
    private Map<String, ISysBackendTaskRuntime> sysBackendTaskRuntimeMap = null;
    private Map<String, ISubSysServiceAPIRuntime> subSysServiceAPIRuntimeMap = null;
    private Map<String, IDBDialect> dbDialectMap = new ConcurrentHashMap<String, IDBDialect>();
    private Map<String, ISysTestDataRuntime> sysTestDataRuntimeMap = null;
    private ISystemPersistentAdapter iSystemPersistentAdapter = null;
    private ISystemAccessManager iSystemAccessManager = null;
    private ISystemLogAdapter iSystemLogAdapter = null;
    private Map<String, IDELogicNodeRuntime> deELogicNodeRuntimeMap = new ConcurrentHashMap<String, IDELogicNodeRuntime>();
    private Map<String, IDEService> deServiceMap = new ConcurrentHashMap<String, IDEService>();
    private Map<String, String> deServiceObjMap = new ConcurrentHashMap<String, String>();
    private IWebClient defaultWebClient = null;
    private ISysUniStateUtilRuntime iSysUniStateUtilRuntime = null;
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;
    private String strDeploySessionId = null;
    private ISystemRTGroovyContext iSystemRTGroovyContext = null;
    private ISystemRuntimeContext iSystemRuntimeContext = new ISystemRuntimeContext(){

        @Override
        public ISystemRuntime getSystemRuntime() {
            return SystemRuntime.this.getSelf();
        }

        @Override
        public ISystemPersistentAdapter getSystemPersistentAdapter(IPSDataEntity iPSDataEntity) throws Exception {
            return SystemRuntime.this.internalGetSystemPersistentAdapter(iPSDataEntity);
        }

        @Override
        public IPSSystemService getPSSystemService() {
            return SystemRuntime.this.getSelf().getPSSystemService();
        }

        @Override
        public int getStorageMode(IPSDataEntity iPSDataEntity) {
            return SystemRuntime.this.getSelf().getDataEntityStorageMode(iPSDataEntity);
        }
    };

    @Override
    public void init(ISystemGatewayContext iSystemGatewayContext, IPSSystemService iPSSystemService, String strDeploySystemId, Object data) throws Exception {
        this.strDeploySystemId = strDeploySystemId;
        this.iSystemGatewayContext = iSystemGatewayContext;
        if (iPSSystemService != null) {
            this.setPSSystemService(iPSSystemService);
        } else {
            this.setPSSystemService(this.createPSSystemService());
        }
        this.strDeploySessionId = KeyValueUtils.genUniqueId(strDeploySystemId, DateUtils.getCurTimeString2(), KeyValueUtils.genUniqueId());
        this.setPSModelEngineVer(this.getPSSystem().getEngineVer());
        if (data instanceof ISystemRuntimeSetting) {
            ISystemRuntimeSetting iSystemRuntimeSetting = (ISystemRuntimeSetting)data;
            this.setSystemRuntimeSetting(iSystemRuntimeSetting);
            this.data = this.getSystemRuntimeSetting().getParam("data");
        } else if (data instanceof Map) {
            this.prepareSystemSetting((Map)data);
            this.data = this.getSystemRuntimeSetting().getParam("data");
        } else {
            this.data = data;
            if (this.getSystemRuntimeSetting() == null) {
                this.prepareSystemSetting(null);
            }
        }
        this.prepareSysSFPluginRuntimes();
        this.prepareThreadPoolExecutors();
        this.onInit();
        this.onBeforeStart();
        this.onStart();
        this.onAfterStart();
        this.markLoaded();
    }

    @Override
    protected void onInit() throws Exception {
        List psSysBackServices;
        List psApplications;
        List psSysServiceAPIs;
        List psSysDataSyncAgents;
        ISystemAccessManager iSystemAccessManager;
        ISystemPersistentAdapter iSystemPersistentAdapter;
        List psSubSysServiceAPIs;
        List psSysBISchemes;
        List psSysSearchSchemes;
        List psSysBDSchemes;
        List psSysDBSchemes;
        List psDEGroups;
        List psSystemModules;
        List psSysUtils;
        List psSysResources;
        List psSysRefs;
        if (this.getSystemLogAdapter() == null) {
            try {
                this.prepareSystemLogAdapter();
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u51c6\u5907\u7cfb\u7edf\u65e5\u5fd7\u9002\u914d\u5668\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        try {
            this.prepareSystemFolders();
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u51c6\u5907\u7cfb\u7edf\u6587\u4ef6\u5939\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        List psDataEntityList = this.getPSSystem().getAllPSDataEntities();
        if (psDataEntityList != null) {
            for (Object iPSDataEntity : psDataEntityList) {
                if (StringUtils.hasLength((String)iPSDataEntity.getId())) {
                    this.psDataEntityMap.put(iPSDataEntity.getId(), (IPSDataEntity)iPSDataEntity);
                }
                if (!StringUtils.hasLength((String)iPSDataEntity.getName())) continue;
                this.psDataEntityMap.put(iPSDataEntity.getName().toLowerCase(), (IPSDataEntity)iPSDataEntity);
                if (iPSDataEntity.getPSSystemModule() == null) continue;
                this.psDataEntityMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSDataEntity.getPSSystemModule(), (String)iPSDataEntity.getName()), (IPSDataEntity)iPSDataEntity);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psSysRefs = this.getPSSystem().getAllPSSysRefs()))) {
            for (Object iPSSysRef : psSysRefs) {
                this.registerPSSysRef((IPSSysRef)iPSSysRef);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psSysResources = this.getPSSystem().getAllPSSysResources()))) {
            for (IPSSysResource iPSSysResource : psSysResources) {
                this.registerPSSysResource(iPSSysResource);
            }
        }
        if ((psSysUtils = this.getPSSystem().getAllPSSysUtils()) != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                if (iPSSysUtil.getOrderValue() < 0 || iPSSysUtil.getOrderValue() >= 100) continue;
                this.registerPSSysUtil(iPSSysUtil);
            }
        }
        if ((psSystemModules = this.getPSSystem().getAllPSSystemModules()) != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModules) {
                this.registerPSSystemModule(iPSSystemModule);
            }
        }
        if ((psDEGroups = this.getPSSystem().getAllPSSysDEGroups()) != null) {
            for (IPSDEGroup iPSDEGroup : psDEGroups) {
                this.registerPSDEGroup(iPSDEGroup);
            }
        }
        if ((psSysDBSchemes = this.getPSSystem().getAllPSSysDBSchemes()) != null) {
            for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
                this.registerPSSysDBScheme(iPSSysDBScheme);
            }
        }
        if ((psSysBDSchemes = this.getPSSystem().getAllPSSysBDSchemes()) != null) {
            for (Object iPSSysBDScheme : psSysBDSchemes) {
                ISysBDSchemeRuntime iSysBDSchemeRuntime = this.registerPSSysBDScheme((IPSSysBDScheme)iPSSysBDScheme);
                if (iSysBDSchemeRuntime == null || !iSysBDSchemeRuntime.isDefaultMode() || this.getDefaultSysBDSchemeRuntime() != null) continue;
                this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
            }
        }
        if (this.getDefaultSysBDSchemeRuntime() == null) {
            try {
                this.prepareDefaultSysBDSchemeRuntime();
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u51c6\u5907\u7cfb\u7edf\u9ed8\u8ba4\u5927\u6570\u636e\u4f53\u7cfb\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if ((psSysSearchSchemes = this.getPSSystem().getAllPSSysSearchSchemes()) != null) {
            for (IPSSysSearchScheme iPSSysSearchScheme : psSysSearchSchemes) {
                ISysSearchSchemeRuntime iSysSearchSchemeRuntime = this.registerPSSysSearchScheme(iPSSysSearchScheme);
            }
        }
        if ((psSysBISchemes = this.getPSSystem().getAllPSSysBISchemes()) != null) {
            for (IPSSysBIScheme iPSSysBIScheme : psSysBISchemes) {
                ISysBISchemeRuntime iSysBISchemeRuntime = this.registerPSSysBIScheme(iPSSysBIScheme);
            }
        }
        if ((psSubSysServiceAPIs = this.getPSSystem().getAllPSSubSysServiceAPIs()) != null) {
            for (IPSSubSysServiceAPI iPSSubSysServiceAPI : psSubSysServiceAPIs) {
                this.registerPSSubSysServiceAPI(iPSSubSysServiceAPI);
            }
        }
        if ((iSystemPersistentAdapter = this.createSystemPersistentAdapter()) != null) {
            iSystemPersistentAdapter.init(this.getSystemRuntimeContext());
            this.iSystemPersistentAdapter = iSystemPersistentAdapter;
        }
        if ((iSystemAccessManager = this.createSystemAccessManager()) != null) {
            iSystemAccessManager.init(this.getSystemRuntimeContext());
            this.iSystemAccessManager = iSystemAccessManager;
        }
        super.onInit();
        List psSysUniStates = this.getPSSystem().getAllPSSysUniStates();
        if (!ObjectUtils.isEmpty((Object)psSysUniStates)) {
            for (Object iPSSysUniState : psSysUniStates) {
                this.registerPSSysUniState((IPSSysUniState)iPSSysUniState);
            }
        }
        if ((psSysDataSyncAgents = this.getPSSystem().getAllPSSysDataSyncAgents()) != null) {
            String strSyncDir;
            for (IPSSysDataSyncAgent iPSSysDataSyncAgent : psSysDataSyncAgents) {
                strSyncDir = iPSSysDataSyncAgent.getSyncDir();
                if (!"INOUT".equals(strSyncDir) && !"OUT".equals(strSyncDir)) continue;
                this.getSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
            }
            for (IPSSysDataSyncAgent iPSSysDataSyncAgent : psSysDataSyncAgents) {
                strSyncDir = iPSSysDataSyncAgent.getSyncDir();
                if (!"IN".equals(strSyncDir)) continue;
                this.getSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
            }
        }
        if (psDataEntityList != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                try {
                    if (!this.testPreloadPSDataEntity(iPSDataEntity)) continue;
                    IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime(iPSDataEntity.getId());
                    iDataEntityRuntime.getKeyPSDEField();
                }
                catch (Exception ex) {
                    throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u9884\u8f7d\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDataEntity.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysServiceAPIs = this.getPSSystem().getAllPSSysServiceAPIs()) != null) {
            HashMap<String, String> enableAPIMap = null;
            String strEnableAPIs = this.getSystemRuntimeSetting().getEnableAPIs();
            if (StringUtils.hasLength((String)strEnableAPIs)) {
                String[] apis;
                enableAPIMap = new HashMap<String, String>();
                for (String api : apis = strEnableAPIs.toLowerCase().split("[;]")) {
                    enableAPIMap.put(api, "");
                }
            }
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIs) {
                boolean bEnable = true;
                if (!PSModelEnums.ServiceType.LOCAL.value.equals(iPSSysServiceAPI.getServiceType()) && enableAPIMap != null) {
                    bEnable = false;
                    if (StringUtils.hasLength((String)iPSSysServiceAPI.getCodeName())) {
                        bEnable = enableAPIMap.containsKey(iPSSysServiceAPI.getCodeName().toLowerCase());
                    }
                    if (!bEnable && StringUtils.hasLength((String)iPSSysServiceAPI.getName())) {
                        bEnable = enableAPIMap.containsKey(iPSSysServiceAPI.getName().toLowerCase());
                    }
                }
                if (!bEnable) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u670d\u52a1\u63a5\u53e3[%2$s]\u672a\u542f\u7528\uff0c\u5ffd\u7565\u52a0\u8f7d", this.getDeploySystemId(), iPSSysServiceAPI.getName()));
                    continue;
                }
                this.registerPSSysServiceAPI(iPSSysServiceAPI);
            }
        }
        if (this.isEnableAppGateway() && (psApplications = this.getPSSystem().getAllPSApps()) != null) {
            for (IPSApplication iPSApplication : psApplications) {
                this.registerPSApplication(iPSApplication);
            }
        }
        if ((psSysBackServices = this.getPSSystem().getAllPSSysBackServices()) != null) {
            for (IPSSysBackService iPSSysBackService : psSysBackServices) {
                this.registerPSSysBackService(iPSSysBackService);
            }
        }
    }

    protected boolean isEnableAppGateway() {
        return this.getSystemGatewayContext().isEnableAppGateway();
    }

    @Override
    protected void onStart() throws Exception {
        List psSysUtils;
        List psSysBISchemes;
        List psSysSearchSchemes;
        List psSysBDSchemes;
        List psSysDBSchemes;
        List psSystemModules;
        List psSysRefs = this.getPSSystem().getAllPSSysRefs();
        if (psSysRefs != null) {
            for (IPSSysRef iPSSysRef : psSysRefs) {
                ISysRefRuntime iSysRefRuntime = this.getSysRefRuntime(iPSSysRef.getId(), false);
                try {
                    iSysRefRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u5f15\u7528[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysRefRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSystemModules = this.getPSSystem().getAllPSSystemModules()) != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModules) {
                ISystemModuleRuntime iSystemModuleRuntime = this.getSystemModuleRuntime(iPSSystemModule.getId(), false);
                if (!(iSystemModuleRuntime instanceof ISystemModuleUtilRuntime)) continue;
                ISystemModuleUtilRuntime iSystemModuleUtilRuntime = (ISystemModuleUtilRuntime)((Object)iSystemModuleRuntime);
                try {
                    iSystemModuleUtilRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u6a21\u5757\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSystemModuleRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysDBSchemes = this.getPSSystem().getAllPSSysDBSchemes()) != null) {
            for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
                ISysDBSchemeRuntime iSysDBSchemeRuntime = this.getSysDBSchemeRuntime(iPSSysDBScheme.getId(), false);
                try {
                    iSysDBSchemeRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysDBSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysBDSchemes = this.getPSSystem().getAllPSSysBDSchemes()) != null) {
            for (IPSSysBDScheme iPSSysBDScheme : psSysBDSchemes) {
                ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(iPSSysBDScheme.getId(), false);
                try {
                    iSysBDSchemeRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysBDSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysSearchSchemes = this.getPSSystem().getAllPSSysSearchSchemes()) != null) {
            for (IPSSysSearchScheme iPSSysSearchScheme : psSysSearchSchemes) {
                ISysSearchSchemeRuntime iSysSearchSchemeRuntime = this.getSysSearchSchemeRuntime(iPSSysSearchScheme.getId(), false);
                try {
                    iSysSearchSchemeRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u641c\u7d22\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysSearchSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysBISchemes = this.getPSSystem().getAllPSSysBISchemes()) != null) {
            for (IPSSysBIScheme iPSSysBIScheme : psSysBISchemes) {
                ISysBISchemeRuntime iSysBISchemeRuntime = this.getSysBISchemeRuntime(iPSSysBIScheme.getId(), false);
                try {
                    iSysBISchemeRuntime.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysBISchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysUtils = this.getPSSystem().getAllPSSysUtils()) != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                net.ibizsys.runtime.res.ISysUtilRuntime iSysUtilRuntime = this.getSysUtilRuntime(iPSSysUtil.getId(), false);
                if (!(iSysUtilRuntime instanceof ISysUtilRuntime)) continue;
                ISysUtilRuntime iSysUtilRuntime2 = (ISysUtilRuntime)iSysUtilRuntime;
                try {
                    iSysUtilRuntime2.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysUtilRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        super.onStart();
    }

    @Override
    public void installData(String strMode) throws Exception {
        this.onInstallData(strMode);
    }

    protected void onInstallData(String strMode) throws Exception {
        List psSysUtils;
        List psSystemModules = this.getPSSystem().getAllPSSystemModules();
        if (psSystemModules != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModules) {
                ISystemModuleRuntime iSystemModuleRuntime = this.getSystemModuleRuntime(iPSSystemModule.getId(), false);
                if (!(iSystemModuleRuntime instanceof ISystemModuleUtilRuntime)) continue;
                ISystemModuleUtilRuntime iSystemModuleUtilRuntime = (ISystemModuleUtilRuntime)((Object)iSystemModuleRuntime);
                try {
                    iSystemModuleUtilRuntime.installData(strMode);
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u7cfb\u7edf\u6a21\u5757\u529f\u80fd[%1$s]\u5b89\u88c5\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSystemModuleRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysUtils = this.getPSSystem().getAllPSSysUtils()) != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                net.ibizsys.runtime.res.ISysUtilRuntime iSysUtilRuntime = this.getSysUtilRuntime(iPSSysUtil.getId(), false);
                if (!(iSysUtilRuntime instanceof ISysUtilRuntime)) continue;
                ISysUtilRuntime iSysUtilRuntime2 = (ISysUtilRuntime)iSysUtilRuntime;
                try {
                    iSysUtilRuntime2.installData(strMode);
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u5b89\u88c5\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysUtilRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
    }

    @Override
    public Object getGlobalParam(String strKey) {
        return super.getGlobalParam(strKey);
    }

    private SystemRuntime getSelf() {
        return this;
    }

    @Override
    public String getServiceId() {
        return this.getDeploySystemId();
    }

    @Override
    public String getContextId() {
        return this.getDeploySystemId();
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    protected ISystemPersistentAdapter getSystemPersistentAdapter() {
        return this.iSystemPersistentAdapter;
    }

    protected ISystemPersistentAdapter internalGetSystemPersistentAdapter(IPSDataEntity iPSDataEntity) {
        return this.iSystemPersistentAdapter;
    }

    protected ISystemPersistentAdapter createSystemPersistentAdapter() {
        ISystemPersistentAdapter iSystemPersistentAdapter = this.getRuntimeObject("GLOBAL_PERSISTENTADAPTER", ISystemPersistentAdapter.class, true, true);
        if (iSystemPersistentAdapter != null) {
            return iSystemPersistentAdapter;
        }
        iSystemPersistentAdapter = this.getRuntimeObject(ISystemPersistentAdapter.class, null);
        if (iSystemPersistentAdapter != null) {
            return iSystemPersistentAdapter;
        }
        return this.createDefaultSystemPersistentAdapter();
    }

    protected ISystemPersistentAdapter createDefaultSystemPersistentAdapter() {
        return new SystemPersistentAdapter();
    }

    protected ISystemLogAdapter getSystemLogAdapter() {
        return this.iSystemLogAdapter;
    }

    protected void setSystemLogAdapter(ISystemLogAdapter iSystemLogAdapter) {
        this.iSystemLogAdapter = iSystemLogAdapter;
    }

    protected void prepareSystemLogAdapter() throws Exception {
        ISystemLogAdapter iSystemLogAdapter = this.createSystemLogAdapter();
        if (iSystemLogAdapter != null) {
            iSystemLogAdapter.init(this.getSystemRuntimeContext());
            this.setSystemLogAdapter(iSystemLogAdapter);
        }
    }

    protected ISystemLogAdapter createSystemLogAdapter() {
        ISystemLogAdapter iSystemLogAdapter = this.getRuntimeObject("GLOBAL_LOGADAPTER", ISystemLogAdapter.class, true, true);
        if (iSystemLogAdapter != null) {
            return iSystemLogAdapter;
        }
        iSystemLogAdapter = this.getRuntimeObject(ISystemLogAdapter.class, null);
        if (iSystemLogAdapter != null) {
            return iSystemLogAdapter;
        }
        return this.createDefaultSystemLogAdapter();
    }

    protected ISystemLogAdapter createDefaultSystemLogAdapter() {
        return new DefaultSystemLogAdapter();
    }

    @Override
    protected void setPSDynaInstServiceGlobal() {
    }

    @Override
    public String getDeploySystemId() {
        return this.strDeploySystemId;
    }

    @Override
    protected net.ibizsys.runtime.util.script.ISystemRTScriptContext createSystemRTScriptContext() {
        return new SystemRTScriptContext(this.getSystemRuntimeContext());
    }

    @Override
    public ISystemRTScriptContext getSystemRTScriptContext() {
        return (ISystemRTScriptContext)super.getSystemRTScriptContext();
    }

    protected ISystemRTGroovyContext createSystemRTGroovyContext() {
        return new SystemRTGroovyContext(this.getSystemRuntimeContext());
    }

    @Override
    public ISystemRTGroovyContext getSystemRTGroovyContext() {
        if (this.iSystemRTGroovyContext == null) {
            this.iSystemRTGroovyContext = this.createSystemRTGroovyContext();
        }
        return this.iSystemRTGroovyContext;
    }

    protected void prepareSystemSetting(Map<String, Object> map) throws Exception {
        this.setSystemRuntimeSetting(new SystemRuntimeSetting(this.getSystemRuntimeContext(), map));
    }

    protected void prepareSystemFolders() throws Exception {
        File fileFolder;
        String strSystemFolder;
        if (!StringUtils.hasLength((String)this.getFileFolder()) && StringUtils.hasLength((String)this.getSystemGatewayContext().getFileFolder())) {
            strSystemFolder = this.getDeploySystemId();
            if (!StringUtils.hasLength((String)strSystemFolder)) {
                strSystemFolder = "default";
            }
            String strFileFolder = String.format("%1$s%2$s%3$s", this.getSystemGatewayContext().getFileFolder(), File.separator, strSystemFolder);
            fileFolder = new File(strFileFolder);
            fileFolder.mkdirs();
            this.setFileFolder(strFileFolder);
        }
        if (!StringUtils.hasLength((String)this.getTempFolder()) && StringUtils.hasLength((String)this.getSystemGatewayContext().getTempFolder())) {
            strSystemFolder = this.getDeploySystemId();
            if (!StringUtils.hasLength((String)strSystemFolder)) {
                strSystemFolder = "default";
            }
            String strTempFolder = String.format("%1$s%2$s%3$s", this.getSystemGatewayContext().getTempFolder(), File.separator, strSystemFolder);
            fileFolder = new File(strTempFolder);
            fileFolder.mkdirs();
            this.setTempFolder(strTempFolder);
        }
        if (!StringUtils.hasLength((String)this.getReportFolder()) && StringUtils.hasLength((String)this.getSystemGatewayContext().getReportFolder())) {
            this.setReportFolder(this.getSystemGatewayContext().getReportFolder());
        }
        if (!StringUtils.hasLength((String)this.getFontFolder()) && StringUtils.hasLength((String)this.getSystemGatewayContext().getFontFolder())) {
            this.setFontFolder(this.getSystemGatewayContext().getFontFolder());
        }
    }

    protected Object getData() {
        return this.data;
    }

    protected ISystemGatewayContext getSystemGatewayContext() {
        return this.iSystemGatewayContext;
    }

    @Override
    protected IPSSystemService createPSSystemService() throws Exception {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    protected IPSDynaInstService createPSDynaInstService(String strPSDynaInstId) throws Exception {
        return null;
    }

    protected IDataEntityRuntime createDataEntityRuntime(IPSDataEntity iPSDataEntity) {
        ISystemModuleRuntime iSystemModuleRuntime;
        Assert.notNull((Object)iPSDataEntity, (String)"\u5b9e\u4f53\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        IDataEntityRuntime iDataEntityRuntime = this.getRuntimeObject(iPSDataEntity.getPSSysSFPlugin(), IDataEntityRuntime.class, true);
        if (iDataEntityRuntime != null) {
            return iDataEntityRuntime;
        }
        if (iPSDataEntity.getPSSystemModule() != null && (iSystemModuleRuntime = this.getSystemModuleRuntime(iPSDataEntity.getPSSystemModule().getId(), false)) instanceof ISystemModuleUtilRuntime && (iDataEntityRuntime = ((ISystemModuleUtilRuntime)((Object)iSystemModuleRuntime)).createDataEntityRuntime(iPSDataEntity)) != null) {
            return iDataEntityRuntime;
        }
        iDataEntityRuntime = this.getRuntimeObject("GLOBAL_DATAENTITYRUNTIME", IDataEntityRuntime.class, true, true);
        if (iDataEntityRuntime != null) {
            return iDataEntityRuntime;
        }
        return this.createDefaultDataEntityRuntime();
    }

    protected IDataEntityRuntime createDefaultDataEntityRuntime() {
        return new DataEntityRuntime();
    }

    @Override
    public ISysMsgQueueRuntime createSysMsgQueueRuntime(IPSSysMsgQueue iPSSysMsgQueue) {
        Assert.notNull((Object)iPSSysMsgQueue, (String)"\u7cfb\u7edf\u6d88\u606f\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSysMsgQueue.getMsgQueueType(), (String)"\u7cfb\u7edf\u6d88\u606f\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548");
        if ("RUNTIME".equals(iPSSysMsgQueue.getMsgQueueType())) {
            return new SysRTMsgQueueRuntime();
        }
        return super.createSysMsgQueueRuntime(iPSSysMsgQueue);
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime(String strIdOrName, boolean bTryMode) {
        Assert.hasLength((String)strIdOrName, (String)"\u4f20\u5165\u5b9e\u4f53\u6807\u8bc6\u65e0\u6548");
        net.ibizsys.runtime.dataentity.IDataEntityRuntime iDataEntityRuntime = this.dataEntityRuntimeMap.get(strIdOrName);
        if (iDataEntityRuntime != null) {
            return (IDataEntityRuntime)iDataEntityRuntime;
        }
        iDataEntityRuntime = this.dataEntityRuntimeMap.get(strIdOrName.toLowerCase());
        if (iDataEntityRuntime != null) {
            return (IDataEntityRuntime)iDataEntityRuntime;
        }
        IPSDataEntity iPSDataEntity = this.psDataEntityMap.get(strIdOrName);
        if (iPSDataEntity == null && (iPSDataEntity = this.psDataEntityMap.get(strIdOrName.toLowerCase())) == null) {
            if (bTryMode) {
                return null;
            }
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u6a21\u578b\u5bf9\u8c61", strIdOrName));
        }
        IDataEntityRuntime centralDataEntityRuntime = this.createDataEntityRuntime(iPSDataEntity);
        try {
            centralDataEntityRuntime.init(this.getSystemRuntimeContext(), iPSDataEntity, null);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDataEntity.getName(), ex.getMessage()), ex);
        }
        this.registerDataEntityRuntime(centralDataEntityRuntime, iPSDataEntity);
        return centralDataEntityRuntime;
    }

    protected void registerDataEntityRuntime(IDataEntityRuntime iDataEntity, IPSDataEntity iPSDataEntity) {
        this.registerDataEntityRuntime(iDataEntity);
        if (StringUtils.hasLength((String)iDataEntity.getId())) {
            this.dataEntityRuntimeMap.put(iDataEntity.getId(), iDataEntity);
        }
        if (StringUtils.hasLength((String)iDataEntity.getName())) {
            this.dataEntityRuntimeMap.put(iDataEntity.getName().toLowerCase(), iDataEntity);
            if (iPSDataEntity.getPSSystemModule() != null) {
                this.dataEntityRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSDataEntity.getPSSystemModule(), (String)iPSDataEntity.getName()), iDataEntity);
            }
        }
        if (StringUtils.hasLength((String)iPSDataEntity.getCodeName()) && !this.dataEntityRuntimeMap.containsKey(iPSDataEntity.getCodeName().toLowerCase())) {
            this.dataEntityRuntimeMap.put(iPSDataEntity.getCodeName().toLowerCase(), iDataEntity);
        }
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime(String strIdOrName) {
        return (IDataEntityRuntime)super.getDataEntityRuntime(strIdOrName);
    }

    @Override
    public Object invokeDEMethod(String strDataEntityName, String strMethodName, Object objArg, IUserContext iUserContext, Object objTag) throws Throwable {
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime(strDataEntityName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iDataEntityRuntime.invokeMethod(strMethodName, objArg, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIImportData(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIImportData2(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEImportData2(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIGetImportTemplate(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEGetImportTemplate(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIExportData(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIExportData(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIPrintData(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEPrintData(strScope, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIWFStart(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEWFStart(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIWFCancel(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEWFCancel(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIDownloadFile(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, net.ibizsys.runtime.util.domain.File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEDownloadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAPIUploadFile(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, net.ibizsys.runtime.util.domain.File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEUploadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public ISysServiceAPIRuntime getSysServiceAPIRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u670d\u52a1\u63a5\u53e3\u6807\u8bb0\u65e0\u6548");
        ISysServiceAPIRuntime iSysServiceAPIRuntime = null;
        if (this.sysServiceAPIRuntimeMap != null && (iSysServiceAPIRuntime = this.sysServiceAPIRuntimeMap.get(strTag)) == null) {
            iSysServiceAPIRuntime = this.sysServiceAPIRuntimeMap.get(strTag.toUpperCase());
        }
        if (iSysServiceAPIRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysServiceAPIRuntime;
    }

    protected ISysServiceAPIRuntime registerPSSysServiceAPI(IPSSysServiceAPI iPSSysServiceAPI) {
        ISysServiceAPIRuntime iSysServiceAPIRuntime;
        if (this.sysServiceAPIRuntimeMap != null && (iSysServiceAPIRuntime = this.sysServiceAPIRuntimeMap.get(iPSSysServiceAPI.getId())) != null) {
            return iSysServiceAPIRuntime;
        }
        iSysServiceAPIRuntime = this.createSysServiceAPIRuntime(iPSSysServiceAPI);
        if (iSysServiceAPIRuntime == null) {
            return null;
        }
        try {
            iSysServiceAPIRuntime.init(this.getSystemRuntimeContext(), iPSSysServiceAPI);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysServiceAPI.getName(), ex.getMessage()), ex);
        }
        if (this.sysServiceAPIRuntimeMap == null) {
            this.sysServiceAPIRuntimeMap = new HashMap<String, ISysServiceAPIRuntime>();
        }
        this.sysServiceAPIRuntimeMap.put(iPSSysServiceAPI.getCodeName().toUpperCase(), iSysServiceAPIRuntime);
        this.sysServiceAPIRuntimeMap.put(iPSSysServiceAPI.getId(), iSysServiceAPIRuntime);
        return iSysServiceAPIRuntime;
    }

    protected ISysServiceAPIRuntime createSysServiceAPIRuntime(IPSSysServiceAPI iPSSysServiceAPI) {
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getRuntimeObject(iPSSysServiceAPI.getPSSysSFPlugin(), ISysServiceAPIRuntime.class, true);
        if (iSysServiceAPIRuntime != null) {
            return iSysServiceAPIRuntime;
        }
        return this.createDefaultSysServiceAPIRuntime();
    }

    protected ISysServiceAPIRuntime createDefaultSysServiceAPIRuntime() {
        return new SysServiceAPIRuntime();
    }

    @Override
    public IApplicationRuntime getApplicationRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bb0\u65e0\u6548");
        IApplicationRuntime iApplicationRuntime = null;
        if (this.applicationRuntimeMap != null && (iApplicationRuntime = this.applicationRuntimeMap.get(strTag)) == null) {
            iApplicationRuntime = this.applicationRuntimeMap.get(strTag.toUpperCase());
        }
        if (iApplicationRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u524d\u7aef\u5e94\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iApplicationRuntime;
    }

    protected IApplicationRuntime registerPSApplication(IPSApplication iPSApplication) {
        IApplicationRuntime iApplicationRuntime;
        if (this.applicationRuntimeMap != null && (iApplicationRuntime = this.applicationRuntimeMap.get(iPSApplication.getId())) != null) {
            return iApplicationRuntime;
        }
        iApplicationRuntime = this.createApplicationRuntime(iPSApplication);
        if (iApplicationRuntime == null) {
            return null;
        }
        try {
            iApplicationRuntime.init(this.getSystemRuntimeContext(), iPSApplication);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u524d\u7aef\u5e94\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSApplication.getName(), ex.getMessage()), ex);
        }
        if (this.applicationRuntimeMap == null) {
            this.applicationRuntimeMap = new HashMap<String, IApplicationRuntime>();
        }
        this.applicationRuntimeMap.put(iPSApplication.getCodeName().toUpperCase(), iApplicationRuntime);
        this.applicationRuntimeMap.put(iPSApplication.getId(), iApplicationRuntime);
        return iApplicationRuntime;
    }

    protected IApplicationRuntime createApplicationRuntime(IPSApplication iPSApplication) {
        IApplicationRuntime iApplicationRuntime = this.getRuntimeObject(iPSApplication.getPSSysSFPlugin(), IApplicationRuntime.class, true);
        if (iApplicationRuntime != null) {
            return iApplicationRuntime;
        }
        return this.createDefaultApplicationRuntime();
    }

    protected IApplicationRuntime createDefaultApplicationRuntime() {
        return new ApplicationRuntime();
    }

    @Override
    public ISysBackendTaskRuntime getSysBackendTaskRuntime(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u540e\u53f0\u4efb\u52a1\u6807\u8bb0\u65e0\u6548");
        ISysBackendTaskRuntime iSysBackendTaskRuntime = null;
        if (this.sysBackendTaskRuntimeMap != null && (iSysBackendTaskRuntime = this.sysBackendTaskRuntimeMap.get(strTag)) == null) {
            iSysBackendTaskRuntime = this.sysBackendTaskRuntimeMap.get(strTag.toUpperCase());
        }
        if (iSysBackendTaskRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u540e\u53f0\u4efb\u52a1[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysBackendTaskRuntime;
    }

    @Override
    public ISysBackendTaskRuntime getSysBackendTaskRuntime(IPSSysBackService iPSSysBackService) {
        Assert.notNull((Object)iPSSysBackService, (String)"\u4f20\u5165\u540e\u53f0\u4efb\u52a1\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.registerPSSysBackService(iPSSysBackService);
    }

    protected ISysBackendTaskRuntime registerPSSysBackService(IPSSysBackService iPSSysBackService) {
        ISysBackendTaskRuntime iSysBackendTaskRuntime;
        if (this.sysBackendTaskRuntimeMap != null && (iSysBackendTaskRuntime = this.sysBackendTaskRuntimeMap.get(iPSSysBackService.getId())) != null) {
            return iSysBackendTaskRuntime;
        }
        iSysBackendTaskRuntime = this.createSysBackendTaskRuntime(iPSSysBackService);
        if (iSysBackendTaskRuntime == null) {
            return null;
        }
        try {
            iSysBackendTaskRuntime.init(this.getSystemRuntimeContext(), iPSSysBackService);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u540e\u53f0\u4efb\u52a1[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBackService.getName(), ex.getMessage()), ex);
        }
        if (this.sysBackendTaskRuntimeMap == null) {
            this.sysBackendTaskRuntimeMap = new HashMap<String, ISysBackendTaskRuntime>();
        }
        if (StringUtils.hasLength((String)iPSSysBackService.getTaskType())) {
            if ("PREDEFINED".equals(iPSSysBackService.getTaskType())) {
                this.sysBackendTaskRuntimeMap.put(String.format("%1$s|%2$s", iPSSysBackService.getTaskType(), iPSSysBackService.getPredefinedType()).toUpperCase(), iSysBackendTaskRuntime);
            } else {
                this.sysBackendTaskRuntimeMap.put(String.format("%1$s|%2$s", iPSSysBackService.getTaskType(), iPSSysBackService.getCodeName()).toUpperCase(), iSysBackendTaskRuntime);
            }
        }
        this.sysBackendTaskRuntimeMap.put(iPSSysBackService.getId(), iSysBackendTaskRuntime);
        return iSysBackendTaskRuntime;
    }

    protected ISysBackendTaskRuntime createSysBackendTaskRuntime(IPSSysBackService iPSSysBackService) {
        ISysBackendTaskRuntime iSysBackendTaskRuntime = this.getRuntimeObject(iPSSysBackService.getPSSysSFPlugin(), ISysBackendTaskRuntime.class, true);
        if (iSysBackendTaskRuntime != null) {
            return iSysBackendTaskRuntime;
        }
        if (StringUtils.hasLength((String)iPSSysBackService.getTaskType())) {
            String strType;
            if ("PREDEFINED".equals(iPSSysBackService.getTaskType()) && (iSysBackendTaskRuntime = this.getRuntimeObject(ISysBackendTaskRuntime.class, strType = String.format("%1$s:%2$s", "PREDEFINED", iPSSysBackService.getPredefinedType()))) != null) {
                return iSysBackendTaskRuntime;
            }
            iSysBackendTaskRuntime = this.getRuntimeObject(ISysBackendTaskRuntime.class, iPSSysBackService.getTaskType());
            if (iSysBackendTaskRuntime != null) {
                return iSysBackendTaskRuntime;
            }
        }
        return this.onCreateSysBackendTaskRuntime(iPSSysBackService);
    }

    protected ISysBackendTaskRuntime onCreateSysBackendTaskRuntime(IPSSysBackService iPSSysBackService) {
        if (StringUtils.hasLength((String)iPSSysBackService.getTaskType())) {
            if ("PREDEFINED".equals(iPSSysBackService.getTaskType())) {
                if ("DENOTIFY".equals(iPSSysBackService.getPredefinedType())) {
                    return new SysDENotifyBackendTaskRuntime();
                }
                if ("SYSADMIN".equals(iPSSysBackService.getPredefinedType())) {
                    return new SysAdminBackendTaskRuntime();
                }
                if ("SYSDATASYNCAGENT".equals(iPSSysBackService.getPredefinedType())) {
                    return new SysDataSyncAgentBackendTaskRuntime();
                }
                if ("WFCALLBACK".equals(iPSSysBackService.getPredefinedType())) {
                    return new SysWFCallbackBackendTaskRuntime();
                }
                throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u7cfb\u7edf\u540e\u53f0\u4efb\u52a1[%1$s]\u9884\u5b9a\u4e49\u7c7b\u578b[%2$s]", iPSSysBackService.getName(), iPSSysBackService.getPredefinedType()));
            }
            if ("DEACTION".equals(iPSSysBackService.getTaskType())) {
                return new SysDEActionBackendTaskRuntime();
            }
        }
        return this.createDefaultSysBackendTaskRuntime();
    }

    protected ISysBackendTaskRuntime createDefaultSysBackendTaskRuntime() {
        return new SysUserBackendTaskRuntime();
    }

    @Override
    public ISysDBSchemeRuntime getSysDBSchemeRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u6570\u636e\u5e93\u4f53\u7cfb\u6807\u8bb0\u65e0\u6548");
        ISysDBSchemeRuntime iSysDBSchemeRuntime = null;
        if (this.sysDBSchemeRuntimeMap != null && (iSysDBSchemeRuntime = this.sysDBSchemeRuntimeMap.get(strTag)) == null) {
            iSysDBSchemeRuntime = this.sysDBSchemeRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysDBSchemeRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysDBSchemeRuntime;
    }

    @Override
    public ISysDBSchemeRuntime getSysDBSchemeRuntime(IPSSysDBScheme iPSSysDBScheme) {
        Assert.notNull((Object)iPSSysDBScheme, (String)"\u4f20\u5165\u6570\u636e\u5e93\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.getSysDBSchemeRuntime(iPSSysDBScheme.getId(), false);
    }

    protected ISysDBSchemeRuntime registerPSSysDBScheme(IPSSysDBScheme iPSSysDBScheme) {
        ISysDBSchemeRuntime iSysDBSchemeRuntime;
        if (this.sysDBSchemeRuntimeMap != null && (iSysDBSchemeRuntime = this.sysDBSchemeRuntimeMap.get(iPSSysDBScheme.getId())) != null) {
            return iSysDBSchemeRuntime;
        }
        iSysDBSchemeRuntime = this.createSysDBSchemeRuntime(iPSSysDBScheme);
        if (iSysDBSchemeRuntime == null) {
            return null;
        }
        try {
            iSysDBSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysDBScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysDBScheme.getName(), ex.getMessage()), ex);
        }
        if (this.sysDBSchemeRuntimeMap == null) {
            this.sysDBSchemeRuntimeMap = new HashMap<String, ISysDBSchemeRuntime>();
        }
        this.sysDBSchemeRuntimeMap.put(iPSSysDBScheme.getId(), iSysDBSchemeRuntime);
        if (StringUtils.hasLength((String)iPSSysDBScheme.getCodeName())) {
            this.sysDBSchemeRuntimeMap.put(iPSSysDBScheme.getCodeName().toLowerCase(), iSysDBSchemeRuntime);
            if (iPSSysDBScheme.getPSSysModelGroup() != null) {
                this.sysDBSchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysDBScheme.getPSSysModelGroup(), (String)iPSSysDBScheme.getCodeName()), iSysDBSchemeRuntime);
            }
        }
        return iSysDBSchemeRuntime;
    }

    protected ISysDBSchemeRuntime createSysDBSchemeRuntime(IPSSysDBScheme iPSSysDBScheme) {
        ISysDBSchemeRuntime iSysDBSchemeRuntime = this.getRuntimeObject(iPSSysDBScheme.getPSSysSFPlugin(), ISysDBSchemeRuntime.class, true);
        if (iSysDBSchemeRuntime != null) {
            return iSysDBSchemeRuntime;
        }
        return this.createDefaultSysDBSchemeRuntime();
    }

    protected ISysDBSchemeRuntime createDefaultSysDBSchemeRuntime() {
        return new SysDBSchemeRuntime();
    }

    @Override
    public ISysBDSchemeRuntime getSysBDSchemeRuntime(IPSSysBDScheme iPSSysBDScheme) {
        Assert.notNull((Object)iPSSysBDScheme, (String)"\u4f20\u5165\u5927\u6570\u636e\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.registerPSSysBDScheme(iPSSysBDScheme);
    }

    @Override
    public ISysBDSchemeRuntime getSysBDSchemeRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u5927\u6570\u636e\u4f53\u7cfb\u6807\u8bb0\u65e0\u6548");
        ISysBDSchemeRuntime iSysBDSchemeRuntime = null;
        if (this.sysBDSchemeRuntimeMap != null && (iSysBDSchemeRuntime = this.sysBDSchemeRuntimeMap.get(strTag)) == null) {
            iSysBDSchemeRuntime = this.sysBDSchemeRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysBDSchemeRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysBDSchemeRuntime;
    }

    protected ISysBDSchemeRuntime registerPSSysBDScheme(IPSSysBDScheme iPSSysBDScheme) {
        ISysBDSchemeRuntime iSysBDSchemeRuntime;
        if (this.sysBDSchemeRuntimeMap != null && (iSysBDSchemeRuntime = this.sysBDSchemeRuntimeMap.get(iPSSysBDScheme.getId())) != null) {
            return iSysBDSchemeRuntime;
        }
        iSysBDSchemeRuntime = this.createSysBDSchemeRuntime(iPSSysBDScheme);
        if (iSysBDSchemeRuntime == null) {
            return null;
        }
        try {
            iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBDScheme.getName(), ex.getMessage()), ex);
        }
        if (this.sysBDSchemeRuntimeMap == null) {
            this.sysBDSchemeRuntimeMap = new HashMap<String, ISysBDSchemeRuntime>();
        }
        this.sysBDSchemeRuntimeMap.put(iPSSysBDScheme.getId(), iSysBDSchemeRuntime);
        if (StringUtils.hasLength((String)iPSSysBDScheme.getCodeName())) {
            this.sysBDSchemeRuntimeMap.put(iPSSysBDScheme.getCodeName().toLowerCase(), iSysBDSchemeRuntime);
            if (iPSSysBDScheme.getPSSystemModule() != null) {
                this.sysBDSchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysBDScheme.getPSSystemModule(), (String)iPSSysBDScheme.getCodeName()), iSysBDSchemeRuntime);
                this.sysBDSchemeRuntimeMap.put(iPSSysBDScheme.getPSSystemModule().getId(), iSysBDSchemeRuntime);
            } else if (iPSSysBDScheme.getPSSysModelGroup() != null) {
                this.sysBDSchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysBDScheme.getPSSysModelGroup(), (String)iPSSysBDScheme.getCodeName()), iSysBDSchemeRuntime);
                this.sysBDSchemeRuntimeMap.put(iPSSysBDScheme.getPSSysModelGroup().getId(), iSysBDSchemeRuntime);
            }
        }
        return iSysBDSchemeRuntime;
    }

    protected ISysBDSchemeRuntime createSysBDSchemeRuntime(IPSSysBDScheme iPSSysBDScheme) {
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getRuntimeObject(iPSSysBDScheme.getPSSysSFPlugin(), ISysBDSchemeRuntime.class, true);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime;
        }
        String strConfigFolder = SysBDSchemeRuntime.getConfigFolder(iPSSysBDScheme);
        String strBDType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".bdtype", iPSSysBDScheme.getBDType());
        iSysBDSchemeRuntime = this.getRuntimeObject(ISysBDSchemeRuntime.class, strBDType);
        if (iSysBDSchemeRuntime != null) {
            return iSysBDSchemeRuntime;
        }
        return this.createDefaultSysBDSchemeRuntime();
    }

    protected ISysBDSchemeRuntime createDefaultSysBDSchemeRuntime() {
        return new SysBDSchemeRuntime();
    }

    protected void prepareDefaultSysBDSchemeRuntime() throws Exception {
        IPSSysBDScheme iPSSysBDScheme = SysBDSchemeRuntime.getDefaultPSSysBDScheme(this.getSystemRuntimeContext());
        String strConfigFolder = SysBDSchemeRuntime.getConfigFolder(iPSSysBDScheme);
        String strBDType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".bdtype", iPSSysBDScheme.getBDType());
        if (!StringUtils.hasLength((String)strBDType)) {
            return;
        }
        ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getRuntimeObject(ISysBDSchemeRuntime.class, strBDType);
        if (iSysBDSchemeRuntime == null) {
            return;
        }
        try {
            iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBDScheme.getName(), ex.getMessage()), ex);
        }
        this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
    }

    @Override
    public ISysBDSchemeRuntime getDefaultSysBDSchemeRuntime() {
        return this.defaultSysBDSchemeRuntime;
    }

    protected void setDefaultSysBDSchemeRuntime(ISysBDSchemeRuntime defaultSysBDSchemeRuntime) {
        this.defaultSysBDSchemeRuntime = defaultSysBDSchemeRuntime;
    }

    @Override
    public ISysBDSchemeRuntime getSysBDSchemeRuntime(IDataEntityRuntime iDataEntityRuntime) {
        try {
            IPSSystemModule iPSSystemModule = iDataEntityRuntime.getPSDataEntity().getPSSystemModuleMust();
            ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(iPSSystemModule.getId(), true);
            if (iSysBDSchemeRuntime != null) {
                return iSysBDSchemeRuntime;
            }
            if (iPSSystemModule.getPSSysModelGroup() != null && (iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(iPSSystemModule.getPSSysModelGroup().getId(), true)) != null) {
                return iSysBDSchemeRuntime;
            }
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u8ba1\u7b97\u5b9e\u4f53[%1$s]\u5927\u6570\u636e\u5e93\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getName(), ex.getMessage()), ex);
        }
        return this.getDefaultSysBDSchemeRuntime();
    }

    @Override
    public ISystemModuleRuntime getSystemModuleRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u7cfb\u7edf\u6a21\u5757\u6807\u8bb0\u65e0\u6548");
        ISystemModuleRuntime iSystemModuleRuntime = null;
        if (this.systemModuleRuntimeMap != null && (iSystemModuleRuntime = this.systemModuleRuntimeMap.get(strTag)) == null) {
            iSystemModuleRuntime = this.systemModuleRuntimeMap.get(strTag.toUpperCase());
        }
        if (iSystemModuleRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u6a21\u5757[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSystemModuleRuntime;
    }

    protected ISystemModuleRuntime registerPSSystemModule(IPSSystemModule iPSSystemModule) {
        ISystemModuleRuntime iSystemModuleRuntime;
        if (this.systemModuleRuntimeMap != null && (iSystemModuleRuntime = this.systemModuleRuntimeMap.get(iPSSystemModule.getId())) != null) {
            return iSystemModuleRuntime;
        }
        iSystemModuleRuntime = this.createSystemModuleRuntime(iPSSystemModule);
        if (iSystemModuleRuntime == null) {
            return null;
        }
        try {
            iSystemModuleRuntime.init(this.getSystemRuntimeContext(), iPSSystemModule);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6a21\u5757[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSystemModule.getName(), ex.getMessage()), ex);
        }
        if (this.systemModuleRuntimeMap == null) {
            this.systemModuleRuntimeMap = new HashMap<String, ISystemModuleRuntime>();
        }
        this.systemModuleRuntimeMap.put(iPSSystemModule.getId(), iSystemModuleRuntime);
        return iSystemModuleRuntime;
    }

    protected ISystemModuleRuntime createSystemModuleRuntime(IPSSystemModule iPSSystemModule) {
        ISystemModuleRuntime iSystemModuleRuntime = this.getRuntimeObject(iPSSystemModule.getPSSysSFPlugin(), ISystemModuleRuntime.class, true);
        if (iSystemModuleRuntime != null) {
            return iSystemModuleRuntime;
        }
        if (StringUtils.hasLength((String)iPSSystemModule.getUtilType()) && (iSystemModuleRuntime = this.createSystemModuleUtilRuntime(iPSSystemModule)) != null) {
            return iSystemModuleRuntime;
        }
        return this.createDefaultSystemModuleRuntime();
    }

    protected ISystemModuleRuntime createSystemModuleUtilRuntime(IPSSystemModule iPSSystemModule) {
        ISystemModuleUtilRuntime iSystemModuleUtilRuntime = this.getRuntimeObject(ISystemModuleUtilRuntime.class, iPSSystemModule.getUtilType());
        if (iSystemModuleUtilRuntime == null) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u6307\u5b9a\u7c7b\u578b[%1$s]\u7cfb\u7edf\u6a21\u5757\u529f\u80fd\u8fd0\u884c\u65f6", iPSSystemModule.getUtilType()));
        }
        return (ISystemModuleRuntime)((Object)iSystemModuleUtilRuntime);
    }

    protected ISystemModuleRuntime createDefaultSystemModuleRuntime() {
        return new SystemModuleRuntime();
    }

    protected ISysResourceRuntime registerPSSysResource(IPSSysResource iPSSysResource) {
        ISysResourceRuntime iSysResourceRuntime;
        Assert.notNull((Object)iPSSysResource, (String)"\u4f20\u5165\u9884\u7f6e\u8d44\u6e90\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        if (this.sysResourceRuntimeMap != null && (iSysResourceRuntime = this.sysResourceRuntimeMap.get(iPSSysResource.getId())) != null) {
            return iSysResourceRuntime;
        }
        iSysResourceRuntime = this.createSysResourceRuntime(iPSSysResource);
        if (iSysResourceRuntime == null) {
            return null;
        }
        try {
            iSysResourceRuntime.init(this.getSystemRuntimeContext(), iPSSysResource);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u8d44\u6e90[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysResource.getName(), ex.getMessage()), ex);
        }
        if (this.sysResourceRuntimeMap == null) {
            this.sysResourceRuntimeMap = new HashMap<String, ISysResourceRuntime>();
        }
        this.sysResourceRuntimeMap.put(iPSSysResource.getId(), iSysResourceRuntime);
        String strCodeName = iPSSysResource.getResTag();
        if (StringUtils.hasLength((String)strCodeName)) {
            this.sysResourceRuntimeMap.put(strCodeName.toLowerCase(), iSysResourceRuntime);
            if (iPSSysResource.getPSSystemModule() != null) {
                this.sysResourceRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysResource.getPSSystemModule(), (String)strCodeName), iSysResourceRuntime);
            }
        }
        return iSysResourceRuntime;
    }

    protected ISysResourceRuntime createSysResourceRuntime(IPSSysResource iPSSysResource) {
        ISysResourceRuntime iSysResourceRuntime = this.getRuntimeObject(iPSSysResource.getPSSysSFPlugin(), ISysResourceRuntime.class, true);
        if (iSysResourceRuntime != null) {
            return iSysResourceRuntime;
        }
        String strConfigFolder = SysResourceRuntime.getConfigFolder(iPSSysResource);
        String strResourceType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".resourcetype", iPSSysResource.getResourceType());
        iSysResourceRuntime = this.getRuntimeObject(ISysResourceRuntime.class, strResourceType);
        if (iSysResourceRuntime != null) {
            return iSysResourceRuntime;
        }
        return this.createDefaultSysResourceRuntime();
    }

    protected ISysResourceRuntime createDefaultSysResourceRuntime() {
        return new SysResourceRuntime();
    }

    @Override
    public ISysResourceRuntime getSysResourceRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u9884\u7f6e\u8d44\u6e90\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        ISysResourceRuntime iSysResourceRuntime = null;
        if (this.sysResourceRuntimeMap != null && (iSysResourceRuntime = this.sysResourceRuntimeMap.get(strTag)) == null) {
            iSysResourceRuntime = this.sysResourceRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysResourceRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u9884\u7f6e\u8d44\u6e90[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysResourceRuntime;
    }

    @Override
    public ISysResourceRuntime getSysResourceRuntime(IPSSysResource iPSSysResource) {
        return this.registerPSSysResource(iPSSysResource);
    }

    protected ISysUniStateRuntime registerPSSysUniState(IPSSysUniState iPSSysUniState) {
        ISysUniStateRuntime iSysUniStateRuntime;
        Assert.notNull((Object)iPSSysUniState, (String)"\u4f20\u5165\u7edf\u4e00\u72b6\u6001\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        if (this.sysUniStateRuntimeMap != null && (iSysUniStateRuntime = this.sysUniStateRuntimeMap.get(iPSSysUniState.getId())) != null) {
            return iSysUniStateRuntime;
        }
        iSysUniStateRuntime = this.createSysUniStateRuntime(iPSSysUniState);
        if (iSysUniStateRuntime == null) {
            return null;
        }
        try {
            iSysUniStateRuntime.init(this.getSystemRuntimeContext(), iPSSysUniState);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u7edf\u4e00\u72b6\u6001[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysUniState.getName(), ex.getMessage()), ex);
        }
        if (this.sysUniStateRuntimeMap == null) {
            this.sysUniStateRuntimeMap = new HashMap<String, ISysUniStateRuntime>();
        }
        this.sysUniStateRuntimeMap.put(iPSSysUniState.getId(), iSysUniStateRuntime);
        String strCodeName = iPSSysUniState.getUniqueTag();
        if (StringUtils.hasLength((String)strCodeName)) {
            this.sysUniStateRuntimeMap.put(strCodeName.toLowerCase(), iSysUniStateRuntime);
            if (iPSSysUniState.getPSSystemModule() != null) {
                this.sysUniStateRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysUniState.getPSSystemModule(), (String)strCodeName), iSysUniStateRuntime);
            }
        }
        return iSysUniStateRuntime;
    }

    protected ISysUniStateRuntime createSysUniStateRuntime(IPSSysUniState iPSSysUniState) {
        ISysUniStateRuntime iSysUniStateRuntime = this.getRuntimeObject(iPSSysUniState.getPSSysSFPlugin(), ISysUniStateRuntime.class, true);
        if (iSysUniStateRuntime != null) {
            return iSysUniStateRuntime;
        }
        iSysUniStateRuntime = this.getRuntimeObject(ISysUniStateRuntime.class, iPSSysUniState.getUniStateType());
        if (iSysUniStateRuntime != null) {
            return iSysUniStateRuntime;
        }
        return this.createDefaultSysUniStateRuntime();
    }

    protected ISysUniStateRuntime createDefaultSysUniStateRuntime() {
        return new SysUniStateRuntime();
    }

    @Override
    public ISysUniStateRuntime getSysUniStateRuntime(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u7edf\u4e00\u72b6\u6001\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        ISysUniStateRuntime iSysUniStateRuntime = null;
        if (this.sysUniStateRuntimeMap != null && (iSysUniStateRuntime = this.sysUniStateRuntimeMap.get(strTag)) == null) {
            iSysUniStateRuntime = this.sysUniStateRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysUniStateRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7edf\u4e00\u72b6\u6001[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysUniStateRuntime;
    }

    @Override
    public ISysUniStateRuntime getSysUniStateRuntime(IPSSysUniState iPSSysUniState) {
        return this.registerPSSysUniState(iPSSysUniState);
    }

    protected ISysRefRuntime registerPSSysRef(IPSSysRef iPSSysRef) {
        ISysRefRuntime iSysRefRuntime;
        if (this.sysRefRuntimeMap != null && (iSysRefRuntime = this.sysRefRuntimeMap.get(iPSSysRef.getId())) != null) {
            return iSysRefRuntime;
        }
        iSysRefRuntime = this.createSysRefRuntime(iPSSysRef);
        if (iSysRefRuntime == null) {
            return null;
        }
        try {
            iSysRefRuntime.init(this.getSystemRuntimeContext(), iPSSysRef);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysRef.getName(), ex.getMessage()), ex);
        }
        if (this.sysRefRuntimeMap == null) {
            this.sysRefRuntimeMap = new HashMap<String, ISysRefRuntime>();
        }
        this.sysRefRuntimeMap.put(iPSSysRef.getId(), iSysRefRuntime);
        String strCodeName = iPSSysRef.getSysRefTag();
        if (StringUtils.hasLength((String)strCodeName)) {
            this.sysRefRuntimeMap.put(strCodeName.toLowerCase(), iSysRefRuntime);
        }
        return iSysRefRuntime;
    }

    protected ISysRefRuntime createSysRefRuntime(IPSSysRef iPSSysRef) {
        ISysRefRuntime iSysRefRuntime = this.getRuntimeObject(iPSSysRef.getPSSysSFPlugin(), ISysRefRuntime.class, true);
        if (iSysRefRuntime != null) {
            return iSysRefRuntime;
        }
        if (StringUtils.hasLength((String)iPSSysRef.getSysRefType()) && (iSysRefRuntime = this.getRuntimeObject(ISysRefRuntime.class, iPSSysRef.getSysRefType())) != null) {
            return iSysRefRuntime;
        }
        return this.createDefaultSysRefRuntime();
    }

    protected ISysRefRuntime createDefaultSysRefRuntime() {
        return new SysRefRuntime();
    }

    @Override
    public ISysRefRuntime getSysRefRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u7cfb\u7edf\u5f15\u7528\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        ISysRefRuntime iSysRefRuntime = null;
        if (this.sysRefRuntimeMap != null && (iSysRefRuntime = this.sysRefRuntimeMap.get(strTag)) == null) {
            iSysRefRuntime = this.sysRefRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysRefRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysRefRuntime;
    }

    @Override
    public ISysRefRuntime getSysRefRuntime(IPSSysRef iPSSysRef) {
        Assert.notNull((Object)iPSSysRef, (String)"\u4f20\u5165\u7cfb\u7edf\u5f15\u7528\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.getSysRefRuntime(iPSSysRef.getId(), false);
    }

    @Override
    public ISysUtilRuntime getSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        Assert.notNull((Object)iPSSysUtil, (String)"\u4f20\u5165\u7cfb\u7edf\u9884\u7f6e\u529f\u80fd\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return (ISysUtilRuntime)this.getSysUtilRuntime(iPSSysUtil.getId(), false);
    }

    @Override
    public ISysDataSyncAgentRuntime createSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        Assert.notNull((Object)iPSSysDataSyncAgent, (String)"\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime = this.getRuntimeObject(iPSSysDataSyncAgent.getPSSysSFPlugin(), ISysDataSyncAgentRuntime.class, true);
        if (iSysDataSyncAgentRuntime != null) {
            return iSysDataSyncAgentRuntime;
        }
        String strConfigFolder = SysEAIAgentRuntimeBase.getConfigFolder(iPSSysDataSyncAgent);
        String strAgentType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".agenttype", iPSSysDataSyncAgent.getAgentType());
        iSysDataSyncAgentRuntime = this.getRuntimeObject(ISysDataSyncAgentRuntime.class, strAgentType);
        if (iSysDataSyncAgentRuntime != null) {
            return iSysDataSyncAgentRuntime;
        }
        return this.onCreateSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
    }

    @Override
    public IDataEntityGroupRuntime getDataEntityGroupRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u5b9e\u4f53\u7ec4\u6807\u8bb0\u65e0\u6548");
        IDataEntityGroupRuntime iDataEntityGroupRuntime = null;
        if (this.dataEntityGroupRuntimeMap != null && (iDataEntityGroupRuntime = this.dataEntityGroupRuntimeMap.get(strTag)) == null) {
            iDataEntityGroupRuntime = this.dataEntityGroupRuntimeMap.get(strTag.toUpperCase());
        }
        if (iDataEntityGroupRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u7ec4[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iDataEntityGroupRuntime;
    }

    protected IDataEntityGroupRuntime registerPSDEGroup(IPSDEGroup iPSDEGroup) {
        IDataEntityGroupRuntime iDataEntityGroupRuntime;
        if (this.dataEntityGroupRuntimeMap != null && (iDataEntityGroupRuntime = this.dataEntityGroupRuntimeMap.get(iPSDEGroup.getId())) != null) {
            return iDataEntityGroupRuntime;
        }
        iDataEntityGroupRuntime = this.createDataEntityGroupRuntime(iPSDEGroup);
        if (iDataEntityGroupRuntime == null) {
            return null;
        }
        try {
            iDataEntityGroupRuntime.init(this.getSystemRuntimeContext(), iPSDEGroup);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5b9e\u4f53\u7ec4[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEGroup.getName(), ex.getMessage()), ex);
        }
        if (this.dataEntityGroupRuntimeMap == null) {
            this.dataEntityGroupRuntimeMap = new HashMap<String, IDataEntityGroupRuntime>();
        }
        this.dataEntityGroupRuntimeMap.put(iPSDEGroup.getId(), iDataEntityGroupRuntime);
        if (iDataEntityGroupRuntime instanceof IDataEntityGroupUtilRuntime) {
            if (this.dataEntityGroupUtilRuntimeList == null) {
                this.dataEntityGroupUtilRuntimeList = new ArrayList<IDataEntityGroupUtilRuntime>();
            }
            this.dataEntityGroupUtilRuntimeList.add((IDataEntityGroupUtilRuntime)((Object)iDataEntityGroupRuntime));
        }
        return iDataEntityGroupRuntime;
    }

    protected IDataEntityGroupRuntime createDataEntityGroupRuntime(IPSDEGroup iPSDEGroup) {
        IDataEntityGroupRuntime iDataEntityGroupRuntime = this.getRuntimeObject(iPSDEGroup.getPSSysSFPlugin(), IDataEntityGroupRuntime.class, true);
        if (iDataEntityGroupRuntime != null) {
            return iDataEntityGroupRuntime;
        }
        if (StringUtils.hasLength((String)iPSDEGroup.getLogicMode()) && (iDataEntityGroupRuntime = this.createDataEntityGroupUtilRuntime(iPSDEGroup)) != null) {
            return iDataEntityGroupRuntime;
        }
        return this.createDefaultDataEntityGroupRuntime();
    }

    protected IDataEntityGroupRuntime createDataEntityGroupUtilRuntime(IPSDEGroup iPSDEGroup) {
        return null;
    }

    protected IDataEntityGroupRuntime createDefaultDataEntityGroupRuntime() {
        return new DataEntityGroupRuntime();
    }

    @Override
    public List<IDataEntityGroupUtilRuntime> getDataEntityGroupUtilRuntimes() {
        if (this.dataEntityGroupUtilRuntimeList == null || this.dataEntityGroupUtilRuntimeList.size() == 0) {
            return null;
        }
        return this.dataEntityGroupUtilRuntimeList;
    }

    @Override
    public ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u6807\u8bb0\u65e0\u6548");
        ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = null;
        if (this.subSysServiceAPIRuntimeMap != null && (iSubSysServiceAPIRuntime = this.subSysServiceAPIRuntimeMap.get(strTag)) == null) {
            iSubSysServiceAPIRuntime = this.subSysServiceAPIRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSubSysServiceAPIRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSubSysServiceAPIRuntime;
    }

    @Override
    public ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
        Assert.notNull((Object)iPSSubSysServiceAPI, (String)"\u4f20\u5165\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.getSubSysServiceAPIRuntime(iPSSubSysServiceAPI.getId(), false);
    }

    protected ISubSysServiceAPIRuntime registerPSSubSysServiceAPI(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
        ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime;
        if (this.subSysServiceAPIRuntimeMap != null && (iSubSysServiceAPIRuntime = this.subSysServiceAPIRuntimeMap.get(iPSSubSysServiceAPI.getId())) != null) {
            return iSubSysServiceAPIRuntime;
        }
        iSubSysServiceAPIRuntime = this.createSubSysServiceAPIRuntime(iPSSubSysServiceAPI);
        if (iSubSysServiceAPIRuntime == null) {
            return null;
        }
        try {
            iSubSysServiceAPIRuntime.init(this.getSystemRuntimeContext(), iPSSubSysServiceAPI);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSubSysServiceAPI.getName(), ex.getMessage()), ex);
        }
        if (this.subSysServiceAPIRuntimeMap == null) {
            this.subSysServiceAPIRuntimeMap = new HashMap<String, ISubSysServiceAPIRuntime>();
        }
        this.subSysServiceAPIRuntimeMap.put(iPSSubSysServiceAPI.getId(), iSubSysServiceAPIRuntime);
        String strCodeName = iPSSubSysServiceAPI.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            this.subSysServiceAPIRuntimeMap.put(strCodeName.toLowerCase(), iSubSysServiceAPIRuntime);
            if (iPSSubSysServiceAPI.getPSSystemModule() != null) {
                this.subSysServiceAPIRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSubSysServiceAPI.getPSSystemModule(), (String)strCodeName), iSubSysServiceAPIRuntime);
            }
        }
        return iSubSysServiceAPIRuntime;
    }

    protected ISubSysServiceAPIRuntime createSubSysServiceAPIRuntime(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
        ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = this.getRuntimeObject(iPSSubSysServiceAPI.getPSSysSFPlugin(), ISubSysServiceAPIRuntime.class, true);
        if (iSubSysServiceAPIRuntime != null) {
            return iSubSysServiceAPIRuntime;
        }
        if (StringUtils.hasLength((String)iPSSubSysServiceAPI.getAPIType()) && (iSubSysServiceAPIRuntime = this.getRuntimeObject(ISubSysServiceAPIRuntime.class, iPSSubSysServiceAPI.getAPIType())) != null) {
            return iSubSysServiceAPIRuntime;
        }
        iSubSysServiceAPIRuntime = this.getRuntimeObject(ISubSysServiceAPIRuntime.class, null);
        if (iSubSysServiceAPIRuntime != null) {
            return iSubSysServiceAPIRuntime;
        }
        return this.createDefaultSubSysServiceAPIRuntime();
    }

    protected ISubSysServiceAPIRuntime createDefaultSubSysServiceAPIRuntime() {
        return new SubSysServiceAPIRuntime();
    }

    @Override
    public ISystemRuntimeSetting getSystemRuntimeSetting() {
        return this.iSystemRuntimeSetting;
    }

    protected void setSystemRuntimeSetting(ISystemRuntimeSetting iSystemRuntimeSetting) {
        this.iSystemRuntimeSetting = iSystemRuntimeSetting;
    }

    @Override
    public Object invokeAPIMethod(String strAPICodeName, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        return this.invokeAPIMethod(strAPICodeName, null, null, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIMethod(String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAPICodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u63a5\u53e3\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAPICodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAPICodeName.substring(nPos + 1);
            strAPICodeName = strAPICodeName.substring(0, nPos);
        }
        ISysServiceAPIRuntime iSysServiceAPIRuntime = this.getSysServiceAPIRuntime(strAPICodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysServiceAPIRuntime.invokeDEMethod(strScope, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public IDBDialect getDBDialect(String strDBType) {
        IDBDialect iDBDialect = this.dbDialectMap.get(strDBType);
        if (iDBDialect != null) {
            return iDBDialect;
        }
        iDBDialect = this.getRuntimeObject("GLOBAL_DBDIALECT_" + strDBType, IDBDialect.class, true, true);
        if (iDBDialect == null) {
            iDBDialect = this.createDBDialect(strDBType);
        }
        this.dbDialectMap.put(strDBType, iDBDialect);
        return iDBDialect;
    }

    protected IDBDialect createDBDialect(String strDBType) {
        if ("MYSQL5".equals(strDBType)) {
            return new MySQL5Dialect();
        }
        return new SimpleDBDialect(strDBType);
    }

    @Override
    public ISystemAccessManager getSystemAccessManager() {
        return this.iSystemAccessManager;
    }

    protected void setSystemAccessManager(ISystemAccessManager iSystemAccessManager) {
        this.iSystemAccessManager = iSystemAccessManager;
    }

    protected ISystemAccessManager createSystemAccessManager() {
        ISystemAccessManager iSystemAccessManager = this.getRuntimeObject("GLOBAL_ACCESSMANAGER", ISystemAccessManager.class, true, true);
        if (iSystemAccessManager != null) {
            return iSystemAccessManager;
        }
        return this.createDefaultSystemAccessManager();
    }

    protected ISystemAccessManager createDefaultSystemAccessManager() {
        return new SystemAccessManager();
    }

    @Override
    public void log(int nLogLevel, String strCat, String strInfo, Object objData) {
        if (this.getSystemLogAdapter() != null) {
            this.getSystemLogAdapter().log(nLogLevel, strCat, strInfo, objData);
        }
    }

    @Override
    public void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData) {
        if (this.getSystemLogAdapter() != null) {
            this.getSystemLogAdapter().logAudit(nLogLevel, strCat, strInfo, strPersonId, strAddress, objData);
        }
    }

    @Override
    public void logEvent(int nLogLevel, String strCat, String strInfo, Object objData) {
        if (this.getSystemLogAdapter() != null) {
            this.getSystemLogAdapter().logEvent(nLogLevel, strCat, strInfo, objData);
        }
    }

    @Override
    public void logPO(int nLogLevel, String strCat, String strInfo, String strDEName, String strAction, long nTime, Object objData) {
        if (this.getSystemLogAdapter() != null) {
            this.getSystemLogAdapter().logPO(nLogLevel, strCat, strInfo, strDEName, strAction, nTime, objData);
        }
    }

    @Override
    public IDELogicNodeRuntime getDELogicNodeRuntime(IPSDELogicNode iPSDELogicNode, boolean bNewInstance) {
        String strLogicNodeType = iPSDELogicNode.getLogicNodeType();
        if (bNewInstance) {
            return this.createDELogicNodeRuntime(iPSDELogicNode);
        }
        IDELogicNodeRuntime iDELogicNodeRuntime = this.deELogicNodeRuntimeMap.get(strLogicNodeType);
        if (iDELogicNodeRuntime == null) {
            iDELogicNodeRuntime = this.createDELogicNodeRuntime(iPSDELogicNode);
            this.deELogicNodeRuntimeMap.put(strLogicNodeType, iDELogicNodeRuntime);
        }
        return iDELogicNodeRuntime;
    }

    protected IDELogicNodeRuntime createDELogicNodeRuntime(IPSDELogicNode iPSDELogicNode) {
        String strLogicNodeType = iPSDELogicNode.getLogicNodeType();
        if ("PREPAREPARAM".equals(strLogicNodeType)) {
            return new DELogicPrepareParamNodeRuntime();
        }
        if ("BEGIN".equals(strLogicNodeType)) {
            return new SimpleDELogicNodeRuntime();
        }
        if ("DEACTION".equals(strLogicNodeType)) {
            return new DELogicDEActionNodeRuntime();
        }
        if ("RAWSQLANDLOOPCALL".equals(strLogicNodeType)) {
            return new DELogicRawSqlAndLoopCallNodeRuntime();
        }
        if ("RAWSQLCALL".equals(strLogicNodeType)) {
            return new DELogicRawSqlCallNodeRuntime();
        }
        if ("STARTWF".equals(strLogicNodeType)) {
            return new DELogicStartWFNodeRuntime();
        }
        if ("SUBMITWF".equals(strLogicNodeType)) {
            return new DELogicSubmitWFNodeRuntime();
        }
        if ("SYSLOGIC".equals(strLogicNodeType)) {
            return new DELogicSysLogicNodeRuntime();
        }
        if ("THROWEXCEPTION".equals(strLogicNodeType)) {
            return new DELogicThrowExceptionNodeRuntime();
        }
        if ("SFPLUGIN".equals(strLogicNodeType)) {
            return new DELogicSFPluginNodeRuntime();
        }
        if ("RAWSFCODE".equals(strLogicNodeType)) {
            return new DELogicRawSFCodeNodeRuntime();
        }
        if ("DEDATASET".equals(strLogicNodeType)) {
            return new DELogicDEDataSetNodeRuntime();
        }
        if ("DELOGIC".equals(strLogicNodeType)) {
            return new DELogicDELogicNodeRuntime();
        }
        if ("END".equals(strLogicNodeType)) {
            return new DELogicEndNodeRuntime();
        }
        if ("DENOTIFY".equals(strLogicNodeType)) {
            return new DELogicDENotifyNodeRuntime();
        }
        if ("COMMIT".equals(strLogicNodeType)) {
            return new DELogicCommitNodeRuntime();
        }
        if ("ROLLBACK".equals(strLogicNodeType)) {
            return new DELogicRollbackNodeRuntime();
        }
        if ("DEDATAQUERY".equals(strLogicNodeType)) {
            return new DELogicDEDataQueryNodeRuntime();
        }
        if ("DEBUGPARAM".equals(strLogicNodeType)) {
            return new DELogicDebugParamNodeRuntime();
        }
        if ("SUBSYSSAMETHOD".equals(strLogicNodeType)) {
            return new DELogicSubSysSAMethodNodeRuntime();
        }
        if ("DEDATASYNC".equals(strLogicNodeType)) {
            return new DELogicDEDataSyncNodeRuntime();
        }
        if ("APPENDPARAM".equals(strLogicNodeType)) {
            return new DELogicAppendParamNodeRuntime();
        }
        if ("BINDPARAM".equals(strLogicNodeType)) {
            return new DELogicBindParamNodeRuntime();
        }
        if ("COPYPARAM".equals(strLogicNodeType)) {
            return new DELogicCopyParamNodeRuntime();
        }
        if ("RENEWPARAM".equals(strLogicNodeType)) {
            return new DELogicRenewParamNodeRuntime();
        }
        if ("RESETPARAM".equals(strLogicNodeType)) {
            return new DELogicResetParamNodeRuntime();
        }
        if ("SORTPARAM".equals(strLogicNodeType)) {
            return new DELogicSortParamNodeRuntime();
        }
        if ("MERGEPARAM".equals(strLogicNodeType)) {
            return new DELogicMergeParamNodeRuntime();
        }
        if ("RAWWEBCALL".equals(strLogicNodeType)) {
            return new DELogicRawWebCallNodeRuntime();
        }
        if ("DEPRINT".equals(strLogicNodeType)) {
            return new DELogicDEPrintNodeRuntime();
        }
        if ("LOOPSUBCALL".equals(strLogicNodeType)) {
            return new DELogicLoopSubCallNodeRuntime();
        }
        if ("SYSDATASYNCAGENTOUT".equals(strLogicNodeType)) {
            return new DELogicSysDataSyncAgentOutNodeRuntime();
        }
        if ("SYSUTIL".equals(strLogicNodeType)) {
            return new DELogicSysUtilNodeRuntime();
        }
        if ("DEDATAFLOW".equals(strLogicNodeType)) {
            return new DELogicDEDataFlowNodeRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5904\u7406\u903b\u8f91\u8282\u70b9\u7c7b\u578b[%1$s]", strLogicNodeType));
    }

    @Override
    public IDELogicParamRuntime getDELogicParamRuntime(IPSDELogicParam iPSDELogicParam) {
        if (iPSDELogicParam.isEntityParam()) {
            return new DELogicEntityParamRuntime();
        }
        if (iPSDELogicParam.isEntityListParam()) {
            return new DELogicEntityListParamRuntime();
        }
        if (iPSDELogicParam.isEntityPageParam()) {
            return new DELogicEntityPageParamRuntime();
        }
        if (iPSDELogicParam.isFilterParam()) {
            return new DELogicFilterParamRuntime();
        }
        if (iPSDELogicParam.isLastReturnParam()) {
            return new DELogicLastReturnParamRuntime();
        }
        if (iPSDELogicParam.isLastParam()) {
            return new DELogicLastParamRuntime();
        }
        if (iPSDELogicParam.isEnvParam()) {
            return new DELogicEnvParamRuntime();
        }
        if (iPSDELogicParam.isSessionParam()) {
            return new DELogicSessionParamRuntime();
        }
        if (iPSDELogicParam.isFileParam()) {
            return new DELogicFileParamRuntime();
        }
        if (iPSDELogicParam.isFileListParam()) {
            return new DELogicFileListParamRuntime();
        }
        if (iPSDELogicParam.isSimpleParam()) {
            return new DELogicSimpleParamRuntime();
        }
        if (iPSDELogicParam.isSimpleListParam()) {
            return new DELogicSimpleListParamRuntime();
        }
        if (iPSDELogicParam.isAppContextParam()) {
            return new DELogicAppContextParamRuntime();
        }
        if (iPSDELogicParam.isWebContextParam()) {
            return new DELogicWebContextParamRuntime();
        }
        if (iPSDELogicParam.isWebResponseParam()) {
            return new DELogicWebResponseParamRuntime();
        }
        if (iPSDELogicParam.isAppGlobalParam()) {
            return new DELogicAppGlobalParamRuntime();
        }
        return new DELogicParamRuntime();
    }

    @Override
    public ISysTestCaseRuntime createSysTestCaseRuntime(IPSSysTestCase iPSSysTestCase) {
        String strTestCaseType = iPSSysTestCase.getTestCaseType();
        if ("DEACTION".equals(strTestCaseType)) {
            return new DEActionTestCaseRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6d4b\u8bd5\u7528\u4f8b\u7c7b\u578b[%1$s]", strTestCaseType));
    }

    @Override
    public ISysTestDataRuntime createSysTestDataRuntime(IPSSysTestData iPSSysTestData) {
        return new SysTestDataRuntime();
    }

    @Override
    public Object invokeBackendTask(String strTaskType, String strTaskTag, String strDynaInstId, String strParam, IUserContext iUserContext, Object objTag) throws Throwable {
        String strTag = String.format("%1$s|%2$s", strTaskType, strTaskTag).toUpperCase();
        ISysBackendTaskRuntime iSysBackendTaskRuntime = this.getSysBackendTaskRuntime(strTag, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iSysBackendTaskRuntime.execute(strDynaInstId, strParam);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public boolean isEnableDEService(IPSDataEntity iPSDataEntity) {
        return this.deServiceObjMap.containsKey(iPSDataEntity.getId());
    }

    protected IDEService createDEService(IDataEntityRuntime iDataEntityRuntime) {
        String strDEServiceObj = this.deServiceObjMap.get(iDataEntityRuntime.getId());
        if (!StringUtils.hasLength((String)strDEServiceObj)) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53[%1$s]\u670d\u52a1\u5bf9\u8c61\u7ec4\u4ef6", iDataEntityRuntime.getId()));
        }
        try {
            Object objDEService = Class.forName(strDEServiceObj).newInstance();
            if (!(objDEService instanceof IDEService)) {
                throw new Exception("\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            return (IDEService)objDEService;
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u5b9e\u4f53[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getId(), ex.getMessage()), ex);
        }
    }

    protected void registerDEServiceObj(String strDataEntityId, String strDEServiceObj) {
        this.deServiceObjMap.put(strDataEntityId, strDEServiceObj);
    }

    @Override
    public IDEService getDEService(String strDataEntityId) {
        return this.getDEService(this.getDataEntityRuntime(strDataEntityId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDEService getDEService(IDataEntityRuntime iDataEntityRuntime) {
        if (!this.getSystemGatewayContext().isMultiSystemMode()) {
            IDEService iDEService = this.getSystemGatewayContext().getDEService(this.getDeploySystemId(), iDataEntityRuntime.getId());
            return iDEService;
        }
        IDEService iDEService = this.deServiceMap.get(iDataEntityRuntime.getId());
        if (iDEService == null) {
            Map<String, IDEService> map = this.deServiceMap;
            synchronized (map) {
                iDEService = this.deServiceMap.get(iDataEntityRuntime.getId());
                if (iDEService == null) {
                    iDEService = this.createDEService(iDataEntityRuntime);
                    try {
                        iDEService.init(this, iDataEntityRuntime);
                    }
                    catch (Exception ex) {
                        throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5b9e\u4f53[%1$s]\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getId(), ex.getMessage()), ex);
                    }
                    this.deServiceMap.put(iDataEntityRuntime.getId(), iDEService);
                }
            }
        }
        return iDEService;
    }

    @Override
    public Object getDeploySystemTag() {
        return this.getData();
    }

    @Override
    public Object invokeAppMethod(String strAppCodeName, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        return this.invokeAppMethod(strAppCodeName, null, null, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppMethod(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEMethod(strScope, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppImportData(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppExportData(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppExportData(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppPrintData(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEPrintData(strScope, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppWFStart(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEWFStart(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppWFCancel(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEWFCancel(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppDownloadFile(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, net.ibizsys.runtime.util.domain.File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEDownloadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object invokeAppUploadFile(String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, net.ibizsys.runtime.util.domain.File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        if (!StringUtils.hasLength((String)strAppCodeName)) {
            throw new SystemRuntimeException(this, String.format("\u4f20\u5165\u524d\u7aef\u5e94\u7528\u6807\u8bc6\u65e0\u6548", new Object[0]));
        }
        int nPos = strAppCodeName.indexOf("-");
        String strScope = null;
        if (nPos != -1) {
            strScope = strAppCodeName.substring(nPos + 1);
            strAppCodeName = strAppCodeName.substring(0, nPos);
        }
        IApplicationRuntime iApplicationRuntime = this.getApplicationRuntime(strAppCodeName, false);
        IUserContext last = UserContext.getCurrent();
        try {
            UserContext.setCurrent(iUserContext);
            Object ret = iApplicationRuntime.invokeDEUploadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            UserContext.setCurrent(last);
            return ret;
        }
        catch (Throwable ex) {
            UserContext.setCurrent(last);
            throw ex;
        }
    }

    @Override
    public Object serialize(Object obj) {
        Assert.notNull((Object)obj, (String)"\u4e0d\u80fd\u4f20\u5165\u7a7a\u5bf9\u8c61");
        try {
            return JsonUtils.MAPPER.writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5e8f\u5217\u5316\u6570\u636e\u5bf9\u8c61\u5217\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public <T> T deserialize(Object objData, Class<T> cls) {
        if (!(objData instanceof String)) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8f93\u5165\u6570\u636e", new Object[0]));
        }
        Assert.hasLength((String)((String)objData), (String)"\u4e0d\u80fd\u4f20\u5165\u7a7a\u6570\u636e");
        try {
            return (T)JsonUtils.MAPPER.readValue((String)objData, cls);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u5bf9\u8c61\u5217\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public <T> T deserialize(Object objData, TypeReference<T> type) {
        if (!(objData instanceof String)) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8f93\u5165\u6570\u636e", new Object[0]));
        }
        Assert.hasLength((String)((String)objData), (String)"\u4e0d\u80fd\u4f20\u5165\u7a7a\u6570\u636e");
        try {
            return (T)JsonUtils.MAPPER.readValue((String)objData, type);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u5bf9\u8c61\u5217\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public IWebClient getDefaultWebClient() {
        if (this.defaultWebClient == null) {
            IWebClient iWebClient = this.createWebClient(null);
            try {
                iWebClient.init(this);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u9ed8\u8ba4Web\u5ba2\u6237\u7aef\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.defaultWebClient = iWebClient;
        }
        return this.defaultWebClient;
    }

    @Override
    public IWebClient createWebClient(Object data) {
        return this.getRuntimeObject("GLOBAL_WEBCLIENT", IWebClient.class, true, false);
    }

    @Override
    public IScriptPage createScriptPage(Page<?> page) {
        return this.createScriptPage(page, true);
    }

    @Override
    public IScriptPage createScriptPage(Page<?> page, boolean bLowerCaseFieldName) {
        return new ScriptPage((ISystemRuntime)this, page, bLowerCaseFieldName);
    }

    @Override
    public IScriptWebResponse createScriptWebResponse(IWebResponse iWebResponse) {
        Assert.notNull((Object)iWebResponse, (String)"\u672a\u4f20\u5165Web\u53cd\u9988\u5bf9\u8c61");
        return new ScriptWebResponse(this, iWebResponse);
    }

    @Override
    public IScriptEntity createScriptEntity(IEntity iEntity) {
        return new ScriptEntity(this, iEntity);
    }

    @Override
    public IScriptList createScriptList(List<?> list) {
        return new ScriptList(this, list);
    }

    @Override
    public IScriptList createScriptList(List<?> list, boolean bLowerCaseFieldName) {
        return new ScriptList(this, list, bLowerCaseFieldName);
    }

    @Override
    public Object createScriptObject(Object objValue) {
        IEntityDTO iEntityDTO;
        if (objValue instanceof IEntityDTO && (iEntityDTO = (IEntityDTO)objValue).getDEMethodDTORuntime() != null) {
            return iEntityDTO.getDEMethodDTORuntime().getDataEntityRuntime().createScriptEntity(iEntityDTO);
        }
        if (objValue instanceof IEntity) {
            return this.createScriptEntity((IEntity)objValue);
        }
        if (objValue instanceof List) {
            return this.createScriptList((List)objValue);
        }
        return objValue;
    }

    @Override
    public ISubSysServiceAPIScriptLogicRuntime createSubSysServiceAPIScriptLogicRuntime(String strLogicMode) {
        return new SubSysServiceAPIScriptLogicRuntime();
    }

    @Override
    protected net.ibizsys.runtime.res.ISysUtilRuntime onCreateSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        String strUtilType = iPSSysUtil.getUtilType();
        if (StringUtils.hasLength((String)strUtilType) && "LOGLISTENER".equals(strUtilType)) {
            return new SysLogListenerUtilRuntime();
        }
        return super.onCreateSysUtilRuntime(iPSSysUtil);
    }

    @Override
    public void registerSystemLogListener(ISystemLogListener iSystemLogListener) {
        if (!(this.getSystemLogAdapter() instanceof ISystemLogListenerProxy)) {
            throw new SystemRuntimeException(this, "\u5f53\u524d\u7cfb\u7edf\u65e5\u5fd7\u9002\u914d\u5668\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        ((ISystemLogListenerProxy)((Object)this.getSystemLogAdapter())).registerSystemLogListener(iSystemLogListener);
    }

    @Override
    public void unregisterSystemLogListener(ISystemLogListener iSystemLogListener) {
        if (!(this.getSystemLogAdapter() instanceof ISystemLogListenerProxy)) {
            throw new SystemRuntimeException(this, "\u5f53\u524d\u7cfb\u7edf\u65e5\u5fd7\u9002\u914d\u5668\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        ((ISystemLogListenerProxy)((Object)this.getSystemLogAdapter())).unregisterSystemLogListener(iSystemLogListener);
    }

    protected boolean testPreloadPSDataEntity(IPSDataEntity iPSDataEntity) {
        if (iPSDataEntity.getAllPSDEDataSyncs() != null) {
            List psDEDataSyncs = iPSDataEntity.getAllPSDEDataSyncs();
            for (IPSDEDataSync iPSDEDataSync : psDEDataSyncs) {
                if (!iPSDEDataSync.isValid() || !"IN".equals(iPSDEDataSync.getSyncDir())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IUserContext createDefaultUserContext() {
        UserContextRuntime userContextRuntime = new UserContextRuntime();
        userContextRuntime.setUserid("SYSTEM");
        userContextRuntime.setUsername("\u7cfb\u7edf\u5185\u7f6e\u7528\u6237");
        return userContextRuntime;
    }

    @Override
    public IUserContext createAnonymousUserContext() {
        UserContextRuntime userContextRuntime = new UserContextRuntime();
        userContextRuntime.setUserid("ANONYMOUSUSER");
        userContextRuntime.setUsername("\u533f\u540d\u7528\u6237");
        userContextRuntime.setAnonymoususer(true);
        return userContextRuntime;
    }

    @Override
    protected net.ibizsys.runtime.res.ISysUtilRuntime registerPSSysUtil(IPSSysUtil iPSSysUtil) throws Exception {
        net.ibizsys.runtime.res.ISysUtilRuntime iSysUtilRuntime = super.registerPSSysUtil(iPSSysUtil);
        if (iSysUtilRuntime != null) {
            if (iSysUtilRuntime instanceof ISysUniStateUtilRuntime) {
                if (this.getSysUniStateUtilRuntime(true) == null) {
                    this.setSysUniStateUtilRuntime((ISysUniStateUtilRuntime)iSysUtilRuntime);
                }
            } else if (iSysUtilRuntime instanceof ISysCacheUtilRuntime && this.getSysCacheUtilRuntime(true) == null) {
                this.setSysCacheUtilRuntime((ISysCacheUtilRuntime)iSysUtilRuntime);
            }
        }
        return iSysUtilRuntime;
    }

    @Override
    public ISysUniStateUtilRuntime getSysUniStateUtilRuntime(boolean bTryMode) {
        if (this.iSysUniStateUtilRuntime != null || bTryMode) {
            return this.iSysUniStateUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u7edf\u4e00\u72b6\u6001\u529f\u80fd\u7ec4\u4ef6", new Object[0]));
    }

    protected void setSysUniStateUtilRuntime(ISysUniStateUtilRuntime iSysUniStateUtilRuntime) {
        this.iSysUniStateUtilRuntime = iSysUniStateUtilRuntime;
    }

    @Override
    public ISysCacheUtilRuntime getSysCacheUtilRuntime(boolean bTryMode) {
        if (this.iSysCacheUtilRuntime != null || bTryMode) {
            return this.iSysCacheUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6", new Object[0]));
    }

    protected void setSysCacheUtilRuntime(ISysCacheUtilRuntime iSysCacheUtilRuntime) {
        this.iSysCacheUtilRuntime = iSysCacheUtilRuntime;
    }

    @Override
    public ISysTestDataRuntime getSysTestDataRuntime(IPSSysTestData iPSSysTestData) {
        Assert.notNull((Object)iPSSysTestData, (String)"\u4f20\u5165\u6d4b\u8bd5\u6570\u636e\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.registerPSSysTestData(iPSSysTestData);
    }

    protected ISysTestDataRuntime registerPSSysTestData(IPSSysTestData iPSSysTestData) {
        ISysTestDataRuntime iSysTestDataRuntime;
        if (this.sysTestDataRuntimeMap != null && (iSysTestDataRuntime = this.sysTestDataRuntimeMap.get(iPSSysTestData.getId())) != null) {
            return iSysTestDataRuntime;
        }
        iSysTestDataRuntime = this.createSysTestDataRuntime(iPSSysTestData);
        if (iSysTestDataRuntime == null) {
            return null;
        }
        try {
            iSysTestDataRuntime.init(this.getSystemRuntimeContext(), iPSSysTestData);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6d4b\u8bd5\u6570\u636e[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysTestData.getName(), ex.getMessage()), ex);
        }
        if (this.sysTestDataRuntimeMap == null) {
            this.sysTestDataRuntimeMap = new HashMap<String, ISysTestDataRuntime>();
        }
        this.sysTestDataRuntimeMap.put(iPSSysTestData.getId(), iSysTestDataRuntime);
        return iSysTestDataRuntime;
    }

    @Override
    public String getDeploySessionId() {
        return this.strDeploySessionId;
    }

    @Override
    public DataSource getDefaultDataSource() {
        return this.getSystemGatewayContext().getDefaultDataSource();
    }

    @Override
    public DataSource getDataSource(String strDSTag, boolean bTryMode) {
        return this.getSystemGatewayContext().getDataSource(strDSTag, bTryMode);
    }

    @Override
    public IDEMapRuntime createDefaultDEMapRuntime() {
        return new DEMapRuntime();
    }

    @Override
    protected ICodeListRuntime createDefaultDynamicCodeListRuntime() {
        return new DynamicCodeListRuntime();
    }

    @Override
    public ISysSearchSchemeRuntime getSysSearchSchemeRuntime(IPSSysSearchScheme iPSSysSearchScheme) {
        Assert.notNull((Object)iPSSysSearchScheme, (String)"\u4f20\u5165\u7cfb\u7edf\u68c0\u7d22\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.getSysSearchSchemeRuntime(iPSSysSearchScheme.getId(), false);
    }

    @Override
    public ISysSearchSchemeRuntime getSysSearchSchemeRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u68c0\u7d22\u4f53\u7cfb\u6807\u8bb0\u65e0\u6548");
        ISysSearchSchemeRuntime iSysSearchSchemeRuntime = null;
        if (this.sysSearchSchemeRuntimeMap != null && (iSysSearchSchemeRuntime = this.sysSearchSchemeRuntimeMap.get(strTag)) == null) {
            iSysSearchSchemeRuntime = this.sysSearchSchemeRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysSearchSchemeRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u68c0\u7d22\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysSearchSchemeRuntime;
    }

    protected ISysSearchSchemeRuntime registerPSSysSearchScheme(IPSSysSearchScheme iPSSysSearchScheme) {
        ISysSearchSchemeRuntime iSysSearchSchemeRuntime;
        if (this.sysSearchSchemeRuntimeMap != null && (iSysSearchSchemeRuntime = this.sysSearchSchemeRuntimeMap.get(iPSSysSearchScheme.getId())) != null) {
            return iSysSearchSchemeRuntime;
        }
        iSysSearchSchemeRuntime = this.createSysSearchSchemeRuntime(iPSSysSearchScheme);
        if (iSysSearchSchemeRuntime == null) {
            return null;
        }
        try {
            iSysSearchSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysSearchScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u68c0\u7d22\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSearchScheme.getName(), ex.getMessage()), ex);
        }
        if (this.sysSearchSchemeRuntimeMap == null) {
            this.sysSearchSchemeRuntimeMap = new HashMap<String, ISysSearchSchemeRuntime>();
        }
        this.sysSearchSchemeRuntimeMap.put(iPSSysSearchScheme.getId(), iSysSearchSchemeRuntime);
        if (StringUtils.hasLength((String)iPSSysSearchScheme.getCodeName())) {
            this.sysSearchSchemeRuntimeMap.put(iPSSysSearchScheme.getCodeName().toLowerCase(), iSysSearchSchemeRuntime);
            if (iPSSysSearchScheme.getPSSystemModule() != null) {
                this.sysSearchSchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysSearchScheme.getPSSystemModule(), (String)iPSSysSearchScheme.getCodeName()), iSysSearchSchemeRuntime);
                this.sysSearchSchemeRuntimeMap.put(iPSSysSearchScheme.getPSSystemModule().getId(), iSysSearchSchemeRuntime);
            } else if (iPSSysSearchScheme.getPSSysModelGroup() != null) {
                this.sysSearchSchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysSearchScheme.getPSSysModelGroup(), (String)iPSSysSearchScheme.getCodeName()), iSysSearchSchemeRuntime);
                this.sysSearchSchemeRuntimeMap.put(iPSSysSearchScheme.getPSSysModelGroup().getId(), iSysSearchSchemeRuntime);
            }
        }
        return iSysSearchSchemeRuntime;
    }

    protected ISysSearchSchemeRuntime createSysSearchSchemeRuntime(IPSSysSearchScheme iPSSysSearchScheme) {
        ISysSearchSchemeRuntime iSysSearchSchemeRuntime = this.getRuntimeObject(iPSSysSearchScheme.getPSSysSFPlugin(), ISysSearchSchemeRuntime.class, true);
        if (iSysSearchSchemeRuntime != null) {
            return iSysSearchSchemeRuntime;
        }
        String strConfigFolder = SysSearchSchemeRuntime.getConfigFolder(iPSSysSearchScheme);
        String strSEType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".setype", iPSSysSearchScheme.getSearchEngineType());
        iSysSearchSchemeRuntime = this.getRuntimeObject(ISysSearchSchemeRuntime.class, strSEType);
        if (iSysSearchSchemeRuntime != null) {
            return iSysSearchSchemeRuntime;
        }
        return this.createDefaultSysSearchSchemeRuntime();
    }

    protected ISysSearchSchemeRuntime createDefaultSysSearchSchemeRuntime() {
        return new SysSearchSchemeRuntime();
    }

    @Override
    public ISysBISchemeRuntime getSysBISchemeRuntime(IPSSysBIScheme iPSSysBIScheme) {
        Assert.notNull((Object)iPSSysBIScheme, (String)"\u4f20\u5165\u7cfb\u7edf\u667a\u80fd\u62a5\u8868\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        return this.getSysBISchemeRuntime(iPSSysBIScheme.getId(), false);
    }

    @Override
    public ISysBISchemeRuntime getSysBISchemeRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u667a\u80fd\u62a5\u8868\u4f53\u7cfb\u6807\u8bb0\u65e0\u6548");
        ISysBISchemeRuntime iSysBISchemeRuntime = null;
        if (this.sysBISchemeRuntimeMap != null && (iSysBISchemeRuntime = this.sysBISchemeRuntimeMap.get(strTag)) == null) {
            iSysBISchemeRuntime = this.sysBISchemeRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysBISchemeRuntime == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSysBISchemeRuntime;
    }

    protected ISysBISchemeRuntime registerPSSysBIScheme(IPSSysBIScheme iPSSysBIScheme) {
        ISysBISchemeRuntime iSysBISchemeRuntime;
        if (this.sysBISchemeRuntimeMap != null && (iSysBISchemeRuntime = this.sysBISchemeRuntimeMap.get(iPSSysBIScheme.getId())) != null) {
            return iSysBISchemeRuntime;
        }
        iSysBISchemeRuntime = this.createSysBISchemeRuntime(iPSSysBIScheme);
        if (iSysBISchemeRuntime == null) {
            return null;
        }
        try {
            iSysBISchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBIScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBIScheme.getName(), ex.getMessage()), ex);
        }
        if (this.sysBISchemeRuntimeMap == null) {
            this.sysBISchemeRuntimeMap = new HashMap<String, ISysBISchemeRuntime>();
        }
        this.sysBISchemeRuntimeMap.put(iPSSysBIScheme.getId(), iSysBISchemeRuntime);
        if (StringUtils.hasLength((String)iPSSysBIScheme.getCodeName())) {
            this.sysBISchemeRuntimeMap.put(iPSSysBIScheme.getCodeName().toLowerCase(), iSysBISchemeRuntime);
            if (iPSSysBIScheme.getPSSystemModule() != null) {
                this.sysBISchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysBIScheme.getPSSystemModule(), (String)iPSSysBIScheme.getCodeName()), iSysBISchemeRuntime);
                this.sysBISchemeRuntimeMap.put(iPSSysBIScheme.getPSSystemModule().getId(), iSysBISchemeRuntime);
            } else if (iPSSysBIScheme.getPSSysModelGroup() != null) {
                this.sysBISchemeRuntimeMap.put(PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysBIScheme.getPSSysModelGroup(), (String)iPSSysBIScheme.getCodeName()), iSysBISchemeRuntime);
                this.sysBISchemeRuntimeMap.put(iPSSysBIScheme.getPSSysModelGroup().getId(), iSysBISchemeRuntime);
            }
        }
        return iSysBISchemeRuntime;
    }

    protected ISysBISchemeRuntime createSysBISchemeRuntime(IPSSysBIScheme iPSSysBIScheme) {
        ISysBISchemeRuntime iSysBISchemeRuntime = this.getRuntimeObject(iPSSysBIScheme.getPSSysSFPlugin(), ISysBISchemeRuntime.class, true);
        if (iSysBISchemeRuntime != null) {
            return iSysBISchemeRuntime;
        }
        String strConfigFolder = SysBISchemeRuntime.getConfigFolder(iPSSysBIScheme);
        String strBEType = this.getSystemRuntimeSetting().getParam(strConfigFolder + ".betype", iPSSysBIScheme.getBIEngineType());
        iSysBISchemeRuntime = this.getRuntimeObject(ISysBISchemeRuntime.class, strBEType);
        if (iSysBISchemeRuntime != null) {
            return iSysBISchemeRuntime;
        }
        return this.createDefaultSysBISchemeRuntime();
    }

    protected ISysBISchemeRuntime createDefaultSysBISchemeRuntime() {
        return new SysBISchemeRuntime();
    }

    @Override
    protected void onShutdown() throws Exception {
        List psSysRefs;
        List psSystemModules;
        List psSysSearchSchemes;
        List psSysBISchemes;
        List psSysBDSchemes;
        List psSysDBSchemes;
        List psSysUtils = this.getPSSystem().getAllPSSysUtils();
        if (psSysUtils != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                net.ibizsys.runtime.res.ISysUtilRuntime iSysUtilRuntime = this.getSysUtilRuntime(iPSSysUtil.getId(), false);
                if (!(iSysUtilRuntime instanceof ISysUtilRuntime)) continue;
                ISysUtilRuntime iSysUtilRuntime2 = (ISysUtilRuntime)iSysUtilRuntime;
                try {
                    iSysUtilRuntime2.uninstall();
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u5378\u8f7d\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysUtilRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysDBSchemes = this.getPSSystem().getAllPSSysDBSchemes()) != null) {
            for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
                ISysDBSchemeRuntime iSysDBSchemeRuntime = this.getSysDBSchemeRuntime(iPSSysDBScheme.getId(), false);
                try {
                    iSysDBSchemeRuntime.uninstall();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5378\u8f7d\u7cfb\u7edf\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysDBSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysBDSchemes = this.getPSSystem().getAllPSSysBDSchemes()) != null) {
            for (IPSSysBDScheme iPSSysBDScheme : psSysBDSchemes) {
                ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getSysBDSchemeRuntime(iPSSysBDScheme.getId(), false);
                try {
                    iSysBDSchemeRuntime.uninstall();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5378\u8f7d\u7cfb\u7edf\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysBDSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysBISchemes = this.getPSSystem().getAllPSSysBISchemes()) != null) {
            for (IPSSysBIScheme iPSSysBIScheme : psSysBISchemes) {
                ISysBISchemeRuntime iSysBISchemeRuntime = this.getSysBISchemeRuntime(iPSSysBIScheme.getId(), false);
                try {
                    iSysBISchemeRuntime.uninstall();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5378\u8f7d\u7cfb\u7edf\u667a\u80fd\u62a5\u8868\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysBISchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysSearchSchemes = this.getPSSystem().getAllPSSysSearchSchemes()) != null) {
            for (IPSSysSearchScheme iPSSysSearchScheme : psSysSearchSchemes) {
                ISysSearchSchemeRuntime iSysSearchSchemeRuntime = this.getSysSearchSchemeRuntime(iPSSysSearchScheme.getId(), false);
                try {
                    iSysSearchSchemeRuntime.uninstall();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5378\u8f7d\u7cfb\u7edf\u641c\u7d22\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysSearchSchemeRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSystemModules = this.getPSSystem().getAllPSSystemModules()) != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModules) {
                ISystemModuleRuntime iSystemModuleRuntime = this.getSystemModuleRuntime(iPSSystemModule.getId(), false);
                if (!(iSystemModuleRuntime instanceof ISystemModuleUtilRuntime)) continue;
                ISystemModuleUtilRuntime iSystemModuleUtilRuntime = (ISystemModuleUtilRuntime)((Object)iSystemModuleRuntime);
                try {
                    iSystemModuleUtilRuntime.uninstall();
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u5378\u8f7d\u7cfb\u7edf\u6a21\u5757\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSystemModuleRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        if ((psSysRefs = this.getPSSystem().getAllPSSysRefs()) != null) {
            for (IPSSysRef iPSSysRef : psSysRefs) {
                ISysRefRuntime iSysRefRuntime = this.getSysRefRuntime(iPSSysRef.getId(), false);
                try {
                    iSysRefRuntime.uninstall();
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u5378\u8f7d\u7cfb\u7edf\u5f15\u7528[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysRefRuntime.getName(), ex.getMessage()), ex);
                }
            }
        }
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysRefRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.systemModuleRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.dataEntityRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.dataEntityGroupRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysResourceRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysServiceAPIRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.applicationRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysDBSchemeRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysBDSchemeRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysSearchSchemeRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysBISchemeRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysBackendTaskRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.subSysServiceAPIRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysTestDataRuntimeMap);
        ModelRuntimeUtils.shutdownModelRuntimes(this.sysUniStateRuntimeMap);
        super.onShutdown();
    }

    static {
        SystemRuntime.registerRuntimeObjectIf(ISystemModuleUtilRuntime.class, "BI", "net.ibizsys.centralutil.bi.system.druid.DruidBISystemModuleUtilRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, "INTERNAL", "net.ibizsys.central.eai.InternalDataSyncAgentRuntime");
        SystemRuntime.registerRuntimeObjectIf(net.ibizsys.runtime.res.ISysUtilRuntime.class, "LOGLISTENER", SysLogListenerUtilRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(net.ibizsys.runtime.res.ISysUtilRuntime.class, "FILE", DefaultSysFileUtilRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(IDEPrintRuntime.class, "POI_TL", "net.ibizsys.central.plugin.poi.dataentity.print.POIDEPrintRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEPrintRuntime.class, "JR", "net.ibizsys.central.plugin.jr.dataentity.print.JRDEPrintRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, "JR", "net.ibizsys.central.plugin.jr.dataentity.report.JRDEReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.SYSBICUBE.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.DESYSBICUBES.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.ALLSYSBICUBES.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.SYSBIREPORT.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.DESYSBIREPORTS.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.SYSBICUBEREPORTS.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEReportRuntime.class, PSModelEnums.ReportType.ALLSYSBIREPORTS.value, "net.ibizsys.central.dataentity.report.DEBIReportRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, PSModelEnums.BDType.MONGODB.value, "net.ibizsys.central.plugin.mongodb.ba.MongoDBSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, PSModelEnums.BDType.SOLR.value, "net.ibizsys.central.plugin.solr.ba.SolrBDSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, PSModelEnums.BDType.ES.value, "net.ibizsys.central.plugin.es.ba.ESBDSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, PSModelEnums.BDType.NEO4J.value, "net.ibizsys.central.plugin.neo4j.ba.Neo4jBDSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, PSModelEnums.BDType.MILVUS.value, "net.ibizsys.central.plugin.milvus.ba.MilvusBDSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysSearchSchemeRuntime.class, PSModelEnums.SearchEngineType.ELASTICSEARCH.value, "net.ibizsys.central.plugin.es.search.ESSearchSchemeRuntime");
        SystemRuntime.registerRuntimeObjectIf(IDEDataSyncInRuntime.class, DEDataSyncInRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(IDEDataSyncOutRuntime.class, DEDataSyncOutRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(ISysResourceRuntime.class, PSModelEnums.ResourceType.ZIPFILE.value, SysZipFileResourceRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(ISysResourceRuntime.class, PSModelEnums.ResourceType.GITPROJECT.value, "net.ibizsys.central.plugin.jgit.res.JGitSysGitResourceRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysResourceRuntime.class, PSModelEnums.ResourceType.SYSCONTENTCAT.value, SysContentCatResourceRuntime.class.getCanonicalName());
        SystemRuntime.registerRuntimeObjectIf(ISysMsgTemplRuntime.class, PSModelEnums.MsgTemplEngine.FREEMARKER.value, "net.ibizsys.central.msg.SysMsgTemplRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysMsgTemplRuntime.class, null, "net.ibizsys.central.msg.SysMsgTemplRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysMsgTemplRuntime.class, PSModelEnums.MsgTemplEngine.GROOVY.value, "net.ibizsys.central.plugin.groovy.msg.GroovySysMsgTemplRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysSequenceRuntime.class, PSModelEnums.SequenceType.DE.value, "net.ibizsys.central.res.SysDESequenceRuntime");
        SystemRuntime.registerRuntimeObjectIf(ISysUniStateRuntime.class, PSModelEnums.UniStateType.DE.value, "net.ibizsys.central.res.SysDEUniStateRuntime");
        SystemRuntime.registerSingleInstanceRuntimeObjectIf(IDEDQSQLCustomCondParser.class, "PQL", "net.ibizsys.central.plugin.calcite.dataentity.ds.CalciteDEDQSQLCustomCondParser");
        SystemRuntime.registerSingleInstanceRuntimeObjectIf(ISysBICubeCalculatedMeasureParser.class, "SQL", "net.ibizsys.central.plugin.calcite.bi.CalciteSysBICubeSQLCalculatedMeasureParser");
        SystemRuntime.registerSingleInstanceRuntimeObjectIf(ISysBICubeCalculatedDimensionParser.class, "SQL", "net.ibizsys.central.plugin.calcite.bi.CalciteSysBICubeSQLCalculatedDimensionParser");
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle((MetaClassRegistry.MetaClassCreationHandle)new MetaClassCreationHandle());
    }
}

